/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.motion.widget;

import android.content.Context;
import android.util.Log;
import android.util.Xml;
import androidx.constraintlayout.motion.widget.Key;
import androidx.constraintlayout.motion.widget.KeyAttributes;
import androidx.constraintlayout.motion.widget.KeyCycle;
import androidx.constraintlayout.motion.widget.KeyPosition;
import androidx.constraintlayout.motion.widget.KeyTimeCycle;
import androidx.constraintlayout.motion.widget.KeyTrigger;
import androidx.constraintlayout.motion.widget.MotionController;
import androidx.constraintlayout.widget.ConstraintAttribute;
import androidx.constraintlayout.widget.ConstraintLayout;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class KeyFrames {
    public static final int UNSET = -1;
    private static final String CUSTOM_METHOD = "CustomMethod";
    private static final String CUSTOM_ATTRIBUTE = "CustomAttribute";
    private HashMap<Integer, ArrayList<Key>> mFramesMap = new HashMap();
    static HashMap<String, Constructor<? extends Key>> sKeyMakers = new HashMap();
    private static final String TAG = "KeyFrames";

    public void addKey(Key key) {
        ArrayList<Key> frames;
        if (!this.mFramesMap.containsKey(key.mTargetId)) {
            this.mFramesMap.put(key.mTargetId, new ArrayList());
        }
        if ((frames = this.mFramesMap.get(key.mTargetId)) != null) {
            frames.add(key);
        }
    }

    public KeyFrames() {
    }

    public KeyFrames(Context context, XmlPullParser parser) {
        String tagName = null;
        try {
            Key key = null;
            int eventType = parser.getEventType();
            while (eventType != 1) {
                switch (eventType) {
                    case 0: {
                        break;
                    }
                    case 2: {
                        tagName = parser.getName();
                        if (sKeyMakers.containsKey(tagName)) {
                            try {
                                Constructor<? extends Key> keyMaker = sKeyMakers.get(tagName);
                                if (keyMaker == null) {
                                    throw new NullPointerException("Keymaker for " + tagName + " not found");
                                }
                                key = keyMaker.newInstance(new Object[0]);
                                key.load(context, Xml.asAttributeSet((XmlPullParser)parser));
                                this.addKey(key);
                            }
                            catch (Exception e) {
                                Log.e((String)TAG, (String)"unable to create ", (Throwable)e);
                            }
                            break;
                        }
                        if (tagName.equalsIgnoreCase(CUSTOM_ATTRIBUTE)) {
                            if (key == null || key.mCustomConstraints == null) break;
                            ConstraintAttribute.parse(context, parser, key.mCustomConstraints);
                            break;
                        }
                        if (!tagName.equalsIgnoreCase(CUSTOM_METHOD) || key == null || key.mCustomConstraints == null) break;
                        ConstraintAttribute.parse(context, parser, key.mCustomConstraints);
                        break;
                    }
                    case 3: {
                        if (!"KeyFrameSet".equals(parser.getName())) break;
                        return;
                    }
                }
                eventType = parser.next();
            }
        }
        catch (XmlPullParserException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void addAllFrames(MotionController motionController) {
        ArrayList<Key> list = this.mFramesMap.get(-1);
        if (list != null) {
            motionController.addKeys(list);
        }
    }

    public void addFrames(MotionController motionController) {
        ArrayList<Key> list = this.mFramesMap.get(motionController.mId);
        if (list != null) {
            motionController.addKeys(list);
        }
        if ((list = this.mFramesMap.get(-1)) != null) {
            for (Key key : list) {
                String tag;
                if (!key.matches(tag = ((ConstraintLayout.LayoutParams)motionController.mView.getLayoutParams()).constraintTag)) continue;
                motionController.addKey(key);
            }
        }
    }

    static String name(int viewId, Context context) {
        return context.getResources().getResourceEntryName(viewId);
    }

    public Set<Integer> getKeys() {
        return this.mFramesMap.keySet();
    }

    public ArrayList<Key> getKeyFramesForView(int id2) {
        return this.mFramesMap.get(id2);
    }

    static {
        try {
            sKeyMakers.put("KeyAttribute", KeyAttributes.class.getConstructor(new Class[0]));
            sKeyMakers.put("KeyPosition", KeyPosition.class.getConstructor(new Class[0]));
            sKeyMakers.put("KeyCycle", KeyCycle.class.getConstructor(new Class[0]));
            sKeyMakers.put("KeyTimeCycle", KeyTimeCycle.class.getConstructor(new Class[0]));
            sKeyMakers.put("KeyTrigger", KeyTrigger.class.getConstructor(new Class[0]));
        }
        catch (NoSuchMethodException e) {
            Log.e((String)TAG, (String)"unable to load", (Throwable)e);
        }
    }
}

