/*
 * Decompiled with CFR 0.152.
 */
package androidx.media;

import android.content.Context;
import android.media.session.MediaSessionManager;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.media.MediaSessionManagerImplApi21;
import androidx.media.MediaSessionManagerImplApi28;
import androidx.media.MediaSessionManagerImplBase;

public final class MediaSessionManager {
    static final String TAG = "MediaSessionManager";
    static final boolean DEBUG = Log.isLoggable((String)"MediaSessionManager", (int)3);
    private static final Object sLock = new Object();
    private static volatile MediaSessionManager sSessionManager;
    MediaSessionManagerImpl mImpl;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static MediaSessionManager getSessionManager(@NonNull Context context) {
        if (context == null) {
            throw new IllegalArgumentException("context cannot be null");
        }
        Object object = sLock;
        synchronized (object) {
            if (sSessionManager == null) {
                sSessionManager = new MediaSessionManager(context.getApplicationContext());
            }
            return sSessionManager;
        }
    }

    private MediaSessionManager(Context context) {
        this.mImpl = Build.VERSION.SDK_INT >= 28 ? new MediaSessionManagerImplApi28(context) : (Build.VERSION.SDK_INT >= 21 ? new MediaSessionManagerImplApi21(context) : new MediaSessionManagerImplBase(context));
    }

    public boolean isTrustedForMediaControl(@NonNull RemoteUserInfo userInfo) {
        if (userInfo == null) {
            throw new IllegalArgumentException("userInfo should not be null");
        }
        return this.mImpl.isTrustedForMediaControl(userInfo.mImpl);
    }

    Context getContext() {
        return this.mImpl.getContext();
    }

    public static final class RemoteUserInfo {
        public static final String LEGACY_CONTROLLER = "android.media.session.MediaController";
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
        public static final int UNKNOWN_PID = -1;
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
        public static final int UNKNOWN_UID = -1;
        RemoteUserInfoImpl mImpl;

        public RemoteUserInfo(@NonNull String packageName, int pid, int uid) {
            if (packageName == null) {
                throw new NullPointerException("package shouldn't be null");
            }
            if (TextUtils.isEmpty((CharSequence)packageName)) {
                throw new IllegalArgumentException("packageName should be nonempty");
            }
            this.mImpl = Build.VERSION.SDK_INT >= 28 ? new MediaSessionManagerImplApi28.RemoteUserInfoImplApi28(packageName, pid, uid) : new MediaSessionManagerImplBase.RemoteUserInfoImplBase(packageName, pid, uid);
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        @RequiresApi(value=28)
        public RemoteUserInfo(MediaSessionManager.RemoteUserInfo remoteUserInfo) {
            String packageName = MediaSessionManagerImplApi28.RemoteUserInfoImplApi28.getPackageName(remoteUserInfo);
            if (packageName == null) {
                throw new NullPointerException("package shouldn't be null");
            }
            if (TextUtils.isEmpty((CharSequence)packageName)) {
                throw new IllegalArgumentException("packageName should be nonempty");
            }
            this.mImpl = new MediaSessionManagerImplApi28.RemoteUserInfoImplApi28(remoteUserInfo);
        }

        @NonNull
        public String getPackageName() {
            return this.mImpl.getPackageName();
        }

        public int getPid() {
            return this.mImpl.getPid();
        }

        public int getUid() {
            return this.mImpl.getUid();
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof RemoteUserInfo)) {
                return false;
            }
            return this.mImpl.equals(((RemoteUserInfo)obj).mImpl);
        }

        public int hashCode() {
            return this.mImpl.hashCode();
        }
    }

    static interface RemoteUserInfoImpl {
        public String getPackageName();

        public int getPid();

        public int getUid();
    }

    static interface MediaSessionManagerImpl {
        public Context getContext();

        public boolean isTrustedForMediaControl(RemoteUserInfoImpl var1);
    }
}

