/*
 * Decompiled with CFR 0.152.
 */
package androidx.fragment.app;

import android.annotation.SuppressLint;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.fragment.app.BackStackRecord;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;
import androidx.lifecycle.Lifecycle;
import java.util.ArrayList;
import java.util.Map;

@SuppressLint(value={"BanParcelableUsage"})
final class BackStackRecordState
implements Parcelable {
    private static final String TAG = "FragmentManager";
    final int[] mOps;
    final ArrayList<String> mFragmentWhos;
    final int[] mOldMaxLifecycleStates;
    final int[] mCurrentMaxLifecycleStates;
    final int mTransition;
    final String mName;
    final int mIndex;
    final int mBreadCrumbTitleRes;
    final CharSequence mBreadCrumbTitleText;
    final int mBreadCrumbShortTitleRes;
    final CharSequence mBreadCrumbShortTitleText;
    final ArrayList<String> mSharedElementSourceNames;
    final ArrayList<String> mSharedElementTargetNames;
    final boolean mReorderingAllowed;
    public static final Parcelable.Creator<BackStackRecordState> CREATOR = new Parcelable.Creator<BackStackRecordState>(){

        public BackStackRecordState createFromParcel(Parcel in) {
            return new BackStackRecordState(in);
        }

        public BackStackRecordState[] newArray(int size) {
            return new BackStackRecordState[size];
        }
    };

    BackStackRecordState(BackStackRecord bse) {
        int numOps = bse.mOps.size();
        this.mOps = new int[numOps * 6];
        if (!bse.mAddToBackStack) {
            throw new IllegalStateException("Not on back stack");
        }
        this.mFragmentWhos = new ArrayList(numOps);
        this.mOldMaxLifecycleStates = new int[numOps];
        this.mCurrentMaxLifecycleStates = new int[numOps];
        int pos = 0;
        for (int opNum = 0; opNum < numOps; ++opNum) {
            FragmentTransaction.Op op = (FragmentTransaction.Op)bse.mOps.get(opNum);
            this.mOps[pos++] = op.mCmd;
            this.mFragmentWhos.add(op.mFragment != null ? op.mFragment.mWho : null);
            this.mOps[pos++] = op.mFromExpandedOp ? 1 : 0;
            this.mOps[pos++] = op.mEnterAnim;
            this.mOps[pos++] = op.mExitAnim;
            this.mOps[pos++] = op.mPopEnterAnim;
            this.mOps[pos++] = op.mPopExitAnim;
            this.mOldMaxLifecycleStates[opNum] = op.mOldMaxState.ordinal();
            this.mCurrentMaxLifecycleStates[opNum] = op.mCurrentMaxState.ordinal();
        }
        this.mTransition = bse.mTransition;
        this.mName = bse.mName;
        this.mIndex = bse.mIndex;
        this.mBreadCrumbTitleRes = bse.mBreadCrumbTitleRes;
        this.mBreadCrumbTitleText = bse.mBreadCrumbTitleText;
        this.mBreadCrumbShortTitleRes = bse.mBreadCrumbShortTitleRes;
        this.mBreadCrumbShortTitleText = bse.mBreadCrumbShortTitleText;
        this.mSharedElementSourceNames = bse.mSharedElementSourceNames;
        this.mSharedElementTargetNames = bse.mSharedElementTargetNames;
        this.mReorderingAllowed = bse.mReorderingAllowed;
    }

    BackStackRecordState(Parcel in) {
        this.mOps = in.createIntArray();
        this.mFragmentWhos = in.createStringArrayList();
        this.mOldMaxLifecycleStates = in.createIntArray();
        this.mCurrentMaxLifecycleStates = in.createIntArray();
        this.mTransition = in.readInt();
        this.mName = in.readString();
        this.mIndex = in.readInt();
        this.mBreadCrumbTitleRes = in.readInt();
        this.mBreadCrumbTitleText = (CharSequence)TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
        this.mBreadCrumbShortTitleRes = in.readInt();
        this.mBreadCrumbShortTitleText = (CharSequence)TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
        this.mSharedElementSourceNames = in.createStringArrayList();
        this.mSharedElementTargetNames = in.createStringArrayList();
        this.mReorderingAllowed = in.readInt() != 0;
    }

    @NonNull
    public BackStackRecord instantiate(@NonNull FragmentManager fm) {
        BackStackRecord bse = new BackStackRecord(fm);
        this.fillInBackStackRecord(bse);
        bse.mIndex = this.mIndex;
        for (int num = 0; num < this.mFragmentWhos.size(); ++num) {
            String fWho = this.mFragmentWhos.get(num);
            if (fWho == null) continue;
            ((FragmentTransaction.Op)bse.mOps.get((int)num)).mFragment = fm.findActiveFragment(fWho);
        }
        bse.bumpBackStackNesting(1);
        return bse;
    }

    @NonNull
    public BackStackRecord instantiate(@NonNull FragmentManager fm, @NonNull Map<String, Fragment> fragments) {
        BackStackRecord bse = new BackStackRecord(fm);
        this.fillInBackStackRecord(bse);
        for (int num = 0; num < this.mFragmentWhos.size(); ++num) {
            String fWho = this.mFragmentWhos.get(num);
            if (fWho == null) continue;
            Fragment fragment = fragments.get(fWho);
            if (fragment != null) {
                ((FragmentTransaction.Op)bse.mOps.get((int)num)).mFragment = fragment;
                continue;
            }
            throw new IllegalStateException("Restoring FragmentTransaction " + this.mName + " failed due to missing saved state for Fragment (" + fWho + ")");
        }
        return bse;
    }

    private void fillInBackStackRecord(@NonNull BackStackRecord bse) {
        int pos = 0;
        int num = 0;
        while (pos < this.mOps.length) {
            FragmentTransaction.Op op = new FragmentTransaction.Op();
            op.mCmd = this.mOps[pos++];
            if (FragmentManager.isLoggingEnabled(2)) {
                Log.v((String)TAG, (String)("Instantiate " + bse + " op #" + num + " base fragment #" + this.mOps[pos]));
            }
            op.mOldMaxState = Lifecycle.State.values()[this.mOldMaxLifecycleStates[num]];
            op.mCurrentMaxState = Lifecycle.State.values()[this.mCurrentMaxLifecycleStates[num]];
            op.mFromExpandedOp = this.mOps[pos++] != 0;
            op.mEnterAnim = this.mOps[pos++];
            op.mExitAnim = this.mOps[pos++];
            op.mPopEnterAnim = this.mOps[pos++];
            op.mPopExitAnim = this.mOps[pos++];
            bse.mEnterAnim = op.mEnterAnim;
            bse.mExitAnim = op.mExitAnim;
            bse.mPopEnterAnim = op.mPopEnterAnim;
            bse.mPopExitAnim = op.mPopExitAnim;
            bse.addOp(op);
            ++num;
        }
        bse.mTransition = this.mTransition;
        bse.mName = this.mName;
        bse.mAddToBackStack = true;
        bse.mBreadCrumbTitleRes = this.mBreadCrumbTitleRes;
        bse.mBreadCrumbTitleText = this.mBreadCrumbTitleText;
        bse.mBreadCrumbShortTitleRes = this.mBreadCrumbShortTitleRes;
        bse.mBreadCrumbShortTitleText = this.mBreadCrumbShortTitleText;
        bse.mSharedElementSourceNames = this.mSharedElementSourceNames;
        bse.mSharedElementTargetNames = this.mSharedElementTargetNames;
        bse.mReorderingAllowed = this.mReorderingAllowed;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeIntArray(this.mOps);
        dest.writeStringList(this.mFragmentWhos);
        dest.writeIntArray(this.mOldMaxLifecycleStates);
        dest.writeIntArray(this.mCurrentMaxLifecycleStates);
        dest.writeInt(this.mTransition);
        dest.writeString(this.mName);
        dest.writeInt(this.mIndex);
        dest.writeInt(this.mBreadCrumbTitleRes);
        TextUtils.writeToParcel((CharSequence)this.mBreadCrumbTitleText, (Parcel)dest, (int)0);
        dest.writeInt(this.mBreadCrumbShortTitleRes);
        TextUtils.writeToParcel((CharSequence)this.mBreadCrumbShortTitleText, (Parcel)dest, (int)0);
        dest.writeStringList(this.mSharedElementSourceNames);
        dest.writeStringList(this.mSharedElementTargetNames);
        dest.writeInt(this.mReorderingAllowed ? 1 : 0);
    }
}

