/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.progressindicator;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import androidx.annotation.ColorInt;
import androidx.annotation.FloatRange;
import androidx.annotation.NonNull;
import com.google.android.material.color.MaterialColors;
import com.google.android.material.progressindicator.DrawingDelegate;
import com.google.android.material.progressindicator.LinearProgressIndicatorSpec;

final class LinearDrawingDelegate
extends DrawingDelegate<LinearProgressIndicatorSpec> {
    private float trackLength = 300.0f;
    private float displayedTrackThickness;
    private float displayedCornerRadius;

    public LinearDrawingDelegate(@NonNull LinearProgressIndicatorSpec spec) {
        super(spec);
    }

    @Override
    public int getPreferredWidth() {
        return -1;
    }

    @Override
    public int getPreferredHeight() {
        return ((LinearProgressIndicatorSpec)this.spec).trackThickness;
    }

    @Override
    public void adjustCanvas(@NonNull Canvas canvas, @FloatRange(from=0.0, to=1.0) float trackThicknessFraction) {
        Rect clipBounds = canvas.getClipBounds();
        this.trackLength = clipBounds.width();
        float trackSize = ((LinearProgressIndicatorSpec)this.spec).trackThickness;
        canvas.translate((float)clipBounds.left + (float)clipBounds.width() / 2.0f, (float)clipBounds.top + (float)clipBounds.height() / 2.0f + Math.max(0.0f, (float)(clipBounds.height() - ((LinearProgressIndicatorSpec)this.spec).trackThickness) / 2.0f));
        if (((LinearProgressIndicatorSpec)this.spec).drawHorizontallyInverse) {
            canvas.scale(-1.0f, 1.0f);
        }
        if (this.drawable.isShowing() && ((LinearProgressIndicatorSpec)this.spec).showAnimationBehavior == 1 || this.drawable.isHiding() && ((LinearProgressIndicatorSpec)this.spec).hideAnimationBehavior == 2) {
            canvas.scale(1.0f, -1.0f);
        }
        if (this.drawable.isShowing() || this.drawable.isHiding()) {
            canvas.translate(0.0f, (float)((LinearProgressIndicatorSpec)this.spec).trackThickness * (trackThicknessFraction - 1.0f) / 2.0f);
        }
        canvas.clipRect(-this.trackLength / 2.0f, -trackSize / 2.0f, this.trackLength / 2.0f, trackSize / 2.0f);
        this.displayedTrackThickness = (float)((LinearProgressIndicatorSpec)this.spec).trackThickness * trackThicknessFraction;
        this.displayedCornerRadius = (float)((LinearProgressIndicatorSpec)this.spec).trackCornerRadius * trackThicknessFraction;
    }

    @Override
    public void fillIndicator(@NonNull Canvas canvas, @NonNull Paint paint, @FloatRange(from=0.0, to=1.0) float startFraction, @FloatRange(from=0.0, to=1.0) float endFraction, @ColorInt int color2) {
        if (startFraction == endFraction) {
            return;
        }
        float adjustedStartX = -this.trackLength / 2.0f + startFraction * (this.trackLength - 2.0f * this.displayedCornerRadius);
        float adjustedEndX = -this.trackLength / 2.0f + endFraction * (this.trackLength - 2.0f * this.displayedCornerRadius) + 2.0f * this.displayedCornerRadius;
        paint.setStyle(Paint.Style.FILL);
        paint.setAntiAlias(true);
        paint.setColor(color2);
        RectF indicatorBound = new RectF(adjustedStartX, -this.displayedTrackThickness / 2.0f, adjustedEndX, this.displayedTrackThickness / 2.0f);
        canvas.drawRoundRect(indicatorBound, this.displayedCornerRadius, this.displayedCornerRadius, paint);
    }

    @Override
    void fillTrack(@NonNull Canvas canvas, @NonNull Paint paint) {
        int trackColor = MaterialColors.compositeARGBWithAlpha(((LinearProgressIndicatorSpec)this.spec).trackColor, this.drawable.getAlpha());
        paint.setStyle(Paint.Style.FILL);
        paint.setAntiAlias(true);
        paint.setColor(trackColor);
        RectF trackBound = new RectF(-this.trackLength / 2.0f, -this.displayedTrackThickness / 2.0f, this.trackLength / 2.0f, this.displayedTrackThickness / 2.0f);
        canvas.drawRoundRect(trackBound, this.displayedCornerRadius, this.displayedCornerRadius, paint);
    }
}

