/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.navigation;

import android.app.Activity;
import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Path;
import android.graphics.RectF;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.InsetDrawable;
import android.graphics.drawable.RippleDrawable;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import androidx.annotation.DimenRes;
import androidx.annotation.Dimension;
import androidx.annotation.DrawableRes;
import androidx.annotation.IdRes;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Px;
import androidx.annotation.RestrictTo;
import androidx.annotation.StyleRes;
import androidx.appcompat.R;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.appcompat.view.SupportMenuInflater;
import androidx.appcompat.view.menu.MenuBuilder;
import androidx.appcompat.view.menu.MenuItemImpl;
import androidx.appcompat.widget.TintTypedArray;
import androidx.core.content.ContextCompat;
import androidx.core.view.GravityCompat;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;
import androidx.customview.view.AbsSavedState;
import androidx.drawerlayout.widget.DrawerLayout;
import com.google.android.material.R;
import com.google.android.material.internal.ContextUtils;
import com.google.android.material.internal.NavigationMenu;
import com.google.android.material.internal.NavigationMenuPresenter;
import com.google.android.material.internal.ScrimInsetsFrameLayout;
import com.google.android.material.internal.ThemeEnforcement;
import com.google.android.material.resources.MaterialResources;
import com.google.android.material.ripple.RippleUtils;
import com.google.android.material.shape.MaterialShapeDrawable;
import com.google.android.material.shape.MaterialShapeUtils;
import com.google.android.material.shape.ShapeAppearanceModel;
import com.google.android.material.shape.ShapeAppearancePathProvider;
import com.google.android.material.theme.overlay.MaterialThemeOverlay;

public class NavigationView
extends ScrimInsetsFrameLayout {
    private static final int[] CHECKED_STATE_SET = new int[]{0x10100A0};
    private static final int[] DISABLED_STATE_SET = new int[]{-16842910};
    private static final int DEF_STYLE_RES = R.style.Widget_Design_NavigationView;
    private static final int PRESENTER_NAVIGATION_VIEW_ID = 1;
    @NonNull
    private final NavigationMenu menu;
    private final NavigationMenuPresenter presenter = new NavigationMenuPresenter();
    OnNavigationItemSelectedListener listener;
    private final int maxWidth;
    private final int[] tmpLocation = new int[2];
    private MenuInflater menuInflater;
    private ViewTreeObserver.OnGlobalLayoutListener onGlobalLayoutListener;
    private boolean topInsetScrimEnabled = true;
    private boolean bottomInsetScrimEnabled = true;
    private int layoutGravity = 0;
    @Px
    private int drawerLayoutCornerSize = 0;
    @Nullable
    private Path shapeClipPath;
    private final RectF shapeClipBounds = new RectF();

    public NavigationView(@NonNull Context context) {
        this(context, null);
    }

    public NavigationView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, R.attr.navigationViewStyle);
    }

    public NavigationView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(MaterialThemeOverlay.wrap(context, attrs, defStyleAttr, DEF_STYLE_RES), attrs, defStyleAttr);
        Drawable itemBackground;
        context = this.getContext();
        this.menu = new NavigationMenu(context);
        TintTypedArray a = ThemeEnforcement.obtainTintedStyledAttributes(context, attrs, R.styleable.NavigationView, defStyleAttr, DEF_STYLE_RES, new int[0]);
        if (a.hasValue(R.styleable.NavigationView_android_background)) {
            ViewCompat.setBackground((View)this, (Drawable)a.getDrawable(R.styleable.NavigationView_android_background));
        }
        this.drawerLayoutCornerSize = a.getDimensionPixelSize(R.styleable.NavigationView_drawerLayoutCornerSize, 0);
        this.layoutGravity = a.getInt(R.styleable.NavigationView_android_layout_gravity, 0);
        if (this.getBackground() == null || this.getBackground() instanceof ColorDrawable) {
            ShapeAppearanceModel shapeAppearanceModel = ShapeAppearanceModel.builder(context, attrs, defStyleAttr, DEF_STYLE_RES).build();
            Drawable orig = this.getBackground();
            MaterialShapeDrawable materialShapeDrawable = new MaterialShapeDrawable(shapeAppearanceModel);
            if (orig instanceof ColorDrawable) {
                materialShapeDrawable.setFillColor(ColorStateList.valueOf((int)((ColorDrawable)orig).getColor()));
            }
            materialShapeDrawable.initializeElevationOverlay(context);
            ViewCompat.setBackground((View)this, (Drawable)materialShapeDrawable);
        }
        if (a.hasValue(R.styleable.NavigationView_elevation)) {
            this.setElevation(a.getDimensionPixelSize(R.styleable.NavigationView_elevation, 0));
        }
        this.setFitsSystemWindows(a.getBoolean(R.styleable.NavigationView_android_fitsSystemWindows, false));
        this.maxWidth = a.getDimensionPixelSize(R.styleable.NavigationView_android_maxWidth, 0);
        ColorStateList subheaderColor = null;
        if (a.hasValue(R.styleable.NavigationView_subheaderColor)) {
            subheaderColor = a.getColorStateList(R.styleable.NavigationView_subheaderColor);
        }
        int subheaderTextAppearance = 0;
        if (a.hasValue(R.styleable.NavigationView_subheaderTextAppearance)) {
            subheaderTextAppearance = a.getResourceId(R.styleable.NavigationView_subheaderTextAppearance, 0);
        }
        if (subheaderTextAppearance == 0 && subheaderColor == null) {
            subheaderColor = this.createDefaultColorStateList(16842808);
        }
        ColorStateList itemIconTint = a.hasValue(R.styleable.NavigationView_itemIconTint) ? a.getColorStateList(R.styleable.NavigationView_itemIconTint) : this.createDefaultColorStateList(16842808);
        int textAppearance = 0;
        if (a.hasValue(R.styleable.NavigationView_itemTextAppearance)) {
            textAppearance = a.getResourceId(R.styleable.NavigationView_itemTextAppearance, 0);
        }
        if (a.hasValue(R.styleable.NavigationView_itemIconSize)) {
            this.setItemIconSize(a.getDimensionPixelSize(R.styleable.NavigationView_itemIconSize, 0));
        }
        ColorStateList itemTextColor = null;
        if (a.hasValue(R.styleable.NavigationView_itemTextColor)) {
            itemTextColor = a.getColorStateList(R.styleable.NavigationView_itemTextColor);
        }
        if (textAppearance == 0 && itemTextColor == null) {
            itemTextColor = this.createDefaultColorStateList(16842806);
        }
        if ((itemBackground = a.getDrawable(R.styleable.NavigationView_itemBackground)) == null && this.hasShapeAppearance(a)) {
            itemBackground = this.createDefaultItemBackground(a);
            ColorStateList itemRippleColor = MaterialResources.getColorStateList(context, a, R.styleable.NavigationView_itemRippleColor);
            if (Build.VERSION.SDK_INT >= 21 && itemRippleColor != null) {
                Drawable itemRippleMask = this.createDefaultItemDrawable(a, null);
                RippleDrawable ripple = new RippleDrawable(RippleUtils.sanitizeRippleDrawableColor(itemRippleColor), null, itemRippleMask);
                this.presenter.setItemForeground(ripple);
            }
        }
        if (a.hasValue(R.styleable.NavigationView_itemHorizontalPadding)) {
            int itemHorizontalPadding = a.getDimensionPixelSize(R.styleable.NavigationView_itemHorizontalPadding, 0);
            this.setItemHorizontalPadding(itemHorizontalPadding);
        }
        if (a.hasValue(R.styleable.NavigationView_itemVerticalPadding)) {
            int itemVerticalPadding = a.getDimensionPixelSize(R.styleable.NavigationView_itemVerticalPadding, 0);
            this.setItemVerticalPadding(itemVerticalPadding);
        }
        int dividerInsetStart = a.getDimensionPixelSize(R.styleable.NavigationView_dividerInsetStart, 0);
        this.setDividerInsetStart(dividerInsetStart);
        int dividerInsetEnd = a.getDimensionPixelSize(R.styleable.NavigationView_dividerInsetEnd, 0);
        this.setDividerInsetEnd(dividerInsetEnd);
        int subheaderInsetStart = a.getDimensionPixelSize(R.styleable.NavigationView_subheaderInsetStart, 0);
        this.setSubheaderInsetStart(subheaderInsetStart);
        int subheaderInsetEnd = a.getDimensionPixelSize(R.styleable.NavigationView_subheaderInsetEnd, 0);
        this.setSubheaderInsetEnd(subheaderInsetEnd);
        this.setTopInsetScrimEnabled(a.getBoolean(R.styleable.NavigationView_topInsetScrimEnabled, this.topInsetScrimEnabled));
        this.setBottomInsetScrimEnabled(a.getBoolean(R.styleable.NavigationView_bottomInsetScrimEnabled, this.bottomInsetScrimEnabled));
        int itemIconPadding = a.getDimensionPixelSize(R.styleable.NavigationView_itemIconPadding, 0);
        this.setItemMaxLines(a.getInt(R.styleable.NavigationView_itemMaxLines, 1));
        this.menu.setCallback(new MenuBuilder.Callback(){

            public boolean onMenuItemSelected(MenuBuilder menu, MenuItem item) {
                return NavigationView.this.listener != null && NavigationView.this.listener.onNavigationItemSelected(item);
            }

            public void onMenuModeChange(MenuBuilder menu) {
            }
        });
        this.presenter.setId(1);
        this.presenter.initForMenu(context, this.menu);
        if (subheaderTextAppearance != 0) {
            this.presenter.setSubheaderTextAppearance(subheaderTextAppearance);
        }
        this.presenter.setSubheaderColor(subheaderColor);
        this.presenter.setItemIconTintList(itemIconTint);
        this.presenter.setOverScrollMode(this.getOverScrollMode());
        if (textAppearance != 0) {
            this.presenter.setItemTextAppearance(textAppearance);
        }
        this.presenter.setItemTextColor(itemTextColor);
        this.presenter.setItemBackground(itemBackground);
        this.presenter.setItemIconPadding(itemIconPadding);
        this.menu.addMenuPresenter(this.presenter);
        this.addView((View)this.presenter.getMenuView((ViewGroup)this));
        if (a.hasValue(R.styleable.NavigationView_menu)) {
            this.inflateMenu(a.getResourceId(R.styleable.NavigationView_menu, 0));
        }
        if (a.hasValue(R.styleable.NavigationView_headerLayout)) {
            this.inflateHeaderView(a.getResourceId(R.styleable.NavigationView_headerLayout, 0));
        }
        a.recycle();
        this.setupInsetScrimsListener();
    }

    public void setOverScrollMode(int overScrollMode) {
        super.setOverScrollMode(overScrollMode);
        if (this.presenter != null) {
            this.presenter.setOverScrollMode(overScrollMode);
        }
    }

    private void maybeUpdateCornerSizeForDrawerLayout(@Px int width, @Px int height) {
        if (this.getParent() instanceof DrawerLayout && this.drawerLayoutCornerSize > 0 && this.getBackground() instanceof MaterialShapeDrawable) {
            MaterialShapeDrawable background = (MaterialShapeDrawable)this.getBackground();
            ShapeAppearanceModel.Builder builder = background.getShapeAppearanceModel().toBuilder();
            int absGravity = GravityCompat.getAbsoluteGravity((int)this.layoutGravity, (int)ViewCompat.getLayoutDirection((View)this));
            if (absGravity == 3) {
                builder.setTopRightCornerSize(this.drawerLayoutCornerSize);
                builder.setBottomRightCornerSize(this.drawerLayoutCornerSize);
            } else {
                builder.setTopLeftCornerSize(this.drawerLayoutCornerSize);
                builder.setBottomLeftCornerSize(this.drawerLayoutCornerSize);
            }
            background.setShapeAppearanceModel(builder.build());
            if (this.shapeClipPath == null) {
                this.shapeClipPath = new Path();
            }
            this.shapeClipPath.reset();
            this.shapeClipBounds.set(0.0f, 0.0f, (float)width, (float)height);
            ShapeAppearancePathProvider.getInstance().calculatePath(background.getShapeAppearanceModel(), background.getInterpolation(), this.shapeClipBounds, this.shapeClipPath);
            this.invalidate();
        } else {
            this.shapeClipPath = null;
            this.shapeClipBounds.setEmpty();
        }
    }

    private boolean hasShapeAppearance(@NonNull TintTypedArray a) {
        return a.hasValue(R.styleable.NavigationView_itemShapeAppearance) || a.hasValue(R.styleable.NavigationView_itemShapeAppearanceOverlay);
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        MaterialShapeUtils.setParentAbsoluteElevation((View)this);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.maybeUpdateCornerSizeForDrawerLayout(w, h);
    }

    public void setElevation(float elevation) {
        if (Build.VERSION.SDK_INT >= 21) {
            super.setElevation(elevation);
        }
        MaterialShapeUtils.setElevation((View)this, elevation);
    }

    @NonNull
    private Drawable createDefaultItemBackground(@NonNull TintTypedArray a) {
        ColorStateList fillColor = MaterialResources.getColorStateList(this.getContext(), a, R.styleable.NavigationView_itemShapeFillColor);
        return this.createDefaultItemDrawable(a, fillColor);
    }

    @NonNull
    private Drawable createDefaultItemDrawable(@NonNull TintTypedArray a, @Nullable ColorStateList fillColor) {
        int shapeAppearanceResId = a.getResourceId(R.styleable.NavigationView_itemShapeAppearance, 0);
        int shapeAppearanceOverlayResId = a.getResourceId(R.styleable.NavigationView_itemShapeAppearanceOverlay, 0);
        MaterialShapeDrawable materialShapeDrawable = new MaterialShapeDrawable(ShapeAppearanceModel.builder(this.getContext(), shapeAppearanceResId, shapeAppearanceOverlayResId).build());
        materialShapeDrawable.setFillColor(fillColor);
        int insetLeft = a.getDimensionPixelSize(R.styleable.NavigationView_itemShapeInsetStart, 0);
        int insetTop = a.getDimensionPixelSize(R.styleable.NavigationView_itemShapeInsetTop, 0);
        int insetRight = a.getDimensionPixelSize(R.styleable.NavigationView_itemShapeInsetEnd, 0);
        int insetBottom = a.getDimensionPixelSize(R.styleable.NavigationView_itemShapeInsetBottom, 0);
        return new InsetDrawable((Drawable)materialShapeDrawable, insetLeft, insetTop, insetRight, insetBottom);
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState state = new SavedState(superState);
        state.menuState = new Bundle();
        this.menu.savePresenterStates(state.menuState);
        return state;
    }

    protected void onRestoreInstanceState(Parcelable savedState) {
        if (!(savedState instanceof SavedState)) {
            super.onRestoreInstanceState(savedState);
            return;
        }
        SavedState state = (SavedState)savedState;
        super.onRestoreInstanceState(state.getSuperState());
        this.menu.restorePresenterStates(state.menuState);
    }

    public void setNavigationItemSelectedListener(@Nullable OnNavigationItemSelectedListener listener) {
        this.listener = listener;
    }

    protected void onMeasure(int widthSpec, int heightSpec) {
        switch (View.MeasureSpec.getMode((int)widthSpec)) {
            case 0x40000000: {
                break;
            }
            case -2147483648: {
                widthSpec = View.MeasureSpec.makeMeasureSpec((int)Math.min(View.MeasureSpec.getSize((int)widthSpec), this.maxWidth), (int)0x40000000);
                break;
            }
            case 0: {
                widthSpec = View.MeasureSpec.makeMeasureSpec((int)this.maxWidth, (int)0x40000000);
            }
        }
        super.onMeasure(widthSpec, heightSpec);
    }

    protected void dispatchDraw(@NonNull Canvas canvas) {
        if (this.shapeClipPath == null) {
            super.dispatchDraw(canvas);
            return;
        }
        int save = canvas.save();
        canvas.clipPath(this.shapeClipPath);
        super.dispatchDraw(canvas);
        canvas.restoreToCount(save);
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected void onInsetsChanged(@NonNull WindowInsetsCompat insets) {
        this.presenter.dispatchApplyWindowInsets(insets);
    }

    public void inflateMenu(int resId) {
        this.presenter.setUpdateSuspended(true);
        this.getMenuInflater().inflate(resId, (Menu)this.menu);
        this.presenter.setUpdateSuspended(false);
        this.presenter.updateMenuView(false);
    }

    @NonNull
    public Menu getMenu() {
        return this.menu;
    }

    public View inflateHeaderView(@LayoutRes int res) {
        return this.presenter.inflateHeaderView(res);
    }

    public void addHeaderView(@NonNull View view) {
        this.presenter.addHeaderView(view);
    }

    public void removeHeaderView(@NonNull View view) {
        this.presenter.removeHeaderView(view);
    }

    public int getHeaderCount() {
        return this.presenter.getHeaderCount();
    }

    public View getHeaderView(int index) {
        return this.presenter.getHeaderView(index);
    }

    @Nullable
    public ColorStateList getItemIconTintList() {
        return this.presenter.getItemTintList();
    }

    public void setItemIconTintList(@Nullable ColorStateList tint) {
        this.presenter.setItemIconTintList(tint);
    }

    @Nullable
    public ColorStateList getItemTextColor() {
        return this.presenter.getItemTextColor();
    }

    public void setItemTextColor(@Nullable ColorStateList textColor) {
        this.presenter.setItemTextColor(textColor);
    }

    @Nullable
    public Drawable getItemBackground() {
        return this.presenter.getItemBackground();
    }

    public void setItemBackgroundResource(@DrawableRes int resId) {
        this.setItemBackground(ContextCompat.getDrawable((Context)this.getContext(), (int)resId));
    }

    public void setItemBackground(@Nullable Drawable itemBackground) {
        this.presenter.setItemBackground(itemBackground);
    }

    @Dimension
    public int getItemHorizontalPadding() {
        return this.presenter.getItemHorizontalPadding();
    }

    public void setItemHorizontalPadding(@Dimension int padding) {
        this.presenter.setItemHorizontalPadding(padding);
    }

    public void setItemHorizontalPaddingResource(@DimenRes int paddingResource) {
        this.presenter.setItemHorizontalPadding(this.getResources().getDimensionPixelSize(paddingResource));
    }

    @Px
    public int getItemVerticalPadding() {
        return this.presenter.getItemVerticalPadding();
    }

    public void setItemVerticalPadding(@Px int padding) {
        this.presenter.setItemVerticalPadding(padding);
    }

    public void setItemVerticalPaddingResource(@DimenRes int paddingResource) {
        this.presenter.setItemVerticalPadding(this.getResources().getDimensionPixelSize(paddingResource));
    }

    @Dimension
    public int getItemIconPadding() {
        return this.presenter.getItemIconPadding();
    }

    public void setItemIconPadding(@Dimension int padding) {
        this.presenter.setItemIconPadding(padding);
    }

    public void setItemIconPaddingResource(int paddingResource) {
        this.presenter.setItemIconPadding(this.getResources().getDimensionPixelSize(paddingResource));
    }

    public void setCheckedItem(@IdRes int id2) {
        MenuItem item = this.menu.findItem(id2);
        if (item != null) {
            this.presenter.setCheckedItem((MenuItemImpl)item);
        }
    }

    public void setCheckedItem(@NonNull MenuItem checkedItem) {
        MenuItem item = this.menu.findItem(checkedItem.getItemId());
        if (item == null) {
            throw new IllegalArgumentException("Called setCheckedItem(MenuItem) with an item that is not in the current menu.");
        }
        this.presenter.setCheckedItem((MenuItemImpl)item);
    }

    @Nullable
    public MenuItem getCheckedItem() {
        return this.presenter.getCheckedItem();
    }

    public void setItemTextAppearance(@StyleRes int resId) {
        this.presenter.setItemTextAppearance(resId);
    }

    public void setItemIconSize(@Dimension int iconSize) {
        this.presenter.setItemIconSize(iconSize);
    }

    public void setItemMaxLines(int itemMaxLines) {
        this.presenter.setItemMaxLines(itemMaxLines);
    }

    public int getItemMaxLines() {
        return this.presenter.getItemMaxLines();
    }

    public boolean isTopInsetScrimEnabled() {
        return this.topInsetScrimEnabled;
    }

    public void setTopInsetScrimEnabled(boolean enabled) {
        this.topInsetScrimEnabled = enabled;
    }

    public boolean isBottomInsetScrimEnabled() {
        return this.bottomInsetScrimEnabled;
    }

    public void setBottomInsetScrimEnabled(boolean enabled) {
        this.bottomInsetScrimEnabled = enabled;
    }

    @Px
    public int getDividerInsetStart() {
        return this.presenter.getDividerInsetStart();
    }

    public void setDividerInsetStart(@Px int dividerInsetStart) {
        this.presenter.setDividerInsetStart(dividerInsetStart);
    }

    @Px
    public int getDividerInsetEnd() {
        return this.presenter.getDividerInsetEnd();
    }

    public void setDividerInsetEnd(@Px int dividerInsetEnd) {
        this.presenter.setDividerInsetEnd(dividerInsetEnd);
    }

    @Px
    public int getSubheaderInsetStart() {
        return this.presenter.getSubheaderInsetStart();
    }

    public void setSubheaderInsetStart(@Px int subheaderInsetStart) {
        this.presenter.setSubheaderInsetStart(subheaderInsetStart);
    }

    @Px
    public int getSubheaderInsetEnd() {
        return this.presenter.getSubheaderInsetEnd();
    }

    public void setSubheaderInsetEnd(@Px int subheaderInsetEnd) {
        this.presenter.setSubheaderInsetStart(subheaderInsetEnd);
    }

    private MenuInflater getMenuInflater() {
        if (this.menuInflater == null) {
            this.menuInflater = new SupportMenuInflater(this.getContext());
        }
        return this.menuInflater;
    }

    @Nullable
    private ColorStateList createDefaultColorStateList(int baseColorThemeAttr) {
        TypedValue value = new TypedValue();
        if (!this.getContext().getTheme().resolveAttribute(baseColorThemeAttr, value, true)) {
            return null;
        }
        ColorStateList baseColor = AppCompatResources.getColorStateList((Context)this.getContext(), (int)value.resourceId);
        if (!this.getContext().getTheme().resolveAttribute(R.attr.colorPrimary, value, true)) {
            return null;
        }
        int colorPrimary = value.data;
        int defaultColor = baseColor.getDefaultColor();
        return new ColorStateList((int[][])new int[][]{DISABLED_STATE_SET, CHECKED_STATE_SET, EMPTY_STATE_SET}, new int[]{baseColor.getColorForState(DISABLED_STATE_SET, defaultColor), colorPrimary, defaultColor});
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (Build.VERSION.SDK_INT < 16) {
            this.getViewTreeObserver().removeGlobalOnLayoutListener(this.onGlobalLayoutListener);
        } else {
            this.getViewTreeObserver().removeOnGlobalLayoutListener(this.onGlobalLayoutListener);
        }
    }

    private void setupInsetScrimsListener() {
        this.onGlobalLayoutListener = new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                NavigationView.this.getLocationOnScreen(NavigationView.this.tmpLocation);
                boolean isBehindStatusBar = NavigationView.this.tmpLocation[1] == 0;
                NavigationView.this.presenter.setBehindStatusBar(isBehindStatusBar);
                NavigationView.this.setDrawTopInsetForeground(isBehindStatusBar && NavigationView.this.isTopInsetScrimEnabled());
                Activity activity = ContextUtils.getActivity(NavigationView.this.getContext());
                if (activity != null && Build.VERSION.SDK_INT >= 21) {
                    boolean isBehindSystemNav = activity.findViewById(0x1020002).getHeight() == NavigationView.this.getHeight();
                    boolean hasNonZeroAlpha = Color.alpha((int)activity.getWindow().getNavigationBarColor()) != 0;
                    NavigationView.this.setDrawBottomInsetForeground(isBehindSystemNav && hasNonZeroAlpha && NavigationView.this.isBottomInsetScrimEnabled());
                }
            }
        };
        this.getViewTreeObserver().addOnGlobalLayoutListener(this.onGlobalLayoutListener);
    }

    public static class SavedState
    extends AbsSavedState {
        @Nullable
        public Bundle menuState;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.ClassLoaderCreator<SavedState>(){

            @NonNull
            public SavedState createFromParcel(@NonNull Parcel in, ClassLoader loader) {
                return new SavedState(in, loader);
            }

            @Nullable
            public SavedState createFromParcel(@NonNull Parcel in) {
                return new SavedState(in, null);
            }

            @NonNull
            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        public SavedState(@NonNull Parcel in, @Nullable ClassLoader loader) {
            super(in, loader);
            this.menuState = in.readBundle(loader);
        }

        public SavedState(Parcelable superState) {
            super(superState);
        }

        public void writeToParcel(@NonNull Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeBundle(this.menuState);
        }
    }

    public static interface OnNavigationItemSelectedListener {
        public boolean onNavigationItemSelected(@NonNull MenuItem var1);
    }
}

