/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.engine;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.Key;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class GlideException
extends Exception {
    private static final long serialVersionUID = 1L;
    private static final StackTraceElement[] EMPTY_ELEMENTS = new StackTraceElement[0];
    private final List<Throwable> causes;
    private Key key;
    private DataSource dataSource;
    private Class<?> dataClass;
    private String detailMessage;
    @Nullable
    private Exception exception;

    public GlideException(String message) {
        this(message, Collections.emptyList());
    }

    public GlideException(String detailMessage, Throwable cause) {
        this(detailMessage, Collections.singletonList(cause));
    }

    public GlideException(String detailMessage, List<Throwable> causes) {
        this.detailMessage = detailMessage;
        this.setStackTrace(EMPTY_ELEMENTS);
        this.causes = causes;
    }

    void setLoggingDetails(Key key, DataSource dataSource) {
        this.setLoggingDetails(key, dataSource, null);
    }

    void setLoggingDetails(Key key, DataSource dataSource, Class<?> dataClass) {
        this.key = key;
        this.dataSource = dataSource;
        this.dataClass = dataClass;
    }

    public void setOrigin(@Nullable Exception exception) {
        this.exception = exception;
    }

    @Nullable
    public Exception getOrigin() {
        return this.exception;
    }

    @Override
    public Throwable fillInStackTrace() {
        return this;
    }

    public List<Throwable> getCauses() {
        return this.causes;
    }

    public List<Throwable> getRootCauses() {
        ArrayList<Throwable> rootCauses = new ArrayList<Throwable>();
        this.addRootCauses(this, rootCauses);
        return rootCauses;
    }

    public void logRootCauses(String tag) {
        List<Throwable> causes = this.getRootCauses();
        int size = causes.size();
        for (int i = 0; i < size; ++i) {
            Log.i((String)tag, (String)("Root cause (" + (i + 1) + " of " + size + ")"), (Throwable)causes.get(i));
        }
    }

    private void addRootCauses(Throwable throwable, List<Throwable> rootCauses) {
        if (throwable instanceof GlideException) {
            GlideException glideException = (GlideException)throwable;
            for (Throwable t : glideException.getCauses()) {
                this.addRootCauses(t, rootCauses);
            }
        } else {
            rootCauses.add(throwable);
        }
    }

    @Override
    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    @Override
    public void printStackTrace(PrintStream err) {
        this.printStackTrace((Appendable)err);
    }

    @Override
    public void printStackTrace(PrintWriter err) {
        this.printStackTrace((Appendable)err);
    }

    private void printStackTrace(Appendable appendable) {
        GlideException.appendExceptionMessage(this, appendable);
        GlideException.appendCauses(this.getCauses(), new IndentedAppendable(appendable));
    }

    @Override
    public String getMessage() {
        StringBuilder result = new StringBuilder(71).append(this.detailMessage).append(this.dataClass != null ? ", " + this.dataClass : "").append(this.dataSource != null ? ", " + (Object)((Object)this.dataSource) : "").append(this.key != null ? ", " + this.key : "");
        List<Throwable> rootCauses = this.getRootCauses();
        if (rootCauses.isEmpty()) {
            return result.toString();
        }
        if (rootCauses.size() == 1) {
            result.append("\nThere was 1 root cause:");
        } else {
            result.append("\nThere were ").append(rootCauses.size()).append(" root causes:");
        }
        for (Throwable cause : rootCauses) {
            result.append('\n').append(cause.getClass().getName()).append('(').append(cause.getMessage()).append(')');
        }
        result.append("\n call GlideException#logRootCauses(String) for more detail");
        return result.toString();
    }

    private static void appendExceptionMessage(Throwable t, Appendable appendable) {
        try {
            appendable.append(t.getClass().toString()).append(": ").append(t.getMessage()).append('\n');
        }
        catch (IOException e1) {
            throw new RuntimeException(t);
        }
    }

    private static void appendCauses(List<Throwable> causes, Appendable appendable) {
        try {
            GlideException.appendCausesWrapped(causes, appendable);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void appendCausesWrapped(List<Throwable> causes, Appendable appendable) throws IOException {
        int size = causes.size();
        for (int i = 0; i < size; ++i) {
            appendable.append("Cause (").append(String.valueOf(i + 1)).append(" of ").append(String.valueOf(size)).append("): ");
            Throwable cause = causes.get(i);
            if (cause instanceof GlideException) {
                GlideException glideCause = (GlideException)cause;
                glideCause.printStackTrace(appendable);
                continue;
            }
            GlideException.appendExceptionMessage(cause, appendable);
        }
    }

    private static final class IndentedAppendable
    implements Appendable {
        private static final String EMPTY_SEQUENCE = "";
        private static final String INDENT = "  ";
        private final Appendable appendable;
        private boolean printedNewLine = true;

        IndentedAppendable(Appendable appendable) {
            this.appendable = appendable;
        }

        @Override
        public Appendable append(char c) throws IOException {
            if (this.printedNewLine) {
                this.printedNewLine = false;
                this.appendable.append(INDENT);
            }
            this.printedNewLine = c == '\n';
            this.appendable.append(c);
            return this;
        }

        @Override
        public Appendable append(@Nullable CharSequence charSequence) throws IOException {
            charSequence = this.safeSequence(charSequence);
            return this.append(charSequence, 0, charSequence.length());
        }

        @Override
        public Appendable append(@Nullable CharSequence charSequence, int start, int end) throws IOException {
            charSequence = this.safeSequence(charSequence);
            if (this.printedNewLine) {
                this.printedNewLine = false;
                this.appendable.append(INDENT);
            }
            this.printedNewLine = charSequence.length() > 0 && charSequence.charAt(end - 1) == '\n';
            this.appendable.append(charSequence, start, end);
            return this;
        }

        @NonNull
        private CharSequence safeSequence(@Nullable CharSequence sequence) {
            if (sequence == null) {
                return EMPTY_SEQUENCE;
            }
            return sequence;
        }
    }
}

