/*
 * Decompiled with CFR 0.152.
 */
package androidx.fragment.app;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentManagerNonConfig;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

final class FragmentManagerViewModel
extends ViewModel {
    private static final String TAG = "FragmentManager";
    private static final ViewModelProvider.Factory FACTORY = new ViewModelProvider.Factory(){

        @NonNull
        public <T extends ViewModel> T create(@NonNull Class<T> modelClass) {
            FragmentManagerViewModel viewModel = new FragmentManagerViewModel(true);
            return (T)((Object)viewModel);
        }
    };
    private final HashMap<String, Fragment> mRetainedFragments = new HashMap();
    private final HashMap<String, FragmentManagerViewModel> mChildNonConfigs = new HashMap();
    private final HashMap<String, ViewModelStore> mViewModelStores = new HashMap();
    private final boolean mStateAutomaticallySaved;
    private boolean mHasBeenCleared = false;
    private boolean mHasSavedSnapshot = false;
    private boolean mIsStateSaved = false;

    @NonNull
    static FragmentManagerViewModel getInstance(ViewModelStore viewModelStore) {
        ViewModelProvider viewModelProvider = new ViewModelProvider(viewModelStore, FACTORY);
        return (FragmentManagerViewModel)viewModelProvider.get(FragmentManagerViewModel.class);
    }

    FragmentManagerViewModel(boolean stateAutomaticallySaved) {
        this.mStateAutomaticallySaved = stateAutomaticallySaved;
    }

    void setIsStateSaved(boolean isStateSaved) {
        this.mIsStateSaved = isStateSaved;
    }

    protected void onCleared() {
        if (FragmentManager.isLoggingEnabled(3)) {
            Log.d((String)TAG, (String)("onCleared called for " + (Object)((Object)this)));
        }
        this.mHasBeenCleared = true;
    }

    boolean isCleared() {
        return this.mHasBeenCleared;
    }

    void addRetainedFragment(@NonNull Fragment fragment) {
        if (this.mIsStateSaved) {
            if (FragmentManager.isLoggingEnabled(2)) {
                Log.v((String)TAG, (String)"Ignoring addRetainedFragment as the state is already saved");
            }
            return;
        }
        if (this.mRetainedFragments.containsKey(fragment.mWho)) {
            return;
        }
        this.mRetainedFragments.put(fragment.mWho, fragment);
        if (FragmentManager.isLoggingEnabled(2)) {
            Log.v((String)TAG, (String)("Updating retained Fragments: Added " + fragment));
        }
    }

    @Nullable
    Fragment findRetainedFragmentByWho(String who) {
        return this.mRetainedFragments.get(who);
    }

    @NonNull
    Collection<Fragment> getRetainedFragments() {
        return new ArrayList<Fragment>(this.mRetainedFragments.values());
    }

    boolean shouldDestroy(@NonNull Fragment fragment) {
        if (!this.mRetainedFragments.containsKey(fragment.mWho)) {
            return true;
        }
        if (this.mStateAutomaticallySaved) {
            return this.mHasBeenCleared;
        }
        return !this.mHasSavedSnapshot;
    }

    void removeRetainedFragment(@NonNull Fragment fragment) {
        boolean removed;
        if (this.mIsStateSaved) {
            if (FragmentManager.isLoggingEnabled(2)) {
                Log.v((String)TAG, (String)"Ignoring removeRetainedFragment as the state is already saved");
            }
            return;
        }
        boolean bl = removed = this.mRetainedFragments.remove(fragment.mWho) != null;
        if (removed && FragmentManager.isLoggingEnabled(2)) {
            Log.v((String)TAG, (String)("Updating retained Fragments: Removed " + fragment));
        }
    }

    @NonNull
    FragmentManagerViewModel getChildNonConfig(@NonNull Fragment f) {
        FragmentManagerViewModel childNonConfig = this.mChildNonConfigs.get(f.mWho);
        if (childNonConfig == null) {
            childNonConfig = new FragmentManagerViewModel(this.mStateAutomaticallySaved);
            this.mChildNonConfigs.put(f.mWho, childNonConfig);
        }
        return childNonConfig;
    }

    @NonNull
    ViewModelStore getViewModelStore(@NonNull Fragment f) {
        ViewModelStore viewModelStore = this.mViewModelStores.get(f.mWho);
        if (viewModelStore == null) {
            viewModelStore = new ViewModelStore();
            this.mViewModelStores.put(f.mWho, viewModelStore);
        }
        return viewModelStore;
    }

    void clearNonConfigState(@NonNull Fragment f) {
        if (FragmentManager.isLoggingEnabled(3)) {
            Log.d((String)TAG, (String)("Clearing non-config state for " + f));
        }
        this.clearNonConfigStateInternal(f.mWho);
    }

    void clearNonConfigState(@NonNull String who) {
        if (FragmentManager.isLoggingEnabled(3)) {
            Log.d((String)TAG, (String)("Clearing non-config state for saved state of Fragment " + who));
        }
        this.clearNonConfigStateInternal(who);
    }

    private void clearNonConfigStateInternal(@NonNull String who) {
        ViewModelStore viewModelStore;
        FragmentManagerViewModel childNonConfig = this.mChildNonConfigs.get(who);
        if (childNonConfig != null) {
            childNonConfig.onCleared();
            this.mChildNonConfigs.remove(who);
        }
        if ((viewModelStore = this.mViewModelStores.get(who)) != null) {
            viewModelStore.clear();
            this.mViewModelStores.remove(who);
        }
    }

    @Deprecated
    void restoreFromSnapshot(@Nullable FragmentManagerNonConfig nonConfig) {
        this.mRetainedFragments.clear();
        this.mChildNonConfigs.clear();
        this.mViewModelStores.clear();
        if (nonConfig != null) {
            Map<String, ViewModelStore> map;
            Map<String, FragmentManagerNonConfig> childNonConfigs;
            Collection<Fragment> fragments = nonConfig.getFragments();
            if (fragments != null) {
                for (Fragment fragment : fragments) {
                    if (fragment == null) continue;
                    this.mRetainedFragments.put(fragment.mWho, fragment);
                }
            }
            if ((childNonConfigs = nonConfig.getChildNonConfigs()) != null) {
                for (Map.Entry<String, FragmentManagerNonConfig> entry : childNonConfigs.entrySet()) {
                    FragmentManagerViewModel childViewModel = new FragmentManagerViewModel(this.mStateAutomaticallySaved);
                    childViewModel.restoreFromSnapshot(entry.getValue());
                    this.mChildNonConfigs.put(entry.getKey(), childViewModel);
                }
            }
            if ((map = nonConfig.getViewModelStores()) != null) {
                this.mViewModelStores.putAll(map);
            }
        }
        this.mHasSavedSnapshot = false;
    }

    @Deprecated
    @Nullable
    FragmentManagerNonConfig getSnapshot() {
        if (this.mRetainedFragments.isEmpty() && this.mChildNonConfigs.isEmpty() && this.mViewModelStores.isEmpty()) {
            return null;
        }
        HashMap<String, FragmentManagerNonConfig> childNonConfigs = new HashMap<String, FragmentManagerNonConfig>();
        for (Map.Entry<String, FragmentManagerViewModel> entry : this.mChildNonConfigs.entrySet()) {
            FragmentManagerNonConfig childNonConfig = entry.getValue().getSnapshot();
            if (childNonConfig == null) continue;
            childNonConfigs.put(entry.getKey(), childNonConfig);
        }
        this.mHasSavedSnapshot = true;
        if (this.mRetainedFragments.isEmpty() && childNonConfigs.isEmpty() && this.mViewModelStores.isEmpty()) {
            return null;
        }
        return new FragmentManagerNonConfig(new ArrayList<Fragment>(this.mRetainedFragments.values()), childNonConfigs, new HashMap<String, ViewModelStore>(this.mViewModelStores));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        FragmentManagerViewModel that = (FragmentManagerViewModel)((Object)o);
        return this.mRetainedFragments.equals(that.mRetainedFragments) && this.mChildNonConfigs.equals(that.mChildNonConfigs) && this.mViewModelStores.equals(that.mViewModelStores);
    }

    public int hashCode() {
        int result = this.mRetainedFragments.hashCode();
        result = 31 * result + this.mChildNonConfigs.hashCode();
        result = 31 * result + this.mViewModelStores.hashCode();
        return result;
    }

    @NonNull
    public String toString() {
        StringBuilder sb = new StringBuilder("FragmentManagerViewModel{");
        sb.append(Integer.toHexString(System.identityHashCode((Object)this)));
        sb.append("} Fragments (");
        Iterator<Fragment> fragmentIterator = this.mRetainedFragments.values().iterator();
        while (fragmentIterator.hasNext()) {
            sb.append(fragmentIterator.next());
            if (!fragmentIterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append(") Child Non Config (");
        Iterator<String> childNonConfigIterator = this.mChildNonConfigs.keySet().iterator();
        while (childNonConfigIterator.hasNext()) {
            sb.append(childNonConfigIterator.next());
            if (!childNonConfigIterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append(") ViewModelStores (");
        Iterator<String> viewModelStoreIterator = this.mViewModelStores.keySet().iterator();
        while (viewModelStoreIterator.hasNext()) {
            sb.append(viewModelStoreIterator.next());
            if (!viewModelStoreIterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append(')');
        return sb.toString();
    }
}

