/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.view;

import android.annotation.SuppressLint;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import androidx.annotation.NonNull;
import androidx.core.view.MenuProvider;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleEventObserver;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public class MenuHostHelper {
    private final Runnable mOnInvalidateMenuCallback;
    private final CopyOnWriteArrayList<MenuProvider> mMenuProviders = new CopyOnWriteArrayList();
    private final Map<MenuProvider, LifecycleContainer> mProviderToLifecycleContainers = new HashMap<MenuProvider, LifecycleContainer>();

    public MenuHostHelper(@NonNull Runnable onInvalidateMenuCallback) {
        this.mOnInvalidateMenuCallback = onInvalidateMenuCallback;
    }

    public void onCreateMenu(@NonNull Menu menu, @NonNull MenuInflater menuInflater) {
        for (MenuProvider menuProvider : this.mMenuProviders) {
            menuProvider.onCreateMenu(menu, menuInflater);
        }
    }

    public boolean onMenuItemSelected(@NonNull MenuItem item) {
        for (MenuProvider menuProvider : this.mMenuProviders) {
            if (!menuProvider.onMenuItemSelected(item)) continue;
            return true;
        }
        return false;
    }

    public void addMenuProvider(@NonNull MenuProvider provider) {
        this.mMenuProviders.add(provider);
        this.mOnInvalidateMenuCallback.run();
    }

    public void addMenuProvider(@NonNull MenuProvider provider, @NonNull LifecycleOwner owner) {
        this.addMenuProvider(provider);
        Lifecycle lifecycle = owner.getLifecycle();
        LifecycleContainer lifecycleContainer = this.mProviderToLifecycleContainers.remove(provider);
        if (lifecycleContainer != null) {
            lifecycleContainer.clearObservers();
        }
        LifecycleEventObserver observer = (source, event) -> {
            if (event == Lifecycle.Event.ON_DESTROY) {
                this.removeMenuProvider(provider);
            }
        };
        this.mProviderToLifecycleContainers.put(provider, new LifecycleContainer(lifecycle, observer));
    }

    @SuppressLint(value={"LambdaLast"})
    public void addMenuProvider(@NonNull MenuProvider provider, @NonNull LifecycleOwner owner, @NonNull Lifecycle.State state) {
        Lifecycle lifecycle = owner.getLifecycle();
        LifecycleContainer lifecycleContainer = this.mProviderToLifecycleContainers.remove(provider);
        if (lifecycleContainer != null) {
            lifecycleContainer.clearObservers();
        }
        LifecycleEventObserver observer = (source, event) -> {
            if (event == Lifecycle.Event.upTo((Lifecycle.State)state)) {
                this.addMenuProvider(provider);
            } else if (event == Lifecycle.Event.ON_DESTROY) {
                this.removeMenuProvider(provider);
            } else if (event == Lifecycle.Event.downFrom((Lifecycle.State)state)) {
                this.mMenuProviders.remove(provider);
                this.mOnInvalidateMenuCallback.run();
            }
        };
        this.mProviderToLifecycleContainers.put(provider, new LifecycleContainer(lifecycle, observer));
    }

    public void removeMenuProvider(@NonNull MenuProvider provider) {
        this.mMenuProviders.remove(provider);
        LifecycleContainer lifecycleContainer = this.mProviderToLifecycleContainers.remove(provider);
        if (lifecycleContainer != null) {
            lifecycleContainer.clearObservers();
        }
        this.mOnInvalidateMenuCallback.run();
    }

    private static class LifecycleContainer {
        final Lifecycle mLifecycle;
        private LifecycleEventObserver mObserver;

        LifecycleContainer(@NonNull Lifecycle lifecycle, @NonNull LifecycleEventObserver observer) {
            this.mLifecycle = lifecycle;
            this.mObserver = observer;
            this.mLifecycle.addObserver((LifecycleObserver)observer);
        }

        void clearObservers() {
            this.mLifecycle.removeObserver((LifecycleObserver)this.mObserver);
            this.mObserver = null;
        }
    }
}

