/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.provider;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.bumptech.glide.load.ResourceEncoder;
import java.util.ArrayList;
import java.util.List;

public class ResourceEncoderRegistry {
    private final List<Entry<?>> encoders = new ArrayList();

    public synchronized <Z> void append(@NonNull Class<Z> resourceClass, @NonNull ResourceEncoder<Z> encoder) {
        this.encoders.add(new Entry<Z>(resourceClass, encoder));
    }

    public synchronized <Z> void prepend(@NonNull Class<Z> resourceClass, @NonNull ResourceEncoder<Z> encoder) {
        this.encoders.add(0, new Entry<Z>(resourceClass, encoder));
    }

    @Nullable
    public synchronized <Z> ResourceEncoder<Z> get(@NonNull Class<Z> resourceClass) {
        int size = this.encoders.size();
        for (int i = 0; i < size; ++i) {
            Entry<Z> entry = this.encoders.get(i);
            if (!entry.handles(resourceClass)) continue;
            return entry.encoder;
        }
        return null;
    }

    private static final class Entry<T> {
        private final Class<T> resourceClass;
        final ResourceEncoder<T> encoder;

        Entry(@NonNull Class<T> resourceClass, @NonNull ResourceEncoder<T> encoder) {
            this.resourceClass = resourceClass;
            this.encoder = encoder;
        }

        boolean handles(@NonNull Class<?> resourceClass) {
            return this.resourceClass.isAssignableFrom(resourceClass);
        }
    }
}

