/*
 * Decompiled with CFR 0.152.
 */
package androidx.browser.customtabs;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.annotation.WorkerThread;
import androidx.browser.customtabs.CustomTabsIntent;
import androidx.browser.customtabs.CustomTabsSession;
import androidx.core.app.BundleCompat;
import androidx.core.content.FileProvider;
import java.io.File;

public class TrustedWebUtils {
    public static final String EXTRA_LAUNCH_AS_TRUSTED_WEB_ACTIVITY = "android.support.customtabs.extra.LAUNCH_AS_TRUSTED_WEB_ACTIVITY";
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static final String ACTION_MANAGE_TRUSTED_WEB_ACTIVITY_DATA = "android.support.customtabs.action.ACTION_MANAGE_TRUSTED_WEB_ACTIVITY_DATA";

    private TrustedWebUtils() {
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static void launchBrowserSiteSettings(@NonNull Context context, @NonNull CustomTabsSession session, @NonNull Uri uri) {
        Intent intent = new Intent(ACTION_MANAGE_TRUSTED_WEB_ACTIVITY_DATA);
        intent.setPackage(session.getComponentName().getPackageName());
        intent.setData(uri);
        Bundle bundle = new Bundle();
        BundleCompat.putBinder((Bundle)bundle, (String)"android.support.customtabs.extra.SESSION", (IBinder)session.getBinder());
        intent.putExtras(bundle);
        PendingIntent id2 = session.getId();
        if (id2 != null) {
            intent.putExtra("android.support.customtabs.extra.SESSION_ID", (Parcelable)id2);
        }
        context.startActivity(intent);
    }

    public static boolean areSplashScreensSupported(@NonNull Context context, @NonNull String packageName, @NonNull String version) {
        Intent serviceIntent = new Intent().setAction("android.support.customtabs.action.CustomTabsService").setPackage(packageName);
        ResolveInfo resolveInfo = context.getPackageManager().resolveService(serviceIntent, 64);
        if (resolveInfo == null || resolveInfo.filter == null) {
            return false;
        }
        return resolveInfo.filter.hasCategory(version);
    }

    @WorkerThread
    public static boolean transferSplashImage(@NonNull Context context, @NonNull File file, @NonNull String fileProviderAuthority, @NonNull String packageName, @NonNull CustomTabsSession session) {
        Uri uri = FileProvider.getUriForFile((Context)context, (String)fileProviderAuthority, (File)file);
        context.grantUriPermission(packageName, uri, 1);
        return session.receiveFile(uri, 1, null);
    }

    @Deprecated
    public static void launchAsTrustedWebActivity(@NonNull Context context, @NonNull CustomTabsIntent customTabsIntent, @NonNull Uri uri) {
        if (BundleCompat.getBinder((Bundle)customTabsIntent.intent.getExtras(), (String)"android.support.customtabs.extra.SESSION") == null) {
            throw new IllegalArgumentException("Given CustomTabsIntent should be associated with a valid CustomTabsSession");
        }
        customTabsIntent.intent.putExtra(EXTRA_LAUNCH_AS_TRUSTED_WEB_ACTIVITY, true);
        customTabsIntent.launchUrl(context, uri);
    }
}

