/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.resource.bitmap;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.ParcelFileDescriptor;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.bumptech.glide.load.ImageHeaderParser;
import com.bumptech.glide.load.ImageHeaderParserUtils;
import com.bumptech.glide.load.data.InputStreamRewinder;
import com.bumptech.glide.load.data.ParcelFileDescriptorRewinder;
import com.bumptech.glide.load.engine.bitmap_recycle.ArrayPool;
import com.bumptech.glide.util.Preconditions;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

interface ImageReader {
    @Nullable
    public Bitmap decodeBitmap(BitmapFactory.Options var1) throws IOException;

    public ImageHeaderParser.ImageType getImageType() throws IOException;

    public int getImageOrientation() throws IOException;

    public void stopGrowingBuffers();

    @RequiresApi(value=21)
    public static final class ParcelFileDescriptorImageReader
    implements ImageReader {
        private final ArrayPool byteArrayPool;
        private final List<ImageHeaderParser> parsers;
        private final ParcelFileDescriptorRewinder dataRewinder;

        ParcelFileDescriptorImageReader(ParcelFileDescriptor parcelFileDescriptor, List<ImageHeaderParser> parsers, ArrayPool byteArrayPool) {
            this.byteArrayPool = Preconditions.checkNotNull(byteArrayPool);
            this.parsers = Preconditions.checkNotNull(parsers);
            this.dataRewinder = new ParcelFileDescriptorRewinder(parcelFileDescriptor);
        }

        @Override
        @Nullable
        public Bitmap decodeBitmap(BitmapFactory.Options options) throws IOException {
            return BitmapFactory.decodeFileDescriptor((FileDescriptor)this.dataRewinder.rewindAndGet().getFileDescriptor(), null, (BitmapFactory.Options)options);
        }

        @Override
        public ImageHeaderParser.ImageType getImageType() throws IOException {
            return ImageHeaderParserUtils.getType(this.parsers, this.dataRewinder, this.byteArrayPool);
        }

        @Override
        public int getImageOrientation() throws IOException {
            return ImageHeaderParserUtils.getOrientation(this.parsers, this.dataRewinder, this.byteArrayPool);
        }

        @Override
        public void stopGrowingBuffers() {
        }
    }

    public static final class InputStreamImageReader
    implements ImageReader {
        private final InputStreamRewinder dataRewinder;
        private final ArrayPool byteArrayPool;
        private final List<ImageHeaderParser> parsers;

        InputStreamImageReader(InputStream is, List<ImageHeaderParser> parsers, ArrayPool byteArrayPool) {
            this.byteArrayPool = Preconditions.checkNotNull(byteArrayPool);
            this.parsers = Preconditions.checkNotNull(parsers);
            this.dataRewinder = new InputStreamRewinder(is, byteArrayPool);
        }

        @Override
        @Nullable
        public Bitmap decodeBitmap(BitmapFactory.Options options) throws IOException {
            return BitmapFactory.decodeStream((InputStream)this.dataRewinder.rewindAndGet(), null, (BitmapFactory.Options)options);
        }

        @Override
        public ImageHeaderParser.ImageType getImageType() throws IOException {
            return ImageHeaderParserUtils.getType(this.parsers, this.dataRewinder.rewindAndGet(), this.byteArrayPool);
        }

        @Override
        public int getImageOrientation() throws IOException {
            return ImageHeaderParserUtils.getOrientation(this.parsers, this.dataRewinder.rewindAndGet(), this.byteArrayPool);
        }

        @Override
        public void stopGrowingBuffers() {
            this.dataRewinder.fixMarkLimits();
        }
    }
}

