/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.data;

import android.content.ContentResolver;
import android.content.UriMatcher;
import android.net.Uri;
import android.provider.ContactsContract;
import androidx.annotation.NonNull;
import com.bumptech.glide.load.data.LocalUriFetcher;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class StreamLocalUriFetcher
extends LocalUriFetcher<InputStream> {
    private static final int ID_CONTACTS_LOOKUP = 1;
    private static final int ID_CONTACTS_THUMBNAIL = 2;
    private static final int ID_CONTACTS_CONTACT = 3;
    private static final int ID_CONTACTS_PHOTO = 4;
    private static final int ID_LOOKUP_BY_PHONE = 5;
    private static final UriMatcher URI_MATCHER = new UriMatcher(-1);

    public StreamLocalUriFetcher(ContentResolver resolver, Uri uri) {
        super(resolver, uri);
    }

    @Override
    protected InputStream loadResource(Uri uri, ContentResolver contentResolver) throws FileNotFoundException {
        InputStream inputStream = this.loadResourceFromUri(uri, contentResolver);
        if (inputStream == null) {
            throw new FileNotFoundException("InputStream is null for " + uri);
        }
        return inputStream;
    }

    private InputStream loadResourceFromUri(Uri uri, ContentResolver contentResolver) throws FileNotFoundException {
        switch (URI_MATCHER.match(uri)) {
            case 3: {
                return this.openContactPhotoInputStream(contentResolver, uri);
            }
            case 1: 
            case 5: {
                uri = ContactsContract.Contacts.lookupContact((ContentResolver)contentResolver, (Uri)uri);
                if (uri == null) {
                    throw new FileNotFoundException("Contact cannot be found");
                }
                return this.openContactPhotoInputStream(contentResolver, uri);
            }
        }
        return contentResolver.openInputStream(uri);
    }

    private InputStream openContactPhotoInputStream(ContentResolver contentResolver, Uri contactUri) {
        return ContactsContract.Contacts.openContactPhotoInputStream((ContentResolver)contentResolver, (Uri)contactUri, (boolean)true);
    }

    @Override
    protected void close(InputStream data) throws IOException {
        data.close();
    }

    @Override
    @NonNull
    public Class<InputStream> getDataClass() {
        return InputStream.class;
    }

    static {
        URI_MATCHER.addURI("com.android.contacts", "contacts/lookup/*/#", 1);
        URI_MATCHER.addURI("com.android.contacts", "contacts/lookup/*", 1);
        URI_MATCHER.addURI("com.android.contacts", "contacts/#/photo", 2);
        URI_MATCHER.addURI("com.android.contacts", "contacts/#", 3);
        URI_MATCHER.addURI("com.android.contacts", "contacts/#/display_photo", 4);
        URI_MATCHER.addURI("com.android.contacts", "phone_lookup/*", 5);
    }
}

