/*
 * Decompiled with CFR 0.152.
 */
package androidx.browser.customtabs;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.support.customtabs.ICustomTabsCallback;
import android.support.customtabs.IPostMessageService;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.browser.customtabs.CustomTabsSessionToken;
import androidx.browser.customtabs.PostMessageBackend;
import androidx.browser.customtabs.PostMessageService;

public abstract class PostMessageServiceConnection
implements PostMessageBackend,
ServiceConnection {
    private static final String TAG = "PostMessageServConn";
    private final Object mLock = new Object();
    private final ICustomTabsCallback mSessionBinder;
    @Nullable
    private IPostMessageService mService;
    @Nullable
    private String mPackageName;
    private boolean mMessageChannelCreated;

    public PostMessageServiceConnection(@NonNull CustomTabsSessionToken session) {
        IBinder binder = session.getCallbackBinder();
        if (binder == null) {
            throw new IllegalArgumentException("Provided session must have binder.");
        }
        this.mSessionBinder = ICustomTabsCallback.Stub.asInterface(binder);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void setPackageName(@NonNull String packageName) {
        this.mPackageName = packageName;
    }

    public boolean bindSessionToPostMessageService(@NonNull Context context, @NonNull String packageName) {
        Intent intent = new Intent();
        intent.setClassName(packageName, PostMessageService.class.getName());
        boolean success = context.bindService(intent, (ServiceConnection)this, 1);
        if (!success) {
            Log.w((String)TAG, (String)"Could not bind to PostMessageService in client.");
        }
        return success;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public boolean bindSessionToPostMessageService(@NonNull Context appContext) {
        if (this.mPackageName == null) {
            throw new IllegalStateException("setPackageName must be called before bindSessionToPostMessageService.");
        }
        return this.bindSessionToPostMessageService(appContext, this.mPackageName);
    }

    private boolean isBoundToService() {
        return this.mService != null;
    }

    public void unbindFromContext(@NonNull Context context) {
        if (this.isBoundToService()) {
            context.unbindService((ServiceConnection)this);
            this.mService = null;
        }
    }

    public final void onServiceConnected(@NonNull ComponentName name, @NonNull IBinder service) {
        this.mService = IPostMessageService.Stub.asInterface(service);
        this.onPostMessageServiceConnected();
    }

    public final void onServiceDisconnected(@NonNull ComponentName name) {
        this.mService = null;
        this.onPostMessageServiceDisconnected();
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public final boolean onNotifyMessageChannelReady(@Nullable Bundle extras) {
        return this.notifyMessageChannelReady(extras);
    }

    public final boolean notifyMessageChannelReady(@Nullable Bundle extras) {
        this.mMessageChannelCreated = true;
        return this.notifyMessageChannelReadyInternal(extras);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean notifyMessageChannelReadyInternal(@Nullable Bundle extras) {
        if (this.mService == null) {
            return false;
        }
        Object object = this.mLock;
        synchronized (object) {
            try {
                this.mService.onMessageChannelReady(this.mSessionBinder, extras);
            }
            catch (RemoteException e) {
                return false;
            }
        }
        return true;
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public final boolean onPostMessage(@NonNull String message, @Nullable Bundle extras) {
        return this.postMessage(message, extras);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean postMessage(@NonNull String message, @Nullable Bundle extras) {
        if (this.mService == null) {
            return false;
        }
        Object object = this.mLock;
        synchronized (object) {
            try {
                this.mService.onPostMessage(this.mSessionBinder, message, extras);
            }
            catch (RemoteException e) {
                return false;
            }
        }
        return true;
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void onDisconnectChannel(@NonNull Context appContext) {
        this.unbindFromContext(appContext);
    }

    public void onPostMessageServiceConnected() {
        if (this.mMessageChannelCreated) {
            this.notifyMessageChannelReadyInternal(null);
        }
    }

    public void onPostMessageServiceDisconnected() {
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void cleanup(@NonNull Context context) {
        if (this.isBoundToService()) {
            this.unbindFromContext(context);
        }
    }
}

