/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.bottomsheet;

import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.Log;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import androidx.annotation.FloatRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Px;
import androidx.annotation.RestrictTo;
import androidx.annotation.StringRes;
import androidx.annotation.VisibleForTesting;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import androidx.core.graphics.Insets;
import androidx.core.math.MathUtils;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import androidx.core.view.accessibility.AccessibilityViewCommand;
import androidx.customview.view.AbsSavedState;
import androidx.customview.widget.ViewDragHelper;
import com.google.android.material.R;
import com.google.android.material.internal.ViewUtils;
import com.google.android.material.resources.MaterialResources;
import com.google.android.material.shape.MaterialShapeDrawable;
import com.google.android.material.shape.ShapeAppearanceModel;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class BottomSheetBehavior<V extends View>
extends CoordinatorLayout.Behavior<V> {
    public static final int STATE_DRAGGING = 1;
    public static final int STATE_SETTLING = 2;
    public static final int STATE_EXPANDED = 3;
    public static final int STATE_COLLAPSED = 4;
    public static final int STATE_HIDDEN = 5;
    public static final int STATE_HALF_EXPANDED = 6;
    public static final int PEEK_HEIGHT_AUTO = -1;
    public static final int SAVE_PEEK_HEIGHT = 1;
    public static final int SAVE_FIT_TO_CONTENTS = 2;
    public static final int SAVE_HIDEABLE = 4;
    public static final int SAVE_SKIP_COLLAPSED = 8;
    public static final int SAVE_ALL = -1;
    public static final int SAVE_NONE = 0;
    private static final String TAG = "BottomSheetBehavior";
    private int saveFlags = 0;
    private static final int SIGNIFICANT_VEL_THRESHOLD = 500;
    private static final float HIDE_THRESHOLD = 0.5f;
    private static final float HIDE_FRICTION = 0.1f;
    private static final int CORNER_ANIMATION_DURATION = 500;
    private static final int NO_MAX_SIZE = -1;
    private boolean fitToContents = true;
    private boolean updateImportantForAccessibilityOnSiblings = false;
    private float maximumVelocity;
    private int peekHeight;
    private boolean peekHeightAuto;
    private int peekHeightMin;
    private int peekHeightGestureInsetBuffer;
    private MaterialShapeDrawable materialShapeDrawable;
    @Nullable
    private ColorStateList backgroundTint;
    private int maxWidth = -1;
    private int maxHeight = -1;
    private int gestureInsetBottom;
    private boolean gestureInsetBottomIgnored;
    private boolean paddingBottomSystemWindowInsets;
    private boolean paddingLeftSystemWindowInsets;
    private boolean paddingRightSystemWindowInsets;
    private boolean paddingTopSystemWindowInsets;
    private boolean marginLeftSystemWindowInsets;
    private boolean marginRightSystemWindowInsets;
    private boolean marginTopSystemWindowInsets;
    private int insetBottom;
    private int insetTop;
    private ShapeAppearanceModel shapeAppearanceModelDefault;
    private boolean isShapeExpanded;
    private final StateSettlingTracker stateSettlingTracker = new StateSettlingTracker();
    @Nullable
    private ValueAnimator interpolatorAnimator;
    private static final int DEF_STYLE_RES = R.style.Widget_Design_BottomSheet_Modal;
    int expandedOffset;
    int fitToContentsOffset;
    int halfExpandedOffset;
    float halfExpandedRatio = 0.5f;
    int collapsedOffset;
    float elevation = -1.0f;
    boolean hideable;
    private boolean skipCollapsed;
    private boolean draggable = true;
    int state = 4;
    int lastStableState = 4;
    @Nullable
    ViewDragHelper viewDragHelper;
    private boolean ignoreEvents;
    private int lastNestedScrollDy;
    private boolean nestedScrolled;
    private int childHeight;
    int parentWidth;
    int parentHeight;
    @Nullable
    WeakReference<V> viewRef;
    @Nullable
    WeakReference<View> nestedScrollingChildRef;
    @NonNull
    private final ArrayList<BottomSheetCallback> callbacks = new ArrayList();
    @Nullable
    private VelocityTracker velocityTracker;
    int activePointerId;
    private int initialY;
    boolean touchingScrollingChild;
    @Nullable
    private Map<View, Integer> importantForAccessibilityMap;
    private int expandHalfwayActionId = -1;
    private final ViewDragHelper.Callback dragCallback = new ViewDragHelper.Callback(){
        private long viewCapturedMillis;

        public boolean tryCaptureView(@NonNull View child, int pointerId) {
            if (BottomSheetBehavior.this.state == 1) {
                return false;
            }
            if (BottomSheetBehavior.this.touchingScrollingChild) {
                return false;
            }
            if (BottomSheetBehavior.this.state == 3 && BottomSheetBehavior.this.activePointerId == pointerId) {
                View scroll;
                View view = scroll = BottomSheetBehavior.this.nestedScrollingChildRef != null ? (View)BottomSheetBehavior.this.nestedScrollingChildRef.get() : null;
                if (scroll != null && scroll.canScrollVertically(-1)) {
                    return false;
                }
            }
            this.viewCapturedMillis = System.currentTimeMillis();
            return BottomSheetBehavior.this.viewRef != null && BottomSheetBehavior.this.viewRef.get() == child;
        }

        public void onViewPositionChanged(@NonNull View changedView, int left, int top, int dx, int dy) {
            BottomSheetBehavior.this.dispatchOnSlide(top);
        }

        public void onViewDragStateChanged(int state) {
            if (state == 1 && BottomSheetBehavior.this.draggable) {
                BottomSheetBehavior.this.setStateInternal(1);
            }
        }

        private boolean releasedLow(@NonNull View child) {
            return child.getTop() > (BottomSheetBehavior.this.parentHeight + BottomSheetBehavior.this.getExpandedOffset()) / 2;
        }

        public void onViewReleased(@NonNull View releasedChild, float xvel, float yvel) {
            int targetState;
            if (yvel < 0.0f) {
                if (BottomSheetBehavior.this.fitToContents) {
                    targetState = 3;
                } else {
                    float yPositionPercentage;
                    int currentTop = releasedChild.getTop();
                    long dragDurationMillis = System.currentTimeMillis() - this.viewCapturedMillis;
                    targetState = BottomSheetBehavior.this.shouldSkipHalfExpandedStateWhenDragging() ? (BottomSheetBehavior.this.shouldExpandOnUpwardDrag(dragDurationMillis, yPositionPercentage = (float)currentTop * 100.0f / (float)BottomSheetBehavior.this.parentHeight) ? 3 : 4) : (currentTop > BottomSheetBehavior.this.halfExpandedOffset ? 6 : 3);
                }
            } else if (BottomSheetBehavior.this.hideable && BottomSheetBehavior.this.shouldHide(releasedChild, yvel)) {
                targetState = Math.abs(xvel) < Math.abs(yvel) && yvel > 500.0f || this.releasedLow(releasedChild) ? 5 : (BottomSheetBehavior.this.fitToContents ? 3 : (Math.abs(releasedChild.getTop() - BottomSheetBehavior.this.getExpandedOffset()) < Math.abs(releasedChild.getTop() - BottomSheetBehavior.this.halfExpandedOffset) ? 3 : 6));
            } else if (yvel == 0.0f || Math.abs(xvel) > Math.abs(yvel)) {
                int currentTop = releasedChild.getTop();
                targetState = BottomSheetBehavior.this.fitToContents ? (Math.abs(currentTop - BottomSheetBehavior.this.fitToContentsOffset) < Math.abs(currentTop - BottomSheetBehavior.this.collapsedOffset) ? 3 : 4) : (currentTop < BottomSheetBehavior.this.halfExpandedOffset ? (currentTop < Math.abs(currentTop - BottomSheetBehavior.this.collapsedOffset) ? 3 : (BottomSheetBehavior.this.shouldSkipHalfExpandedStateWhenDragging() ? 4 : 6)) : (Math.abs(currentTop - BottomSheetBehavior.this.halfExpandedOffset) < Math.abs(currentTop - BottomSheetBehavior.this.collapsedOffset) ? (BottomSheetBehavior.this.shouldSkipHalfExpandedStateWhenDragging() ? 4 : 6) : 4));
            } else {
                int currentTop;
                targetState = BottomSheetBehavior.this.fitToContents ? 4 : (Math.abs((currentTop = releasedChild.getTop()) - BottomSheetBehavior.this.halfExpandedOffset) < Math.abs(currentTop - BottomSheetBehavior.this.collapsedOffset) ? (BottomSheetBehavior.this.shouldSkipHalfExpandedStateWhenDragging() ? 4 : 6) : 4);
            }
            BottomSheetBehavior.this.startSettling(releasedChild, targetState, BottomSheetBehavior.this.shouldSkipSmoothAnimation());
        }

        public int clampViewPositionVertical(@NonNull View child, int top, int dy) {
            return MathUtils.clamp((int)top, (int)BottomSheetBehavior.this.getExpandedOffset(), (int)(BottomSheetBehavior.this.hideable ? BottomSheetBehavior.this.parentHeight : BottomSheetBehavior.this.collapsedOffset));
        }

        public int clampViewPositionHorizontal(@NonNull View child, int left, int dx) {
            return child.getLeft();
        }

        public int getViewVerticalDragRange(@NonNull View child) {
            if (BottomSheetBehavior.this.hideable) {
                return BottomSheetBehavior.this.parentHeight;
            }
            return BottomSheetBehavior.this.collapsedOffset;
        }
    };

    public BottomSheetBehavior() {
    }

    public BottomSheetBehavior(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        TypedValue value;
        this.peekHeightGestureInsetBuffer = context.getResources().getDimensionPixelSize(R.dimen.mtrl_min_touch_target_size);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.BottomSheetBehavior_Layout);
        if (a.hasValue(R.styleable.BottomSheetBehavior_Layout_backgroundTint)) {
            this.backgroundTint = MaterialResources.getColorStateList(context, a, R.styleable.BottomSheetBehavior_Layout_backgroundTint);
        }
        if (a.hasValue(R.styleable.BottomSheetBehavior_Layout_shapeAppearance)) {
            this.shapeAppearanceModelDefault = ShapeAppearanceModel.builder(context, attrs, R.attr.bottomSheetStyle, DEF_STYLE_RES).build();
        }
        this.createMaterialShapeDrawableIfNeeded(context);
        this.createShapeValueAnimator();
        if (Build.VERSION.SDK_INT >= 21) {
            this.elevation = a.getDimension(R.styleable.BottomSheetBehavior_Layout_android_elevation, -1.0f);
        }
        if (a.hasValue(R.styleable.BottomSheetBehavior_Layout_android_maxWidth)) {
            this.setMaxWidth(a.getDimensionPixelSize(R.styleable.BottomSheetBehavior_Layout_android_maxWidth, -1));
        }
        if (a.hasValue(R.styleable.BottomSheetBehavior_Layout_android_maxHeight)) {
            this.setMaxHeight(a.getDimensionPixelSize(R.styleable.BottomSheetBehavior_Layout_android_maxHeight, -1));
        }
        if ((value = a.peekValue(R.styleable.BottomSheetBehavior_Layout_behavior_peekHeight)) != null && value.data == -1) {
            this.setPeekHeight(value.data);
        } else {
            this.setPeekHeight(a.getDimensionPixelSize(R.styleable.BottomSheetBehavior_Layout_behavior_peekHeight, -1));
        }
        this.setHideable(a.getBoolean(R.styleable.BottomSheetBehavior_Layout_behavior_hideable, false));
        this.setGestureInsetBottomIgnored(a.getBoolean(R.styleable.BottomSheetBehavior_Layout_gestureInsetBottomIgnored, false));
        this.setFitToContents(a.getBoolean(R.styleable.BottomSheetBehavior_Layout_behavior_fitToContents, true));
        this.setSkipCollapsed(a.getBoolean(R.styleable.BottomSheetBehavior_Layout_behavior_skipCollapsed, false));
        this.setDraggable(a.getBoolean(R.styleable.BottomSheetBehavior_Layout_behavior_draggable, true));
        this.setSaveFlags(a.getInt(R.styleable.BottomSheetBehavior_Layout_behavior_saveFlags, 0));
        this.setHalfExpandedRatio(a.getFloat(R.styleable.BottomSheetBehavior_Layout_behavior_halfExpandedRatio, 0.5f));
        value = a.peekValue(R.styleable.BottomSheetBehavior_Layout_behavior_expandedOffset);
        if (value != null && value.type == 16) {
            this.setExpandedOffset(value.data);
        } else {
            this.setExpandedOffset(a.getDimensionPixelOffset(R.styleable.BottomSheetBehavior_Layout_behavior_expandedOffset, 0));
        }
        this.paddingBottomSystemWindowInsets = a.getBoolean(R.styleable.BottomSheetBehavior_Layout_paddingBottomSystemWindowInsets, false);
        this.paddingLeftSystemWindowInsets = a.getBoolean(R.styleable.BottomSheetBehavior_Layout_paddingLeftSystemWindowInsets, false);
        this.paddingRightSystemWindowInsets = a.getBoolean(R.styleable.BottomSheetBehavior_Layout_paddingRightSystemWindowInsets, false);
        this.paddingTopSystemWindowInsets = a.getBoolean(R.styleable.BottomSheetBehavior_Layout_paddingTopSystemWindowInsets, true);
        this.marginLeftSystemWindowInsets = a.getBoolean(R.styleable.BottomSheetBehavior_Layout_marginLeftSystemWindowInsets, false);
        this.marginRightSystemWindowInsets = a.getBoolean(R.styleable.BottomSheetBehavior_Layout_marginRightSystemWindowInsets, false);
        this.marginTopSystemWindowInsets = a.getBoolean(R.styleable.BottomSheetBehavior_Layout_marginTopSystemWindowInsets, false);
        a.recycle();
        ViewConfiguration configuration = ViewConfiguration.get((Context)context);
        this.maximumVelocity = configuration.getScaledMaximumFlingVelocity();
    }

    @NonNull
    public Parcelable onSaveInstanceState(@NonNull CoordinatorLayout parent, @NonNull V child) {
        return new SavedState(super.onSaveInstanceState(parent, child), this);
    }

    public void onRestoreInstanceState(@NonNull CoordinatorLayout parent, @NonNull V child, @NonNull Parcelable state) {
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(parent, child, ss.getSuperState());
        this.restoreOptionalState(ss);
        this.lastStableState = ss.state == 1 || ss.state == 2 ? (this.state = 4) : (this.state = ss.state);
    }

    public void onAttachedToLayoutParams(@NonNull CoordinatorLayout.LayoutParams layoutParams) {
        super.onAttachedToLayoutParams(layoutParams);
        this.viewRef = null;
        this.viewDragHelper = null;
    }

    public void onDetachedFromLayoutParams() {
        super.onDetachedFromLayoutParams();
        this.viewRef = null;
        this.viewDragHelper = null;
    }

    public boolean onMeasureChild(@NonNull CoordinatorLayout parent, @NonNull V child, int parentWidthMeasureSpec, int widthUsed, int parentHeightMeasureSpec, int heightUsed) {
        ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)child.getLayoutParams();
        int childWidthMeasureSpec = this.getChildMeasureSpec(parentWidthMeasureSpec, parent.getPaddingLeft() + parent.getPaddingRight() + lp.leftMargin + lp.rightMargin + widthUsed, this.maxWidth, lp.width);
        int childHeightMeasureSpec = this.getChildMeasureSpec(parentHeightMeasureSpec, parent.getPaddingTop() + parent.getPaddingBottom() + lp.topMargin + lp.bottomMargin + heightUsed, this.maxHeight, lp.height);
        child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
        return true;
    }

    private int getChildMeasureSpec(int parentMeasureSpec, int padding, int maxSize, int childDimension) {
        int result = ViewGroup.getChildMeasureSpec((int)parentMeasureSpec, (int)padding, (int)childDimension);
        if (maxSize == -1) {
            return result;
        }
        int mode = View.MeasureSpec.getMode((int)result);
        int size = View.MeasureSpec.getSize((int)result);
        switch (mode) {
            case 0x40000000: {
                return View.MeasureSpec.makeMeasureSpec((int)Math.min(size, maxSize), (int)0x40000000);
            }
        }
        return View.MeasureSpec.makeMeasureSpec((int)(size == 0 ? maxSize : Math.min(size, maxSize)), (int)Integer.MIN_VALUE);
    }

    public boolean onLayoutChild(@NonNull CoordinatorLayout parent, @NonNull V child, int layoutDirection) {
        if (ViewCompat.getFitsSystemWindows((View)parent) && !ViewCompat.getFitsSystemWindows(child)) {
            child.setFitsSystemWindows(true);
        }
        if (this.viewRef == null) {
            this.peekHeightMin = parent.getResources().getDimensionPixelSize(R.dimen.design_bottom_sheet_peek_height_min);
            this.setWindowInsetsListener((View)child);
            this.viewRef = new WeakReference<V>(child);
            if (this.materialShapeDrawable != null) {
                ViewCompat.setBackground(child, (Drawable)this.materialShapeDrawable);
                this.materialShapeDrawable.setElevation(this.elevation == -1.0f ? ViewCompat.getElevation(child) : this.elevation);
                this.isShapeExpanded = this.state == 3;
                this.materialShapeDrawable.setInterpolation(this.isShapeExpanded ? 0.0f : 1.0f);
            } else if (this.backgroundTint != null) {
                ViewCompat.setBackgroundTintList(child, (ColorStateList)this.backgroundTint);
            }
            this.updateAccessibilityActions();
            if (ViewCompat.getImportantForAccessibility(child) == 0) {
                ViewCompat.setImportantForAccessibility(child, (int)1);
            }
        }
        if (this.viewDragHelper == null) {
            this.viewDragHelper = ViewDragHelper.create((ViewGroup)parent, (ViewDragHelper.Callback)this.dragCallback);
        }
        int savedTop = child.getTop();
        parent.onLayoutChild(child, layoutDirection);
        this.parentWidth = parent.getWidth();
        this.parentHeight = parent.getHeight();
        this.childHeight = child.getHeight();
        if (this.parentHeight - this.childHeight < this.insetTop) {
            this.childHeight = this.paddingTopSystemWindowInsets ? this.parentHeight : this.parentHeight - this.insetTop;
        }
        this.fitToContentsOffset = Math.max(0, this.parentHeight - this.childHeight);
        this.calculateHalfExpandedOffset();
        this.calculateCollapsedOffset();
        if (this.state == 3) {
            ViewCompat.offsetTopAndBottom(child, (int)this.getExpandedOffset());
        } else if (this.state == 6) {
            ViewCompat.offsetTopAndBottom(child, (int)this.halfExpandedOffset);
        } else if (this.hideable && this.state == 5) {
            ViewCompat.offsetTopAndBottom(child, (int)this.parentHeight);
        } else if (this.state == 4) {
            ViewCompat.offsetTopAndBottom(child, (int)this.collapsedOffset);
        } else if (this.state == 1 || this.state == 2) {
            ViewCompat.offsetTopAndBottom(child, (int)(savedTop - child.getTop()));
        }
        this.nestedScrollingChildRef = new WeakReference<View>(this.findScrollingChild((View)child));
        for (int i = 0; i < this.callbacks.size(); ++i) {
            this.callbacks.get(i).onLayout((View)child);
        }
        return true;
    }

    public boolean onInterceptTouchEvent(@NonNull CoordinatorLayout parent, @NonNull V child, @NonNull MotionEvent event) {
        if (!child.isShown() || !this.draggable) {
            this.ignoreEvents = true;
            return false;
        }
        int action = event.getActionMasked();
        if (action == 0) {
            this.reset();
        }
        if (this.velocityTracker == null) {
            this.velocityTracker = VelocityTracker.obtain();
        }
        this.velocityTracker.addMovement(event);
        switch (action) {
            case 1: 
            case 3: {
                this.touchingScrollingChild = false;
                this.activePointerId = -1;
                if (!this.ignoreEvents) break;
                this.ignoreEvents = false;
                return false;
            }
            case 0: {
                int initialX = (int)event.getX();
                this.initialY = (int)event.getY();
                if (this.state != 2) {
                    View scroll;
                    View view = scroll = this.nestedScrollingChildRef != null ? (View)this.nestedScrollingChildRef.get() : null;
                    if (scroll != null && parent.isPointInChildBounds(scroll, initialX, this.initialY)) {
                        this.activePointerId = event.getPointerId(event.getActionIndex());
                        this.touchingScrollingChild = true;
                    }
                }
                this.ignoreEvents = this.activePointerId == -1 && !parent.isPointInChildBounds(child, initialX, this.initialY);
                break;
            }
        }
        if (!this.ignoreEvents && this.viewDragHelper != null && this.viewDragHelper.shouldInterceptTouchEvent(event)) {
            return true;
        }
        View scroll = this.nestedScrollingChildRef != null ? (View)this.nestedScrollingChildRef.get() : null;
        return action == 2 && scroll != null && !this.ignoreEvents && this.state != 1 && !parent.isPointInChildBounds(scroll, (int)event.getX(), (int)event.getY()) && this.viewDragHelper != null && Math.abs((float)this.initialY - event.getY()) > (float)this.viewDragHelper.getTouchSlop();
    }

    public boolean onTouchEvent(@NonNull CoordinatorLayout parent, @NonNull V child, @NonNull MotionEvent event) {
        if (!child.isShown()) {
            return false;
        }
        int action = event.getActionMasked();
        if (this.state == 1 && action == 0) {
            return true;
        }
        if (this.shouldHandleDraggingWithHelper()) {
            this.viewDragHelper.processTouchEvent(event);
        }
        if (action == 0) {
            this.reset();
        }
        if (this.velocityTracker == null) {
            this.velocityTracker = VelocityTracker.obtain();
        }
        this.velocityTracker.addMovement(event);
        if (this.shouldHandleDraggingWithHelper() && action == 2 && !this.ignoreEvents && Math.abs((float)this.initialY - event.getY()) > (float)this.viewDragHelper.getTouchSlop()) {
            this.viewDragHelper.captureChildView(child, event.getPointerId(event.getActionIndex()));
        }
        return !this.ignoreEvents;
    }

    public boolean onStartNestedScroll(@NonNull CoordinatorLayout coordinatorLayout, @NonNull V child, @NonNull View directTargetChild, @NonNull View target, int axes, int type) {
        this.lastNestedScrollDy = 0;
        this.nestedScrolled = false;
        return (axes & 2) != 0;
    }

    public void onNestedPreScroll(@NonNull CoordinatorLayout coordinatorLayout, @NonNull V child, @NonNull View target, int dx, int dy, @NonNull int[] consumed, int type) {
        View scrollingChild;
        if (type == 1) {
            return;
        }
        View view = scrollingChild = this.nestedScrollingChildRef != null ? (View)this.nestedScrollingChildRef.get() : null;
        if (this.isNestedScrollingCheckEnabled() && target != scrollingChild) {
            return;
        }
        int currentTop = child.getTop();
        int newTop = currentTop - dy;
        if (dy > 0) {
            if (newTop < this.getExpandedOffset()) {
                consumed[1] = currentTop - this.getExpandedOffset();
                ViewCompat.offsetTopAndBottom(child, (int)(-consumed[1]));
                this.setStateInternal(3);
            } else {
                if (!this.draggable) {
                    return;
                }
                consumed[1] = dy;
                ViewCompat.offsetTopAndBottom(child, (int)(-dy));
                this.setStateInternal(1);
            }
        } else if (dy < 0 && !target.canScrollVertically(-1)) {
            if (newTop <= this.collapsedOffset || this.hideable) {
                if (!this.draggable) {
                    return;
                }
                consumed[1] = dy;
                ViewCompat.offsetTopAndBottom(child, (int)(-dy));
                this.setStateInternal(1);
            } else {
                consumed[1] = currentTop - this.collapsedOffset;
                ViewCompat.offsetTopAndBottom(child, (int)(-consumed[1]));
                this.setStateInternal(4);
            }
        }
        this.dispatchOnSlide(child.getTop());
        this.lastNestedScrollDy = dy;
        this.nestedScrolled = true;
    }

    public void onStopNestedScroll(@NonNull CoordinatorLayout coordinatorLayout, @NonNull V child, @NonNull View target, int type) {
        int targetState;
        if (child.getTop() == this.getExpandedOffset()) {
            this.setStateInternal(3);
            return;
        }
        if (this.isNestedScrollingCheckEnabled() && (this.nestedScrollingChildRef == null || target != this.nestedScrollingChildRef.get() || !this.nestedScrolled)) {
            return;
        }
        if (this.lastNestedScrollDy > 0) {
            int currentTop;
            targetState = this.fitToContents ? 3 : ((currentTop = child.getTop()) > this.halfExpandedOffset ? 6 : 3);
        } else if (this.hideable && this.shouldHide((View)child, this.getYVelocity())) {
            targetState = 5;
        } else if (this.lastNestedScrollDy == 0) {
            int currentTop = child.getTop();
            targetState = this.fitToContents ? (Math.abs(currentTop - this.fitToContentsOffset) < Math.abs(currentTop - this.collapsedOffset) ? 3 : 4) : (currentTop < this.halfExpandedOffset ? (currentTop < Math.abs(currentTop - this.collapsedOffset) ? 3 : (this.shouldSkipHalfExpandedStateWhenDragging() ? 4 : 6)) : (Math.abs(currentTop - this.halfExpandedOffset) < Math.abs(currentTop - this.collapsedOffset) ? 6 : 4));
        } else {
            int currentTop;
            targetState = this.fitToContents ? 4 : (Math.abs((currentTop = child.getTop()) - this.halfExpandedOffset) < Math.abs(currentTop - this.collapsedOffset) ? 6 : 4);
        }
        this.startSettling((View)child, targetState, false);
        this.nestedScrolled = false;
    }

    public void onNestedScroll(@NonNull CoordinatorLayout coordinatorLayout, @NonNull V child, @NonNull View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed, int type, @NonNull int[] consumed) {
    }

    public boolean onNestedPreFling(@NonNull CoordinatorLayout coordinatorLayout, @NonNull V child, @NonNull View target, float velocityX, float velocityY) {
        if (this.isNestedScrollingCheckEnabled() && this.nestedScrollingChildRef != null) {
            return target == this.nestedScrollingChildRef.get() && (this.state != 3 || super.onNestedPreFling(coordinatorLayout, child, target, velocityX, velocityY));
        }
        return false;
    }

    public boolean isFitToContents() {
        return this.fitToContents;
    }

    public void setFitToContents(boolean fitToContents) {
        if (this.fitToContents == fitToContents) {
            return;
        }
        this.fitToContents = fitToContents;
        if (this.viewRef != null) {
            this.calculateCollapsedOffset();
        }
        this.setStateInternal(this.fitToContents && this.state == 6 ? 3 : this.state);
        this.updateAccessibilityActions();
    }

    public void setMaxWidth(@Px int maxWidth) {
        this.maxWidth = maxWidth;
    }

    @Px
    public int getMaxWidth() {
        return this.maxWidth;
    }

    public void setMaxHeight(@Px int maxHeight) {
        this.maxHeight = maxHeight;
    }

    @Px
    public int getMaxHeight() {
        return this.maxHeight;
    }

    public void setPeekHeight(int peekHeight) {
        this.setPeekHeight(peekHeight, false);
    }

    public final void setPeekHeight(int peekHeight, boolean animate) {
        boolean layout2 = false;
        if (peekHeight == -1) {
            if (!this.peekHeightAuto) {
                this.peekHeightAuto = true;
                layout2 = true;
            }
        } else if (this.peekHeightAuto || this.peekHeight != peekHeight) {
            this.peekHeightAuto = false;
            this.peekHeight = Math.max(0, peekHeight);
            layout2 = true;
        }
        if (layout2) {
            this.updatePeekHeight(animate);
        }
    }

    private void updatePeekHeight(boolean animate) {
        if (this.viewRef != null) {
            View view;
            this.calculateCollapsedOffset();
            if (this.state == 4 && (view = (View)this.viewRef.get()) != null) {
                if (animate) {
                    this.setState(4);
                } else {
                    view.requestLayout();
                }
            }
        }
    }

    public int getPeekHeight() {
        return this.peekHeightAuto ? -1 : this.peekHeight;
    }

    public void setHalfExpandedRatio(@FloatRange(from=0.0, to=1.0, fromInclusive=false, toInclusive=false) float ratio) {
        if (ratio <= 0.0f || ratio >= 1.0f) {
            throw new IllegalArgumentException("ratio must be a float value between 0 and 1");
        }
        this.halfExpandedRatio = ratio;
        if (this.viewRef != null) {
            this.calculateHalfExpandedOffset();
        }
    }

    @FloatRange(from=0.0, to=1.0)
    public float getHalfExpandedRatio() {
        return this.halfExpandedRatio;
    }

    public void setExpandedOffset(int offset) {
        if (offset < 0) {
            throw new IllegalArgumentException("offset must be greater than or equal to 0");
        }
        this.expandedOffset = offset;
    }

    public int getExpandedOffset() {
        return this.fitToContents ? this.fitToContentsOffset : Math.max(this.expandedOffset, this.paddingTopSystemWindowInsets ? 0 : this.insetTop);
    }

    public void setHideable(boolean hideable) {
        if (this.hideable != hideable) {
            this.hideable = hideable;
            if (!hideable && this.state == 5) {
                this.setState(4);
            }
            this.updateAccessibilityActions();
        }
    }

    public boolean isHideable() {
        return this.hideable;
    }

    public void setSkipCollapsed(boolean skipCollapsed) {
        this.skipCollapsed = skipCollapsed;
    }

    public boolean getSkipCollapsed() {
        return this.skipCollapsed;
    }

    public void setDraggable(boolean draggable) {
        this.draggable = draggable;
    }

    public boolean isDraggable() {
        return this.draggable;
    }

    public void setSaveFlags(int flags) {
        this.saveFlags = flags;
    }

    public int getSaveFlags() {
        return this.saveFlags;
    }

    @Deprecated
    public void setBottomSheetCallback(BottomSheetCallback callback) {
        Log.w((String)TAG, (String)"BottomSheetBehavior now supports multiple callbacks. `setBottomSheetCallback()` removes all existing callbacks, including ones set internally by library authors, which may result in unintended behavior. This may change in the future. Please use `addBottomSheetCallback()` and `removeBottomSheetCallback()` instead to set your own callbacks.");
        this.callbacks.clear();
        if (callback != null) {
            this.callbacks.add(callback);
        }
    }

    public void addBottomSheetCallback(@NonNull BottomSheetCallback callback) {
        if (!this.callbacks.contains(callback)) {
            this.callbacks.add(callback);
        }
    }

    public void removeBottomSheetCallback(@NonNull BottomSheetCallback callback) {
        this.callbacks.remove(callback);
    }

    public void setState(int state) {
        if (state == 1 || state == 2) {
            throw new IllegalArgumentException("STATE_" + (state == 1 ? "DRAGGING" : "SETTLING") + " should not be set externally.");
        }
        if (!this.hideable && state == 5) {
            Log.w((String)TAG, (String)("Cannot set state: " + state));
            return;
        }
        final int finalState = state == 6 && this.fitToContents && this.getTopOffsetForState(state) <= this.fitToContentsOffset ? 3 : state;
        if (this.viewRef == null || this.viewRef.get() == null) {
            this.setStateInternal(state);
        } else {
            final View child = (View)this.viewRef.get();
            this.runAfterLayout(child, new Runnable(){

                @Override
                public void run() {
                    BottomSheetBehavior.this.startSettling(child, finalState, false);
                }
            });
        }
    }

    private void runAfterLayout(V child, Runnable runnable) {
        if (this.isLayouting(child)) {
            child.post(runnable);
        } else {
            runnable.run();
        }
    }

    private boolean isLayouting(V child) {
        ViewParent parent = child.getParent();
        return parent != null && parent.isLayoutRequested() && ViewCompat.isAttachedToWindow(child);
    }

    public void setGestureInsetBottomIgnored(boolean gestureInsetBottomIgnored) {
        this.gestureInsetBottomIgnored = gestureInsetBottomIgnored;
    }

    public boolean isGestureInsetBottomIgnored() {
        return this.gestureInsetBottomIgnored;
    }

    public int getState() {
        return this.state;
    }

    void setStateInternal(int state) {
        if (this.state == state) {
            return;
        }
        this.state = state;
        if (state == 4 || state == 3 || state == 6 || this.hideable && state == 5) {
            this.lastStableState = state;
        }
        if (this.viewRef == null) {
            return;
        }
        View bottomSheet = (View)this.viewRef.get();
        if (bottomSheet == null) {
            return;
        }
        if (state == 3) {
            this.updateImportantForAccessibility(true);
        } else if (state == 6 || state == 5 || state == 4) {
            this.updateImportantForAccessibility(false);
        }
        this.updateDrawableForTargetState(state);
        for (int i = 0; i < this.callbacks.size(); ++i) {
            this.callbacks.get(i).onStateChanged(bottomSheet, state);
        }
        this.updateAccessibilityActions();
    }

    private void updateDrawableForTargetState(int state) {
        boolean expand;
        if (state == 2) {
            return;
        }
        boolean bl = expand = state == 3;
        if (this.isShapeExpanded != expand) {
            this.isShapeExpanded = expand;
            if (this.materialShapeDrawable != null && this.interpolatorAnimator != null) {
                if (this.interpolatorAnimator.isRunning()) {
                    this.interpolatorAnimator.reverse();
                } else {
                    float to = expand ? 0.0f : 1.0f;
                    float from = 1.0f - to;
                    this.interpolatorAnimator.setFloatValues(new float[]{from, to});
                    this.interpolatorAnimator.start();
                }
            }
        }
    }

    private int calculatePeekHeight() {
        if (this.peekHeightAuto) {
            int desiredHeight = Math.max(this.peekHeightMin, this.parentHeight - this.parentWidth * 9 / 16);
            return Math.min(desiredHeight, this.childHeight) + this.insetBottom;
        }
        if (!this.gestureInsetBottomIgnored && !this.paddingBottomSystemWindowInsets && this.gestureInsetBottom > 0) {
            return Math.max(this.peekHeight, this.gestureInsetBottom + this.peekHeightGestureInsetBuffer);
        }
        return this.peekHeight + this.insetBottom;
    }

    private void calculateCollapsedOffset() {
        int peek = this.calculatePeekHeight();
        this.collapsedOffset = this.fitToContents ? Math.max(this.parentHeight - peek, this.fitToContentsOffset) : this.parentHeight - peek;
    }

    private void calculateHalfExpandedOffset() {
        this.halfExpandedOffset = (int)((float)this.parentHeight * (1.0f - this.halfExpandedRatio));
    }

    private void reset() {
        this.activePointerId = -1;
        if (this.velocityTracker != null) {
            this.velocityTracker.recycle();
            this.velocityTracker = null;
        }
    }

    private void restoreOptionalState(@NonNull SavedState ss) {
        if (this.saveFlags == 0) {
            return;
        }
        if (this.saveFlags == -1 || (this.saveFlags & 1) == 1) {
            this.peekHeight = ss.peekHeight;
        }
        if (this.saveFlags == -1 || (this.saveFlags & 2) == 2) {
            this.fitToContents = ss.fitToContents;
        }
        if (this.saveFlags == -1 || (this.saveFlags & 4) == 4) {
            this.hideable = ss.hideable;
        }
        if (this.saveFlags == -1 || (this.saveFlags & 8) == 8) {
            this.skipCollapsed = ss.skipCollapsed;
        }
    }

    boolean shouldHide(@NonNull View child, float yvel) {
        if (this.skipCollapsed) {
            return true;
        }
        if (child.getTop() < this.collapsedOffset) {
            return false;
        }
        int peek = this.calculatePeekHeight();
        float newTop = (float)child.getTop() + yvel * 0.1f;
        return Math.abs(newTop - (float)this.collapsedOffset) / (float)peek > 0.5f;
    }

    @Nullable
    @VisibleForTesting
    View findScrollingChild(View view) {
        if (ViewCompat.isNestedScrollingEnabled((View)view)) {
            return view;
        }
        if (view instanceof ViewGroup) {
            ViewGroup group = (ViewGroup)view;
            int count = group.getChildCount();
            for (int i = 0; i < count; ++i) {
                View scrollingChild = this.findScrollingChild(group.getChildAt(i));
                if (scrollingChild == null) continue;
                return scrollingChild;
            }
        }
        return null;
    }

    private boolean shouldHandleDraggingWithHelper() {
        return this.viewDragHelper != null && (this.draggable || this.state == 1);
    }

    private void createMaterialShapeDrawableIfNeeded(@NonNull Context context) {
        if (this.shapeAppearanceModelDefault == null) {
            return;
        }
        this.materialShapeDrawable = new MaterialShapeDrawable(this.shapeAppearanceModelDefault);
        this.materialShapeDrawable.initializeElevationOverlay(context);
        if (this.backgroundTint != null) {
            this.materialShapeDrawable.setFillColor(this.backgroundTint);
        } else {
            TypedValue defaultColor = new TypedValue();
            context.getTheme().resolveAttribute(0x1010031, defaultColor, true);
            this.materialShapeDrawable.setTint(defaultColor.data);
        }
    }

    MaterialShapeDrawable getMaterialShapeDrawable() {
        return this.materialShapeDrawable;
    }

    private void createShapeValueAnimator() {
        this.interpolatorAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        this.interpolatorAnimator.setDuration(500L);
        this.interpolatorAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(@NonNull ValueAnimator animation) {
                float value = ((Float)animation.getAnimatedValue()).floatValue();
                if (BottomSheetBehavior.this.materialShapeDrawable != null) {
                    BottomSheetBehavior.this.materialShapeDrawable.setInterpolation(value);
                }
            }
        });
    }

    private void setWindowInsetsListener(@NonNull View child) {
        boolean shouldHandleGestureInsets;
        boolean bl = shouldHandleGestureInsets = Build.VERSION.SDK_INT >= 29 && !this.isGestureInsetBottomIgnored() && !this.peekHeightAuto;
        if (!(this.paddingBottomSystemWindowInsets || this.paddingLeftSystemWindowInsets || this.paddingRightSystemWindowInsets || this.marginLeftSystemWindowInsets || this.marginRightSystemWindowInsets || this.marginTopSystemWindowInsets || shouldHandleGestureInsets)) {
            return;
        }
        ViewUtils.doOnApplyWindowInsets(child, new ViewUtils.OnApplyWindowInsetsListener(){

            @Override
            public WindowInsetsCompat onApplyWindowInsets(View view, WindowInsetsCompat insets, ViewUtils.RelativePadding initialPadding) {
                Insets systemBarInsets = insets.getInsets(WindowInsetsCompat.Type.systemBars());
                Insets mandatoryGestureInsets = insets.getInsets(WindowInsetsCompat.Type.mandatorySystemGestures());
                BottomSheetBehavior.this.insetTop = systemBarInsets.top;
                boolean isRtl = ViewUtils.isLayoutRtl(view);
                int bottomPadding = view.getPaddingBottom();
                int leftPadding = view.getPaddingLeft();
                int rightPadding = view.getPaddingRight();
                if (BottomSheetBehavior.this.paddingBottomSystemWindowInsets) {
                    BottomSheetBehavior.this.insetBottom = insets.getSystemWindowInsetBottom();
                    bottomPadding = initialPadding.bottom + BottomSheetBehavior.this.insetBottom;
                }
                if (BottomSheetBehavior.this.paddingLeftSystemWindowInsets) {
                    leftPadding = isRtl ? initialPadding.end : initialPadding.start;
                    leftPadding += systemBarInsets.left;
                }
                if (BottomSheetBehavior.this.paddingRightSystemWindowInsets) {
                    rightPadding = isRtl ? initialPadding.start : initialPadding.end;
                    rightPadding += systemBarInsets.right;
                }
                ViewGroup.MarginLayoutParams mlp = (ViewGroup.MarginLayoutParams)view.getLayoutParams();
                boolean marginUpdated = false;
                if (BottomSheetBehavior.this.marginLeftSystemWindowInsets && mlp.leftMargin != systemBarInsets.left) {
                    mlp.leftMargin = systemBarInsets.left;
                    marginUpdated = true;
                }
                if (BottomSheetBehavior.this.marginRightSystemWindowInsets && mlp.rightMargin != systemBarInsets.right) {
                    mlp.rightMargin = systemBarInsets.right;
                    marginUpdated = true;
                }
                if (BottomSheetBehavior.this.marginTopSystemWindowInsets && mlp.topMargin != systemBarInsets.top) {
                    mlp.topMargin = systemBarInsets.top;
                    marginUpdated = true;
                }
                if (marginUpdated) {
                    view.setLayoutParams((ViewGroup.LayoutParams)mlp);
                }
                view.setPadding(leftPadding, view.getPaddingTop(), rightPadding, bottomPadding);
                if (shouldHandleGestureInsets) {
                    BottomSheetBehavior.this.gestureInsetBottom = mandatoryGestureInsets.bottom;
                }
                if (BottomSheetBehavior.this.paddingBottomSystemWindowInsets || shouldHandleGestureInsets) {
                    BottomSheetBehavior.this.updatePeekHeight(false);
                }
                return insets;
            }
        });
    }

    private float getYVelocity() {
        if (this.velocityTracker == null) {
            return 0.0f;
        }
        this.velocityTracker.computeCurrentVelocity(1000, this.maximumVelocity);
        return this.velocityTracker.getYVelocity(this.activePointerId);
    }

    private void startSettling(View child, int state, boolean isReleasingView) {
        boolean settling;
        int top = this.getTopOffsetForState(state);
        boolean bl = this.viewDragHelper != null && (isReleasingView ? this.viewDragHelper.settleCapturedViewAt(child.getLeft(), top) : this.viewDragHelper.smoothSlideViewTo(child, child.getLeft(), top)) ? true : (settling = false);
        if (settling) {
            this.setStateInternal(2);
            this.updateDrawableForTargetState(state);
            this.stateSettlingTracker.continueSettlingToState(state);
        } else {
            this.setStateInternal(state);
        }
    }

    private int getTopOffsetForState(int state) {
        switch (state) {
            case 4: {
                return this.collapsedOffset;
            }
            case 3: {
                return this.getExpandedOffset();
            }
            case 6: {
                return this.halfExpandedOffset;
            }
            case 5: {
                return this.parentHeight;
            }
        }
        throw new IllegalArgumentException("Invalid state to get top offset: " + state);
    }

    void dispatchOnSlide(int top) {
        View bottomSheet = (View)this.viewRef.get();
        if (bottomSheet != null && !this.callbacks.isEmpty()) {
            float slideOffset = top > this.collapsedOffset || this.collapsedOffset == this.getExpandedOffset() ? (float)(this.collapsedOffset - top) / (float)(this.parentHeight - this.collapsedOffset) : (float)(this.collapsedOffset - top) / (float)(this.collapsedOffset - this.getExpandedOffset());
            for (int i = 0; i < this.callbacks.size(); ++i) {
                this.callbacks.get(i).onSlide(bottomSheet, slideOffset);
            }
        }
    }

    @VisibleForTesting
    int getPeekHeightMin() {
        return this.peekHeightMin;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @VisibleForTesting
    public void disableShapeAnimations() {
        this.interpolatorAnimator = null;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public boolean isNestedScrollingCheckEnabled() {
        return true;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public boolean shouldSkipHalfExpandedStateWhenDragging() {
        return false;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public boolean shouldSkipSmoothAnimation() {
        return true;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public boolean shouldExpandOnUpwardDrag(long dragDurationMillis, @FloatRange(from=0.0, to=100.0) float yPositionPercentage) {
        return false;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void setHideableInternal(boolean hideable) {
        this.hideable = hideable;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public int getLastStableState() {
        return this.lastStableState;
    }

    @NonNull
    public static <V extends View> BottomSheetBehavior<V> from(@NonNull V view) {
        ViewGroup.LayoutParams params = view.getLayoutParams();
        if (!(params instanceof CoordinatorLayout.LayoutParams)) {
            throw new IllegalArgumentException("The view is not a child of CoordinatorLayout");
        }
        CoordinatorLayout.Behavior behavior = ((CoordinatorLayout.LayoutParams)params).getBehavior();
        if (!(behavior instanceof BottomSheetBehavior)) {
            throw new IllegalArgumentException("The view is not associated with BottomSheetBehavior");
        }
        return (BottomSheetBehavior)behavior;
    }

    public void setUpdateImportantForAccessibilityOnSiblings(boolean updateImportantForAccessibilityOnSiblings) {
        this.updateImportantForAccessibilityOnSiblings = updateImportantForAccessibilityOnSiblings;
    }

    private void updateImportantForAccessibility(boolean expanded) {
        if (this.viewRef == null) {
            return;
        }
        ViewParent viewParent = ((View)this.viewRef.get()).getParent();
        if (!(viewParent instanceof CoordinatorLayout)) {
            return;
        }
        CoordinatorLayout parent = (CoordinatorLayout)viewParent;
        int childCount = parent.getChildCount();
        if (Build.VERSION.SDK_INT >= 16 && expanded) {
            if (this.importantForAccessibilityMap == null) {
                this.importantForAccessibilityMap = new HashMap<View, Integer>(childCount);
            } else {
                return;
            }
        }
        for (int i = 0; i < childCount; ++i) {
            View child = parent.getChildAt(i);
            if (child == this.viewRef.get()) continue;
            if (expanded) {
                if (Build.VERSION.SDK_INT >= 16) {
                    this.importantForAccessibilityMap.put(child, child.getImportantForAccessibility());
                }
                if (!this.updateImportantForAccessibilityOnSiblings) continue;
                ViewCompat.setImportantForAccessibility((View)child, (int)4);
                continue;
            }
            if (!this.updateImportantForAccessibilityOnSiblings || this.importantForAccessibilityMap == null || !this.importantForAccessibilityMap.containsKey(child)) continue;
            ViewCompat.setImportantForAccessibility((View)child, (int)this.importantForAccessibilityMap.get(child));
        }
        if (!expanded) {
            this.importantForAccessibilityMap = null;
        } else if (this.updateImportantForAccessibilityOnSiblings) {
            ((View)this.viewRef.get()).sendAccessibilityEvent(8);
        }
    }

    private void updateAccessibilityActions() {
        if (this.viewRef == null) {
            return;
        }
        View child = (View)this.viewRef.get();
        if (child == null) {
            return;
        }
        ViewCompat.removeAccessibilityAction((View)child, (int)524288);
        ViewCompat.removeAccessibilityAction((View)child, (int)262144);
        ViewCompat.removeAccessibilityAction((View)child, (int)0x100000);
        if (this.expandHalfwayActionId != -1) {
            ViewCompat.removeAccessibilityAction((View)child, (int)this.expandHalfwayActionId);
        }
        if (!this.fitToContents && this.state != 6) {
            this.expandHalfwayActionId = this.addAccessibilityActionForState(child, R.string.bottomsheet_action_expand_halfway, 6);
        }
        if (this.hideable && this.state != 5) {
            this.replaceAccessibilityActionForState(child, AccessibilityNodeInfoCompat.AccessibilityActionCompat.ACTION_DISMISS, 5);
        }
        switch (this.state) {
            case 3: {
                int nextState = this.fitToContents ? 4 : 6;
                this.replaceAccessibilityActionForState(child, AccessibilityNodeInfoCompat.AccessibilityActionCompat.ACTION_COLLAPSE, nextState);
                break;
            }
            case 6: {
                this.replaceAccessibilityActionForState(child, AccessibilityNodeInfoCompat.AccessibilityActionCompat.ACTION_COLLAPSE, 4);
                this.replaceAccessibilityActionForState(child, AccessibilityNodeInfoCompat.AccessibilityActionCompat.ACTION_EXPAND, 3);
                break;
            }
            case 4: {
                int nextState = this.fitToContents ? 3 : 6;
                this.replaceAccessibilityActionForState(child, AccessibilityNodeInfoCompat.AccessibilityActionCompat.ACTION_EXPAND, nextState);
                break;
            }
        }
    }

    private void replaceAccessibilityActionForState(V child, AccessibilityNodeInfoCompat.AccessibilityActionCompat action, int state) {
        ViewCompat.replaceAccessibilityAction(child, (AccessibilityNodeInfoCompat.AccessibilityActionCompat)action, null, (AccessibilityViewCommand)this.createAccessibilityViewCommandForState(state));
    }

    private int addAccessibilityActionForState(V child, @StringRes int stringResId, int state) {
        return ViewCompat.addAccessibilityAction(child, (CharSequence)child.getResources().getString(stringResId), (AccessibilityViewCommand)this.createAccessibilityViewCommandForState(state));
    }

    private AccessibilityViewCommand createAccessibilityViewCommandForState(final int state) {
        return new AccessibilityViewCommand(){

            public boolean perform(@NonNull View view, @Nullable AccessibilityViewCommand.CommandArguments arguments) {
                BottomSheetBehavior.this.setState(state);
                return true;
            }
        };
    }

    protected static class SavedState
    extends AbsSavedState {
        final int state;
        int peekHeight;
        boolean fitToContents;
        boolean hideable;
        boolean skipCollapsed;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.ClassLoaderCreator<SavedState>(){

            @NonNull
            public SavedState createFromParcel(@NonNull Parcel in, ClassLoader loader) {
                return new SavedState(in, loader);
            }

            @Nullable
            public SavedState createFromParcel(@NonNull Parcel in) {
                return new SavedState(in, null);
            }

            @NonNull
            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        public SavedState(@NonNull Parcel source) {
            this(source, null);
        }

        public SavedState(@NonNull Parcel source, ClassLoader loader) {
            super(source, loader);
            this.state = source.readInt();
            this.peekHeight = source.readInt();
            this.fitToContents = source.readInt() == 1;
            this.hideable = source.readInt() == 1;
            this.skipCollapsed = source.readInt() == 1;
        }

        public SavedState(Parcelable superState, @NonNull BottomSheetBehavior<?> behavior) {
            super(superState);
            this.state = behavior.state;
            this.peekHeight = ((BottomSheetBehavior)behavior).peekHeight;
            this.fitToContents = ((BottomSheetBehavior)behavior).fitToContents;
            this.hideable = behavior.hideable;
            this.skipCollapsed = ((BottomSheetBehavior)behavior).skipCollapsed;
        }

        @Deprecated
        public SavedState(Parcelable superstate, int state) {
            super(superstate);
            this.state = state;
        }

        public void writeToParcel(@NonNull Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeInt(this.state);
            out.writeInt(this.peekHeight);
            out.writeInt(this.fitToContents ? 1 : 0);
            out.writeInt(this.hideable ? 1 : 0);
            out.writeInt(this.skipCollapsed ? 1 : 0);
        }
    }

    private class StateSettlingTracker {
        private int targetState;
        private boolean isContinueSettlingRunnablePosted;
        private final Runnable continueSettlingRunnable = new Runnable(){

            @Override
            public void run() {
                StateSettlingTracker.this.isContinueSettlingRunnablePosted = false;
                if (BottomSheetBehavior.this.viewDragHelper != null && BottomSheetBehavior.this.viewDragHelper.continueSettling(true)) {
                    StateSettlingTracker.this.continueSettlingToState(StateSettlingTracker.this.targetState);
                } else if (BottomSheetBehavior.this.state == 2) {
                    BottomSheetBehavior.this.setStateInternal(StateSettlingTracker.this.targetState);
                }
            }
        };

        private StateSettlingTracker() {
        }

        void continueSettlingToState(int targetState) {
            if (BottomSheetBehavior.this.viewRef == null || BottomSheetBehavior.this.viewRef.get() == null) {
                return;
            }
            this.targetState = targetState;
            if (!this.isContinueSettlingRunnablePosted) {
                ViewCompat.postOnAnimation((View)((View)BottomSheetBehavior.this.viewRef.get()), (Runnable)this.continueSettlingRunnable);
                this.isContinueSettlingRunnablePosted = true;
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface SaveFlags {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface StableState {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface State {
    }

    public static abstract class BottomSheetCallback {
        public abstract void onStateChanged(@NonNull View var1, int var2);

        public abstract void onSlide(@NonNull View var1, float var2);

        void onLayout(@NonNull View bottomSheet) {
        }
    }
}

