/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.content.res;

import android.graphics.Color;
import androidx.annotation.NonNull;
import androidx.core.graphics.ColorUtils;

final class CamUtils {
    static final float[][] XYZ_TO_CAM16RGB = new float[][]{{0.401288f, 0.650173f, -0.051461f}, {-0.250268f, 1.204414f, 0.045854f}, {-0.002079f, 0.048952f, 0.953127f}};
    static final float[][] CAM16RGB_TO_XYZ = new float[][]{{1.8620678f, -1.0112547f, 0.14918678f}, {0.38752654f, 0.62144744f, -0.00897398f}, {-0.0158415f, -0.03412294f, 1.0499644f}};
    static final float[] WHITE_POINT_D65 = new float[]{95.047f, 100.0f, 108.883f};
    static final float[][] SRGB_TO_XYZ = new float[][]{{0.41233894f, 0.35762063f, 0.18051042f}, {0.2126f, 0.7152f, 0.0722f}, {0.01932141f, 0.11916382f, 0.9503448f}};

    private CamUtils() {
    }

    static int intFromLStar(float lStar) {
        float fy;
        if (lStar < 1.0f) {
            return -16777216;
        }
        if (lStar > 99.0f) {
            return -1;
        }
        float fz = fy = (lStar + 16.0f) / 116.0f;
        float fx = fy;
        float kappa = 903.2963f;
        float epsilon = 0.008856452f;
        boolean lExceedsEpsilonKappa = lStar > 8.0f;
        float yT = lExceedsEpsilonKappa ? fy * fy * fy : lStar / kappa;
        boolean cubeExceedEpsilon = fy * fy * fy > epsilon;
        float xT = cubeExceedEpsilon ? fx * fx * fx : (116.0f * fx - 16.0f) / kappa;
        float zT = cubeExceedEpsilon ? fz * fz * fz : (116.0f * fx - 16.0f) / kappa;
        return ColorUtils.XYZToColor(xT * WHITE_POINT_D65[0], yT * WHITE_POINT_D65[1], zT * WHITE_POINT_D65[2]);
    }

    static float lerp(float start, float stop, float amount) {
        return start + (stop - start) * amount;
    }

    static float lStarFromInt(int argb) {
        return CamUtils.lStarFromY(CamUtils.yFromInt(argb));
    }

    static float lStarFromY(float y) {
        y /= 100.0f;
        float e = 0.008856452f;
        if (y <= 0.008856452f) {
            return 903.2963f * y;
        }
        float yIntermediate = (float)Math.cbrt(y);
        return 116.0f * yIntermediate - 16.0f;
    }

    static float yFromInt(int argb) {
        float r = CamUtils.linearized(Color.red((int)argb));
        float g = CamUtils.linearized(Color.green((int)argb));
        float b = CamUtils.linearized(Color.blue((int)argb));
        float[][] matrix = SRGB_TO_XYZ;
        float y = r * matrix[1][0] + g * matrix[1][1] + b * matrix[1][2];
        return y;
    }

    @NonNull
    static float[] xyzFromInt(int argb) {
        float r = CamUtils.linearized(Color.red((int)argb));
        float g = CamUtils.linearized(Color.green((int)argb));
        float b = CamUtils.linearized(Color.blue((int)argb));
        float[][] matrix = SRGB_TO_XYZ;
        float x = r * matrix[0][0] + g * matrix[0][1] + b * matrix[0][2];
        float y = r * matrix[1][0] + g * matrix[1][1] + b * matrix[1][2];
        float z = r * matrix[2][0] + g * matrix[2][1] + b * matrix[2][2];
        return new float[]{x, y, z};
    }

    static float yFromLStar(float lstar) {
        float ke = 8.0f;
        if (lstar > ke) {
            return (float)Math.pow(((double)lstar + 16.0) / 116.0, 3.0) * 100.0f;
        }
        return lstar / 903.2963f * 100.0f;
    }

    static float linearized(int rgbComponent) {
        float normalized = (float)rgbComponent / 255.0f;
        if (normalized <= 0.04045f) {
            return normalized / 12.92f * 100.0f;
        }
        return (float)Math.pow((normalized + 0.055f) / 1.055f, 2.4f) * 100.0f;
    }
}

