/*
 * Decompiled with CFR 0.152.
 */
package androidx.browser.customtabs;

import android.os.Bundle;
import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

public final class CustomTabColorSchemeParams {
    @Nullable
    @ColorInt
    public final Integer toolbarColor;
    @Nullable
    @ColorInt
    public final Integer secondaryToolbarColor;
    @Nullable
    @ColorInt
    public final Integer navigationBarColor;
    @Nullable
    @ColorInt
    public final Integer navigationBarDividerColor;

    CustomTabColorSchemeParams(@Nullable @ColorInt Integer toolbarColor, @Nullable @ColorInt Integer secondaryToolbarColor, @Nullable @ColorInt Integer navigationBarColor, @Nullable @ColorInt Integer navigationBarDividerColor) {
        this.toolbarColor = toolbarColor;
        this.secondaryToolbarColor = secondaryToolbarColor;
        this.navigationBarColor = navigationBarColor;
        this.navigationBarDividerColor = navigationBarDividerColor;
    }

    @NonNull
    Bundle toBundle() {
        Bundle bundle = new Bundle();
        if (this.toolbarColor != null) {
            bundle.putInt("android.support.customtabs.extra.TOOLBAR_COLOR", this.toolbarColor.intValue());
        }
        if (this.secondaryToolbarColor != null) {
            bundle.putInt("android.support.customtabs.extra.SECONDARY_TOOLBAR_COLOR", this.secondaryToolbarColor.intValue());
        }
        if (this.navigationBarColor != null) {
            bundle.putInt("androidx.browser.customtabs.extra.NAVIGATION_BAR_COLOR", this.navigationBarColor.intValue());
        }
        if (this.navigationBarDividerColor != null) {
            bundle.putInt("androidx.browser.customtabs.extra.NAVIGATION_BAR_DIVIDER_COLOR", this.navigationBarDividerColor.intValue());
        }
        return bundle;
    }

    @NonNull
    static CustomTabColorSchemeParams fromBundle(@Nullable Bundle bundle) {
        if (bundle == null) {
            bundle = new Bundle(0);
        }
        return new CustomTabColorSchemeParams((Integer)bundle.get("android.support.customtabs.extra.TOOLBAR_COLOR"), (Integer)bundle.get("android.support.customtabs.extra.SECONDARY_TOOLBAR_COLOR"), (Integer)bundle.get("androidx.browser.customtabs.extra.NAVIGATION_BAR_COLOR"), (Integer)bundle.get("androidx.browser.customtabs.extra.NAVIGATION_BAR_DIVIDER_COLOR"));
    }

    @NonNull
    CustomTabColorSchemeParams withDefaults(@NonNull CustomTabColorSchemeParams defaults) {
        return new CustomTabColorSchemeParams(this.toolbarColor == null ? defaults.toolbarColor : this.toolbarColor, this.secondaryToolbarColor == null ? defaults.secondaryToolbarColor : this.secondaryToolbarColor, this.navigationBarColor == null ? defaults.navigationBarColor : this.navigationBarColor, this.navigationBarDividerColor == null ? defaults.navigationBarDividerColor : this.navigationBarDividerColor);
    }

    public static final class Builder {
        @Nullable
        @ColorInt
        private Integer mToolbarColor;
        @Nullable
        @ColorInt
        private Integer mSecondaryToolbarColor;
        @Nullable
        @ColorInt
        private Integer mNavigationBarColor;
        @Nullable
        @ColorInt
        private Integer mNavigationBarDividerColor;

        @NonNull
        public Builder setToolbarColor(@ColorInt int color) {
            this.mToolbarColor = color | 0xFF000000;
            return this;
        }

        @NonNull
        public Builder setSecondaryToolbarColor(@ColorInt int color) {
            this.mSecondaryToolbarColor = color;
            return this;
        }

        @NonNull
        public Builder setNavigationBarColor(@ColorInt int color) {
            this.mNavigationBarColor = color | 0xFF000000;
            return this;
        }

        @NonNull
        public Builder setNavigationBarDividerColor(@ColorInt int color) {
            this.mNavigationBarDividerColor = color;
            return this;
        }

        @NonNull
        public CustomTabColorSchemeParams build() {
            return new CustomTabColorSchemeParams(this.mToolbarColor, this.mSecondaryToolbarColor, this.mNavigationBarColor, this.mNavigationBarDividerColor);
        }
    }
}

