/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.navigationrail;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Px;
import androidx.annotation.RestrictTo;
import com.google.android.material.navigation.NavigationBarItemView;
import com.google.android.material.navigation.NavigationBarMenuView;
import com.google.android.material.navigationrail.NavigationRailItemView;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class NavigationRailMenuView
extends NavigationBarMenuView {
    @Px
    private int itemMinimumHeight = -1;
    private final FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -2);

    public NavigationRailMenuView(@NonNull Context context) {
        super(context);
        this.layoutParams.gravity = 49;
        this.setLayoutParams((ViewGroup.LayoutParams)this.layoutParams);
        this.setItemActiveIndicatorResizeable(true);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int maxHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int visibleCount = this.getMenu().getVisibleItems().size();
        int measuredHeight = visibleCount > 1 && this.isShifting(this.getLabelVisibilityMode(), visibleCount) ? this.measureShiftingChildHeights(widthMeasureSpec, maxHeight, visibleCount) : this.measureSharedChildHeights(widthMeasureSpec, maxHeight, visibleCount, null);
        int parentWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        this.setMeasuredDimension(View.resolveSizeAndState((int)parentWidth, (int)widthMeasureSpec, (int)0), View.resolveSizeAndState((int)measuredHeight, (int)heightMeasureSpec, (int)0));
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        int count = this.getChildCount();
        int width = right - left;
        int used = 0;
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            int childHeight = child.getMeasuredHeight();
            child.layout(0, used, width, childHeight + used);
            used += childHeight;
        }
    }

    @Override
    @NonNull
    protected NavigationBarItemView createNavigationBarItemView(@NonNull Context context) {
        return new NavigationRailItemView(context);
    }

    private int makeSharedHeightSpec(int parentWidthSpec, int maxHeight, int shareCount) {
        int maxAvailable = maxHeight / Math.max(1, shareCount);
        int minHeight = this.itemMinimumHeight != -1 ? this.itemMinimumHeight : View.MeasureSpec.getSize((int)parentWidthSpec);
        return View.MeasureSpec.makeMeasureSpec((int)Math.min(minHeight, maxAvailable), (int)0);
    }

    private int measureShiftingChildHeights(int widthMeasureSpec, int maxHeight, int shareCount) {
        int selectedViewHeight = 0;
        View selectedView = this.getChildAt(this.getSelectedItemPosition());
        if (selectedView != null) {
            int childHeightSpec = this.makeSharedHeightSpec(widthMeasureSpec, maxHeight, shareCount);
            selectedViewHeight = this.measureChildHeight(selectedView, widthMeasureSpec, childHeightSpec);
            maxHeight -= selectedViewHeight;
            --shareCount;
        }
        return selectedViewHeight + this.measureSharedChildHeights(widthMeasureSpec, maxHeight, shareCount, selectedView);
    }

    private int measureSharedChildHeights(int widthMeasureSpec, int maxHeight, int shareCount, View selectedView) {
        int childHeightSpec = this.makeSharedHeightSpec(widthMeasureSpec, maxHeight, shareCount);
        childHeightSpec = selectedView == null ? this.makeSharedHeightSpec(widthMeasureSpec, maxHeight, shareCount) : View.MeasureSpec.makeMeasureSpec((int)selectedView.getMeasuredHeight(), (int)0);
        int childCount = this.getChildCount();
        int totalHeight = 0;
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            if (child == selectedView) continue;
            totalHeight += this.measureChildHeight(child, widthMeasureSpec, childHeightSpec);
        }
        return totalHeight;
    }

    private int measureChildHeight(View child, int widthMeasureSpec, int heightMeasureSpec) {
        if (child.getVisibility() != 8) {
            child.measure(widthMeasureSpec, heightMeasureSpec);
            return child.getMeasuredHeight();
        }
        return 0;
    }

    void setMenuGravity(int gravity) {
        if (this.layoutParams.gravity != gravity) {
            this.layoutParams.gravity = gravity;
            this.setLayoutParams((ViewGroup.LayoutParams)this.layoutParams);
        }
    }

    int getMenuGravity() {
        return this.layoutParams.gravity;
    }

    public void setItemMinimumHeight(@Px int minHeight) {
        if (this.itemMinimumHeight != minHeight) {
            this.itemMinimumHeight = minHeight;
            this.requestLayout();
        }
    }

    @Px
    public int getItemMinimumHeight() {
        return this.itemMinimumHeight;
    }

    boolean isTopGravity() {
        return (this.layoutParams.gravity & 0x70) == 48;
    }
}

