/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.motion.widget;

import android.graphics.Rect;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import androidx.constraintlayout.motion.widget.MotionController;
import androidx.constraintlayout.motion.widget.MotionLayout;
import androidx.constraintlayout.motion.widget.ViewTransition;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.constraintlayout.widget.ConstraintSet;
import androidx.constraintlayout.widget.SharedValues;
import java.util.ArrayList;
import java.util.HashSet;

public class ViewTransitionController {
    private final MotionLayout mMotionLayout;
    private ArrayList<ViewTransition> viewTransitions = new ArrayList();
    private HashSet<View> mRelatedViews;
    private String TAG = "ViewTransitionController";
    ArrayList<ViewTransition.Animate> animations;
    ArrayList<ViewTransition.Animate> removeList = new ArrayList();

    public ViewTransitionController(MotionLayout layout) {
        this.mMotionLayout = layout;
    }

    public void add(ViewTransition viewTransition) {
        this.viewTransitions.add(viewTransition);
        this.mRelatedViews = null;
        if (viewTransition.getStateTransition() == 4) {
            this.listenForSharedVariable(viewTransition, true);
        } else if (viewTransition.getStateTransition() == 5) {
            this.listenForSharedVariable(viewTransition, false);
        }
    }

    void remove(int id2) {
        ViewTransition del = null;
        for (ViewTransition viewTransition : this.viewTransitions) {
            if (viewTransition.getId() != id2) continue;
            del = viewTransition;
            break;
        }
        if (del != null) {
            this.mRelatedViews = null;
            this.viewTransitions.remove(del);
        }
    }

    private void viewTransition(ViewTransition vt, View ... view) {
        int currentId = this.mMotionLayout.getCurrentState();
        if (vt.mViewTransitionMode != 2) {
            if (currentId == -1) {
                Log.w((String)this.TAG, (String)("No support for ViewTransition within transition yet. Currently: " + this.mMotionLayout.toString()));
                return;
            }
            ConstraintSet current = this.mMotionLayout.getConstraintSet(currentId);
            if (current == null) {
                return;
            }
            vt.applyTransition(this, this.mMotionLayout, currentId, current, view);
        } else {
            vt.applyTransition(this, this.mMotionLayout, currentId, null, view);
        }
    }

    void enableViewTransition(int id2, boolean enable) {
        for (ViewTransition viewTransition : this.viewTransitions) {
            if (viewTransition.getId() != id2) continue;
            viewTransition.setEnabled(enable);
            break;
        }
    }

    boolean isViewTransitionEnabled(int id2) {
        for (ViewTransition viewTransition : this.viewTransitions) {
            if (viewTransition.getId() != id2) continue;
            return viewTransition.isEnabled();
        }
        return false;
    }

    void viewTransition(int id2, View ... views) {
        ViewTransition vt = null;
        ArrayList<View> list = new ArrayList<View>();
        for (ViewTransition viewTransition : this.viewTransitions) {
            if (viewTransition.getId() != id2) continue;
            vt = viewTransition;
            for (View view : views) {
                if (!viewTransition.checkTags(view)) continue;
                list.add(view);
            }
            if (list.isEmpty()) continue;
            this.viewTransition(vt, list.toArray(new View[0]));
            list.clear();
        }
        if (vt == null) {
            Log.e((String)this.TAG, (String)" Could not find ViewTransition");
            return;
        }
    }

    void touchEvent(MotionEvent event) {
        int currentId = this.mMotionLayout.getCurrentState();
        if (currentId == -1) {
            return;
        }
        if (this.mRelatedViews == null) {
            this.mRelatedViews = new HashSet();
            for (ViewTransition viewTransition : this.viewTransitions) {
                int count = this.mMotionLayout.getChildCount();
                for (int i = 0; i < count; ++i) {
                    View view = this.mMotionLayout.getChildAt(i);
                    if (!viewTransition.matchesView(view)) continue;
                    int id2 = view.getId();
                    this.mRelatedViews.add(view);
                }
            }
        }
        float x = event.getX();
        float y = event.getY();
        Rect rec = new Rect();
        int action = event.getAction();
        if (this.animations != null && !this.animations.isEmpty()) {
            for (ViewTransition.Animate animation : this.animations) {
                animation.reactTo(action, x, y);
            }
        }
        switch (action) {
            case 0: 
            case 1: {
                ConstraintSet current = this.mMotionLayout.getConstraintSet(currentId);
                for (ViewTransition viewTransition : this.viewTransitions) {
                    if (!viewTransition.supports(action)) continue;
                    for (View view : this.mRelatedViews) {
                        if (!viewTransition.matchesView(view)) continue;
                        view.getHitRect(rec);
                        if (!rec.contains((int)x, (int)y)) continue;
                        viewTransition.applyTransition(this, this.mMotionLayout, currentId, current, view);
                    }
                }
                break;
            }
        }
    }

    void addAnimation(ViewTransition.Animate animation) {
        if (this.animations == null) {
            this.animations = new ArrayList();
        }
        this.animations.add(animation);
    }

    void removeAnimation(ViewTransition.Animate animation) {
        this.removeList.add(animation);
    }

    void animate() {
        if (this.animations == null) {
            return;
        }
        for (ViewTransition.Animate animation : this.animations) {
            animation.mutate();
        }
        this.animations.removeAll(this.removeList);
        this.removeList.clear();
        if (this.animations.isEmpty()) {
            this.animations = null;
        }
    }

    void invalidate() {
        this.mMotionLayout.invalidate();
    }

    boolean applyViewTransition(int viewTransitionId, MotionController motionController) {
        for (ViewTransition viewTransition : this.viewTransitions) {
            if (viewTransition.getId() != viewTransitionId) continue;
            viewTransition.mKeyFrames.addAllFrames(motionController);
            return true;
        }
        return false;
    }

    private void listenForSharedVariable(final ViewTransition viewTransition, final boolean isSet) {
        final int listen_for_id = viewTransition.getSharedValueID();
        final int listen_for_value = viewTransition.getSharedValue();
        ConstraintLayout.getSharedValues().addListener(viewTransition.getSharedValueID(), new SharedValues.SharedValuesListener(){

            @Override
            public void onNewValue(int id2, int value, int oldValue) {
                block3: {
                    block4: {
                        int current_value = viewTransition.getSharedValueCurrent();
                        viewTransition.setSharedValueCurrent(value);
                        if (listen_for_id != id2 || current_value == value) break block3;
                        if (!isSet) break block4;
                        if (listen_for_value != value) break block3;
                        int count = ViewTransitionController.this.mMotionLayout.getChildCount();
                        for (int i = 0; i < count; ++i) {
                            View view = ViewTransitionController.this.mMotionLayout.getChildAt(i);
                            if (!viewTransition.matchesView(view)) continue;
                            int currentId = ViewTransitionController.this.mMotionLayout.getCurrentState();
                            ConstraintSet current = ViewTransitionController.this.mMotionLayout.getConstraintSet(currentId);
                            viewTransition.applyTransition(ViewTransitionController.this, ViewTransitionController.this.mMotionLayout, currentId, current, view);
                        }
                        break block3;
                    }
                    if (listen_for_value != value) {
                        int count = ViewTransitionController.this.mMotionLayout.getChildCount();
                        for (int i = 0; i < count; ++i) {
                            View view = ViewTransitionController.this.mMotionLayout.getChildAt(i);
                            if (!viewTransition.matchesView(view)) continue;
                            int currentId = ViewTransitionController.this.mMotionLayout.getCurrentState();
                            ConstraintSet current = ViewTransitionController.this.mMotionLayout.getConstraintSet(currentId);
                            viewTransition.applyTransition(ViewTransitionController.this, ViewTransitionController.this.mMotionLayout, currentId, current, view);
                        }
                    }
                }
            }
        });
    }
}

