/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.engine;

import androidx.annotation.NonNull;
import com.bumptech.glide.load.Key;
import com.bumptech.glide.load.engine.Resource;
import com.bumptech.glide.util.Preconditions;

class EngineResource<Z>
implements Resource<Z> {
    private final boolean isMemoryCacheable;
    private final boolean isRecyclable;
    private final Resource<Z> resource;
    private final ResourceListener listener;
    private final Key key;
    private int acquired;
    private boolean isRecycled;

    EngineResource(Resource<Z> toWrap, boolean isMemoryCacheable, boolean isRecyclable, Key key, ResourceListener listener) {
        this.resource = Preconditions.checkNotNull(toWrap);
        this.isMemoryCacheable = isMemoryCacheable;
        this.isRecyclable = isRecyclable;
        this.key = key;
        this.listener = Preconditions.checkNotNull(listener);
    }

    Resource<Z> getResource() {
        return this.resource;
    }

    boolean isMemoryCacheable() {
        return this.isMemoryCacheable;
    }

    @Override
    @NonNull
    public Class<Z> getResourceClass() {
        return this.resource.getResourceClass();
    }

    @Override
    @NonNull
    public Z get() {
        return this.resource.get();
    }

    @Override
    public int getSize() {
        return this.resource.getSize();
    }

    @Override
    public synchronized void recycle() {
        if (this.acquired > 0) {
            throw new IllegalStateException("Cannot recycle a resource while it is still acquired");
        }
        if (this.isRecycled) {
            throw new IllegalStateException("Cannot recycle a resource that has already been recycled");
        }
        this.isRecycled = true;
        if (this.isRecyclable) {
            this.resource.recycle();
        }
    }

    synchronized void acquire() {
        if (this.isRecycled) {
            throw new IllegalStateException("Cannot acquire a recycled resource");
        }
        ++this.acquired;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void release() {
        boolean release = false;
        EngineResource engineResource = this;
        synchronized (engineResource) {
            if (this.acquired <= 0) {
                throw new IllegalStateException("Cannot release a recycled or not yet acquired resource");
            }
            if (--this.acquired == 0) {
                release = true;
            }
        }
        if (release) {
            this.listener.onResourceReleased(this.key, this);
        }
    }

    public synchronized String toString() {
        return "EngineResource{isMemoryCacheable=" + this.isMemoryCacheable + ", listener=" + this.listener + ", key=" + this.key + ", acquired=" + this.acquired + ", isRecycled=" + this.isRecycled + ", resource=" + this.resource + '}';
    }

    static interface ResourceListener {
        public void onResourceReleased(Key var1, EngineResource<?> var2);
    }
}

