/*
 * Decompiled with CFR 0.152.
 */
package androidx.media;

import android.media.AudioFocusRequest;
import android.media.AudioManager;
import android.os.Build;
import androidx.annotation.DoNotInline;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.media.AudioFocusRequestCompat;

public final class AudioManagerCompat {
    private static final String TAG = "AudioManCompat";
    public static final int AUDIOFOCUS_GAIN = 1;
    public static final int AUDIOFOCUS_GAIN_TRANSIENT = 2;
    public static final int AUDIOFOCUS_GAIN_TRANSIENT_MAY_DUCK = 3;
    public static final int AUDIOFOCUS_GAIN_TRANSIENT_EXCLUSIVE = 4;

    public static int requestAudioFocus(@NonNull AudioManager audioManager, @NonNull AudioFocusRequestCompat focusRequest) {
        if (audioManager == null) {
            throw new IllegalArgumentException("AudioManager must not be null");
        }
        if (focusRequest == null) {
            throw new IllegalArgumentException("AudioFocusRequestCompat must not be null");
        }
        if (Build.VERSION.SDK_INT >= 26) {
            return Api26Impl.requestAudioFocus(audioManager, focusRequest.getAudioFocusRequest());
        }
        return audioManager.requestAudioFocus(focusRequest.getOnAudioFocusChangeListener(), focusRequest.getAudioAttributesCompat().getLegacyStreamType(), focusRequest.getFocusGain());
    }

    public static int abandonAudioFocusRequest(@NonNull AudioManager audioManager, @NonNull AudioFocusRequestCompat focusRequest) {
        if (audioManager == null) {
            throw new IllegalArgumentException("AudioManager must not be null");
        }
        if (focusRequest == null) {
            throw new IllegalArgumentException("AudioFocusRequestCompat must not be null");
        }
        if (Build.VERSION.SDK_INT >= 26) {
            return Api26Impl.abandonAudioFocusRequest(audioManager, focusRequest.getAudioFocusRequest());
        }
        return audioManager.abandonAudioFocus(focusRequest.getOnAudioFocusChangeListener());
    }

    @IntRange(from=0L)
    public static int getStreamMaxVolume(@NonNull AudioManager audioManager, int streamType) {
        return audioManager.getStreamMaxVolume(streamType);
    }

    @IntRange(from=0L)
    public static int getStreamMinVolume(@NonNull AudioManager audioManager, int streamType) {
        if (Build.VERSION.SDK_INT >= 28) {
            return Api28Impl.getStreamMinVolume(audioManager, streamType);
        }
        return 0;
    }

    public static boolean isVolumeFixed(@NonNull AudioManager audioManager) {
        if (Build.VERSION.SDK_INT >= 21) {
            return Api21Impl.isVolumeFixed(audioManager);
        }
        return false;
    }

    private AudioManagerCompat() {
    }

    @RequiresApi(value=28)
    private static class Api28Impl {
        @DoNotInline
        static int getStreamMinVolume(AudioManager audioManager, int streamType) {
            return audioManager.getStreamMinVolume(streamType);
        }

        private Api28Impl() {
        }
    }

    @RequiresApi(value=26)
    private static class Api26Impl {
        @DoNotInline
        static int abandonAudioFocusRequest(AudioManager audioManager, AudioFocusRequest focusRequest) {
            return audioManager.abandonAudioFocusRequest(focusRequest);
        }

        @DoNotInline
        static int requestAudioFocus(AudioManager audioManager, AudioFocusRequest focusRequest) {
            return audioManager.requestAudioFocus(focusRequest);
        }

        private Api26Impl() {
        }
    }

    @RequiresApi(value=21)
    private static class Api21Impl {
        @DoNotInline
        static boolean isVolumeFixed(AudioManager audioManager) {
            return audioManager.isVolumeFixed();
        }

        private Api21Impl() {
        }
    }
}

