/*
 * Decompiled with CFR 0.152.
 */
package androidx.emoji2.text;

import android.annotation.SuppressLint;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Typeface;
import androidx.annotation.AnyThread;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.emoji2.text.MetadataRepo;
import androidx.emoji2.text.flatbuffer.MetadataItem;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@AnyThread
@RequiresApi(value=19)
public class EmojiMetadata {
    public static final int HAS_GLYPH_UNKNOWN = 0;
    public static final int HAS_GLYPH_ABSENT = 1;
    public static final int HAS_GLYPH_EXISTS = 2;
    private static final ThreadLocal<MetadataItem> sMetadataItem = new ThreadLocal();
    private final int mIndex;
    @NonNull
    private final MetadataRepo mMetadataRepo;
    private volatile int mHasGlyph = 0;

    EmojiMetadata(@NonNull MetadataRepo metadataRepo, @IntRange(from=0L) int index) {
        this.mMetadataRepo = metadataRepo;
        this.mIndex = index;
    }

    public void draw(@NonNull Canvas canvas, float x, float y, @NonNull Paint paint) {
        Typeface typeface = this.mMetadataRepo.getTypeface();
        Typeface oldTypeface = paint.getTypeface();
        paint.setTypeface(typeface);
        int charArrayStartIndex = this.mIndex * 2;
        canvas.drawText(this.mMetadataRepo.getEmojiCharArray(), charArrayStartIndex, 2, x, y, paint);
        paint.setTypeface(oldTypeface);
    }

    @NonNull
    public Typeface getTypeface() {
        return this.mMetadataRepo.getTypeface();
    }

    private MetadataItem getMetadataItem() {
        MetadataItem result = sMetadataItem.get();
        if (result == null) {
            result = new MetadataItem();
            sMetadataItem.set(result);
        }
        this.mMetadataRepo.getMetadataList().list(result, this.mIndex);
        return result;
    }

    public int getId() {
        return this.getMetadataItem().id();
    }

    public short getWidth() {
        return this.getMetadataItem().width();
    }

    public short getHeight() {
        return this.getMetadataItem().height();
    }

    public short getCompatAdded() {
        return this.getMetadataItem().compatAdded();
    }

    public short getSdkAdded() {
        return this.getMetadataItem().sdkAdded();
    }

    @SuppressLint(value={"KotlinPropertyAccess"})
    public int getHasGlyph() {
        return this.mHasGlyph;
    }

    @RestrictTo(value={RestrictTo.Scope.TESTS})
    public void resetHasGlyphCache() {
        this.mHasGlyph = 0;
    }

    @SuppressLint(value={"KotlinPropertyAccess"})
    public void setHasGlyph(boolean hasGlyph) {
        this.mHasGlyph = hasGlyph ? 2 : 1;
    }

    public boolean isDefaultEmoji() {
        return this.getMetadataItem().emojiStyle();
    }

    public int getCodepointAt(int index) {
        return this.getMetadataItem().codepoints(index);
    }

    public int getCodepointsLength() {
        return this.getMetadataItem().codepointsLength();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(super.toString());
        builder.append(", id:");
        builder.append(Integer.toHexString(this.getId()));
        builder.append(", codepoints:");
        int codepointsLength = this.getCodepointsLength();
        for (int i = 0; i < codepointsLength; ++i) {
            builder.append(Integer.toHexString(this.getCodepointAt(i)));
            builder.append(" ");
        }
        return builder.toString();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface HasGlyph {
    }
}

