/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.transition.platform;

import androidx.annotation.AttrRes;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import com.google.android.material.R;
import com.google.android.material.transition.platform.FadeThroughProvider;
import com.google.android.material.transition.platform.MaterialVisibility;
import com.google.android.material.transition.platform.ScaleProvider;
import com.google.android.material.transition.platform.SlideDistanceProvider;
import com.google.android.material.transition.platform.VisibilityAnimatorProvider;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@RequiresApi(value=21)
public final class MaterialSharedAxis
extends MaterialVisibility<VisibilityAnimatorProvider> {
    public static final int X = 0;
    public static final int Y = 1;
    public static final int Z = 2;
    private final int axis;
    private final boolean forward;
    @AttrRes
    private static final int DEFAULT_THEMED_DURATION_ATTR = R.attr.motionDurationLong1;
    @AttrRes
    private static final int DEFAULT_THEMED_EASING_ATTR = R.attr.motionEasingStandard;

    public MaterialSharedAxis(int axis, boolean forward) {
        super(MaterialSharedAxis.createPrimaryAnimatorProvider(axis, forward), MaterialSharedAxis.createSecondaryAnimatorProvider());
        this.axis = axis;
        this.forward = forward;
    }

    public int getAxis() {
        return this.axis;
    }

    public boolean isForward() {
        return this.forward;
    }

    private static VisibilityAnimatorProvider createPrimaryAnimatorProvider(int axis, boolean forward) {
        switch (axis) {
            case 0: {
                return new SlideDistanceProvider(forward ? 0x800005 : 0x800003);
            }
            case 1: {
                return new SlideDistanceProvider(forward ? 80 : 48);
            }
            case 2: {
                return new ScaleProvider(forward);
            }
        }
        throw new IllegalArgumentException("Invalid axis: " + axis);
    }

    private static VisibilityAnimatorProvider createSecondaryAnimatorProvider() {
        return new FadeThroughProvider();
    }

    @Override
    @AttrRes
    int getDurationThemeAttrResId(boolean appearing) {
        return DEFAULT_THEMED_DURATION_ATTR;
    }

    @Override
    @AttrRes
    int getEasingThemeAttrResId(boolean appearing) {
        return DEFAULT_THEMED_EASING_ATTR;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface Axis {
    }
}

