/*
 * Decompiled with CFR 0.152.
 */
package androidx.appcompat.app;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.res.Configuration;
import android.os.Bundle;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MenuInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import androidx.annotation.CallSuper;
import androidx.annotation.IdRes;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.annotation.StyleRes;
import androidx.appcompat.app.ActionBar;
import androidx.appcompat.app.ActionBarDrawerToggle;
import androidx.appcompat.app.AppCompatCallback;
import androidx.appcompat.app.AppCompatDelegateImpl;
import androidx.appcompat.view.ActionMode;
import androidx.appcompat.widget.Toolbar;
import androidx.appcompat.widget.VectorEnabledTintResources;
import androidx.collection.ArraySet;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.util.Iterator;

public abstract class AppCompatDelegate {
    static final boolean DEBUG = false;
    static final String TAG = "AppCompatDelegate";
    public static final int MODE_NIGHT_FOLLOW_SYSTEM = -1;
    @Deprecated
    public static final int MODE_NIGHT_AUTO_TIME = 0;
    @Deprecated
    public static final int MODE_NIGHT_AUTO = 0;
    public static final int MODE_NIGHT_NO = 1;
    public static final int MODE_NIGHT_YES = 2;
    public static final int MODE_NIGHT_AUTO_BATTERY = 3;
    public static final int MODE_NIGHT_UNSPECIFIED = -100;
    private static int sDefaultNightMode = -100;
    private static final ArraySet<WeakReference<AppCompatDelegate>> sActivityDelegates = new ArraySet();
    private static final Object sActivityDelegatesLock = new Object();
    public static final int FEATURE_SUPPORT_ACTION_BAR = 108;
    public static final int FEATURE_SUPPORT_ACTION_BAR_OVERLAY = 109;
    public static final int FEATURE_ACTION_MODE_OVERLAY = 10;

    @NonNull
    public static AppCompatDelegate create(@NonNull Activity activity, @Nullable AppCompatCallback callback) {
        return new AppCompatDelegateImpl(activity, callback);
    }

    @NonNull
    public static AppCompatDelegate create(@NonNull Dialog dialog, @Nullable AppCompatCallback callback) {
        return new AppCompatDelegateImpl(dialog, callback);
    }

    @NonNull
    public static AppCompatDelegate create(@NonNull Context context, @NonNull Window window, @Nullable AppCompatCallback callback) {
        return new AppCompatDelegateImpl(context, window, callback);
    }

    @NonNull
    public static AppCompatDelegate create(@NonNull Context context, @NonNull Activity activity, @Nullable AppCompatCallback callback) {
        return new AppCompatDelegateImpl(context, activity, callback);
    }

    AppCompatDelegate() {
    }

    @Nullable
    public abstract ActionBar getSupportActionBar();

    public abstract void setSupportActionBar(@Nullable Toolbar var1);

    public abstract MenuInflater getMenuInflater();

    public abstract void onCreate(Bundle var1);

    public abstract void onPostCreate(Bundle var1);

    public abstract void onConfigurationChanged(Configuration var1);

    public abstract void onStart();

    public abstract void onStop();

    public abstract void onPostResume();

    public void setTheme(@StyleRes int themeResId) {
    }

    @Nullable
    public abstract <T extends View> T findViewById(@IdRes int var1);

    public abstract void setContentView(View var1);

    public abstract void setContentView(@LayoutRes int var1);

    public abstract void setContentView(View var1, ViewGroup.LayoutParams var2);

    public abstract void addContentView(View var1, ViewGroup.LayoutParams var2);

    @Deprecated
    public void attachBaseContext(Context context) {
    }

    @NonNull
    @CallSuper
    public Context attachBaseContext2(@NonNull Context context) {
        this.attachBaseContext(context);
        return context;
    }

    public abstract void setTitle(@Nullable CharSequence var1);

    public abstract void invalidateOptionsMenu();

    public abstract void onDestroy();

    @Nullable
    public abstract ActionBarDrawerToggle.Delegate getDrawerToggleDelegate();

    public abstract boolean requestWindowFeature(int var1);

    public abstract boolean hasWindowFeature(int var1);

    @Nullable
    public abstract ActionMode startSupportActionMode(@NonNull ActionMode.Callback var1);

    public abstract void installViewFactory();

    public abstract View createView(@Nullable View var1, String var2, @NonNull Context var3, @NonNull AttributeSet var4);

    public abstract void setHandleNativeActionModesEnabled(boolean var1);

    public abstract boolean isHandleNativeActionModesEnabled();

    public abstract void onSaveInstanceState(Bundle var1);

    public abstract boolean applyDayNight();

    @RequiresApi(value=17)
    public abstract void setLocalNightMode(int var1);

    public int getLocalNightMode() {
        return -100;
    }

    public static void setDefaultNightMode(int mode) {
        switch (mode) {
            case -1: 
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                if (sDefaultNightMode == mode) break;
                sDefaultNightMode = mode;
                AppCompatDelegate.applyDayNightToActiveDelegates();
                break;
            }
            default: {
                Log.d((String)TAG, (String)"setDefaultNightMode() called with an unknown mode");
            }
        }
    }

    public static int getDefaultNightMode() {
        return sDefaultNightMode;
    }

    public static void setCompatVectorFromResourcesEnabled(boolean enabled) {
        VectorEnabledTintResources.setCompatVectorFromResourcesEnabled((boolean)enabled);
    }

    public static boolean isCompatVectorFromResourcesEnabled() {
        return VectorEnabledTintResources.isCompatVectorFromResourcesEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addActiveDelegate(@NonNull AppCompatDelegate delegate) {
        Object object = sActivityDelegatesLock;
        synchronized (object) {
            AppCompatDelegate.removeDelegateFromActives(delegate);
            sActivityDelegates.add(new WeakReference<AppCompatDelegate>(delegate));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeActivityDelegate(@NonNull AppCompatDelegate delegate) {
        Object object = sActivityDelegatesLock;
        synchronized (object) {
            AppCompatDelegate.removeDelegateFromActives(delegate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeDelegateFromActives(@NonNull AppCompatDelegate toRemove) {
        Object object = sActivityDelegatesLock;
        synchronized (object) {
            Iterator i = sActivityDelegates.iterator();
            while (i.hasNext()) {
                AppCompatDelegate delegate = (AppCompatDelegate)((WeakReference)i.next()).get();
                if (delegate != toRemove && delegate != null) continue;
                i.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void applyDayNightToActiveDelegates() {
        Object object = sActivityDelegatesLock;
        synchronized (object) {
            for (WeakReference activeDelegate : sActivityDelegates) {
                AppCompatDelegate delegate = (AppCompatDelegate)activeDelegate.get();
                if (delegate == null) continue;
                delegate.applyDayNight();
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public static @interface NightMode {
    }
}

