/*
 * Decompiled with CFR 0.152.
 */
package androidx.window.layout;

import android.app.Activity;
import android.graphics.Rect;
import android.os.Build;
import androidx.annotation.RequiresApi;
import androidx.window.extensions.layout.WindowLayoutComponent;
import androidx.window.layout.SafeWindowLayoutComponentProvider;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.function.Consumer;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J \u0010\u0010\u001a\u0012\u0012\u0002\b\u0003 \u0012*\b\u0012\u0002\b\u0003\u0018\u00010\u00110\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0014\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0015\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0003J\u0010\u0010\u0016\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0016\u0010\u0017\u001a\u00020\n2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\u0019H\u0002J \u0010\u001a\u001a\u0012\u0012\u0002\b\u0003 \u0012*\b\u0012\u0002\b\u0003\u0018\u00010\u00110\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J \u0010\u001b\u001a\u0012\u0012\u0002\b\u0003 \u0012*\b\u0012\u0002\b\u0003\u0018\u00010\u00110\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J \u0010\u001c\u001a\u0012\u0012\u0002\b\u0003 \u0012*\b\u0012\u0002\b\u0003\u0018\u00010\u00110\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u001d\u001a\u00020\n*\u00020\u000b2\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u0011H\u0002J\u0018\u0010\u001d\u001a\u00020\n*\u00020\u000b2\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u001fH\u0002R\u001d\u0010\u0003\u001a\u0004\u0018\u00010\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u0018\u0010\t\u001a\u00020\n*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\f\u00a8\u0006 "}, d2={"Landroidx/window/layout/SafeWindowLayoutComponentProvider;", "", "()V", "windowLayoutComponent", "Landroidx/window/extensions/layout/WindowLayoutComponent;", "getWindowLayoutComponent", "()Landroidx/window/extensions/layout/WindowLayoutComponent;", "windowLayoutComponent$delegate", "Lkotlin/Lazy;", "isPublic", "", "Ljava/lang/reflect/Method;", "(Ljava/lang/reflect/Method;)Z", "canUseWindowLayoutComponent", "classLoader", "Ljava/lang/ClassLoader;", "foldingFeatureClass", "Ljava/lang/Class;", "kotlin.jvm.PlatformType", "isFoldingFeatureValid", "isWindowExtensionsValid", "isWindowLayoutComponentValid", "isWindowLayoutProviderValid", "validate", "block", "Lkotlin/Function0;", "windowExtensionsClass", "windowExtensionsProviderClass", "windowLayoutComponentClass", "doesReturn", "clazz", "Lkotlin/reflect/KClass;", "window_release"})
public final class SafeWindowLayoutComponentProvider {
    @NotNull
    public static final SafeWindowLayoutComponentProvider INSTANCE = new SafeWindowLayoutComponentProvider();
    @NotNull
    private static final Lazy windowLayoutComponent$delegate = LazyKt.lazy((Function0)windowLayoutComponent.2.INSTANCE);

    private SafeWindowLayoutComponentProvider() {
    }

    @Nullable
    public final WindowLayoutComponent getWindowLayoutComponent() {
        Lazy lazy = windowLayoutComponent$delegate;
        return (WindowLayoutComponent)lazy.getValue();
    }

    private final boolean canUseWindowLayoutComponent(ClassLoader classLoader) {
        return Build.VERSION.SDK_INT >= 24 ? this.isWindowLayoutProviderValid(classLoader) && this.isWindowExtensionsValid(classLoader) && this.isWindowLayoutComponentValid(classLoader) && this.isFoldingFeatureValid(classLoader) : false;
    }

    private final boolean isWindowLayoutProviderValid(ClassLoader classLoader) {
        return this.validate((Function0<Boolean>)((Function0)new Function0<Boolean>(classLoader){
            final /* synthetic */ ClassLoader $classLoader;
            {
                this.$classLoader = $classLoader;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                Class providerClass = SafeWindowLayoutComponentProvider.access$windowExtensionsProviderClass(SafeWindowLayoutComponentProvider.INSTANCE, this.$classLoader);
                Method getWindowExtensionsMethod = providerClass.getDeclaredMethod("getWindowExtensions", new Class[0]);
                Class windowExtensionsClass = SafeWindowLayoutComponentProvider.access$windowExtensionsClass(SafeWindowLayoutComponentProvider.INSTANCE, this.$classLoader);
                Intrinsics.checkNotNullExpressionValue((Object)getWindowExtensionsMethod, (String)"getWindowExtensionsMethod");
                Intrinsics.checkNotNullExpressionValue((Object)windowExtensionsClass, (String)"windowExtensionsClass");
                return SafeWindowLayoutComponentProvider.access$doesReturn(SafeWindowLayoutComponentProvider.INSTANCE, getWindowExtensionsMethod, windowExtensionsClass) && SafeWindowLayoutComponentProvider.access$isPublic(SafeWindowLayoutComponentProvider.INSTANCE, getWindowExtensionsMethod);
            }
        }));
    }

    private final boolean isWindowExtensionsValid(ClassLoader classLoader) {
        return this.validate((Function0<Boolean>)((Function0)new Function0<Boolean>(classLoader){
            final /* synthetic */ ClassLoader $classLoader;
            {
                this.$classLoader = $classLoader;
                super(0);
            }

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public final Boolean invoke() {
                boolean bl;
                Class extensionsClass = SafeWindowLayoutComponentProvider.access$windowExtensionsClass(SafeWindowLayoutComponentProvider.INSTANCE, this.$classLoader);
                Method getWindowLayoutComponentMethod = extensionsClass.getMethod("getWindowLayoutComponent", new Class[0]);
                Class windowLayoutComponentClass = SafeWindowLayoutComponentProvider.access$windowLayoutComponentClass(SafeWindowLayoutComponentProvider.INSTANCE, this.$classLoader);
                Intrinsics.checkNotNullExpressionValue((Object)getWindowLayoutComponentMethod, (String)"getWindowLayoutComponentMethod");
                if (SafeWindowLayoutComponentProvider.access$isPublic(SafeWindowLayoutComponentProvider.INSTANCE, getWindowLayoutComponentMethod)) {
                    Intrinsics.checkNotNullExpressionValue((Object)windowLayoutComponentClass, (String)"windowLayoutComponentClass");
                    if (SafeWindowLayoutComponentProvider.access$doesReturn(SafeWindowLayoutComponentProvider.INSTANCE, getWindowLayoutComponentMethod, windowLayoutComponentClass)) {
                        bl = true;
                        return bl;
                    }
                }
                bl = false;
                return bl;
            }
        }));
    }

    private final boolean isFoldingFeatureValid(ClassLoader classLoader) {
        return this.validate((Function0<Boolean>)((Function0)new Function0<Boolean>(classLoader){
            final /* synthetic */ ClassLoader $classLoader;
            {
                this.$classLoader = $classLoader;
                super(0);
            }

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public final Boolean invoke() {
                boolean bl;
                Class foldingFeatureClass = SafeWindowLayoutComponentProvider.access$foldingFeatureClass(SafeWindowLayoutComponentProvider.INSTANCE, this.$classLoader);
                Method getBoundsMethod = foldingFeatureClass.getMethod("getBounds", new Class[0]);
                Method getTypeMethod = foldingFeatureClass.getMethod("getType", new Class[0]);
                Method getStateMethod = foldingFeatureClass.getMethod("getState", new Class[0]);
                Intrinsics.checkNotNullExpressionValue((Object)getBoundsMethod, (String)"getBoundsMethod");
                if (SafeWindowLayoutComponentProvider.access$doesReturn(SafeWindowLayoutComponentProvider.INSTANCE, getBoundsMethod, Reflection.getOrCreateKotlinClass(Rect.class)) && SafeWindowLayoutComponentProvider.access$isPublic(SafeWindowLayoutComponentProvider.INSTANCE, getBoundsMethod)) {
                    Intrinsics.checkNotNullExpressionValue((Object)getTypeMethod, (String)"getTypeMethod");
                    if (SafeWindowLayoutComponentProvider.access$doesReturn(SafeWindowLayoutComponentProvider.INSTANCE, getTypeMethod, Reflection.getOrCreateKotlinClass(Integer.TYPE)) && SafeWindowLayoutComponentProvider.access$isPublic(SafeWindowLayoutComponentProvider.INSTANCE, getTypeMethod)) {
                        Intrinsics.checkNotNullExpressionValue((Object)getStateMethod, (String)"getStateMethod");
                        if (SafeWindowLayoutComponentProvider.access$doesReturn(SafeWindowLayoutComponentProvider.INSTANCE, getStateMethod, Reflection.getOrCreateKotlinClass(Integer.TYPE)) && SafeWindowLayoutComponentProvider.access$isPublic(SafeWindowLayoutComponentProvider.INSTANCE, getStateMethod)) {
                            bl = true;
                            return bl;
                        }
                    }
                }
                bl = false;
                return bl;
            }
        }));
    }

    @RequiresApi(value=24)
    private final boolean isWindowLayoutComponentValid(ClassLoader classLoader) {
        return this.validate((Function0<Boolean>)((Function0)new Function0<Boolean>(classLoader){
            final /* synthetic */ ClassLoader $classLoader;
            {
                this.$classLoader = $classLoader;
                super(0);
            }

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public final Boolean invoke() {
                boolean bl;
                Class windowLayoutComponent2 = SafeWindowLayoutComponentProvider.access$windowLayoutComponentClass(SafeWindowLayoutComponentProvider.INSTANCE, this.$classLoader);
                Class[] classArray = new Class[]{Activity.class, Consumer.class};
                Method addListenerMethod = windowLayoutComponent2.getMethod("addWindowLayoutInfoListener", classArray);
                Class[] classArray2 = new Class[]{Consumer.class};
                Method removeListenerMethod = windowLayoutComponent2.getMethod("removeWindowLayoutInfoListener", classArray2);
                Intrinsics.checkNotNullExpressionValue((Object)addListenerMethod, (String)"addListenerMethod");
                if (SafeWindowLayoutComponentProvider.access$isPublic(SafeWindowLayoutComponentProvider.INSTANCE, addListenerMethod)) {
                    Intrinsics.checkNotNullExpressionValue((Object)removeListenerMethod, (String)"removeListenerMethod");
                    if (SafeWindowLayoutComponentProvider.access$isPublic(SafeWindowLayoutComponentProvider.INSTANCE, removeListenerMethod)) {
                        bl = true;
                        return bl;
                    }
                }
                bl = false;
                return bl;
            }
        }));
    }

    private final boolean validate(Function0<Boolean> block) {
        boolean bl;
        try {
            bl = (Boolean)block.invoke();
        }
        catch (ClassNotFoundException noClass) {
            bl = false;
        }
        catch (NoSuchMethodException noMethod) {
            bl = false;
        }
        return bl;
    }

    private final boolean isPublic(Method $this$isPublic) {
        return Modifier.isPublic($this$isPublic.getModifiers());
    }

    private final boolean doesReturn(Method $this$doesReturn, KClass<?> clazz) {
        return this.doesReturn($this$doesReturn, JvmClassMappingKt.getJavaClass(clazz));
    }

    private final boolean doesReturn(Method $this$doesReturn, Class<?> clazz) {
        return $this$doesReturn.getReturnType().equals(clazz);
    }

    private final Class<?> windowExtensionsProviderClass(ClassLoader classLoader) {
        return classLoader.loadClass("androidx.window.extensions.WindowExtensionsProvider");
    }

    private final Class<?> windowExtensionsClass(ClassLoader classLoader) {
        return classLoader.loadClass("androidx.window.extensions.WindowExtensions");
    }

    private final Class<?> foldingFeatureClass(ClassLoader classLoader) {
        return classLoader.loadClass("androidx.window.extensions.layout.FoldingFeature");
    }

    private final Class<?> windowLayoutComponentClass(ClassLoader classLoader) {
        return classLoader.loadClass("androidx.window.extensions.layout.WindowLayoutComponent");
    }

    public static final /* synthetic */ Class access$windowExtensionsProviderClass(SafeWindowLayoutComponentProvider $this, ClassLoader classLoader) {
        return $this.windowExtensionsProviderClass(classLoader);
    }

    public static final /* synthetic */ Class access$windowExtensionsClass(SafeWindowLayoutComponentProvider $this, ClassLoader classLoader) {
        return $this.windowExtensionsClass(classLoader);
    }

    public static final /* synthetic */ boolean access$doesReturn(SafeWindowLayoutComponentProvider $this, Method $receiver, Class clazz) {
        return $this.doesReturn($receiver, clazz);
    }

    public static final /* synthetic */ boolean access$isPublic(SafeWindowLayoutComponentProvider $this, Method $receiver) {
        return $this.isPublic($receiver);
    }

    public static final /* synthetic */ Class access$windowLayoutComponentClass(SafeWindowLayoutComponentProvider $this, ClassLoader classLoader) {
        return $this.windowLayoutComponentClass(classLoader);
    }

    public static final /* synthetic */ Class access$foldingFeatureClass(SafeWindowLayoutComponentProvider $this, ClassLoader classLoader) {
        return $this.foldingFeatureClass(classLoader);
    }

    public static final /* synthetic */ boolean access$doesReturn(SafeWindowLayoutComponentProvider $this, Method $receiver, KClass clazz) {
        return $this.doesReturn($receiver, clazz);
    }

    public static final /* synthetic */ boolean access$canUseWindowLayoutComponent(SafeWindowLayoutComponentProvider $this, ClassLoader classLoader) {
        return $this.canUseWindowLayoutComponent(classLoader);
    }
}

