/*
 * Decompiled with CFR 0.152.
 */
package androidx.window.embedding;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Intent;
import android.util.Pair;
import android.view.WindowMetrics;
import androidx.window.core.ExperimentalWindowApi;
import androidx.window.embedding.ActivityFilter;
import androidx.window.embedding.ActivityRule;
import androidx.window.embedding.ActivityStack;
import androidx.window.embedding.EmbeddingRule;
import androidx.window.embedding.SplitInfo;
import androidx.window.embedding.SplitPairFilter;
import androidx.window.embedding.SplitPairRule;
import androidx.window.embedding.SplitPlaceholderRule;
import androidx.window.embedding.SplitRule;
import androidx.window.extensions.embedding.ActivityRule;
import androidx.window.extensions.embedding.SplitPairRule;
import androidx.window.extensions.embedding.SplitPlaceholderRule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0001\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00040\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0007J\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\tJ(\u0010\r\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f0\u000e2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\tH\u0007J(\u0010\u0014\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u000f0\u000e2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\tH\u0007J\u001c\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\u000e2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\tH\u0007J\u001c\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00110\u000e2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\tH\u0007J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u000e2\u0006\u0010\u001b\u001a\u00020\u001cH\u0007J*\u0010\u001d\u001a\u0002H\u001e\"\u0004\b\u0000\u0010\u001e\"\u0004\b\u0001\u0010\u001f*\u000e\u0012\u0004\u0012\u0002H\u001e\u0012\u0004\u0012\u0002H\u001f0\u000fH\u0082\u0002\u00a2\u0006\u0002\u0010 J*\u0010!\u001a\u0002H\u001f\"\u0004\b\u0000\u0010\u001e\"\u0004\b\u0001\u0010\u001f*\u000e\u0012\u0004\u0012\u0002H\u001e\u0012\u0004\u0012\u0002H\u001f0\u000fH\u0082\u0002\u00a2\u0006\u0002\u0010 \u00a8\u0006\""}, d2={"Landroidx/window/embedding/EmbeddingAdapter;", "", "()V", "translate", "Landroidx/window/embedding/SplitInfo;", "splitInfo", "Landroidx/window/extensions/embedding/SplitInfo;", "", "splitInfoList", "", "Landroidx/window/extensions/embedding/EmbeddingRule;", "rules", "Landroidx/window/embedding/EmbeddingRule;", "translateActivityIntentPredicates", "Ljava/util/function/Predicate;", "Landroid/util/Pair;", "Landroid/app/Activity;", "Landroid/content/Intent;", "splitPairFilters", "Landroidx/window/embedding/SplitPairFilter;", "translateActivityPairPredicates", "translateActivityPredicates", "activityFilters", "Landroidx/window/embedding/ActivityFilter;", "translateIntentPredicates", "translateParentMetricsPredicate", "Landroid/view/WindowMetrics;", "splitRule", "Landroidx/window/embedding/SplitRule;", "component1", "F", "S", "(Landroid/util/Pair;)Ljava/lang/Object;", "component2", "window_release"})
@ExperimentalWindowApi
public final class EmbeddingAdapter {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<SplitInfo> translate(@NotNull List<? extends androidx.window.extensions.embedding.SplitInfo> splitInfoList) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(splitInfoList, (String)"splitInfoList");
        Iterable $this$map$iv = splitInfoList;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            androidx.window.extensions.embedding.SplitInfo splitInfo = (androidx.window.extensions.embedding.SplitInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.translate((androidx.window.extensions.embedding.SplitInfo)p0));
        }
        return (List)destination$iv$iv;
    }

    private final SplitInfo translate(androidx.window.extensions.embedding.SplitInfo splitInfo) {
        boolean bl;
        boolean bl2;
        androidx.window.extensions.embedding.ActivityStack activityStack = splitInfo.getPrimaryActivityStack();
        Intrinsics.checkNotNullExpressionValue((Object)activityStack, (String)"splitInfo.primaryActivityStack");
        androidx.window.extensions.embedding.ActivityStack primaryActivityStack = activityStack;
        try {
            bl2 = primaryActivityStack.isEmpty();
        }
        catch (NoSuchMethodError e) {
            bl2 = false;
        }
        boolean isPrimaryStackEmpty = bl2;
        List e = primaryActivityStack.getActivities();
        Intrinsics.checkNotNullExpressionValue((Object)e, (String)"primaryActivityStack.activities");
        ActivityStack primaryFragment = new ActivityStack(e, isPrimaryStackEmpty);
        androidx.window.extensions.embedding.ActivityStack activityStack2 = splitInfo.getSecondaryActivityStack();
        Intrinsics.checkNotNullExpressionValue((Object)activityStack2, (String)"splitInfo.secondaryActivityStack");
        androidx.window.extensions.embedding.ActivityStack secondaryActivityStack = activityStack2;
        try {
            bl = secondaryActivityStack.isEmpty();
        }
        catch (NoSuchMethodError e2) {
            bl = false;
        }
        boolean isSecondaryStackEmpty = bl;
        List list = secondaryActivityStack.getActivities();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"secondaryActivityStack.activities");
        ActivityStack secondaryFragment = new ActivityStack(list, isSecondaryStackEmpty);
        return new SplitInfo(primaryFragment, secondaryFragment, splitInfo.getSplitRatio());
    }

    @SuppressLint(value={"ClassVerificationFailure", "NewApi"})
    @NotNull
    public final Predicate<Pair<Activity, Activity>> translateActivityPairPredicates(@NotNull Set<SplitPairFilter> splitPairFilters) {
        Intrinsics.checkNotNullParameter(splitPairFilters, (String)"splitPairFilters");
        return arg_0 -> EmbeddingAdapter.translateActivityPairPredicates$lambda-1(this, splitPairFilters, arg_0);
    }

    @SuppressLint(value={"ClassVerificationFailure", "NewApi"})
    @NotNull
    public final Predicate<Pair<Activity, Intent>> translateActivityIntentPredicates(@NotNull Set<SplitPairFilter> splitPairFilters) {
        Intrinsics.checkNotNullParameter(splitPairFilters, (String)"splitPairFilters");
        return arg_0 -> EmbeddingAdapter.translateActivityIntentPredicates$lambda-3(this, splitPairFilters, arg_0);
    }

    @SuppressLint(value={"ClassVerificationFailure", "NewApi"})
    @NotNull
    public final Predicate<WindowMetrics> translateParentMetricsPredicate(@NotNull SplitRule splitRule) {
        Intrinsics.checkNotNullParameter((Object)splitRule, (String)"splitRule");
        return arg_0 -> EmbeddingAdapter.translateParentMetricsPredicate$lambda-4(splitRule, arg_0);
    }

    @SuppressLint(value={"ClassVerificationFailure", "NewApi"})
    @NotNull
    public final Predicate<Activity> translateActivityPredicates(@NotNull Set<ActivityFilter> activityFilters) {
        Intrinsics.checkNotNullParameter(activityFilters, (String)"activityFilters");
        return arg_0 -> EmbeddingAdapter.translateActivityPredicates$lambda-6(activityFilters, arg_0);
    }

    @SuppressLint(value={"ClassVerificationFailure", "NewApi"})
    @NotNull
    public final Predicate<Intent> translateIntentPredicates(@NotNull Set<ActivityFilter> activityFilters) {
        Intrinsics.checkNotNullParameter(activityFilters, (String)"activityFilters");
        return arg_0 -> EmbeddingAdapter.translateIntentPredicates$lambda-8(activityFilters, arg_0);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<androidx.window.extensions.embedding.EmbeddingRule> translate(@NotNull Set<? extends EmbeddingRule> rules) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(rules, (String)"rules");
        Iterable $this$map$iv = rules;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            androidx.window.extensions.embedding.EmbeddingRule embeddingRule;
            androidx.window.extensions.embedding.ActivityRule activityRule;
            void rule;
            EmbeddingRule embeddingRule2 = (EmbeddingRule)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void var11_11 = rule;
            if (var11_11 instanceof SplitPairRule) {
                activityRule = new SplitPairRule.Builder(this.translateActivityPairPredicates(((SplitPairRule)rule).getFilters()), this.translateActivityIntentPredicates(((SplitPairRule)rule).getFilters()), this.translateParentMetricsPredicate((SplitRule)rule)).setSplitRatio(((SplitPairRule)rule).getSplitRatio()).setLayoutDirection(((SplitPairRule)rule).getLayoutDirection()).setShouldFinishPrimaryWithSecondary(((SplitPairRule)rule).getFinishPrimaryWithSecondary()).setShouldFinishSecondaryWithPrimary(((SplitPairRule)rule).getFinishSecondaryWithPrimary()).setShouldClearTop(((SplitPairRule)rule).getClearTop()).build();
                Intrinsics.checkNotNullExpressionValue((Object)activityRule, (String)"SplitPairRuleBuilder(\n  \u2026                 .build()");
                embeddingRule = (androidx.window.extensions.embedding.EmbeddingRule)activityRule;
            } else if (var11_11 instanceof SplitPlaceholderRule) {
                activityRule = new SplitPlaceholderRule.Builder(((SplitPlaceholderRule)rule).getPlaceholderIntent(), this.translateActivityPredicates(((SplitPlaceholderRule)rule).getFilters()), this.translateIntentPredicates(((SplitPlaceholderRule)rule).getFilters()), this.translateParentMetricsPredicate((SplitRule)rule)).setSplitRatio(((SplitPlaceholderRule)rule).getSplitRatio()).setLayoutDirection(((SplitPlaceholderRule)rule).getLayoutDirection()).build();
                Intrinsics.checkNotNullExpressionValue((Object)activityRule, (String)"SplitPlaceholderRuleBuil\u2026                 .build()");
                embeddingRule = (androidx.window.extensions.embedding.EmbeddingRule)activityRule;
            } else if (var11_11 instanceof ActivityRule) {
                activityRule = new ActivityRule.Builder(this.translateActivityPredicates(((ActivityRule)rule).getFilters()), this.translateIntentPredicates(((ActivityRule)rule).getFilters())).setShouldAlwaysExpand(((ActivityRule)rule).getAlwaysExpand()).build();
                Intrinsics.checkNotNullExpressionValue((Object)activityRule, (String)"ActivityRuleBuilder(\n   \u2026                 .build()");
                embeddingRule = (androidx.window.extensions.embedding.EmbeddingRule)activityRule;
            } else {
                throw new IllegalArgumentException("Unsupported rule type");
            }
            collection.add(embeddingRule);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    private final <F, S> F component1(Pair<F, S> $this$component1) {
        Intrinsics.checkNotNullParameter($this$component1, (String)"<this>");
        return (F)$this$component1.first;
    }

    private final <F, S> S component2(Pair<F, S> $this$component2) {
        Intrinsics.checkNotNullParameter($this$component2, (String)"<this>");
        return (S)$this$component2.second;
    }

    private static final boolean translateActivityPairPredicates$lambda-1(EmbeddingAdapter this$0, Set $splitPairFilters, Pair $dstr$first$second) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$splitPairFilters, (String)"$splitPairFilters");
            Intrinsics.checkNotNullExpressionValue((Object)$dstr$first$second, (String)"(first, second)");
            Activity first = (Activity)this$0.component1($dstr$first$second);
            Activity second = (Activity)this$0.component2($dstr$first$second);
            Iterable $this$any$iv = $splitPairFilters;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    SplitPairFilter filter = (SplitPairFilter)element$iv;
                    boolean bl2 = false;
                    if (!filter.matchesActivityPair(first, second)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean translateActivityIntentPredicates$lambda-3(EmbeddingAdapter this$0, Set $splitPairFilters, Pair $dstr$first$second) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$splitPairFilters, (String)"$splitPairFilters");
            Intrinsics.checkNotNullExpressionValue((Object)$dstr$first$second, (String)"(first, second)");
            Activity first = (Activity)this$0.component1($dstr$first$second);
            Intent second = (Intent)this$0.component2($dstr$first$second);
            Iterable $this$any$iv = $splitPairFilters;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    SplitPairFilter filter = (SplitPairFilter)element$iv;
                    boolean bl2 = false;
                    if (!filter.matchesActivityIntentPair(first, second)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean translateParentMetricsPredicate$lambda-4(SplitRule $splitRule, WindowMetrics windowMetrics) {
        Intrinsics.checkNotNullParameter((Object)$splitRule, (String)"$splitRule");
        Intrinsics.checkNotNullExpressionValue((Object)windowMetrics, (String)"windowMetrics");
        return $splitRule.checkParentMetrics(windowMetrics);
    }

    private static final boolean translateActivityPredicates$lambda-6(Set $activityFilters, Activity activity) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$activityFilters, (String)"$activityFilters");
            Iterable $this$any$iv = $activityFilters;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ActivityFilter filter = (ActivityFilter)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)activity, (String)"activity");
                    if (!filter.matchesActivity(activity)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean translateIntentPredicates$lambda-8(Set $activityFilters, Intent intent) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$activityFilters, (String)"$activityFilters");
            Iterable $this$any$iv = $activityFilters;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ActivityFilter filter = (ActivityFilter)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"intent");
                    if (!filter.matchesIntent(intent)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }
}

