/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.request.transition;

import android.content.Context;
import android.view.View;
import android.view.animation.Animation;
import com.bumptech.glide.request.transition.Transition;

public class ViewTransition<R>
implements Transition<R> {
    private final ViewTransitionAnimationFactory viewTransitionAnimationFactory;

    ViewTransition(ViewTransitionAnimationFactory viewTransitionAnimationFactory) {
        this.viewTransitionAnimationFactory = viewTransitionAnimationFactory;
    }

    @Override
    public boolean transition(R current, Transition.ViewAdapter adapter) {
        View view = adapter.getView();
        if (view != null) {
            view.clearAnimation();
            Animation animation = this.viewTransitionAnimationFactory.build(view.getContext());
            view.startAnimation(animation);
        }
        return false;
    }

    static interface ViewTransitionAnimationFactory {
        public Animation build(Context var1);
    }
}

