/*
 * Decompiled with CFR 0.152.
 */
package androidx.swiperefreshlayout.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RadialGradient;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.OvalShape;
import android.graphics.drawable.shapes.Shape;
import android.os.Build;
import android.view.View;
import android.view.animation.Animation;
import android.widget.ImageView;
import androidx.core.view.ViewCompat;
import androidx.swiperefreshlayout.R;

class CircleImageView
extends ImageView {
    private static final int DEFAULT_BACKGROUND_COLOR = -328966;
    private static final int FILL_SHADOW_COLOR = 0x3D000000;
    private static final int KEY_SHADOW_COLOR = 0x1E000000;
    private static final float X_OFFSET = 0.0f;
    private static final float Y_OFFSET = 1.75f;
    private static final float SHADOW_RADIUS = 3.5f;
    private static final int SHADOW_ELEVATION = 4;
    private Animation.AnimationListener mListener;
    private int mShadowRadius;
    private int mBackgroundColor;

    CircleImageView(Context context) {
        super(context);
        ShapeDrawable circle;
        float density = this.getContext().getResources().getDisplayMetrics().density;
        int shadowYOffset = (int)(density * 1.75f);
        int shadowXOffset = (int)(density * 0.0f);
        this.mShadowRadius = (int)(density * 3.5f);
        TypedArray colorArray = this.getContext().obtainStyledAttributes(R.styleable.SwipeRefreshLayout);
        this.mBackgroundColor = colorArray.getColor(R.styleable.SwipeRefreshLayout_swipeRefreshLayoutProgressSpinnerBackgroundColor, -328966);
        colorArray.recycle();
        if (this.elevationSupported()) {
            circle = new ShapeDrawable((Shape)new OvalShape());
            ViewCompat.setElevation((View)this, (float)(4.0f * density));
        } else {
            circle = new ShapeDrawable((Shape)new OvalShadow(this, this.mShadowRadius));
            this.setLayerType(1, circle.getPaint());
            circle.getPaint().setShadowLayer((float)this.mShadowRadius, (float)shadowXOffset, (float)shadowYOffset, 0x1E000000);
            int padding = this.mShadowRadius;
            this.setPadding(padding, padding, padding, padding);
        }
        circle.getPaint().setColor(this.mBackgroundColor);
        ViewCompat.setBackground((View)this, (Drawable)circle);
    }

    private boolean elevationSupported() {
        return Build.VERSION.SDK_INT >= 21;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (!this.elevationSupported()) {
            this.setMeasuredDimension(this.getMeasuredWidth() + this.mShadowRadius * 2, this.getMeasuredHeight() + this.mShadowRadius * 2);
        }
    }

    public void setAnimationListener(Animation.AnimationListener listener) {
        this.mListener = listener;
    }

    public void onAnimationStart() {
        super.onAnimationStart();
        if (this.mListener != null) {
            this.mListener.onAnimationStart(this.getAnimation());
        }
    }

    public void onAnimationEnd() {
        super.onAnimationEnd();
        if (this.mListener != null) {
            this.mListener.onAnimationEnd(this.getAnimation());
        }
    }

    public void setBackgroundColor(int color) {
        if (this.getBackground() instanceof ShapeDrawable) {
            ((ShapeDrawable)this.getBackground()).getPaint().setColor(color);
            this.mBackgroundColor = color;
        }
    }

    public int getBackgroundColor() {
        return this.mBackgroundColor;
    }

    private static class OvalShadow
    extends OvalShape {
        private Paint mShadowPaint;
        private int mShadowRadius;
        private CircleImageView mCircleImageView;

        OvalShadow(CircleImageView circleImageView, int shadowRadius) {
            this.mCircleImageView = circleImageView;
            this.mShadowPaint = new Paint();
            this.mShadowRadius = shadowRadius;
            this.updateRadialGradient((int)this.rect().width());
        }

        protected void onResize(float width, float height) {
            super.onResize(width, height);
            this.updateRadialGradient((int)width);
        }

        public void draw(Canvas canvas, Paint paint) {
            int x = this.mCircleImageView.getWidth() / 2;
            int y = this.mCircleImageView.getHeight() / 2;
            canvas.drawCircle((float)x, (float)y, (float)x, this.mShadowPaint);
            canvas.drawCircle((float)x, (float)y, (float)(x - this.mShadowRadius), paint);
        }

        private void updateRadialGradient(int diameter) {
            this.mShadowPaint.setShader((Shader)new RadialGradient((float)(diameter / 2), (float)(diameter / 2), (float)this.mShadowRadius, new int[]{0x3D000000, 0}, null, Shader.TileMode.CLAMP));
        }
    }
}

