/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.model;

import android.util.Log;
import androidx.annotation.NonNull;
import com.bumptech.glide.load.Encoder;
import com.bumptech.glide.load.Options;
import com.bumptech.glide.load.engine.bitmap_recycle.ArrayPool;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class StreamEncoder
implements Encoder<InputStream> {
    private static final String TAG = "StreamEncoder";
    private final ArrayPool byteArrayPool;

    public StreamEncoder(ArrayPool byteArrayPool) {
        this.byteArrayPool = byteArrayPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean encode(@NonNull InputStream data, @NonNull File file, @NonNull Options options) {
        byte[] buffer = this.byteArrayPool.get(65536, byte[].class);
        boolean success = false;
        FileOutputStream os = null;
        try {
            int read;
            os = new FileOutputStream(file);
            while ((read = data.read(buffer)) != -1) {
                ((OutputStream)os).write(buffer, 0, read);
            }
            ((OutputStream)os).close();
            success = true;
        }
        catch (IOException e) {
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)"Failed to encode data onto the OutputStream", (Throwable)e);
            }
        }
        finally {
            if (os != null) {
                try {
                    ((OutputStream)os).close();
                }
                catch (IOException iOException) {}
            }
            this.byteArrayPool.put(buffer);
        }
        return success;
    }
}

