/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.transition;

import android.animation.TimeInterpolator;
import androidx.annotation.AttrRes;
import androidx.annotation.NonNull;
import com.google.android.material.R;
import com.google.android.material.animation.AnimationUtils;
import com.google.android.material.transition.FadeProvider;
import com.google.android.material.transition.MaterialVisibility;
import com.google.android.material.transition.ScaleProvider;
import com.google.android.material.transition.VisibilityAnimatorProvider;

public final class MaterialFade
extends MaterialVisibility<FadeProvider> {
    private static final float DEFAULT_START_SCALE = 0.8f;
    private static final float DEFAULT_FADE_END_THRESHOLD_ENTER = 0.3f;
    @AttrRes
    private static final int DEFAULT_THEMED_INCOMING_DURATION_ATTR = R.attr.motionDurationShort2;
    @AttrRes
    private static final int DEFAULT_THEMED_OUTGOING_DURATION_ATTR = R.attr.motionDurationShort1;
    @AttrRes
    private static final int DEFAULT_THEMED_EASING_ATTR = R.attr.motionEasingLinear;

    public MaterialFade() {
        super(MaterialFade.createPrimaryAnimatorProvider(), MaterialFade.createSecondaryAnimatorProvider());
    }

    private static FadeProvider createPrimaryAnimatorProvider() {
        FadeProvider fadeProvider = new FadeProvider();
        fadeProvider.setIncomingEndThreshold(0.3f);
        return fadeProvider;
    }

    private static VisibilityAnimatorProvider createSecondaryAnimatorProvider() {
        ScaleProvider scaleProvider = new ScaleProvider();
        scaleProvider.setScaleOnDisappear(false);
        scaleProvider.setIncomingStartScale(0.8f);
        return scaleProvider;
    }

    @Override
    @AttrRes
    int getDurationThemeAttrResId(boolean appearing) {
        return appearing ? DEFAULT_THEMED_INCOMING_DURATION_ATTR : DEFAULT_THEMED_OUTGOING_DURATION_ATTR;
    }

    @Override
    @AttrRes
    int getEasingThemeAttrResId(boolean appearing) {
        return DEFAULT_THEMED_EASING_ATTR;
    }

    @Override
    @NonNull
    TimeInterpolator getDefaultEasingInterpolator(boolean appearing) {
        return AnimationUtils.LINEAR_INTERPOLATOR;
    }
}

