/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.chip;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityNodeInfo;
import androidx.annotation.BoolRes;
import androidx.annotation.DimenRes;
import androidx.annotation.Dimension;
import androidx.annotation.IdRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.view.ViewCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import com.google.android.material.R;
import com.google.android.material.chip.Chip;
import com.google.android.material.internal.CheckableGroup;
import com.google.android.material.internal.FlowLayout;
import com.google.android.material.internal.ThemeEnforcement;
import com.google.android.material.theme.overlay.MaterialThemeOverlay;
import java.util.List;
import java.util.Set;

public class ChipGroup
extends FlowLayout {
    private static final int DEF_STYLE_RES = R.style.Widget_MaterialComponents_ChipGroup;
    @Dimension
    private int chipSpacingHorizontal;
    @Dimension
    private int chipSpacingVertical;
    @Nullable
    private OnCheckedStateChangeListener onCheckedStateChangeListener;
    private final CheckableGroup<Chip> checkableGroup = new CheckableGroup();
    private final int defaultCheckedId;
    @NonNull
    private final PassThroughHierarchyChangeListener passThroughListener = new PassThroughHierarchyChangeListener();

    public ChipGroup(Context context) {
        this(context, null);
    }

    public ChipGroup(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.chipGroupStyle);
    }

    public ChipGroup(Context context, AttributeSet attrs, int defStyleAttr) {
        super(MaterialThemeOverlay.wrap(context, attrs, defStyleAttr, DEF_STYLE_RES), attrs, defStyleAttr);
        context = this.getContext();
        TypedArray a = ThemeEnforcement.obtainStyledAttributes(context, attrs, R.styleable.ChipGroup, defStyleAttr, DEF_STYLE_RES, new int[0]);
        int chipSpacing = a.getDimensionPixelOffset(R.styleable.ChipGroup_chipSpacing, 0);
        this.setChipSpacingHorizontal(a.getDimensionPixelOffset(R.styleable.ChipGroup_chipSpacingHorizontal, chipSpacing));
        this.setChipSpacingVertical(a.getDimensionPixelOffset(R.styleable.ChipGroup_chipSpacingVertical, chipSpacing));
        this.setSingleLine(a.getBoolean(R.styleable.ChipGroup_singleLine, false));
        this.setSingleSelection(a.getBoolean(R.styleable.ChipGroup_singleSelection, false));
        this.setSelectionRequired(a.getBoolean(R.styleable.ChipGroup_selectionRequired, false));
        this.defaultCheckedId = a.getResourceId(R.styleable.ChipGroup_checkedChip, -1);
        a.recycle();
        this.checkableGroup.setOnCheckedStateChangeListener(new CheckableGroup.OnCheckedStateChangeListener(){

            @Override
            public void onCheckedStateChanged(Set<Integer> checkedIds) {
                if (ChipGroup.this.onCheckedStateChangeListener != null) {
                    ChipGroup.this.onCheckedStateChangeListener.onCheckedChanged(ChipGroup.this, ChipGroup.this.checkableGroup.getCheckedIdsSortedByChildOrder(ChipGroup.this));
                }
            }
        });
        super.setOnHierarchyChangeListener((ViewGroup.OnHierarchyChangeListener)this.passThroughListener);
        ViewCompat.setImportantForAccessibility((View)this, (int)1);
    }

    public void onInitializeAccessibilityNodeInfo(@NonNull AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfo(info);
        AccessibilityNodeInfoCompat infoCompat = AccessibilityNodeInfoCompat.wrap((AccessibilityNodeInfo)info);
        int columnCount = this.isSingleLine() ? this.getChipCount() : -1;
        infoCompat.setCollectionInfo((Object)AccessibilityNodeInfoCompat.CollectionInfoCompat.obtain((int)this.getRowCount(), (int)columnCount, (boolean)false, (int)(this.isSingleSelection() ? 1 : 2)));
    }

    @NonNull
    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    @NonNull
    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams lp) {
        return new LayoutParams(lp);
    }

    @NonNull
    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-2, -2);
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return super.checkLayoutParams(p) && p instanceof LayoutParams;
    }

    public void setOnHierarchyChangeListener(ViewGroup.OnHierarchyChangeListener listener) {
        this.passThroughListener.onHierarchyChangeListener = listener;
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        if (this.defaultCheckedId != -1) {
            this.checkableGroup.check(this.defaultCheckedId);
        }
    }

    @Deprecated
    public void setDividerDrawableHorizontal(Drawable divider) {
        throw new UnsupportedOperationException("Changing divider drawables have no effect. ChipGroup do not use divider drawables as spacing.");
    }

    @Deprecated
    public void setDividerDrawableVertical(@Nullable Drawable divider) {
        throw new UnsupportedOperationException("Changing divider drawables have no effect. ChipGroup do not use divider drawables as spacing.");
    }

    @Deprecated
    public void setShowDividerHorizontal(int dividerMode) {
        throw new UnsupportedOperationException("Changing divider modes has no effect. ChipGroup do not use divider drawables as spacing.");
    }

    @Deprecated
    public void setShowDividerVertical(int dividerMode) {
        throw new UnsupportedOperationException("Changing divider modes has no effect. ChipGroup do not use divider drawables as spacing.");
    }

    @Deprecated
    public void setFlexWrap(int flexWrap) {
        throw new UnsupportedOperationException("Changing flex wrap not allowed. ChipGroup exposes a singleLine attribute instead.");
    }

    public void check(@IdRes int id2) {
        this.checkableGroup.check(id2);
    }

    @IdRes
    public int getCheckedChipId() {
        return this.checkableGroup.getSingleCheckedId();
    }

    @NonNull
    public List<Integer> getCheckedChipIds() {
        return this.checkableGroup.getCheckedIdsSortedByChildOrder(this);
    }

    public void clearCheck() {
        this.checkableGroup.clearCheck();
    }

    @Deprecated
    public void setOnCheckedChangeListener(final @Nullable OnCheckedChangeListener listener) {
        if (listener == null) {
            this.setOnCheckedStateChangeListener(null);
            return;
        }
        this.setOnCheckedStateChangeListener(new OnCheckedStateChangeListener(){

            @Override
            public void onCheckedChanged(@NonNull ChipGroup group, @NonNull List<Integer> checkedIds) {
                if (!ChipGroup.this.checkableGroup.isSingleSelection()) {
                    return;
                }
                listener.onCheckedChanged(group, ChipGroup.this.getCheckedChipId());
            }
        });
    }

    public void setOnCheckedStateChangeListener(@Nullable OnCheckedStateChangeListener listener) {
        this.onCheckedStateChangeListener = listener;
    }

    private int getChipCount() {
        int count = 0;
        for (int i = 0; i < this.getChildCount(); ++i) {
            if (!(this.getChildAt(i) instanceof Chip)) continue;
            ++count;
        }
        return count;
    }

    int getIndexOfChip(@Nullable View child) {
        if (!(child instanceof Chip)) {
            return -1;
        }
        int index = 0;
        for (int i = 0; i < this.getChildCount(); ++i) {
            if (!(this.getChildAt(i) instanceof Chip)) continue;
            Chip chip = (Chip)this.getChildAt(i);
            if (chip == child) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public void setChipSpacing(@Dimension int chipSpacing) {
        this.setChipSpacingHorizontal(chipSpacing);
        this.setChipSpacingVertical(chipSpacing);
    }

    public void setChipSpacingResource(@DimenRes int id2) {
        this.setChipSpacing(this.getResources().getDimensionPixelOffset(id2));
    }

    @Dimension
    public int getChipSpacingHorizontal() {
        return this.chipSpacingHorizontal;
    }

    public void setChipSpacingHorizontal(@Dimension int chipSpacingHorizontal) {
        if (this.chipSpacingHorizontal != chipSpacingHorizontal) {
            this.chipSpacingHorizontal = chipSpacingHorizontal;
            this.setItemSpacing(chipSpacingHorizontal);
            this.requestLayout();
        }
    }

    public void setChipSpacingHorizontalResource(@DimenRes int id2) {
        this.setChipSpacingHorizontal(this.getResources().getDimensionPixelOffset(id2));
    }

    @Dimension
    public int getChipSpacingVertical() {
        return this.chipSpacingVertical;
    }

    public void setChipSpacingVertical(@Dimension int chipSpacingVertical) {
        if (this.chipSpacingVertical != chipSpacingVertical) {
            this.chipSpacingVertical = chipSpacingVertical;
            this.setLineSpacing(chipSpacingVertical);
            this.requestLayout();
        }
    }

    public void setChipSpacingVerticalResource(@DimenRes int id2) {
        this.setChipSpacingVertical(this.getResources().getDimensionPixelOffset(id2));
    }

    @Override
    public boolean isSingleLine() {
        return super.isSingleLine();
    }

    @Override
    public void setSingleLine(boolean singleLine) {
        super.setSingleLine(singleLine);
    }

    public void setSingleLine(@BoolRes int id2) {
        this.setSingleLine(this.getResources().getBoolean(id2));
    }

    public boolean isSingleSelection() {
        return this.checkableGroup.isSingleSelection();
    }

    public void setSingleSelection(boolean singleSelection) {
        this.checkableGroup.setSingleSelection(singleSelection);
    }

    public void setSingleSelection(@BoolRes int id2) {
        this.setSingleSelection(this.getResources().getBoolean(id2));
    }

    public void setSelectionRequired(boolean selectionRequired) {
        this.checkableGroup.setSelectionRequired(selectionRequired);
    }

    public boolean isSelectionRequired() {
        return this.checkableGroup.isSelectionRequired();
    }

    private class PassThroughHierarchyChangeListener
    implements ViewGroup.OnHierarchyChangeListener {
        private ViewGroup.OnHierarchyChangeListener onHierarchyChangeListener;

        private PassThroughHierarchyChangeListener() {
        }

        public void onChildViewAdded(View parent, View child) {
            if (parent == ChipGroup.this && child instanceof Chip) {
                int id2 = child.getId();
                if (id2 == -1) {
                    id2 = ViewCompat.generateViewId();
                    child.setId(id2);
                }
                ChipGroup.this.checkableGroup.addCheckable((Chip)child);
            }
            if (this.onHierarchyChangeListener != null) {
                this.onHierarchyChangeListener.onChildViewAdded(parent, child);
            }
        }

        public void onChildViewRemoved(View parent, View child) {
            if (parent == ChipGroup.this && child instanceof Chip) {
                ChipGroup.this.checkableGroup.removeCheckable((Chip)child);
            }
            if (this.onHierarchyChangeListener != null) {
                this.onHierarchyChangeListener.onChildViewRemoved(parent, child);
            }
        }
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams {
        public LayoutParams(Context context, AttributeSet attrs) {
            super(context, attrs);
        }

        public LayoutParams(ViewGroup.LayoutParams source) {
            super(source);
        }

        public LayoutParams(int width, int height) {
            super(width, height);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams source) {
            super(source);
        }
    }

    public static interface OnCheckedStateChangeListener {
        public void onCheckedChanged(@NonNull ChipGroup var1, @NonNull List<Integer> var2);
    }

    @Deprecated
    public static interface OnCheckedChangeListener {
        public void onCheckedChanged(@NonNull ChipGroup var1, @IdRes int var2);
    }
}

