/*
 * Decompiled with CFR 0.152.
 */
package androidx.window.core;

import java.math.BigInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0000\u0018\u0000 \u001c2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u001cB'\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0011\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0000H\u0096\u0002J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0016\u001a\u0004\u0018\u00010\u0019H\u0096\u0002J\b\u0010\u001a\u001a\u00020\u0003H\u0016J\b\u0010\u001b\u001a\u00020\u0007H\u0016R\u001b\u0010\t\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012\u00a8\u0006\u001d"}, d2={"Landroidx/window/core/Version;", "", "major", "", "minor", "patch", "description", "", "(IIILjava/lang/String;)V", "bigInteger", "Ljava/math/BigInteger;", "getBigInteger", "()Ljava/math/BigInteger;", "bigInteger$delegate", "Lkotlin/Lazy;", "getDescription", "()Ljava/lang/String;", "getMajor", "()I", "getMinor", "getPatch", "compareTo", "other", "equals", "", "", "hashCode", "toString", "Companion", "window_release"})
public final class Version
implements Comparable<Version> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int major;
    private final int minor;
    private final int patch;
    @NotNull
    private final String description;
    @NotNull
    private final Lazy bigInteger$delegate;
    @NotNull
    private static final Version UNKNOWN = new Version(0, 0, 0, "");
    @NotNull
    private static final Version VERSION_0_1 = new Version(0, 1, 0, "");
    @NotNull
    private static final Version VERSION_1_0;
    @NotNull
    private static final Version CURRENT;
    @NotNull
    private static final String VERSION_PATTERN_STRING = "(\\d+)(?:\\.(\\d+))(?:\\.(\\d+))(?:-(.+))?";

    private Version(int major, int minor, int patch, String description) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.description = description;
        this.bigInteger$delegate = LazyKt.lazy((Function0)((Function0)new Function0<BigInteger>(this){
            final /* synthetic */ Version this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final BigInteger invoke() {
                return BigInteger.valueOf(this.this$0.getMajor()).shiftLeft(32).or(BigInteger.valueOf(this.this$0.getMinor())).shiftLeft(32).or(BigInteger.valueOf(this.this$0.getPatch()));
            }
        }));
    }

    public final int getMajor() {
        return this.major;
    }

    public final int getMinor() {
        return this.minor;
    }

    public final int getPatch() {
        return this.patch;
    }

    @NotNull
    public final String getDescription() {
        return this.description;
    }

    private final BigInteger getBigInteger() {
        Lazy lazy = this.bigInteger$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-bigInteger>(...)");
        return (BigInteger)object;
    }

    @NotNull
    public String toString() {
        String postfix = !StringsKt.isBlank((CharSequence)this.description) ? Intrinsics.stringPlus((String)"-", (Object)this.description) : "";
        return "" + this.major + '.' + this.minor + '.' + this.patch + postfix;
    }

    @Override
    public int compareTo(@NotNull Version other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.getBigInteger().compareTo(other.getBigInteger());
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof Version)) {
            return false;
        }
        return this.major == ((Version)other).major && this.minor == ((Version)other).minor && this.patch == ((Version)other).patch;
    }

    public int hashCode() {
        int result = 17;
        result = result * 31 + this.major;
        result = result * 31 + this.minor;
        result = result * 31 + this.patch;
        return result;
    }

    @JvmStatic
    @Nullable
    public static final Version parse(@Nullable String versionString) {
        return Companion.parse(versionString);
    }

    public /* synthetic */ Version(int major, int minor, int patch, String description, DefaultConstructorMarker $constructor_marker) {
        this(major, minor, patch, description);
    }

    static {
        CURRENT = VERSION_1_0 = new Version(1, 0, 0, "");
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u000f\u001a\u0004\u0018\u00010\u00042\b\u0010\u0010\u001a\u0004\u0018\u00010\u000eH\u0007R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u000e\u0010\r\u001a\u00020\u000eX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Landroidx/window/core/Version$Companion;", "", "()V", "CURRENT", "Landroidx/window/core/Version;", "getCURRENT", "()Landroidx/window/core/Version;", "UNKNOWN", "getUNKNOWN", "VERSION_0_1", "getVERSION_0_1", "VERSION_1_0", "getVERSION_1_0", "VERSION_PATTERN_STRING", "", "parse", "versionString", "window_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Version getUNKNOWN() {
            return UNKNOWN;
        }

        @NotNull
        public final Version getVERSION_0_1() {
            return VERSION_0_1;
        }

        @NotNull
        public final Version getVERSION_1_0() {
            return VERSION_1_0;
        }

        @NotNull
        public final Version getCURRENT() {
            return CURRENT;
        }

        @JvmStatic
        @Nullable
        public final Version parse(@Nullable String versionString) {
            if (versionString == null || StringsKt.isBlank((CharSequence)versionString)) {
                return null;
            }
            Matcher matcher = Pattern.compile(Version.VERSION_PATTERN_STRING).matcher(versionString);
            if (!matcher.matches()) {
                return null;
            }
            String string = matcher.group(1);
            Integer n = string == null ? null : Integer.valueOf(Integer.parseInt(string));
            if (n == null) {
                return null;
            }
            int major = n;
            String string2 = matcher.group(2);
            Integer n2 = string2 == null ? null : Integer.valueOf(Integer.parseInt(string2));
            if (n2 == null) {
                return null;
            }
            int minor = n2;
            String string3 = matcher.group(3);
            Integer n3 = string3 == null ? null : Integer.valueOf(Integer.parseInt(string3));
            if (n3 == null) {
                return null;
            }
            int patch = n3;
            String description = matcher.group(4) != null ? matcher.group(4) : "";
            Intrinsics.checkNotNullExpressionValue((Object)description, (String)"description");
            return new Version(major, minor, patch, description, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

