/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.snackbar;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.lang.ref.WeakReference;

class SnackbarManager {
    static final int MSG_TIMEOUT = 0;
    private static final int SHORT_DURATION_MS = 1500;
    private static final int LONG_DURATION_MS = 2750;
    private static SnackbarManager snackbarManager;
    @NonNull
    private final Object lock = new Object();
    @NonNull
    private final Handler handler = new Handler(Looper.getMainLooper(), new Handler.Callback(){

        public boolean handleMessage(@NonNull Message message) {
            switch (message.what) {
                case 0: {
                    SnackbarManager.this.handleTimeout((SnackbarRecord)message.obj);
                    return true;
                }
            }
            return false;
        }
    });
    @Nullable
    private SnackbarRecord currentSnackbar;
    @Nullable
    private SnackbarRecord nextSnackbar;

    static SnackbarManager getInstance() {
        if (snackbarManager == null) {
            snackbarManager = new SnackbarManager();
        }
        return snackbarManager;
    }

    private SnackbarManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void show(int duration, Callback callback) {
        Object object = this.lock;
        synchronized (object) {
            if (this.isCurrentSnackbarLocked(callback)) {
                this.currentSnackbar.duration = duration;
                this.handler.removeCallbacksAndMessages((Object)this.currentSnackbar);
                this.scheduleTimeoutLocked(this.currentSnackbar);
                return;
            }
            if (this.isNextSnackbarLocked(callback)) {
                this.nextSnackbar.duration = duration;
            } else {
                this.nextSnackbar = new SnackbarRecord(duration, callback);
            }
            if (this.currentSnackbar != null && this.cancelSnackbarLocked(this.currentSnackbar, 4)) {
                return;
            }
            this.currentSnackbar = null;
            this.showNextSnackbarLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dismiss(Callback callback, int event) {
        Object object = this.lock;
        synchronized (object) {
            if (this.isCurrentSnackbarLocked(callback)) {
                this.cancelSnackbarLocked(this.currentSnackbar, event);
            } else if (this.isNextSnackbarLocked(callback)) {
                this.cancelSnackbarLocked(this.nextSnackbar, event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDismissed(Callback callback) {
        Object object = this.lock;
        synchronized (object) {
            if (this.isCurrentSnackbarLocked(callback)) {
                this.currentSnackbar = null;
                if (this.nextSnackbar != null) {
                    this.showNextSnackbarLocked();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onShown(Callback callback) {
        Object object = this.lock;
        synchronized (object) {
            if (this.isCurrentSnackbarLocked(callback)) {
                this.scheduleTimeoutLocked(this.currentSnackbar);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseTimeout(Callback callback) {
        Object object = this.lock;
        synchronized (object) {
            if (this.isCurrentSnackbarLocked(callback) && !this.currentSnackbar.paused) {
                this.currentSnackbar.paused = true;
                this.handler.removeCallbacksAndMessages((Object)this.currentSnackbar);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreTimeoutIfPaused(Callback callback) {
        Object object = this.lock;
        synchronized (object) {
            if (this.isCurrentSnackbarLocked(callback) && this.currentSnackbar.paused) {
                this.currentSnackbar.paused = false;
                this.scheduleTimeoutLocked(this.currentSnackbar);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCurrent(Callback callback) {
        Object object = this.lock;
        synchronized (object) {
            return this.isCurrentSnackbarLocked(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCurrentOrNext(Callback callback) {
        Object object = this.lock;
        synchronized (object) {
            return this.isCurrentSnackbarLocked(callback) || this.isNextSnackbarLocked(callback);
        }
    }

    private void showNextSnackbarLocked() {
        if (this.nextSnackbar != null) {
            this.currentSnackbar = this.nextSnackbar;
            this.nextSnackbar = null;
            Callback callback = (Callback)this.currentSnackbar.callback.get();
            if (callback != null) {
                callback.show();
            } else {
                this.currentSnackbar = null;
            }
        }
    }

    private boolean cancelSnackbarLocked(@NonNull SnackbarRecord record, int event) {
        Callback callback = (Callback)record.callback.get();
        if (callback != null) {
            this.handler.removeCallbacksAndMessages((Object)record);
            callback.dismiss(event);
            return true;
        }
        return false;
    }

    private boolean isCurrentSnackbarLocked(Callback callback) {
        return this.currentSnackbar != null && this.currentSnackbar.isSnackbar(callback);
    }

    private boolean isNextSnackbarLocked(Callback callback) {
        return this.nextSnackbar != null && this.nextSnackbar.isSnackbar(callback);
    }

    private void scheduleTimeoutLocked(@NonNull SnackbarRecord r) {
        if (r.duration == -2) {
            return;
        }
        int durationMs = 2750;
        if (r.duration > 0) {
            durationMs = r.duration;
        } else if (r.duration == -1) {
            durationMs = 1500;
        }
        this.handler.removeCallbacksAndMessages((Object)r);
        this.handler.sendMessageDelayed(Message.obtain((Handler)this.handler, (int)0, (Object)r), (long)durationMs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleTimeout(@NonNull SnackbarRecord record) {
        Object object = this.lock;
        synchronized (object) {
            if (this.currentSnackbar == record || this.nextSnackbar == record) {
                this.cancelSnackbarLocked(record, 2);
            }
        }
    }

    private static class SnackbarRecord {
        @NonNull
        final WeakReference<Callback> callback;
        int duration;
        boolean paused;

        SnackbarRecord(int duration, Callback callback) {
            this.callback = new WeakReference<Callback>(callback);
            this.duration = duration;
        }

        boolean isSnackbar(@Nullable Callback callback) {
            return callback != null && this.callback.get() == callback;
        }
    }

    static interface Callback {
        public void show();

        public void dismiss(int var1);
    }
}

