/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.shape;

import android.graphics.RectF;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import com.google.android.material.shape.CornerSize;
import java.util.Arrays;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class AdjustedCornerSize
implements CornerSize {
    private final CornerSize other;
    private final float adjustment;

    public AdjustedCornerSize(float adjustment, @NonNull CornerSize other) {
        while (other instanceof AdjustedCornerSize) {
            other = ((AdjustedCornerSize)other).other;
            adjustment += ((AdjustedCornerSize)other).adjustment;
        }
        this.other = other;
        this.adjustment = adjustment;
    }

    @Override
    public float getCornerSize(@NonNull RectF bounds) {
        return Math.max(0.0f, this.other.getCornerSize(bounds) + this.adjustment);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AdjustedCornerSize)) {
            return false;
        }
        AdjustedCornerSize that = (AdjustedCornerSize)o;
        return this.other.equals(that.other) && this.adjustment == that.adjustment;
    }

    public int hashCode() {
        Object[] hashedFields = new Object[]{this.other, Float.valueOf(this.adjustment)};
        return Arrays.hashCode(hashedFields);
    }
}

