/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.request;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import androidx.annotation.CheckResult;
import androidx.annotation.DrawableRes;
import androidx.annotation.FloatRange;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.bumptech.glide.Priority;
import com.bumptech.glide.load.DecodeFormat;
import com.bumptech.glide.load.Key;
import com.bumptech.glide.load.MultiTransformation;
import com.bumptech.glide.load.Option;
import com.bumptech.glide.load.Options;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.model.stream.HttpGlideUrlLoader;
import com.bumptech.glide.load.resource.bitmap.BitmapEncoder;
import com.bumptech.glide.load.resource.bitmap.CenterCrop;
import com.bumptech.glide.load.resource.bitmap.CenterInside;
import com.bumptech.glide.load.resource.bitmap.CircleCrop;
import com.bumptech.glide.load.resource.bitmap.DownsampleStrategy;
import com.bumptech.glide.load.resource.bitmap.Downsampler;
import com.bumptech.glide.load.resource.bitmap.DrawableTransformation;
import com.bumptech.glide.load.resource.bitmap.FitCenter;
import com.bumptech.glide.load.resource.bitmap.VideoDecoder;
import com.bumptech.glide.load.resource.gif.GifDrawable;
import com.bumptech.glide.load.resource.gif.GifDrawableTransformation;
import com.bumptech.glide.load.resource.gif.GifOptions;
import com.bumptech.glide.signature.EmptySignature;
import com.bumptech.glide.util.CachedHashCodeArrayMap;
import com.bumptech.glide.util.Preconditions;
import com.bumptech.glide.util.Util;
import java.util.Map;

public abstract class BaseRequestOptions<T extends BaseRequestOptions<T>>
implements Cloneable {
    private static final int UNSET = -1;
    private static final int SIZE_MULTIPLIER = 2;
    private static final int DISK_CACHE_STRATEGY = 4;
    private static final int PRIORITY = 8;
    private static final int ERROR_PLACEHOLDER = 16;
    private static final int ERROR_ID = 32;
    private static final int PLACEHOLDER = 64;
    private static final int PLACEHOLDER_ID = 128;
    private static final int IS_CACHEABLE = 256;
    private static final int OVERRIDE = 512;
    private static final int SIGNATURE = 1024;
    private static final int TRANSFORMATION = 2048;
    private static final int RESOURCE_CLASS = 4096;
    private static final int FALLBACK = 8192;
    private static final int FALLBACK_ID = 16384;
    private static final int THEME = 32768;
    private static final int TRANSFORMATION_ALLOWED = 65536;
    private static final int TRANSFORMATION_REQUIRED = 131072;
    private static final int USE_UNLIMITED_SOURCE_GENERATORS_POOL = 262144;
    private static final int ONLY_RETRIEVE_FROM_CACHE = 524288;
    private static final int USE_ANIMATION_POOL = 0x100000;
    private int fields;
    private float sizeMultiplier = 1.0f;
    @NonNull
    private DiskCacheStrategy diskCacheStrategy = DiskCacheStrategy.AUTOMATIC;
    @NonNull
    private Priority priority = Priority.NORMAL;
    @Nullable
    private Drawable errorPlaceholder;
    private int errorId;
    @Nullable
    private Drawable placeholderDrawable;
    private int placeholderId;
    private boolean isCacheable = true;
    private int overrideHeight = -1;
    private int overrideWidth = -1;
    @NonNull
    private Key signature = EmptySignature.obtain();
    private boolean isTransformationRequired;
    private boolean isTransformationAllowed = true;
    @Nullable
    private Drawable fallbackDrawable;
    private int fallbackId;
    @NonNull
    private Options options = new Options();
    @NonNull
    private Map<Class<?>, Transformation<?>> transformations = new CachedHashCodeArrayMap();
    @NonNull
    private Class<?> resourceClass = Object.class;
    private boolean isLocked;
    @Nullable
    private Resources.Theme theme;
    private boolean isAutoCloneEnabled;
    private boolean useUnlimitedSourceGeneratorsPool;
    private boolean onlyRetrieveFromCache;
    private boolean isScaleOnlyOrNoTransform = true;
    private boolean useAnimationPool;

    private static boolean isSet(int fields, int flag) {
        return (fields & flag) != 0;
    }

    @NonNull
    @CheckResult
    public T sizeMultiplier(@FloatRange(from=0.0, to=1.0) float sizeMultiplier) {
        if (this.isAutoCloneEnabled) {
            return ((BaseRequestOptions)this.clone()).sizeMultiplier(sizeMultiplier);
        }
        if (sizeMultiplier < 0.0f || sizeMultiplier > 1.0f) {
            throw new IllegalArgumentException("sizeMultiplier must be between 0 and 1");
        }
        this.sizeMultiplier = sizeMultiplier;
        this.fields |= 2;
        return this.selfOrThrowIfLocked();
    }

    @NonNull
    @CheckResult
    public T useUnlimitedSourceGeneratorsPool(boolean flag) {
        if (this.isAutoCloneEnabled) {
            return ((BaseRequestOptions)this.clone()).useUnlimitedSourceGeneratorsPool(flag);
        }
        this.useUnlimitedSourceGeneratorsPool = flag;
        this.fields |= 0x40000;
        return this.selfOrThrowIfLocked();
    }

    @NonNull
    @CheckResult
    public T useAnimationPool(boolean flag) {
        if (this.isAutoCloneEnabled) {
            return ((BaseRequestOptions)this.clone()).useAnimationPool(flag);
        }
        this.useAnimationPool = flag;
        this.fields |= 0x100000;
        return this.selfOrThrowIfLocked();
    }

    @NonNull
    @CheckResult
    public T onlyRetrieveFromCache(boolean flag) {
        if (this.isAutoCloneEnabled) {
            return ((BaseRequestOptions)this.clone()).onlyRetrieveFromCache(flag);
        }
        this.onlyRetrieveFromCache = flag;
        this.fields |= 0x80000;
        return this.selfOrThrowIfLocked();
    }

    @NonNull
    @CheckResult
    public T diskCacheStrategy(@NonNull DiskCacheStrategy strategy) {
        if (this.isAutoCloneEnabled) {
            return ((BaseRequestOptions)this.clone()).diskCacheStrategy(strategy);
        }
        this.diskCacheStrategy = Preconditions.checkNotNull(strategy);
        this.fields |= 4;
        return this.selfOrThrowIfLocked();
    }

    @NonNull
    @CheckResult
    public T priority(@NonNull Priority priority) {
        if (this.isAutoCloneEnabled) {
            return ((BaseRequestOptions)this.clone()).priority(priority);
        }
        this.priority = Preconditions.checkNotNull(priority);
        this.fields |= 8;
        return this.selfOrThrowIfLocked();
    }

    @NonNull
    @CheckResult
    public T placeholder(@Nullable Drawable drawable) {
        if (this.isAutoCloneEnabled) {
            return ((BaseRequestOptions)this.clone()).placeholder(drawable);
        }
        this.placeholderDrawable = drawable;
        this.fields |= 0x40;
        this.placeholderId = 0;
        this.fields &= 0xFFFFFF7F;
        return this.selfOrThrowIfLocked();
    }

    @NonNull
    @CheckResult
    public T placeholder(@DrawableRes int resourceId) {
        if (this.isAutoCloneEnabled) {
            return ((BaseRequestOptions)this.clone()).placeholder(resourceId);
        }
        this.placeholderId = resourceId;
        this.fields |= 0x80;
        this.placeholderDrawable = null;
        this.fields &= 0xFFFFFFBF;
        return this.selfOrThrowIfLocked();
    }

    @NonNull
    @CheckResult
    public T fallback(@Nullable Drawable drawable) {
        if (this.isAutoCloneEnabled) {
            return ((BaseRequestOptions)this.clone()).fallback(drawable);
        }
        this.fallbackDrawable = drawable;
        this.fields |= 0x2000;
        this.fallbackId = 0;
        this.fields &= 0xFFFFBFFF;
        return this.selfOrThrowIfLocked();
    }

    @NonNull
    @CheckResult
    public T fallback(@DrawableRes int resourceId) {
        if (this.isAutoCloneEnabled) {
            return ((BaseRequestOptions)this.clone()).fallback(resourceId);
        }
        this.fallbackId = resourceId;
        this.fields |= 0x4000;
        this.fallbackDrawable = null;
        this.fields &= 0xFFFFDFFF;
        return this.selfOrThrowIfLocked();
    }

    @NonNull
    @CheckResult
    public T error(@Nullable Drawable drawable) {
        if (this.isAutoCloneEnabled) {
            return ((BaseRequestOptions)this.clone()).error(drawable);
        }
        this.errorPlaceholder = drawable;
        this.fields |= 0x10;
        this.errorId = 0;
        this.fields &= 0xFFFFFFDF;
        return this.selfOrThrowIfLocked();
    }

    @NonNull
    @CheckResult
    public T error(@DrawableRes int resourceId) {
        if (this.isAutoCloneEnabled) {
            return ((BaseRequestOptions)this.clone()).error(resourceId);
        }
        this.errorId = resourceId;
        this.fields |= 0x20;
        this.errorPlaceholder = null;
        this.fields &= 0xFFFFFFEF;
        return this.selfOrThrowIfLocked();
    }

    @NonNull
    @CheckResult
    public T theme(@Nullable Resources.Theme theme) {
        if (this.isAutoCloneEnabled) {
            return ((BaseRequestOptions)this.clone()).theme(theme);
        }
        this.theme = theme;
        this.fields |= 0x8000;
        return this.selfOrThrowIfLocked();
    }

    @NonNull
    @CheckResult
    public T skipMemoryCache(boolean skip) {
        if (this.isAutoCloneEnabled) {
            return ((BaseRequestOptions)this.clone()).skipMemoryCache(true);
        }
        this.isCacheable = !skip;
        this.fields |= 0x100;
        return this.selfOrThrowIfLocked();
    }

    @NonNull
    @CheckResult
    public T override(int width, int height) {
        if (this.isAutoCloneEnabled) {
            return ((BaseRequestOptions)this.clone()).override(width, height);
        }
        this.overrideWidth = width;
        this.overrideHeight = height;
        this.fields |= 0x200;
        return this.selfOrThrowIfLocked();
    }

    @NonNull
    @CheckResult
    public T override(int size) {
        return this.override(size, size);
    }

    @NonNull
    @CheckResult
    public T signature(@NonNull Key signature) {
        if (this.isAutoCloneEnabled) {
            return ((BaseRequestOptions)this.clone()).signature(signature);
        }
        this.signature = Preconditions.checkNotNull(signature);
        this.fields |= 0x400;
        return this.selfOrThrowIfLocked();
    }

    @CheckResult
    public T clone() {
        try {
            BaseRequestOptions result = (BaseRequestOptions)super.clone();
            result.options = new Options();
            result.options.putAll(this.options);
            result.transformations = new CachedHashCodeArrayMap();
            result.transformations.putAll(this.transformations);
            result.isLocked = false;
            result.isAutoCloneEnabled = false;
            return (T)result;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @NonNull
    @CheckResult
    public <Y> T set(@NonNull Option<Y> option, @NonNull Y value) {
        if (this.isAutoCloneEnabled) {
            return ((BaseRequestOptions)this.clone()).set(option, value);
        }
        Preconditions.checkNotNull(option);
        Preconditions.checkNotNull(value);
        this.options.set(option, value);
        return this.selfOrThrowIfLocked();
    }

    @NonNull
    @CheckResult
    public T decode(@NonNull Class<?> resourceClass) {
        if (this.isAutoCloneEnabled) {
            return ((BaseRequestOptions)this.clone()).decode(resourceClass);
        }
        this.resourceClass = Preconditions.checkNotNull(resourceClass);
        this.fields |= 0x1000;
        return this.selfOrThrowIfLocked();
    }

    public final boolean isTransformationAllowed() {
        return this.isTransformationAllowed;
    }

    public final boolean isTransformationSet() {
        return this.isSet(2048);
    }

    public final boolean isLocked() {
        return this.isLocked;
    }

    @NonNull
    @CheckResult
    public T encodeFormat(@NonNull Bitmap.CompressFormat format) {
        return this.set(BitmapEncoder.COMPRESSION_FORMAT, Preconditions.checkNotNull(format));
    }

    @NonNull
    @CheckResult
    public T encodeQuality(@IntRange(from=0L, to=100L) int quality) {
        return this.set(BitmapEncoder.COMPRESSION_QUALITY, quality);
    }

    @NonNull
    @CheckResult
    public T frame(@IntRange(from=0L) long frameTimeMicros) {
        return this.set(VideoDecoder.TARGET_FRAME, frameTimeMicros);
    }

    @NonNull
    @CheckResult
    public T format(@NonNull DecodeFormat format) {
        Preconditions.checkNotNull(format);
        return ((BaseRequestOptions)this.set(Downsampler.DECODE_FORMAT, format)).set(GifOptions.DECODE_FORMAT, (DecodeFormat)format);
    }

    @NonNull
    @CheckResult
    public T disallowHardwareConfig() {
        return this.set(Downsampler.ALLOW_HARDWARE_CONFIG, false);
    }

    @NonNull
    @CheckResult
    public T downsample(@NonNull DownsampleStrategy strategy) {
        return this.set(DownsampleStrategy.OPTION, Preconditions.checkNotNull(strategy));
    }

    @NonNull
    @CheckResult
    public T timeout(@IntRange(from=0L) int timeoutMs) {
        return this.set(HttpGlideUrlLoader.TIMEOUT, timeoutMs);
    }

    @NonNull
    @CheckResult
    public T optionalCenterCrop() {
        return this.optionalTransform(DownsampleStrategy.CENTER_OUTSIDE, new CenterCrop());
    }

    @NonNull
    @CheckResult
    public T centerCrop() {
        return this.transform(DownsampleStrategy.CENTER_OUTSIDE, (Transformation<Bitmap>)new CenterCrop());
    }

    @NonNull
    @CheckResult
    public T optionalFitCenter() {
        return this.optionalScaleOnlyTransform(DownsampleStrategy.FIT_CENTER, new FitCenter());
    }

    @NonNull
    @CheckResult
    public T fitCenter() {
        return this.scaleOnlyTransform(DownsampleStrategy.FIT_CENTER, new FitCenter());
    }

    @NonNull
    @CheckResult
    public T optionalCenterInside() {
        return this.optionalScaleOnlyTransform(DownsampleStrategy.CENTER_INSIDE, new CenterInside());
    }

    @NonNull
    @CheckResult
    public T centerInside() {
        return this.scaleOnlyTransform(DownsampleStrategy.CENTER_INSIDE, new CenterInside());
    }

    @NonNull
    @CheckResult
    public T optionalCircleCrop() {
        return this.optionalTransform(DownsampleStrategy.CENTER_OUTSIDE, new CircleCrop());
    }

    @NonNull
    @CheckResult
    public T circleCrop() {
        return this.transform(DownsampleStrategy.CENTER_INSIDE, (Transformation<Bitmap>)new CircleCrop());
    }

    @NonNull
    final T optionalTransform(@NonNull DownsampleStrategy downsampleStrategy, @NonNull Transformation<Bitmap> transformation) {
        if (this.isAutoCloneEnabled) {
            return ((BaseRequestOptions)this.clone()).optionalTransform(downsampleStrategy, transformation);
        }
        this.downsample(downsampleStrategy);
        return this.transform(transformation, false);
    }

    @NonNull
    @CheckResult
    final T transform(@NonNull DownsampleStrategy downsampleStrategy, @NonNull Transformation<Bitmap> transformation) {
        if (this.isAutoCloneEnabled) {
            return ((BaseRequestOptions)this.clone()).transform(downsampleStrategy, transformation);
        }
        this.downsample(downsampleStrategy);
        return this.transform(transformation);
    }

    @NonNull
    private T scaleOnlyTransform(@NonNull DownsampleStrategy strategy, @NonNull Transformation<Bitmap> transformation) {
        return this.scaleOnlyTransform(strategy, transformation, true);
    }

    @NonNull
    private T optionalScaleOnlyTransform(@NonNull DownsampleStrategy strategy, @NonNull Transformation<Bitmap> transformation) {
        return this.scaleOnlyTransform(strategy, transformation, false);
    }

    @NonNull
    private T scaleOnlyTransform(@NonNull DownsampleStrategy strategy, @NonNull Transformation<Bitmap> transformation, boolean isTransformationRequired) {
        T result = isTransformationRequired ? this.transform(strategy, transformation) : this.optionalTransform(strategy, transformation);
        ((BaseRequestOptions)result).isScaleOnlyOrNoTransform = true;
        return result;
    }

    @NonNull
    @CheckResult
    public T transform(@NonNull Transformation<Bitmap> transformation) {
        return this.transform(transformation, true);
    }

    @NonNull
    @CheckResult
    public T transform(Transformation<Bitmap> ... transformations) {
        if (transformations.length > 1) {
            return this.transform(new MultiTransformation<Bitmap>(transformations), true);
        }
        if (transformations.length == 1) {
            return this.transform(transformations[0]);
        }
        return this.selfOrThrowIfLocked();
    }

    @Deprecated
    @NonNull
    @CheckResult
    public T transforms(Transformation<Bitmap> ... transformations) {
        return this.transform(new MultiTransformation<Bitmap>(transformations), true);
    }

    @NonNull
    @CheckResult
    public T optionalTransform(@NonNull Transformation<Bitmap> transformation) {
        return this.transform(transformation, false);
    }

    @NonNull
    T transform(@NonNull Transformation<Bitmap> transformation, boolean isRequired) {
        if (this.isAutoCloneEnabled) {
            return ((BaseRequestOptions)this.clone()).transform(transformation, isRequired);
        }
        DrawableTransformation drawableTransformation = new DrawableTransformation(transformation, isRequired);
        this.transform(Bitmap.class, transformation, isRequired);
        this.transform(Drawable.class, drawableTransformation, isRequired);
        this.transform(BitmapDrawable.class, drawableTransformation.asBitmapDrawable(), isRequired);
        this.transform(GifDrawable.class, new GifDrawableTransformation(transformation), isRequired);
        return this.selfOrThrowIfLocked();
    }

    @NonNull
    @CheckResult
    public <Y> T optionalTransform(@NonNull Class<Y> resourceClass, @NonNull Transformation<Y> transformation) {
        return this.transform(resourceClass, transformation, false);
    }

    @NonNull
    <Y> T transform(@NonNull Class<Y> resourceClass, @NonNull Transformation<Y> transformation, boolean isRequired) {
        if (this.isAutoCloneEnabled) {
            return ((BaseRequestOptions)this.clone()).transform(resourceClass, transformation, isRequired);
        }
        Preconditions.checkNotNull(resourceClass);
        Preconditions.checkNotNull(transformation);
        this.transformations.put(resourceClass, transformation);
        this.fields |= 0x800;
        this.isTransformationAllowed = true;
        this.fields |= 0x10000;
        this.isScaleOnlyOrNoTransform = false;
        if (isRequired) {
            this.fields |= 0x20000;
            this.isTransformationRequired = true;
        }
        return this.selfOrThrowIfLocked();
    }

    @NonNull
    @CheckResult
    public <Y> T transform(@NonNull Class<Y> resourceClass, @NonNull Transformation<Y> transformation) {
        return this.transform(resourceClass, transformation, true);
    }

    @NonNull
    @CheckResult
    public T dontTransform() {
        if (this.isAutoCloneEnabled) {
            return ((BaseRequestOptions)this.clone()).dontTransform();
        }
        this.transformations.clear();
        this.fields &= 0xFFFFF7FF;
        this.isTransformationRequired = false;
        this.fields &= 0xFFFDFFFF;
        this.isTransformationAllowed = false;
        this.fields |= 0x10000;
        this.isScaleOnlyOrNoTransform = true;
        return this.selfOrThrowIfLocked();
    }

    @NonNull
    @CheckResult
    public T dontAnimate() {
        return this.set(GifOptions.DISABLE_ANIMATION, true);
    }

    @NonNull
    @CheckResult
    public T apply(@NonNull BaseRequestOptions<?> o) {
        if (this.isAutoCloneEnabled) {
            return ((BaseRequestOptions)this.clone()).apply(o);
        }
        BaseRequestOptions<?> other = o;
        if (BaseRequestOptions.isSet(other.fields, 2)) {
            this.sizeMultiplier = other.sizeMultiplier;
        }
        if (BaseRequestOptions.isSet(other.fields, 262144)) {
            this.useUnlimitedSourceGeneratorsPool = other.useUnlimitedSourceGeneratorsPool;
        }
        if (BaseRequestOptions.isSet(other.fields, 0x100000)) {
            this.useAnimationPool = other.useAnimationPool;
        }
        if (BaseRequestOptions.isSet(other.fields, 4)) {
            this.diskCacheStrategy = other.diskCacheStrategy;
        }
        if (BaseRequestOptions.isSet(other.fields, 8)) {
            this.priority = other.priority;
        }
        if (BaseRequestOptions.isSet(other.fields, 16)) {
            this.errorPlaceholder = other.errorPlaceholder;
            this.errorId = 0;
            this.fields &= 0xFFFFFFDF;
        }
        if (BaseRequestOptions.isSet(other.fields, 32)) {
            this.errorId = other.errorId;
            this.errorPlaceholder = null;
            this.fields &= 0xFFFFFFEF;
        }
        if (BaseRequestOptions.isSet(other.fields, 64)) {
            this.placeholderDrawable = other.placeholderDrawable;
            this.placeholderId = 0;
            this.fields &= 0xFFFFFF7F;
        }
        if (BaseRequestOptions.isSet(other.fields, 128)) {
            this.placeholderId = other.placeholderId;
            this.placeholderDrawable = null;
            this.fields &= 0xFFFFFFBF;
        }
        if (BaseRequestOptions.isSet(other.fields, 256)) {
            this.isCacheable = other.isCacheable;
        }
        if (BaseRequestOptions.isSet(other.fields, 512)) {
            this.overrideWidth = other.overrideWidth;
            this.overrideHeight = other.overrideHeight;
        }
        if (BaseRequestOptions.isSet(other.fields, 1024)) {
            this.signature = other.signature;
        }
        if (BaseRequestOptions.isSet(other.fields, 4096)) {
            this.resourceClass = other.resourceClass;
        }
        if (BaseRequestOptions.isSet(other.fields, 8192)) {
            this.fallbackDrawable = other.fallbackDrawable;
            this.fallbackId = 0;
            this.fields &= 0xFFFFBFFF;
        }
        if (BaseRequestOptions.isSet(other.fields, 16384)) {
            this.fallbackId = other.fallbackId;
            this.fallbackDrawable = null;
            this.fields &= 0xFFFFDFFF;
        }
        if (BaseRequestOptions.isSet(other.fields, 32768)) {
            this.theme = other.theme;
        }
        if (BaseRequestOptions.isSet(other.fields, 65536)) {
            this.isTransformationAllowed = other.isTransformationAllowed;
        }
        if (BaseRequestOptions.isSet(other.fields, 131072)) {
            this.isTransformationRequired = other.isTransformationRequired;
        }
        if (BaseRequestOptions.isSet(other.fields, 2048)) {
            this.transformations.putAll(other.transformations);
            this.isScaleOnlyOrNoTransform = other.isScaleOnlyOrNoTransform;
        }
        if (BaseRequestOptions.isSet(other.fields, 524288)) {
            this.onlyRetrieveFromCache = other.onlyRetrieveFromCache;
        }
        if (!this.isTransformationAllowed) {
            this.transformations.clear();
            this.fields &= 0xFFFFF7FF;
            this.isTransformationRequired = false;
            this.fields &= 0xFFFDFFFF;
            this.isScaleOnlyOrNoTransform = true;
        }
        this.fields |= other.fields;
        this.options.putAll(other.options);
        return this.selfOrThrowIfLocked();
    }

    public boolean equals(Object o) {
        if (o instanceof BaseRequestOptions) {
            BaseRequestOptions other = (BaseRequestOptions)o;
            return Float.compare(other.sizeMultiplier, this.sizeMultiplier) == 0 && this.errorId == other.errorId && Util.bothNullOrEqual(this.errorPlaceholder, other.errorPlaceholder) && this.placeholderId == other.placeholderId && Util.bothNullOrEqual(this.placeholderDrawable, other.placeholderDrawable) && this.fallbackId == other.fallbackId && Util.bothNullOrEqual(this.fallbackDrawable, other.fallbackDrawable) && this.isCacheable == other.isCacheable && this.overrideHeight == other.overrideHeight && this.overrideWidth == other.overrideWidth && this.isTransformationRequired == other.isTransformationRequired && this.isTransformationAllowed == other.isTransformationAllowed && this.useUnlimitedSourceGeneratorsPool == other.useUnlimitedSourceGeneratorsPool && this.onlyRetrieveFromCache == other.onlyRetrieveFromCache && this.diskCacheStrategy.equals(other.diskCacheStrategy) && this.priority == other.priority && this.options.equals(other.options) && this.transformations.equals(other.transformations) && this.resourceClass.equals(other.resourceClass) && Util.bothNullOrEqual(this.signature, other.signature) && Util.bothNullOrEqual(this.theme, other.theme);
        }
        return false;
    }

    public int hashCode() {
        int hashCode = Util.hashCode(this.sizeMultiplier);
        hashCode = Util.hashCode(this.errorId, hashCode);
        hashCode = Util.hashCode(this.errorPlaceholder, hashCode);
        hashCode = Util.hashCode(this.placeholderId, hashCode);
        hashCode = Util.hashCode(this.placeholderDrawable, hashCode);
        hashCode = Util.hashCode(this.fallbackId, hashCode);
        hashCode = Util.hashCode(this.fallbackDrawable, hashCode);
        hashCode = Util.hashCode(this.isCacheable, hashCode);
        hashCode = Util.hashCode(this.overrideHeight, hashCode);
        hashCode = Util.hashCode(this.overrideWidth, hashCode);
        hashCode = Util.hashCode(this.isTransformationRequired, hashCode);
        hashCode = Util.hashCode(this.isTransformationAllowed, hashCode);
        hashCode = Util.hashCode(this.useUnlimitedSourceGeneratorsPool, hashCode);
        hashCode = Util.hashCode(this.onlyRetrieveFromCache, hashCode);
        hashCode = Util.hashCode(this.diskCacheStrategy, hashCode);
        hashCode = Util.hashCode((Object)this.priority, hashCode);
        hashCode = Util.hashCode(this.options, hashCode);
        hashCode = Util.hashCode(this.transformations, hashCode);
        hashCode = Util.hashCode(this.resourceClass, hashCode);
        hashCode = Util.hashCode(this.signature, hashCode);
        hashCode = Util.hashCode(this.theme, hashCode);
        return hashCode;
    }

    @NonNull
    public T lock() {
        this.isLocked = true;
        return this.self();
    }

    @NonNull
    public T autoClone() {
        if (this.isLocked && !this.isAutoCloneEnabled) {
            throw new IllegalStateException("You cannot auto lock an already locked options object, try clone() first");
        }
        this.isAutoCloneEnabled = true;
        return this.lock();
    }

    @NonNull
    protected final T selfOrThrowIfLocked() {
        if (this.isLocked) {
            throw new IllegalStateException("You cannot modify locked T, consider clone()");
        }
        return this.self();
    }

    protected final boolean isAutoCloneEnabled() {
        return this.isAutoCloneEnabled;
    }

    public final boolean isDiskCacheStrategySet() {
        return this.isSet(4);
    }

    public final boolean isSkipMemoryCacheSet() {
        return this.isSet(256);
    }

    @NonNull
    public final Map<Class<?>, Transformation<?>> getTransformations() {
        return this.transformations;
    }

    public final boolean isTransformationRequired() {
        return this.isTransformationRequired;
    }

    @NonNull
    public final Options getOptions() {
        return this.options;
    }

    @NonNull
    public final Class<?> getResourceClass() {
        return this.resourceClass;
    }

    @NonNull
    public final DiskCacheStrategy getDiskCacheStrategy() {
        return this.diskCacheStrategy;
    }

    @Nullable
    public final Drawable getErrorPlaceholder() {
        return this.errorPlaceholder;
    }

    public final int getErrorId() {
        return this.errorId;
    }

    public final int getPlaceholderId() {
        return this.placeholderId;
    }

    @Nullable
    public final Drawable getPlaceholderDrawable() {
        return this.placeholderDrawable;
    }

    public final int getFallbackId() {
        return this.fallbackId;
    }

    @Nullable
    public final Drawable getFallbackDrawable() {
        return this.fallbackDrawable;
    }

    @Nullable
    public final Resources.Theme getTheme() {
        return this.theme;
    }

    public final boolean isMemoryCacheable() {
        return this.isCacheable;
    }

    @NonNull
    public final Key getSignature() {
        return this.signature;
    }

    public final boolean isPrioritySet() {
        return this.isSet(8);
    }

    @NonNull
    public final Priority getPriority() {
        return this.priority;
    }

    public final int getOverrideWidth() {
        return this.overrideWidth;
    }

    public final boolean isValidOverride() {
        return Util.isValidDimensions(this.overrideWidth, this.overrideHeight);
    }

    public final int getOverrideHeight() {
        return this.overrideHeight;
    }

    public final float getSizeMultiplier() {
        return this.sizeMultiplier;
    }

    boolean isScaleOnlyOrNoTransform() {
        return this.isScaleOnlyOrNoTransform;
    }

    private boolean isSet(int flag) {
        return BaseRequestOptions.isSet(this.fields, flag);
    }

    public final boolean getUseUnlimitedSourceGeneratorsPool() {
        return this.useUnlimitedSourceGeneratorsPool;
    }

    public final boolean getUseAnimationPool() {
        return this.useAnimationPool;
    }

    public final boolean getOnlyRetrieveFromCache() {
        return this.onlyRetrieveFromCache;
    }

    private T self() {
        return (T)this;
    }
}

