/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.graphics.Color;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.util.TypedValue;
import android.util.Xml;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.constraintlayout.core.motion.utils.Easing;
import androidx.constraintlayout.core.widgets.ConstraintWidget;
import androidx.constraintlayout.core.widgets.HelperWidget;
import androidx.constraintlayout.motion.widget.Debug;
import androidx.constraintlayout.motion.widget.MotionLayout;
import androidx.constraintlayout.motion.widget.MotionScene;
import androidx.constraintlayout.widget.Barrier;
import androidx.constraintlayout.widget.ConstraintAttribute;
import androidx.constraintlayout.widget.ConstraintHelper;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.constraintlayout.widget.Constraints;
import androidx.constraintlayout.widget.Guideline;
import androidx.constraintlayout.widget.R;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class ConstraintSet {
    private static final String TAG = "ConstraintSet";
    private static final String ERROR_MESSAGE = "XML parser error must be within a Constraint ";
    private static final int INTERNAL_MATCH_PARENT = -1;
    private static final int INTERNAL_WRAP_CONTENT = -2;
    private static final int INTERNAL_MATCH_CONSTRAINT = -3;
    private static final int INTERNAL_WRAP_CONTENT_CONSTRAINED = -4;
    private boolean mValidate;
    public String mIdString;
    public String derivedState = "";
    public static final int ROTATE_NONE = 0;
    public static final int ROTATE_PORTRATE_OF_RIGHT = 1;
    public static final int ROTATE_PORTRATE_OF_LEFT = 2;
    public static final int ROTATE_RIGHT_OF_PORTRATE = 3;
    public static final int ROTATE_LEFT_OF_PORTRATE = 4;
    public int mRotate = 0;
    private HashMap<String, ConstraintAttribute> mSavedAttributes = new HashMap();
    private boolean mForceId = true;
    public static final int UNSET = -1;
    public static final int MATCH_CONSTRAINT = 0;
    public static final int WRAP_CONTENT = -2;
    public static final int MATCH_CONSTRAINT_WRAP = 1;
    public static final int MATCH_CONSTRAINT_SPREAD = 0;
    public static final int MATCH_CONSTRAINT_PERCENT = 2;
    public static final int PARENT_ID = 0;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final int HORIZONTAL_GUIDELINE = 0;
    public static final int VERTICAL_GUIDELINE = 1;
    public static final int VISIBLE = 0;
    public static final int INVISIBLE = 4;
    public static final int GONE = 8;
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    public static final int TOP = 3;
    public static final int BOTTOM = 4;
    public static final int BASELINE = 5;
    public static final int START = 6;
    public static final int END = 7;
    public static final int CIRCLE_REFERENCE = 8;
    public static final int CHAIN_SPREAD = 0;
    public static final int CHAIN_SPREAD_INSIDE = 1;
    public static final int VISIBILITY_MODE_NORMAL = 0;
    public static final int VISIBILITY_MODE_IGNORE = 1;
    public static final int CHAIN_PACKED = 2;
    private static final boolean DEBUG = false;
    private static final int[] VISIBILITY_FLAGS = new int[]{0, 4, 8};
    private static final int BARRIER_TYPE = 1;
    private HashMap<Integer, Constraint> mConstraints = new HashMap();
    private static SparseIntArray mapToConstant = new SparseIntArray();
    private static SparseIntArray overrideMapToConstant = new SparseIntArray();
    private static final int BASELINE_TO_BASELINE = 1;
    private static final int BOTTOM_MARGIN = 2;
    private static final int BOTTOM_TO_BOTTOM = 3;
    private static final int BOTTOM_TO_TOP = 4;
    private static final int DIMENSION_RATIO = 5;
    private static final int EDITOR_ABSOLUTE_X = 6;
    private static final int EDITOR_ABSOLUTE_Y = 7;
    private static final int END_MARGIN = 8;
    private static final int END_TO_END = 9;
    private static final int END_TO_START = 10;
    private static final int GONE_BOTTOM_MARGIN = 11;
    private static final int GONE_END_MARGIN = 12;
    private static final int GONE_LEFT_MARGIN = 13;
    private static final int GONE_RIGHT_MARGIN = 14;
    private static final int GONE_START_MARGIN = 15;
    private static final int GONE_TOP_MARGIN = 16;
    private static final int GUIDE_BEGIN = 17;
    private static final int GUIDE_END = 18;
    private static final int GUIDE_PERCENT = 19;
    private static final int HORIZONTAL_BIAS = 20;
    private static final int LAYOUT_HEIGHT = 21;
    private static final int LAYOUT_VISIBILITY = 22;
    private static final int LAYOUT_WIDTH = 23;
    private static final int LEFT_MARGIN = 24;
    private static final int LEFT_TO_LEFT = 25;
    private static final int LEFT_TO_RIGHT = 26;
    private static final int ORIENTATION = 27;
    private static final int RIGHT_MARGIN = 28;
    private static final int RIGHT_TO_LEFT = 29;
    private static final int RIGHT_TO_RIGHT = 30;
    private static final int START_MARGIN = 31;
    private static final int START_TO_END = 32;
    private static final int START_TO_START = 33;
    private static final int TOP_MARGIN = 34;
    private static final int TOP_TO_BOTTOM = 35;
    private static final int TOP_TO_TOP = 36;
    private static final int VERTICAL_BIAS = 37;
    private static final int VIEW_ID = 38;
    private static final int HORIZONTAL_WEIGHT = 39;
    private static final int VERTICAL_WEIGHT = 40;
    private static final int HORIZONTAL_STYLE = 41;
    private static final int VERTICAL_STYLE = 42;
    private static final int ALPHA = 43;
    private static final int ELEVATION = 44;
    private static final int ROTATION_X = 45;
    private static final int ROTATION_Y = 46;
    private static final int SCALE_X = 47;
    private static final int SCALE_Y = 48;
    private static final int TRANSFORM_PIVOT_X = 49;
    private static final int TRANSFORM_PIVOT_Y = 50;
    private static final int TRANSLATION_X = 51;
    private static final int TRANSLATION_Y = 52;
    private static final int TRANSLATION_Z = 53;
    private static final int WIDTH_DEFAULT = 54;
    private static final int HEIGHT_DEFAULT = 55;
    private static final int WIDTH_MAX = 56;
    private static final int HEIGHT_MAX = 57;
    private static final int WIDTH_MIN = 58;
    private static final int HEIGHT_MIN = 59;
    private static final int ROTATION = 60;
    private static final int CIRCLE = 61;
    private static final int CIRCLE_RADIUS = 62;
    private static final int CIRCLE_ANGLE = 63;
    private static final int ANIMATE_RELATIVE_TO = 64;
    private static final int TRANSITION_EASING = 65;
    private static final int DRAW_PATH = 66;
    private static final int TRANSITION_PATH_ROTATE = 67;
    private static final int PROGRESS = 68;
    private static final int WIDTH_PERCENT = 69;
    private static final int HEIGHT_PERCENT = 70;
    private static final int CHAIN_USE_RTL = 71;
    private static final int BARRIER_DIRECTION = 72;
    private static final int BARRIER_MARGIN = 73;
    private static final int CONSTRAINT_REFERENCED_IDS = 74;
    private static final int BARRIER_ALLOWS_GONE_WIDGETS = 75;
    private static final int PATH_MOTION_ARC = 76;
    private static final int CONSTRAINT_TAG = 77;
    private static final int VISIBILITY_MODE = 78;
    private static final int MOTION_STAGGER = 79;
    private static final int CONSTRAINED_WIDTH = 80;
    private static final int CONSTRAINED_HEIGHT = 81;
    private static final int ANIMATE_CIRCLE_ANGLE_TO = 82;
    private static final int TRANSFORM_PIVOT_TARGET = 83;
    private static final int QUANTIZE_MOTION_STEPS = 84;
    private static final int QUANTIZE_MOTION_PHASE = 85;
    private static final int QUANTIZE_MOTION_INTERPOLATOR = 86;
    private static final int UNUSED = 87;
    private static final int QUANTIZE_MOTION_INTERPOLATOR_TYPE = 88;
    private static final int QUANTIZE_MOTION_INTERPOLATOR_ID = 89;
    private static final int QUANTIZE_MOTION_INTERPOLATOR_STR = 90;
    private static final int BASELINE_TO_TOP = 91;
    private static final int BASELINE_TO_BOTTOM = 92;
    private static final int BASELINE_MARGIN = 93;
    private static final int GONE_BASELINE_MARGIN = 94;
    private static final int LAYOUT_CONSTRAINT_WIDTH = 95;
    private static final int LAYOUT_CONSTRAINT_HEIGHT = 96;
    private static final int LAYOUT_WRAP_BEHAVIOR = 97;
    private static final int MOTION_TARGET = 98;
    private static final int GUIDELINE_USE_RTL = 99;
    private static final String KEY_WEIGHT = "weight";
    private static final String KEY_RATIO = "ratio";
    private static final String KEY_PERCENT_PARENT = "parent";

    public HashMap<String, ConstraintAttribute> getCustomAttributeSet() {
        return this.mSavedAttributes;
    }

    public Constraint getParameters(int mId) {
        return this.get(mId);
    }

    public void readFallback(ConstraintSet set) {
        for (Integer key : set.mConstraints.keySet()) {
            Constraint constraint;
            int id2 = key;
            Constraint parent = set.mConstraints.get(key);
            if (!this.mConstraints.containsKey(id2)) {
                this.mConstraints.put(id2, new Constraint());
            }
            if ((constraint = this.mConstraints.get(id2)) == null) continue;
            if (!constraint.layout.mApply) {
                constraint.layout.copyFrom(parent.layout);
            }
            if (!constraint.propertySet.mApply) {
                constraint.propertySet.copyFrom(parent.propertySet);
            }
            if (!constraint.transform.mApply) {
                constraint.transform.copyFrom(parent.transform);
            }
            if (!constraint.motion.mApply) {
                constraint.motion.copyFrom(parent.motion);
            }
            for (String s : parent.mCustomConstraints.keySet()) {
                if (constraint.mCustomConstraints.containsKey(s)) continue;
                constraint.mCustomConstraints.put(s, parent.mCustomConstraints.get(s));
            }
        }
    }

    public void readFallback(ConstraintLayout constraintLayout) {
        int count = constraintLayout.getChildCount();
        for (int i = 0; i < count; ++i) {
            Constraint constraint;
            View view = constraintLayout.getChildAt(i);
            ConstraintLayout.LayoutParams param = (ConstraintLayout.LayoutParams)view.getLayoutParams();
            int id2 = view.getId();
            if (this.mForceId && id2 == -1) {
                throw new RuntimeException("All children of ConstraintLayout must have ids to use ConstraintSet");
            }
            if (!this.mConstraints.containsKey(id2)) {
                this.mConstraints.put(id2, new Constraint());
            }
            if ((constraint = this.mConstraints.get(id2)) == null) continue;
            if (!constraint.layout.mApply) {
                constraint.fillFrom(id2, param);
                if (view instanceof ConstraintHelper) {
                    constraint.layout.mReferenceIds = ((ConstraintHelper)view).getReferencedIds();
                    if (view instanceof Barrier) {
                        Barrier barrier = (Barrier)view;
                        constraint.layout.mBarrierAllowsGoneWidgets = barrier.getAllowsGoneWidget();
                        constraint.layout.mBarrierDirection = barrier.getType();
                        constraint.layout.mBarrierMargin = barrier.getMargin();
                    }
                }
                constraint.layout.mApply = true;
            }
            if (!constraint.propertySet.mApply) {
                constraint.propertySet.visibility = view.getVisibility();
                constraint.propertySet.alpha = view.getAlpha();
                constraint.propertySet.mApply = true;
            }
            if (Build.VERSION.SDK_INT < 17 || constraint.transform.mApply) continue;
            constraint.transform.mApply = true;
            constraint.transform.rotation = view.getRotation();
            constraint.transform.rotationX = view.getRotationX();
            constraint.transform.rotationY = view.getRotationY();
            constraint.transform.scaleX = view.getScaleX();
            constraint.transform.scaleY = view.getScaleY();
            float pivotX = view.getPivotX();
            float pivotY = view.getPivotY();
            if ((double)pivotX != 0.0 || (double)pivotY != 0.0) {
                constraint.transform.transformPivotX = pivotX;
                constraint.transform.transformPivotY = pivotY;
            }
            constraint.transform.translationX = view.getTranslationX();
            constraint.transform.translationY = view.getTranslationY();
            if (Build.VERSION.SDK_INT < 21) continue;
            constraint.transform.translationZ = view.getTranslationZ();
            if (!constraint.transform.applyElevation) continue;
            constraint.transform.elevation = view.getElevation();
        }
    }

    public void applyDeltaFrom(ConstraintSet cs) {
        for (Constraint from : cs.mConstraints.values()) {
            if (from.mDelta == null) continue;
            if (from.mTargetString != null) {
                boolean count = false;
                for (int key : this.mConstraints.keySet()) {
                    Constraint potential = this.getConstraint(key);
                    if (potential.layout.mConstraintTag == null || !from.mTargetString.matches(potential.layout.mConstraintTag)) continue;
                    from.mDelta.applyDelta(potential);
                    potential.mCustomConstraints.putAll((HashMap)from.mCustomConstraints.clone());
                }
                continue;
            }
            Constraint constraint = this.getConstraint(from.mViewId);
            from.mDelta.applyDelta(constraint);
        }
    }

    static void parseDimensionConstraints(Object data, TypedArray a, int attr2, int orientation) {
        if (data == null) {
            return;
        }
        TypedValue v = a.peekValue(attr2);
        int type = v.type;
        int finalValue = 0;
        boolean finalConstrained = false;
        block0 : switch (type) {
            case 5: {
                finalValue = a.getDimensionPixelSize(attr2, 0);
                break;
            }
            case 3: {
                String value = a.getString(attr2);
                ConstraintSet.parseDimensionConstraintsString(data, value, orientation);
                return;
            }
            default: {
                int value = a.getInt(attr2, 0);
                switch (value) {
                    case -2: 
                    case -1: {
                        finalValue = value;
                        break block0;
                    }
                    case -3: {
                        finalValue = 0;
                        break block0;
                    }
                    case -4: {
                        finalValue = -2;
                        finalConstrained = true;
                    }
                }
            }
        }
        if (data instanceof ConstraintLayout.LayoutParams) {
            ConstraintLayout.LayoutParams params = (ConstraintLayout.LayoutParams)((Object)data);
            if (orientation == 0) {
                params.width = finalValue;
                params.constrainedWidth = finalConstrained;
            } else {
                params.height = finalValue;
                params.constrainedHeight = finalConstrained;
            }
        } else if (data instanceof Layout) {
            Layout params = (Layout)data;
            if (orientation == 0) {
                params.mWidth = finalValue;
                params.constrainedWidth = finalConstrained;
            } else {
                params.mHeight = finalValue;
                params.constrainedHeight = finalConstrained;
            }
        } else if (data instanceof Constraint.Delta) {
            Constraint.Delta params = (Constraint.Delta)data;
            if (orientation == 0) {
                params.add(23, finalValue);
                params.add(80, finalConstrained);
            } else {
                params.add(21, finalValue);
                params.add(81, finalConstrained);
            }
        }
    }

    static void parseDimensionRatioString(ConstraintLayout.LayoutParams params, String value) {
        int dimensionRatioSide;
        float dimensionRatioValue;
        String dimensionRatio;
        block15: {
            dimensionRatio = value;
            dimensionRatioValue = Float.NaN;
            dimensionRatioSide = -1;
            if (dimensionRatio != null) {
                int len = dimensionRatio.length();
                int commaIndex = dimensionRatio.indexOf(44);
                if (commaIndex > 0 && commaIndex < len - 1) {
                    String dimension = dimensionRatio.substring(0, commaIndex);
                    if (dimension.equalsIgnoreCase("W")) {
                        dimensionRatioSide = 0;
                    } else if (dimension.equalsIgnoreCase("H")) {
                        dimensionRatioSide = 1;
                    }
                    ++commaIndex;
                } else {
                    commaIndex = 0;
                }
                int colonIndex = dimensionRatio.indexOf(58);
                if (colonIndex >= 0 && colonIndex < len - 1) {
                    String nominator = dimensionRatio.substring(commaIndex, colonIndex);
                    String denominator = dimensionRatio.substring(colonIndex + 1);
                    if (nominator.length() > 0 && denominator.length() > 0) {
                        try {
                            float nominatorValue = Float.parseFloat(nominator);
                            float denominatorValue = Float.parseFloat(denominator);
                            if (!(nominatorValue > 0.0f) || !(denominatorValue > 0.0f)) break block15;
                            if (dimensionRatioSide == 1) {
                                dimensionRatioValue = Math.abs(denominatorValue / nominatorValue);
                                break block15;
                            }
                            dimensionRatioValue = Math.abs(nominatorValue / denominatorValue);
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                } else {
                    String r = dimensionRatio.substring(commaIndex);
                    if (r.length() > 0) {
                        try {
                            dimensionRatioValue = Float.parseFloat(r);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        params.dimensionRatio = dimensionRatio;
        params.dimensionRatioValue = dimensionRatioValue;
        params.dimensionRatioSide = dimensionRatioSide;
    }

    static void parseDimensionConstraintsString(Object data, String value, int orientation) {
        block37: {
            if (value == null) {
                return;
            }
            int equalIndex = value.indexOf(61);
            int len = value.length();
            if (equalIndex > 0 && equalIndex < len - 1) {
                String key = value.substring(0, equalIndex);
                String val = value.substring(equalIndex + 1);
                if (val.length() > 0) {
                    key = key.trim();
                    val = val.trim();
                    if (KEY_RATIO.equalsIgnoreCase(key)) {
                        if (data instanceof ConstraintLayout.LayoutParams) {
                            ConstraintLayout.LayoutParams params = (ConstraintLayout.LayoutParams)((Object)data);
                            if (orientation == 0) {
                                params.width = 0;
                            } else {
                                params.height = 0;
                            }
                            ConstraintSet.parseDimensionRatioString(params, val);
                        } else if (data instanceof Layout) {
                            Layout params = (Layout)data;
                            params.dimensionRatio = val;
                        } else if (data instanceof Constraint.Delta) {
                            Constraint.Delta params = (Constraint.Delta)data;
                            params.add(5, val);
                        }
                    } else if (KEY_WEIGHT.equalsIgnoreCase(key)) {
                        try {
                            float weight = Float.parseFloat(val);
                            if (data instanceof ConstraintLayout.LayoutParams) {
                                ConstraintLayout.LayoutParams params = (ConstraintLayout.LayoutParams)((Object)data);
                                if (orientation == 0) {
                                    params.width = 0;
                                    params.horizontalWeight = weight;
                                } else {
                                    params.height = 0;
                                    params.verticalWeight = weight;
                                }
                                break block37;
                            }
                            if (data instanceof Layout) {
                                Layout params = (Layout)data;
                                if (orientation == 0) {
                                    params.mWidth = 0;
                                    params.horizontalWeight = weight;
                                } else {
                                    params.mHeight = 0;
                                    params.verticalWeight = weight;
                                }
                                break block37;
                            }
                            if (!(data instanceof Constraint.Delta)) break block37;
                            Constraint.Delta params = (Constraint.Delta)data;
                            if (orientation == 0) {
                                params.add(23, 0);
                                params.add(39, weight);
                                break block37;
                            }
                            params.add(21, 0);
                            params.add(40, weight);
                        }
                        catch (NumberFormatException weight) {}
                    } else if (KEY_PERCENT_PARENT.equalsIgnoreCase(key)) {
                        try {
                            float percent = Math.min(1.0f, Float.parseFloat(val));
                            percent = Math.max(0.0f, percent);
                            if (data instanceof ConstraintLayout.LayoutParams) {
                                ConstraintLayout.LayoutParams params = (ConstraintLayout.LayoutParams)((Object)data);
                                if (orientation == 0) {
                                    params.width = 0;
                                    params.matchConstraintPercentWidth = percent;
                                    params.matchConstraintDefaultWidth = 2;
                                } else {
                                    params.height = 0;
                                    params.matchConstraintPercentHeight = percent;
                                    params.matchConstraintDefaultHeight = 2;
                                }
                            } else if (data instanceof Layout) {
                                Layout params = (Layout)data;
                                if (orientation == 0) {
                                    params.mWidth = 0;
                                    params.widthPercent = percent;
                                    params.widthDefault = 2;
                                } else {
                                    params.mHeight = 0;
                                    params.heightPercent = percent;
                                    params.heightDefault = 2;
                                }
                            } else if (data instanceof Constraint.Delta) {
                                Constraint.Delta params = (Constraint.Delta)data;
                                if (orientation == 0) {
                                    params.add(23, 0);
                                    params.add(54, 2);
                                } else {
                                    params.add(21, 0);
                                    params.add(55, 2);
                                }
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                }
            }
        }
    }

    public void clone(Context context, int constraintLayoutId) {
        this.clone((ConstraintLayout)LayoutInflater.from((Context)context).inflate(constraintLayoutId, null));
    }

    public void clone(ConstraintSet set) {
        this.mConstraints.clear();
        for (Integer key : set.mConstraints.keySet()) {
            Constraint constraint = set.mConstraints.get(key);
            if (constraint == null) continue;
            this.mConstraints.put(key, constraint.clone());
        }
    }

    public void clone(ConstraintLayout constraintLayout) {
        int count = constraintLayout.getChildCount();
        this.mConstraints.clear();
        for (int i = 0; i < count; ++i) {
            Constraint constraint;
            View view = constraintLayout.getChildAt(i);
            ConstraintLayout.LayoutParams param = (ConstraintLayout.LayoutParams)view.getLayoutParams();
            int id2 = view.getId();
            if (this.mForceId && id2 == -1) {
                throw new RuntimeException("All children of ConstraintLayout must have ids to use ConstraintSet");
            }
            if (!this.mConstraints.containsKey(id2)) {
                this.mConstraints.put(id2, new Constraint());
            }
            if ((constraint = this.mConstraints.get(id2)) == null) continue;
            constraint.mCustomConstraints = ConstraintAttribute.extractAttributes(this.mSavedAttributes, view);
            constraint.fillFrom(id2, param);
            constraint.propertySet.visibility = view.getVisibility();
            if (Build.VERSION.SDK_INT >= 17) {
                constraint.propertySet.alpha = view.getAlpha();
                constraint.transform.rotation = view.getRotation();
                constraint.transform.rotationX = view.getRotationX();
                constraint.transform.rotationY = view.getRotationY();
                constraint.transform.scaleX = view.getScaleX();
                constraint.transform.scaleY = view.getScaleY();
                float pivotX = view.getPivotX();
                float pivotY = view.getPivotY();
                if ((double)pivotX != 0.0 || (double)pivotY != 0.0) {
                    constraint.transform.transformPivotX = pivotX;
                    constraint.transform.transformPivotY = pivotY;
                }
                constraint.transform.translationX = view.getTranslationX();
                constraint.transform.translationY = view.getTranslationY();
                if (Build.VERSION.SDK_INT >= 21) {
                    constraint.transform.translationZ = view.getTranslationZ();
                    if (constraint.transform.applyElevation) {
                        constraint.transform.elevation = view.getElevation();
                    }
                }
            }
            if (!(view instanceof Barrier)) continue;
            Barrier barrier = (Barrier)view;
            constraint.layout.mBarrierAllowsGoneWidgets = barrier.getAllowsGoneWidget();
            constraint.layout.mReferenceIds = barrier.getReferencedIds();
            constraint.layout.mBarrierDirection = barrier.getType();
            constraint.layout.mBarrierMargin = barrier.getMargin();
        }
    }

    public void clone(Constraints constraints) {
        int count = constraints.getChildCount();
        this.mConstraints.clear();
        for (int i = 0; i < count; ++i) {
            Constraint constraint;
            View view = constraints.getChildAt(i);
            Constraints.LayoutParams param = (Constraints.LayoutParams)view.getLayoutParams();
            int id2 = view.getId();
            if (this.mForceId && id2 == -1) {
                throw new RuntimeException("All children of ConstraintLayout must have ids to use ConstraintSet");
            }
            if (!this.mConstraints.containsKey(id2)) {
                this.mConstraints.put(id2, new Constraint());
            }
            if ((constraint = this.mConstraints.get(id2)) == null) continue;
            if (view instanceof ConstraintHelper) {
                ConstraintHelper helper = (ConstraintHelper)view;
                constraint.fillFromConstraints(helper, id2, param);
            }
            constraint.fillFromConstraints(id2, param);
        }
    }

    public void applyTo(ConstraintLayout constraintLayout) {
        this.applyToInternal(constraintLayout, true);
        constraintLayout.setConstraintSet(null);
        constraintLayout.requestLayout();
    }

    public void applyToWithoutCustom(ConstraintLayout constraintLayout) {
        this.applyToInternal(constraintLayout, false);
        constraintLayout.setConstraintSet(null);
    }

    public void applyCustomAttributes(ConstraintLayout constraintLayout) {
        int count = constraintLayout.getChildCount();
        for (int i = 0; i < count; ++i) {
            Constraint constraint;
            View view = constraintLayout.getChildAt(i);
            int id2 = view.getId();
            if (!this.mConstraints.containsKey(id2)) {
                Log.w((String)TAG, (String)("id unknown " + Debug.getName(view)));
                continue;
            }
            if (this.mForceId && id2 == -1) {
                throw new RuntimeException("All children of ConstraintLayout must have ids to use ConstraintSet");
            }
            if (!this.mConstraints.containsKey(id2) || (constraint = this.mConstraints.get(id2)) == null) continue;
            ConstraintAttribute.setAttributes(view, constraint.mCustomConstraints);
        }
    }

    public void applyToHelper(ConstraintHelper helper, ConstraintWidget child, ConstraintLayout.LayoutParams layoutParams, SparseArray<ConstraintWidget> mapIdToWidget) {
        Constraint constraint;
        int id2 = helper.getId();
        if (this.mConstraints.containsKey(id2) && (constraint = this.mConstraints.get(id2)) != null && child instanceof HelperWidget) {
            HelperWidget helperWidget = (HelperWidget)child;
            helper.loadParameters(constraint, helperWidget, layoutParams, mapIdToWidget);
        }
    }

    public void applyToLayoutParams(int id2, ConstraintLayout.LayoutParams layoutParams) {
        Constraint constraint;
        if (this.mConstraints.containsKey(id2) && (constraint = this.mConstraints.get(id2)) != null) {
            constraint.applyTo(layoutParams);
        }
    }

    void applyToInternal(ConstraintLayout constraintLayout, boolean applyPostLayout) {
        ConstraintLayout.LayoutParams param;
        View view;
        int count = constraintLayout.getChildCount();
        HashSet<Integer> used = new HashSet<Integer>(this.mConstraints.keySet());
        for (int i = 0; i < count; ++i) {
            view = constraintLayout.getChildAt(i);
            int id2 = view.getId();
            if (!this.mConstraints.containsKey(id2)) {
                Log.w((String)TAG, (String)("id unknown " + Debug.getName(view)));
                continue;
            }
            if (this.mForceId && id2 == -1) {
                throw new RuntimeException("All children of ConstraintLayout must have ids to use ConstraintSet");
            }
            if (id2 == -1) continue;
            if (this.mConstraints.containsKey(id2)) {
                used.remove(id2);
                Constraint constraint = this.mConstraints.get(id2);
                if (constraint == null) continue;
                if (view instanceof Barrier) {
                    constraint.layout.mHelperType = 1;
                    Barrier barrier = (Barrier)view;
                    barrier.setId(id2);
                    barrier.setType(constraint.layout.mBarrierDirection);
                    barrier.setMargin(constraint.layout.mBarrierMargin);
                    barrier.setAllowsGoneWidget(constraint.layout.mBarrierAllowsGoneWidgets);
                    if (constraint.layout.mReferenceIds != null) {
                        barrier.setReferencedIds(constraint.layout.mReferenceIds);
                    } else if (constraint.layout.mReferenceIdString != null) {
                        constraint.layout.mReferenceIds = this.convertReferenceString(barrier, constraint.layout.mReferenceIdString);
                        barrier.setReferencedIds(constraint.layout.mReferenceIds);
                    }
                }
                param = (ConstraintLayout.LayoutParams)view.getLayoutParams();
                param.validate();
                constraint.applyTo(param);
                if (applyPostLayout) {
                    ConstraintAttribute.setAttributes(view, constraint.mCustomConstraints);
                }
                view.setLayoutParams((ViewGroup.LayoutParams)param);
                if (constraint.propertySet.mVisibilityMode == 0) {
                    view.setVisibility(constraint.propertySet.visibility);
                }
                if (Build.VERSION.SDK_INT < 17) continue;
                view.setAlpha(constraint.propertySet.alpha);
                view.setRotation(constraint.transform.rotation);
                view.setRotationX(constraint.transform.rotationX);
                view.setRotationY(constraint.transform.rotationY);
                view.setScaleX(constraint.transform.scaleX);
                view.setScaleY(constraint.transform.scaleY);
                if (constraint.transform.transformPivotTarget != -1) {
                    View layout = (View)view.getParent();
                    View center = layout.findViewById(constraint.transform.transformPivotTarget);
                    if (center != null) {
                        float cy = (float)(center.getTop() + center.getBottom()) / 2.0f;
                        float cx = (float)(center.getLeft() + center.getRight()) / 2.0f;
                        if (view.getRight() - view.getLeft() > 0 && view.getBottom() - view.getTop() > 0) {
                            float px = cx - (float)view.getLeft();
                            float py = cy - (float)view.getTop();
                            view.setPivotX(px);
                            view.setPivotY(py);
                        }
                    }
                } else {
                    if (!Float.isNaN(constraint.transform.transformPivotX)) {
                        view.setPivotX(constraint.transform.transformPivotX);
                    }
                    if (!Float.isNaN(constraint.transform.transformPivotY)) {
                        view.setPivotY(constraint.transform.transformPivotY);
                    }
                }
                view.setTranslationX(constraint.transform.translationX);
                view.setTranslationY(constraint.transform.translationY);
                if (Build.VERSION.SDK_INT < 21) continue;
                view.setTranslationZ(constraint.transform.translationZ);
                if (!constraint.transform.applyElevation) continue;
                view.setElevation(constraint.transform.elevation);
                continue;
            }
            Log.v((String)TAG, (String)("WARNING NO CONSTRAINTS for view " + id2));
        }
        for (Integer id3 : used) {
            Constraint constraint = this.mConstraints.get(id3);
            if (constraint == null) continue;
            if (constraint.layout.mHelperType == 1) {
                Barrier barrier = new Barrier(constraintLayout.getContext());
                barrier.setId(id3);
                if (constraint.layout.mReferenceIds != null) {
                    barrier.setReferencedIds(constraint.layout.mReferenceIds);
                } else if (constraint.layout.mReferenceIdString != null) {
                    constraint.layout.mReferenceIds = this.convertReferenceString(barrier, constraint.layout.mReferenceIdString);
                    barrier.setReferencedIds(constraint.layout.mReferenceIds);
                }
                barrier.setType(constraint.layout.mBarrierDirection);
                barrier.setMargin(constraint.layout.mBarrierMargin);
                param = constraintLayout.generateDefaultLayoutParams();
                barrier.validateParams();
                constraint.applyTo(param);
                constraintLayout.addView(barrier, (ViewGroup.LayoutParams)param);
            }
            if (!constraint.layout.mIsGuideline) continue;
            Guideline g = new Guideline(constraintLayout.getContext());
            g.setId(id3);
            param = constraintLayout.generateDefaultLayoutParams();
            constraint.applyTo(param);
            constraintLayout.addView(g, (ViewGroup.LayoutParams)param);
        }
        for (int i = 0; i < count; ++i) {
            view = constraintLayout.getChildAt(i);
            if (!(view instanceof ConstraintHelper)) continue;
            ConstraintHelper constraintHelper = (ConstraintHelper)view;
            constraintHelper.applyLayoutFeaturesInConstraintSet(constraintLayout);
        }
    }

    public void center(int centerID, int firstID, int firstSide, int firstMargin, int secondId, int secondSide, int secondMargin, float bias) {
        if (firstMargin < 0) {
            throw new IllegalArgumentException("margin must be > 0");
        }
        if (secondMargin < 0) {
            throw new IllegalArgumentException("margin must be > 0");
        }
        if (bias <= 0.0f || bias > 1.0f) {
            throw new IllegalArgumentException("bias must be between 0 and 1 inclusive");
        }
        if (firstSide == 1 || firstSide == 2) {
            this.connect(centerID, 1, firstID, firstSide, firstMargin);
            this.connect(centerID, 2, secondId, secondSide, secondMargin);
            Constraint constraint = this.mConstraints.get(centerID);
            if (constraint != null) {
                constraint.layout.horizontalBias = bias;
            }
        } else if (firstSide == 6 || firstSide == 7) {
            this.connect(centerID, 6, firstID, firstSide, firstMargin);
            this.connect(centerID, 7, secondId, secondSide, secondMargin);
            Constraint constraint = this.mConstraints.get(centerID);
            if (constraint != null) {
                constraint.layout.horizontalBias = bias;
            }
        } else {
            this.connect(centerID, 3, firstID, firstSide, firstMargin);
            this.connect(centerID, 4, secondId, secondSide, secondMargin);
            Constraint constraint = this.mConstraints.get(centerID);
            if (constraint != null) {
                constraint.layout.verticalBias = bias;
            }
        }
    }

    public void centerHorizontally(int centerID, int leftId, int leftSide, int leftMargin, int rightId, int rightSide, int rightMargin, float bias) {
        this.connect(centerID, 1, leftId, leftSide, leftMargin);
        this.connect(centerID, 2, rightId, rightSide, rightMargin);
        Constraint constraint = this.mConstraints.get(centerID);
        if (constraint != null) {
            constraint.layout.horizontalBias = bias;
        }
    }

    public void centerHorizontallyRtl(int centerID, int startId, int startSide, int startMargin, int endId, int endSide, int endMargin, float bias) {
        this.connect(centerID, 6, startId, startSide, startMargin);
        this.connect(centerID, 7, endId, endSide, endMargin);
        Constraint constraint = this.mConstraints.get(centerID);
        if (constraint != null) {
            constraint.layout.horizontalBias = bias;
        }
    }

    public void centerVertically(int centerID, int topId, int topSide, int topMargin, int bottomId, int bottomSide, int bottomMargin, float bias) {
        this.connect(centerID, 3, topId, topSide, topMargin);
        this.connect(centerID, 4, bottomId, bottomSide, bottomMargin);
        Constraint constraint = this.mConstraints.get(centerID);
        if (constraint != null) {
            constraint.layout.verticalBias = bias;
        }
    }

    public void createVerticalChain(int topId, int topSide, int bottomId, int bottomSide, int[] chainIds, float[] weights, int style) {
        if (chainIds.length < 2) {
            throw new IllegalArgumentException("must have 2 or more widgets in a chain");
        }
        if (weights != null && weights.length != chainIds.length) {
            throw new IllegalArgumentException("must have 2 or more widgets in a chain");
        }
        if (weights != null) {
            this.get((int)chainIds[0]).layout.verticalWeight = weights[0];
        }
        this.get((int)chainIds[0]).layout.verticalChainStyle = style;
        this.connect(chainIds[0], 3, topId, topSide, 0);
        for (int i = 1; i < chainIds.length; ++i) {
            int chainId = chainIds[i];
            this.connect(chainIds[i], 3, chainIds[i - 1], 4, 0);
            this.connect(chainIds[i - 1], 4, chainIds[i], 3, 0);
            if (weights == null) continue;
            this.get((int)chainIds[i]).layout.verticalWeight = weights[i];
        }
        this.connect(chainIds[chainIds.length - 1], 4, bottomId, bottomSide, 0);
    }

    public void createHorizontalChain(int leftId, int leftSide, int rightId, int rightSide, int[] chainIds, float[] weights, int style) {
        this.createHorizontalChain(leftId, leftSide, rightId, rightSide, chainIds, weights, style, 1, 2);
    }

    public void createHorizontalChainRtl(int startId, int startSide, int endId, int endSide, int[] chainIds, float[] weights, int style) {
        this.createHorizontalChain(startId, startSide, endId, endSide, chainIds, weights, style, 6, 7);
    }

    private void createHorizontalChain(int leftId, int leftSide, int rightId, int rightSide, int[] chainIds, float[] weights, int style, int left, int right) {
        if (chainIds.length < 2) {
            throw new IllegalArgumentException("must have 2 or more widgets in a chain");
        }
        if (weights != null && weights.length != chainIds.length) {
            throw new IllegalArgumentException("must have 2 or more widgets in a chain");
        }
        if (weights != null) {
            this.get((int)chainIds[0]).layout.horizontalWeight = weights[0];
        }
        this.get((int)chainIds[0]).layout.horizontalChainStyle = style;
        this.connect(chainIds[0], left, leftId, leftSide, -1);
        for (int i = 1; i < chainIds.length; ++i) {
            int chainId = chainIds[i];
            this.connect(chainIds[i], left, chainIds[i - 1], right, -1);
            this.connect(chainIds[i - 1], right, chainIds[i], left, -1);
            if (weights == null) continue;
            this.get((int)chainIds[i]).layout.horizontalWeight = weights[i];
        }
        this.connect(chainIds[chainIds.length - 1], right, rightId, rightSide, -1);
    }

    public void connect(int startID, int startSide, int endID, int endSide, int margin) {
        Constraint constraint;
        if (!this.mConstraints.containsKey(startID)) {
            this.mConstraints.put(startID, new Constraint());
        }
        if ((constraint = this.mConstraints.get(startID)) == null) {
            return;
        }
        switch (startSide) {
            case 1: {
                if (endSide == 1) {
                    constraint.layout.leftToLeft = endID;
                    constraint.layout.leftToRight = -1;
                } else if (endSide == 2) {
                    constraint.layout.leftToRight = endID;
                    constraint.layout.leftToLeft = -1;
                } else {
                    throw new IllegalArgumentException("Left to " + this.sideToString(endSide) + " undefined");
                }
                constraint.layout.leftMargin = margin;
                break;
            }
            case 2: {
                if (endSide == 1) {
                    constraint.layout.rightToLeft = endID;
                    constraint.layout.rightToRight = -1;
                } else if (endSide == 2) {
                    constraint.layout.rightToRight = endID;
                    constraint.layout.rightToLeft = -1;
                } else {
                    throw new IllegalArgumentException("right to " + this.sideToString(endSide) + " undefined");
                }
                constraint.layout.rightMargin = margin;
                break;
            }
            case 3: {
                if (endSide == 3) {
                    constraint.layout.topToTop = endID;
                    constraint.layout.topToBottom = -1;
                    constraint.layout.baselineToBaseline = -1;
                    constraint.layout.baselineToTop = -1;
                    constraint.layout.baselineToBottom = -1;
                } else if (endSide == 4) {
                    constraint.layout.topToBottom = endID;
                    constraint.layout.topToTop = -1;
                    constraint.layout.baselineToBaseline = -1;
                    constraint.layout.baselineToTop = -1;
                    constraint.layout.baselineToBottom = -1;
                } else {
                    throw new IllegalArgumentException("right to " + this.sideToString(endSide) + " undefined");
                }
                constraint.layout.topMargin = margin;
                break;
            }
            case 4: {
                if (endSide == 4) {
                    constraint.layout.bottomToBottom = endID;
                    constraint.layout.bottomToTop = -1;
                    constraint.layout.baselineToBaseline = -1;
                    constraint.layout.baselineToTop = -1;
                    constraint.layout.baselineToBottom = -1;
                } else if (endSide == 3) {
                    constraint.layout.bottomToTop = endID;
                    constraint.layout.bottomToBottom = -1;
                    constraint.layout.baselineToBaseline = -1;
                    constraint.layout.baselineToTop = -1;
                    constraint.layout.baselineToBottom = -1;
                } else {
                    throw new IllegalArgumentException("right to " + this.sideToString(endSide) + " undefined");
                }
                constraint.layout.bottomMargin = margin;
                break;
            }
            case 5: {
                if (endSide == 5) {
                    constraint.layout.baselineToBaseline = endID;
                    constraint.layout.bottomToBottom = -1;
                    constraint.layout.bottomToTop = -1;
                    constraint.layout.topToTop = -1;
                    constraint.layout.topToBottom = -1;
                    break;
                }
                if (endSide == 3) {
                    constraint.layout.baselineToTop = endID;
                    constraint.layout.bottomToBottom = -1;
                    constraint.layout.bottomToTop = -1;
                    constraint.layout.topToTop = -1;
                    constraint.layout.topToBottom = -1;
                    break;
                }
                if (endSide == 4) {
                    constraint.layout.baselineToBottom = endID;
                    constraint.layout.bottomToBottom = -1;
                    constraint.layout.bottomToTop = -1;
                    constraint.layout.topToTop = -1;
                    constraint.layout.topToBottom = -1;
                    break;
                }
                throw new IllegalArgumentException("right to " + this.sideToString(endSide) + " undefined");
            }
            case 6: {
                if (endSide == 6) {
                    constraint.layout.startToStart = endID;
                    constraint.layout.startToEnd = -1;
                } else if (endSide == 7) {
                    constraint.layout.startToEnd = endID;
                    constraint.layout.startToStart = -1;
                } else {
                    throw new IllegalArgumentException("right to " + this.sideToString(endSide) + " undefined");
                }
                constraint.layout.startMargin = margin;
                break;
            }
            case 7: {
                if (endSide == 7) {
                    constraint.layout.endToEnd = endID;
                    constraint.layout.endToStart = -1;
                } else if (endSide == 6) {
                    constraint.layout.endToStart = endID;
                    constraint.layout.endToEnd = -1;
                } else {
                    throw new IllegalArgumentException("right to " + this.sideToString(endSide) + " undefined");
                }
                constraint.layout.endMargin = margin;
                break;
            }
            default: {
                throw new IllegalArgumentException(this.sideToString(startSide) + " to " + this.sideToString(endSide) + " unknown");
            }
        }
    }

    public void connect(int startID, int startSide, int endID, int endSide) {
        Constraint constraint;
        if (!this.mConstraints.containsKey(startID)) {
            this.mConstraints.put(startID, new Constraint());
        }
        if ((constraint = this.mConstraints.get(startID)) == null) {
            return;
        }
        switch (startSide) {
            case 1: {
                if (endSide == 1) {
                    constraint.layout.leftToLeft = endID;
                    constraint.layout.leftToRight = -1;
                    break;
                }
                if (endSide == 2) {
                    constraint.layout.leftToRight = endID;
                    constraint.layout.leftToLeft = -1;
                    break;
                }
                throw new IllegalArgumentException("left to " + this.sideToString(endSide) + " undefined");
            }
            case 2: {
                if (endSide == 1) {
                    constraint.layout.rightToLeft = endID;
                    constraint.layout.rightToRight = -1;
                    break;
                }
                if (endSide == 2) {
                    constraint.layout.rightToRight = endID;
                    constraint.layout.rightToLeft = -1;
                    break;
                }
                throw new IllegalArgumentException("right to " + this.sideToString(endSide) + " undefined");
            }
            case 3: {
                if (endSide == 3) {
                    constraint.layout.topToTop = endID;
                    constraint.layout.topToBottom = -1;
                    constraint.layout.baselineToBaseline = -1;
                    constraint.layout.baselineToTop = -1;
                    constraint.layout.baselineToBottom = -1;
                    break;
                }
                if (endSide == 4) {
                    constraint.layout.topToBottom = endID;
                    constraint.layout.topToTop = -1;
                    constraint.layout.baselineToBaseline = -1;
                    constraint.layout.baselineToTop = -1;
                    constraint.layout.baselineToBottom = -1;
                    break;
                }
                throw new IllegalArgumentException("right to " + this.sideToString(endSide) + " undefined");
            }
            case 4: {
                if (endSide == 4) {
                    constraint.layout.bottomToBottom = endID;
                    constraint.layout.bottomToTop = -1;
                    constraint.layout.baselineToBaseline = -1;
                    constraint.layout.baselineToTop = -1;
                    constraint.layout.baselineToBottom = -1;
                    break;
                }
                if (endSide == 3) {
                    constraint.layout.bottomToTop = endID;
                    constraint.layout.bottomToBottom = -1;
                    constraint.layout.baselineToBaseline = -1;
                    constraint.layout.baselineToTop = -1;
                    constraint.layout.baselineToBottom = -1;
                    break;
                }
                throw new IllegalArgumentException("right to " + this.sideToString(endSide) + " undefined");
            }
            case 5: {
                if (endSide == 5) {
                    constraint.layout.baselineToBaseline = endID;
                    constraint.layout.bottomToBottom = -1;
                    constraint.layout.bottomToTop = -1;
                    constraint.layout.topToTop = -1;
                    constraint.layout.topToBottom = -1;
                    break;
                }
                if (endSide == 3) {
                    constraint.layout.baselineToTop = endID;
                    constraint.layout.bottomToBottom = -1;
                    constraint.layout.bottomToTop = -1;
                    constraint.layout.topToTop = -1;
                    constraint.layout.topToBottom = -1;
                    break;
                }
                if (endSide == 4) {
                    constraint.layout.baselineToBottom = endID;
                    constraint.layout.bottomToBottom = -1;
                    constraint.layout.bottomToTop = -1;
                    constraint.layout.topToTop = -1;
                    constraint.layout.topToBottom = -1;
                    break;
                }
                throw new IllegalArgumentException("right to " + this.sideToString(endSide) + " undefined");
            }
            case 6: {
                if (endSide == 6) {
                    constraint.layout.startToStart = endID;
                    constraint.layout.startToEnd = -1;
                    break;
                }
                if (endSide == 7) {
                    constraint.layout.startToEnd = endID;
                    constraint.layout.startToStart = -1;
                    break;
                }
                throw new IllegalArgumentException("right to " + this.sideToString(endSide) + " undefined");
            }
            case 7: {
                if (endSide == 7) {
                    constraint.layout.endToEnd = endID;
                    constraint.layout.endToStart = -1;
                    break;
                }
                if (endSide == 6) {
                    constraint.layout.endToStart = endID;
                    constraint.layout.endToEnd = -1;
                    break;
                }
                throw new IllegalArgumentException("right to " + this.sideToString(endSide) + " undefined");
            }
            default: {
                throw new IllegalArgumentException(this.sideToString(startSide) + " to " + this.sideToString(endSide) + " unknown");
            }
        }
    }

    public void centerHorizontally(int viewId, int toView) {
        if (toView == 0) {
            this.center(viewId, 0, 1, 0, 0, 2, 0, 0.5f);
        } else {
            this.center(viewId, toView, 2, 0, toView, 1, 0, 0.5f);
        }
    }

    public void centerHorizontallyRtl(int viewId, int toView) {
        if (toView == 0) {
            this.center(viewId, 0, 6, 0, 0, 7, 0, 0.5f);
        } else {
            this.center(viewId, toView, 7, 0, toView, 6, 0, 0.5f);
        }
    }

    public void centerVertically(int viewId, int toView) {
        if (toView == 0) {
            this.center(viewId, 0, 3, 0, 0, 4, 0, 0.5f);
        } else {
            this.center(viewId, toView, 4, 0, toView, 3, 0, 0.5f);
        }
    }

    public void clear(int viewId) {
        this.mConstraints.remove(viewId);
    }

    public void clear(int viewId, int anchor) {
        if (this.mConstraints.containsKey(viewId)) {
            Constraint constraint = this.mConstraints.get(viewId);
            if (constraint == null) {
                return;
            }
            switch (anchor) {
                case 1: {
                    constraint.layout.leftToRight = -1;
                    constraint.layout.leftToLeft = -1;
                    constraint.layout.leftMargin = -1;
                    constraint.layout.goneLeftMargin = Integer.MIN_VALUE;
                    break;
                }
                case 2: {
                    constraint.layout.rightToRight = -1;
                    constraint.layout.rightToLeft = -1;
                    constraint.layout.rightMargin = -1;
                    constraint.layout.goneRightMargin = Integer.MIN_VALUE;
                    break;
                }
                case 3: {
                    constraint.layout.topToBottom = -1;
                    constraint.layout.topToTop = -1;
                    constraint.layout.topMargin = 0;
                    constraint.layout.goneTopMargin = Integer.MIN_VALUE;
                    break;
                }
                case 4: {
                    constraint.layout.bottomToTop = -1;
                    constraint.layout.bottomToBottom = -1;
                    constraint.layout.bottomMargin = 0;
                    constraint.layout.goneBottomMargin = Integer.MIN_VALUE;
                    break;
                }
                case 5: {
                    constraint.layout.baselineToBaseline = -1;
                    constraint.layout.baselineToTop = -1;
                    constraint.layout.baselineToBottom = -1;
                    constraint.layout.baselineMargin = 0;
                    constraint.layout.goneBaselineMargin = Integer.MIN_VALUE;
                    break;
                }
                case 6: {
                    constraint.layout.startToEnd = -1;
                    constraint.layout.startToStart = -1;
                    constraint.layout.startMargin = 0;
                    constraint.layout.goneStartMargin = Integer.MIN_VALUE;
                    break;
                }
                case 7: {
                    constraint.layout.endToStart = -1;
                    constraint.layout.endToEnd = -1;
                    constraint.layout.endMargin = 0;
                    constraint.layout.goneEndMargin = Integer.MIN_VALUE;
                    break;
                }
                case 8: {
                    constraint.layout.circleAngle = -1.0f;
                    constraint.layout.circleRadius = -1;
                    constraint.layout.circleConstraint = -1;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown constraint");
                }
            }
        }
    }

    public void setMargin(int viewId, int anchor, int value) {
        Constraint constraint = this.get(viewId);
        switch (anchor) {
            case 1: {
                constraint.layout.leftMargin = value;
                break;
            }
            case 2: {
                constraint.layout.rightMargin = value;
                break;
            }
            case 3: {
                constraint.layout.topMargin = value;
                break;
            }
            case 4: {
                constraint.layout.bottomMargin = value;
                break;
            }
            case 5: {
                constraint.layout.baselineMargin = value;
                break;
            }
            case 6: {
                constraint.layout.startMargin = value;
                break;
            }
            case 7: {
                constraint.layout.endMargin = value;
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown constraint");
            }
        }
    }

    public void setGoneMargin(int viewId, int anchor, int value) {
        Constraint constraint = this.get(viewId);
        switch (anchor) {
            case 1: {
                constraint.layout.goneLeftMargin = value;
                break;
            }
            case 2: {
                constraint.layout.goneRightMargin = value;
                break;
            }
            case 3: {
                constraint.layout.goneTopMargin = value;
                break;
            }
            case 4: {
                constraint.layout.goneBottomMargin = value;
                break;
            }
            case 5: {
                constraint.layout.goneBaselineMargin = value;
                break;
            }
            case 6: {
                constraint.layout.goneStartMargin = value;
                break;
            }
            case 7: {
                constraint.layout.goneEndMargin = value;
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown constraint");
            }
        }
    }

    public void setHorizontalBias(int viewId, float bias) {
        this.get((int)viewId).layout.horizontalBias = bias;
    }

    public void setVerticalBias(int viewId, float bias) {
        this.get((int)viewId).layout.verticalBias = bias;
    }

    public void setDimensionRatio(int viewId, String ratio) {
        this.get((int)viewId).layout.dimensionRatio = ratio;
    }

    public void setVisibility(int viewId, int visibility) {
        this.get((int)viewId).propertySet.visibility = visibility;
    }

    public void setVisibilityMode(int viewId, int visibilityMode) {
        this.get((int)viewId).propertySet.mVisibilityMode = visibilityMode;
    }

    public int getVisibilityMode(int viewId) {
        return this.get((int)viewId).propertySet.mVisibilityMode;
    }

    public int getVisibility(int viewId) {
        return this.get((int)viewId).propertySet.visibility;
    }

    public int getHeight(int viewId) {
        return this.get((int)viewId).layout.mHeight;
    }

    public int getWidth(int viewId) {
        return this.get((int)viewId).layout.mWidth;
    }

    public void setAlpha(int viewId, float alpha) {
        this.get((int)viewId).propertySet.alpha = alpha;
    }

    public boolean getApplyElevation(int viewId) {
        return this.get((int)viewId).transform.applyElevation;
    }

    public void setApplyElevation(int viewId, boolean apply) {
        if (Build.VERSION.SDK_INT >= 21) {
            this.get((int)viewId).transform.applyElevation = apply;
        }
    }

    public void setElevation(int viewId, float elevation) {
        if (Build.VERSION.SDK_INT >= 21) {
            this.get((int)viewId).transform.elevation = elevation;
            this.get((int)viewId).transform.applyElevation = true;
        }
    }

    public void setRotation(int viewId, float rotation) {
        this.get((int)viewId).transform.rotation = rotation;
    }

    public void setRotationX(int viewId, float rotationX) {
        this.get((int)viewId).transform.rotationX = rotationX;
    }

    public void setRotationY(int viewId, float rotationY) {
        this.get((int)viewId).transform.rotationY = rotationY;
    }

    public void setScaleX(int viewId, float scaleX) {
        this.get((int)viewId).transform.scaleX = scaleX;
    }

    public void setScaleY(int viewId, float scaleY) {
        this.get((int)viewId).transform.scaleY = scaleY;
    }

    public void setTransformPivotX(int viewId, float transformPivotX) {
        this.get((int)viewId).transform.transformPivotX = transformPivotX;
    }

    public void setTransformPivotY(int viewId, float transformPivotY) {
        this.get((int)viewId).transform.transformPivotY = transformPivotY;
    }

    public void setTransformPivot(int viewId, float transformPivotX, float transformPivotY) {
        Constraint constraint = this.get(viewId);
        constraint.transform.transformPivotY = transformPivotY;
        constraint.transform.transformPivotX = transformPivotX;
    }

    public void setTranslationX(int viewId, float translationX) {
        this.get((int)viewId).transform.translationX = translationX;
    }

    public void setTranslationY(int viewId, float translationY) {
        this.get((int)viewId).transform.translationY = translationY;
    }

    public void setTranslation(int viewId, float translationX, float translationY) {
        Constraint constraint = this.get(viewId);
        constraint.transform.translationX = translationX;
        constraint.transform.translationY = translationY;
    }

    public void setTranslationZ(int viewId, float translationZ) {
        if (Build.VERSION.SDK_INT >= 21) {
            this.get((int)viewId).transform.translationZ = translationZ;
        }
    }

    public void setEditorAbsoluteX(int viewId, int position) {
        this.get((int)viewId).layout.editorAbsoluteX = position;
    }

    public void setEditorAbsoluteY(int viewId, int position) {
        this.get((int)viewId).layout.editorAbsoluteY = position;
    }

    public void setLayoutWrapBehavior(int viewId, int behavior) {
        if (behavior >= 0 && behavior <= 3) {
            this.get((int)viewId).layout.mWrapBehavior = behavior;
        }
    }

    public void constrainHeight(int viewId, int height) {
        this.get((int)viewId).layout.mHeight = height;
    }

    public void constrainWidth(int viewId, int width) {
        this.get((int)viewId).layout.mWidth = width;
    }

    public void constrainCircle(int viewId, int id2, int radius, float angle) {
        Constraint constraint = this.get(viewId);
        constraint.layout.circleConstraint = id2;
        constraint.layout.circleRadius = radius;
        constraint.layout.circleAngle = angle;
    }

    public void constrainMaxHeight(int viewId, int height) {
        this.get((int)viewId).layout.heightMax = height;
    }

    public void constrainMaxWidth(int viewId, int width) {
        this.get((int)viewId).layout.widthMax = width;
    }

    public void constrainMinHeight(int viewId, int height) {
        this.get((int)viewId).layout.heightMin = height;
    }

    public void constrainMinWidth(int viewId, int width) {
        this.get((int)viewId).layout.widthMin = width;
    }

    public void constrainPercentWidth(int viewId, float percent) {
        this.get((int)viewId).layout.widthPercent = percent;
    }

    public void constrainPercentHeight(int viewId, float percent) {
        this.get((int)viewId).layout.heightPercent = percent;
    }

    public void constrainDefaultHeight(int viewId, int height) {
        this.get((int)viewId).layout.heightDefault = height;
    }

    public void constrainedWidth(int viewId, boolean constrained) {
        this.get((int)viewId).layout.constrainedWidth = constrained;
    }

    public void constrainedHeight(int viewId, boolean constrained) {
        this.get((int)viewId).layout.constrainedHeight = constrained;
    }

    public void constrainDefaultWidth(int viewId, int width) {
        this.get((int)viewId).layout.widthDefault = width;
    }

    public void setHorizontalWeight(int viewId, float weight) {
        this.get((int)viewId).layout.horizontalWeight = weight;
    }

    public void setVerticalWeight(int viewId, float weight) {
        this.get((int)viewId).layout.verticalWeight = weight;
    }

    public void setHorizontalChainStyle(int viewId, int chainStyle) {
        this.get((int)viewId).layout.horizontalChainStyle = chainStyle;
    }

    public void setVerticalChainStyle(int viewId, int chainStyle) {
        this.get((int)viewId).layout.verticalChainStyle = chainStyle;
    }

    public void addToHorizontalChain(int viewId, int leftId, int rightId) {
        this.connect(viewId, 1, leftId, leftId == 0 ? 1 : 2, 0);
        this.connect(viewId, 2, rightId, rightId == 0 ? 2 : 1, 0);
        if (leftId != 0) {
            this.connect(leftId, 2, viewId, 1, 0);
        }
        if (rightId != 0) {
            this.connect(rightId, 1, viewId, 2, 0);
        }
    }

    public void addToHorizontalChainRTL(int viewId, int leftId, int rightId) {
        this.connect(viewId, 6, leftId, leftId == 0 ? 6 : 7, 0);
        this.connect(viewId, 7, rightId, rightId == 0 ? 7 : 6, 0);
        if (leftId != 0) {
            this.connect(leftId, 7, viewId, 6, 0);
        }
        if (rightId != 0) {
            this.connect(rightId, 6, viewId, 7, 0);
        }
    }

    public void addToVerticalChain(int viewId, int topId, int bottomId) {
        this.connect(viewId, 3, topId, topId == 0 ? 3 : 4, 0);
        this.connect(viewId, 4, bottomId, bottomId == 0 ? 4 : 3, 0);
        if (topId != 0) {
            this.connect(topId, 4, viewId, 3, 0);
        }
        if (bottomId != 0) {
            this.connect(bottomId, 3, viewId, 4, 0);
        }
    }

    public void removeFromVerticalChain(int viewId) {
        if (this.mConstraints.containsKey(viewId)) {
            Constraint constraint = this.mConstraints.get(viewId);
            if (constraint == null) {
                return;
            }
            int topId = constraint.layout.topToBottom;
            int bottomId = constraint.layout.bottomToTop;
            if (topId != -1 || bottomId != -1) {
                if (topId != -1 && bottomId != -1) {
                    this.connect(topId, 4, bottomId, 3, 0);
                    this.connect(bottomId, 3, topId, 4, 0);
                } else if (constraint.layout.bottomToBottom != -1) {
                    this.connect(topId, 4, constraint.layout.bottomToBottom, 4, 0);
                } else if (constraint.layout.topToTop != -1) {
                    this.connect(bottomId, 3, constraint.layout.topToTop, 3, 0);
                }
            }
        }
        this.clear(viewId, 3);
        this.clear(viewId, 4);
    }

    public void removeFromHorizontalChain(int viewId) {
        if (this.mConstraints.containsKey(viewId)) {
            Constraint constraint = this.mConstraints.get(viewId);
            if (constraint == null) {
                return;
            }
            int leftId = constraint.layout.leftToRight;
            int rightId = constraint.layout.rightToLeft;
            if (leftId != -1 || rightId != -1) {
                if (leftId != -1 && rightId != -1) {
                    this.connect(leftId, 2, rightId, 1, 0);
                    this.connect(rightId, 1, leftId, 2, 0);
                } else if (constraint.layout.rightToRight != -1) {
                    this.connect(leftId, 2, constraint.layout.rightToRight, 2, 0);
                } else if (constraint.layout.leftToLeft != -1) {
                    this.connect(rightId, 1, constraint.layout.leftToLeft, 1, 0);
                }
                this.clear(viewId, 1);
                this.clear(viewId, 2);
            } else {
                int startId = constraint.layout.startToEnd;
                int endId = constraint.layout.endToStart;
                if (startId != -1 || endId != -1) {
                    if (startId != -1 && endId != -1) {
                        this.connect(startId, 7, endId, 6, 0);
                        this.connect(endId, 6, leftId, 7, 0);
                    } else if (endId != -1) {
                        if (constraint.layout.rightToRight != -1) {
                            this.connect(leftId, 7, constraint.layout.rightToRight, 7, 0);
                        } else if (constraint.layout.leftToLeft != -1) {
                            this.connect(endId, 6, constraint.layout.leftToLeft, 6, 0);
                        }
                    }
                }
                this.clear(viewId, 6);
                this.clear(viewId, 7);
            }
        }
    }

    public void create(int guidelineID, int orientation) {
        Constraint constraint = this.get(guidelineID);
        constraint.layout.mIsGuideline = true;
        constraint.layout.orientation = orientation;
    }

    public void createBarrier(int id2, int direction, int margin, int ... referenced) {
        Constraint constraint = this.get(id2);
        constraint.layout.mHelperType = 1;
        constraint.layout.mBarrierDirection = direction;
        constraint.layout.mBarrierMargin = margin;
        constraint.layout.mIsGuideline = false;
        constraint.layout.mReferenceIds = referenced;
    }

    public void setGuidelineBegin(int guidelineID, int margin) {
        this.get((int)guidelineID).layout.guideBegin = margin;
        this.get((int)guidelineID).layout.guideEnd = -1;
        this.get((int)guidelineID).layout.guidePercent = -1.0f;
    }

    public void setGuidelineEnd(int guidelineID, int margin) {
        this.get((int)guidelineID).layout.guideEnd = margin;
        this.get((int)guidelineID).layout.guideBegin = -1;
        this.get((int)guidelineID).layout.guidePercent = -1.0f;
    }

    public void setGuidelinePercent(int guidelineID, float ratio) {
        this.get((int)guidelineID).layout.guidePercent = ratio;
        this.get((int)guidelineID).layout.guideEnd = -1;
        this.get((int)guidelineID).layout.guideBegin = -1;
    }

    public int[] getReferencedIds(int id2) {
        Constraint constraint = this.get(id2);
        if (constraint.layout.mReferenceIds == null) {
            return new int[0];
        }
        return Arrays.copyOf(constraint.layout.mReferenceIds, constraint.layout.mReferenceIds.length);
    }

    public void setReferencedIds(int id2, int ... referenced) {
        Constraint constraint = this.get(id2);
        constraint.layout.mReferenceIds = referenced;
    }

    public void setBarrierType(int id2, int type) {
        Constraint constraint = this.get(id2);
        constraint.layout.mHelperType = type;
    }

    public void removeAttribute(String attributeName) {
        this.mSavedAttributes.remove(attributeName);
    }

    public void setIntValue(int viewId, String attributeName, int value) {
        this.get(viewId).setIntValue(attributeName, value);
    }

    public void setColorValue(int viewId, String attributeName, int value) {
        this.get(viewId).setColorValue(attributeName, value);
    }

    public void setFloatValue(int viewId, String attributeName, float value) {
        this.get(viewId).setFloatValue(attributeName, value);
    }

    public void setStringValue(int viewId, String attributeName, String value) {
        this.get(viewId).setStringValue(attributeName, value);
    }

    private void addAttributes(ConstraintAttribute.AttributeType attributeType, String ... attributeName) {
        ConstraintAttribute constraintAttribute = null;
        for (int i = 0; i < attributeName.length; ++i) {
            if (this.mSavedAttributes.containsKey(attributeName[i])) {
                constraintAttribute = this.mSavedAttributes.get(attributeName[i]);
                if (constraintAttribute == null || constraintAttribute.getType() == attributeType) continue;
                throw new IllegalArgumentException("ConstraintAttribute is already a " + constraintAttribute.getType().name());
            }
            constraintAttribute = new ConstraintAttribute(attributeName[i], attributeType);
            this.mSavedAttributes.put(attributeName[i], constraintAttribute);
        }
    }

    public void parseIntAttributes(Constraint set, String attributes) {
        String[] sp = attributes.split(",");
        for (int i = 0; i < sp.length; ++i) {
            String[] attr2 = sp[i].split("=");
            if (attr2.length != 2) {
                Log.w((String)TAG, (String)(" Unable to parse " + sp[i]));
                continue;
            }
            set.setFloatValue(attr2[0], Integer.decode(attr2[1]).intValue());
        }
    }

    public void parseColorAttributes(Constraint set, String attributes) {
        String[] sp = attributes.split(",");
        for (int i = 0; i < sp.length; ++i) {
            String[] attr2 = sp[i].split("=");
            if (attr2.length != 2) {
                Log.w((String)TAG, (String)(" Unable to parse " + sp[i]));
                continue;
            }
            set.setColorValue(attr2[0], Color.parseColor((String)attr2[1]));
        }
    }

    public void parseFloatAttributes(Constraint set, String attributes) {
        String[] sp = attributes.split(",");
        for (int i = 0; i < sp.length; ++i) {
            String[] attr2 = sp[i].split("=");
            if (attr2.length != 2) {
                Log.w((String)TAG, (String)(" Unable to parse " + sp[i]));
                continue;
            }
            set.setFloatValue(attr2[0], Float.parseFloat(attr2[1]));
        }
    }

    public void parseStringAttributes(Constraint set, String attributes) {
        String[] sp = ConstraintSet.splitString(attributes);
        for (int i = 0; i < sp.length; ++i) {
            String[] attr2 = sp[i].split("=");
            Log.w((String)TAG, (String)(" Unable to parse " + sp[i]));
            set.setStringValue(attr2[0], attr2[1]);
        }
    }

    private static String[] splitString(String str) {
        char[] chars = str.toCharArray();
        ArrayList<String> list = new ArrayList<String>();
        boolean inDouble = false;
        int start = 0;
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == ',' && !inDouble) {
                list.add(new String(chars, start, i - start));
                start = i + 1;
                continue;
            }
            if (chars[i] != '\"') continue;
            inDouble = !inDouble;
        }
        list.add(new String(chars, start, chars.length - start));
        return list.toArray(new String[list.size()]);
    }

    public void addIntAttributes(String ... attributeName) {
        this.addAttributes(ConstraintAttribute.AttributeType.INT_TYPE, attributeName);
    }

    public void addColorAttributes(String ... attributeName) {
        this.addAttributes(ConstraintAttribute.AttributeType.COLOR_TYPE, attributeName);
    }

    public void addFloatAttributes(String ... attributeName) {
        this.addAttributes(ConstraintAttribute.AttributeType.FLOAT_TYPE, attributeName);
    }

    public void addStringAttributes(String ... attributeName) {
        this.addAttributes(ConstraintAttribute.AttributeType.STRING_TYPE, attributeName);
    }

    private Constraint get(int id2) {
        if (!this.mConstraints.containsKey(id2)) {
            this.mConstraints.put(id2, new Constraint());
        }
        return this.mConstraints.get(id2);
    }

    private String sideToString(int side) {
        switch (side) {
            case 1: {
                return "left";
            }
            case 2: {
                return "right";
            }
            case 3: {
                return "top";
            }
            case 4: {
                return "bottom";
            }
            case 5: {
                return "baseline";
            }
            case 6: {
                return "start";
            }
            case 7: {
                return "end";
            }
        }
        return "undefined";
    }

    public void load(Context context, int resourceId) {
        Resources res = context.getResources();
        XmlResourceParser parser = res.getXml(resourceId);
        String document = null;
        String tagName = null;
        try {
            int eventType = parser.getEventType();
            while (eventType != 1) {
                switch (eventType) {
                    case 0: {
                        document = parser.getName();
                        break;
                    }
                    case 2: {
                        tagName = parser.getName();
                        Constraint constraint = this.fillFromAttributeList(context, Xml.asAttributeSet((XmlPullParser)parser), false);
                        if (tagName.equalsIgnoreCase("Guideline")) {
                            constraint.layout.mIsGuideline = true;
                        }
                        this.mConstraints.put(constraint.mViewId, constraint);
                        break;
                    }
                    case 3: {
                        tagName = null;
                        break;
                    }
                }
                eventType = parser.next();
            }
        }
        catch (XmlPullParserException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void load(Context context, XmlPullParser parser) {
        String tagName = null;
        try {
            Constraint constraint = null;
            int eventType = parser.getEventType();
            while (eventType != 1) {
                switch (eventType) {
                    case 0: {
                        String document = parser.getName();
                        break;
                    }
                    case 2: {
                        switch (tagName = parser.getName()) {
                            case "Constraint": {
                                constraint = this.fillFromAttributeList(context, Xml.asAttributeSet((XmlPullParser)parser), false);
                                break;
                            }
                            case "ConstraintOverride": {
                                constraint = this.fillFromAttributeList(context, Xml.asAttributeSet((XmlPullParser)parser), true);
                                break;
                            }
                            case "Guideline": {
                                constraint = this.fillFromAttributeList(context, Xml.asAttributeSet((XmlPullParser)parser), false);
                                constraint.layout.mIsGuideline = true;
                                constraint.layout.mApply = true;
                                break;
                            }
                            case "Barrier": {
                                constraint = this.fillFromAttributeList(context, Xml.asAttributeSet((XmlPullParser)parser), false);
                                constraint.layout.mHelperType = 1;
                                break;
                            }
                            case "PropertySet": {
                                if (constraint == null) {
                                    throw new RuntimeException(ERROR_MESSAGE + parser.getLineNumber());
                                }
                                constraint.propertySet.fillFromAttributeList(context, Xml.asAttributeSet((XmlPullParser)parser));
                                break;
                            }
                            case "Transform": {
                                if (constraint == null) {
                                    throw new RuntimeException(ERROR_MESSAGE + parser.getLineNumber());
                                }
                                constraint.transform.fillFromAttributeList(context, Xml.asAttributeSet((XmlPullParser)parser));
                                break;
                            }
                            case "Layout": {
                                if (constraint == null) {
                                    throw new RuntimeException(ERROR_MESSAGE + parser.getLineNumber());
                                }
                                constraint.layout.fillFromAttributeList(context, Xml.asAttributeSet((XmlPullParser)parser));
                                break;
                            }
                            case "Motion": {
                                if (constraint == null) {
                                    throw new RuntimeException(ERROR_MESSAGE + parser.getLineNumber());
                                }
                                constraint.motion.fillFromAttributeList(context, Xml.asAttributeSet((XmlPullParser)parser));
                                break;
                            }
                            case "CustomAttribute": 
                            case "CustomMethod": {
                                if (constraint == null) {
                                    throw new RuntimeException(ERROR_MESSAGE + parser.getLineNumber());
                                }
                                ConstraintAttribute.parse(context, parser, constraint.mCustomConstraints);
                            }
                        }
                        break;
                    }
                    case 3: {
                        tagName = parser.getName();
                        switch (tagName.toLowerCase(Locale.ROOT)) {
                            case "constraintset": {
                                return;
                            }
                            case "constraint": 
                            case "constraintoverride": 
                            case "guideline": {
                                this.mConstraints.put(constraint.mViewId, constraint);
                                constraint = null;
                            }
                        }
                        tagName = null;
                        break;
                    }
                }
                eventType = parser.next();
            }
        }
        catch (XmlPullParserException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static int lookupID(TypedArray a, int index, int def) {
        int ret = a.getResourceId(index, def);
        if (ret == -1) {
            ret = a.getInt(index, -1);
        }
        return ret;
    }

    private Constraint fillFromAttributeList(Context context, AttributeSet attrs, boolean override) {
        Constraint c = new Constraint();
        TypedArray a = context.obtainStyledAttributes(attrs, override ? R.styleable.ConstraintOverride : R.styleable.Constraint);
        this.populateConstraint(context, c, a, override);
        a.recycle();
        return c;
    }

    public static Constraint buildDelta(Context context, XmlPullParser parser) {
        AttributeSet attrs = Xml.asAttributeSet((XmlPullParser)parser);
        Constraint c = new Constraint();
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ConstraintOverride);
        ConstraintSet.populateOverride(context, c, a);
        a.recycle();
        return c;
    }

    private static void populateOverride(Context ctx, Constraint c, TypedArray a) {
        Constraint.Delta delta;
        int N = a.getIndexCount();
        c.mDelta = delta = new Constraint.Delta();
        c.motion.mApply = false;
        c.layout.mApply = false;
        c.propertySet.mApply = false;
        c.transform.mApply = false;
        block82: for (int i = 0; i < N; ++i) {
            int attr2 = a.getIndex(i);
            int attrType = overrideMapToConstant.get(attr2);
            switch (attrType) {
                case 6: {
                    delta.add(6, a.getDimensionPixelOffset(attr2, c.layout.editorAbsoluteX));
                    continue block82;
                }
                case 7: {
                    delta.add(7, a.getDimensionPixelOffset(attr2, c.layout.editorAbsoluteY));
                    continue block82;
                }
                case 17: {
                    delta.add(17, a.getDimensionPixelOffset(attr2, c.layout.guideBegin));
                    continue block82;
                }
                case 18: {
                    delta.add(18, a.getDimensionPixelOffset(attr2, c.layout.guideEnd));
                    continue block82;
                }
                case 19: {
                    delta.add(19, a.getFloat(attr2, c.layout.guidePercent));
                    continue block82;
                }
                case 99: {
                    delta.add(99, a.getBoolean(attr2, c.layout.guidelineUseRtl));
                    continue block82;
                }
                case 27: {
                    delta.add(27, a.getInt(attr2, c.layout.orientation));
                    continue block82;
                }
                case 62: {
                    delta.add(62, a.getDimensionPixelSize(attr2, c.layout.circleRadius));
                    continue block82;
                }
                case 63: {
                    delta.add(63, a.getFloat(attr2, c.layout.circleAngle));
                    continue block82;
                }
                case 13: {
                    delta.add(13, a.getDimensionPixelSize(attr2, c.layout.goneLeftMargin));
                    continue block82;
                }
                case 16: {
                    delta.add(16, a.getDimensionPixelSize(attr2, c.layout.goneTopMargin));
                    continue block82;
                }
                case 14: {
                    delta.add(14, a.getDimensionPixelSize(attr2, c.layout.goneRightMargin));
                    continue block82;
                }
                case 11: {
                    delta.add(11, a.getDimensionPixelSize(attr2, c.layout.goneBottomMargin));
                    continue block82;
                }
                case 15: {
                    delta.add(15, a.getDimensionPixelSize(attr2, c.layout.goneStartMargin));
                    continue block82;
                }
                case 12: {
                    delta.add(12, a.getDimensionPixelSize(attr2, c.layout.goneEndMargin));
                    continue block82;
                }
                case 94: {
                    delta.add(94, a.getDimensionPixelSize(attr2, c.layout.goneBaselineMargin));
                    continue block82;
                }
                case 20: {
                    delta.add(20, a.getFloat(attr2, c.layout.horizontalBias));
                    continue block82;
                }
                case 37: {
                    delta.add(37, a.getFloat(attr2, c.layout.verticalBias));
                    continue block82;
                }
                case 24: {
                    delta.add(24, a.getDimensionPixelSize(attr2, c.layout.leftMargin));
                    continue block82;
                }
                case 28: {
                    delta.add(28, a.getDimensionPixelSize(attr2, c.layout.rightMargin));
                    continue block82;
                }
                case 31: {
                    if (Build.VERSION.SDK_INT < 17) continue block82;
                    delta.add(31, a.getDimensionPixelSize(attr2, c.layout.startMargin));
                    continue block82;
                }
                case 8: {
                    if (Build.VERSION.SDK_INT < 17) continue block82;
                    delta.add(8, a.getDimensionPixelSize(attr2, c.layout.endMargin));
                    continue block82;
                }
                case 34: {
                    delta.add(34, a.getDimensionPixelSize(attr2, c.layout.topMargin));
                    continue block82;
                }
                case 2: {
                    delta.add(2, a.getDimensionPixelSize(attr2, c.layout.bottomMargin));
                    continue block82;
                }
                case 93: {
                    delta.add(93, a.getDimensionPixelSize(attr2, c.layout.baselineMargin));
                    continue block82;
                }
                case 23: {
                    delta.add(23, a.getLayoutDimension(attr2, c.layout.mWidth));
                    continue block82;
                }
                case 21: {
                    delta.add(21, a.getLayoutDimension(attr2, c.layout.mHeight));
                    continue block82;
                }
                case 95: {
                    ConstraintSet.parseDimensionConstraints(delta, a, attr2, 0);
                    continue block82;
                }
                case 96: {
                    ConstraintSet.parseDimensionConstraints(delta, a, attr2, 1);
                    continue block82;
                }
                case 97: {
                    delta.add(97, a.getInt(attr2, c.layout.mWrapBehavior));
                    continue block82;
                }
                case 54: {
                    delta.add(54, a.getInt(attr2, c.layout.widthDefault));
                    continue block82;
                }
                case 55: {
                    delta.add(55, a.getInt(attr2, c.layout.heightDefault));
                    continue block82;
                }
                case 57: {
                    delta.add(57, a.getDimensionPixelSize(attr2, c.layout.heightMax));
                    continue block82;
                }
                case 56: {
                    delta.add(56, a.getDimensionPixelSize(attr2, c.layout.widthMax));
                    continue block82;
                }
                case 59: {
                    delta.add(59, a.getDimensionPixelSize(attr2, c.layout.heightMin));
                    continue block82;
                }
                case 58: {
                    delta.add(58, a.getDimensionPixelSize(attr2, c.layout.widthMin));
                    continue block82;
                }
                case 80: {
                    delta.add(80, a.getBoolean(attr2, c.layout.constrainedWidth));
                    continue block82;
                }
                case 81: {
                    delta.add(81, a.getBoolean(attr2, c.layout.constrainedHeight));
                    continue block82;
                }
                case 22: {
                    delta.add(22, VISIBILITY_FLAGS[a.getInt(attr2, c.propertySet.visibility)]);
                    continue block82;
                }
                case 78: {
                    delta.add(78, a.getInt(attr2, c.propertySet.mVisibilityMode));
                    continue block82;
                }
                case 43: {
                    delta.add(43, a.getFloat(attr2, c.propertySet.alpha));
                    continue block82;
                }
                case 44: {
                    if (Build.VERSION.SDK_INT < 21) continue block82;
                    delta.add(44, true);
                    delta.add(44, a.getDimension(attr2, c.transform.elevation));
                    continue block82;
                }
                case 60: {
                    delta.add(60, a.getFloat(attr2, c.transform.rotation));
                    continue block82;
                }
                case 45: {
                    delta.add(45, a.getFloat(attr2, c.transform.rotationX));
                    continue block82;
                }
                case 46: {
                    delta.add(46, a.getFloat(attr2, c.transform.rotationY));
                    continue block82;
                }
                case 47: {
                    delta.add(47, a.getFloat(attr2, c.transform.scaleX));
                    continue block82;
                }
                case 48: {
                    delta.add(48, a.getFloat(attr2, c.transform.scaleY));
                    continue block82;
                }
                case 49: {
                    delta.add(49, a.getDimension(attr2, c.transform.transformPivotX));
                    continue block82;
                }
                case 50: {
                    delta.add(50, a.getDimension(attr2, c.transform.transformPivotY));
                    continue block82;
                }
                case 51: {
                    delta.add(51, a.getDimension(attr2, c.transform.translationX));
                    continue block82;
                }
                case 52: {
                    delta.add(52, a.getDimension(attr2, c.transform.translationY));
                    continue block82;
                }
                case 53: {
                    if (Build.VERSION.SDK_INT < 21) continue block82;
                    delta.add(53, a.getDimension(attr2, c.transform.translationZ));
                    continue block82;
                }
                case 83: {
                    delta.add(83, ConstraintSet.lookupID(a, attr2, c.transform.transformPivotTarget));
                    continue block82;
                }
                case 40: {
                    delta.add(40, a.getFloat(attr2, c.layout.verticalWeight));
                    continue block82;
                }
                case 39: {
                    delta.add(39, a.getFloat(attr2, c.layout.horizontalWeight));
                    continue block82;
                }
                case 42: {
                    delta.add(42, a.getInt(attr2, c.layout.verticalChainStyle));
                    continue block82;
                }
                case 41: {
                    delta.add(41, a.getInt(attr2, c.layout.horizontalChainStyle));
                    continue block82;
                }
                case 38: {
                    c.mViewId = a.getResourceId(attr2, c.mViewId);
                    delta.add(38, c.mViewId);
                    continue block82;
                }
                case 98: {
                    if (MotionLayout.IS_IN_EDIT_MODE) {
                        c.mViewId = a.getResourceId(attr2, c.mViewId);
                        if (c.mViewId != -1) continue block82;
                        c.mTargetString = a.getString(attr2);
                        continue block82;
                    }
                    if (a.peekValue((int)attr2).type == 3) {
                        c.mTargetString = a.getString(attr2);
                        continue block82;
                    }
                    c.mViewId = a.getResourceId(attr2, c.mViewId);
                    continue block82;
                }
                case 5: {
                    delta.add(5, a.getString(attr2));
                    continue block82;
                }
                case 69: {
                    delta.add(69, a.getFloat(attr2, 1.0f));
                    continue block82;
                }
                case 70: {
                    delta.add(70, a.getFloat(attr2, 1.0f));
                    continue block82;
                }
                case 68: {
                    delta.add(68, a.getFloat(attr2, c.propertySet.mProgress));
                    continue block82;
                }
                case 64: {
                    delta.add(64, ConstraintSet.lookupID(a, attr2, c.motion.mAnimateRelativeTo));
                    continue block82;
                }
                case 82: {
                    delta.add(82, a.getInteger(attr2, c.motion.mAnimateCircleAngleTo));
                    continue block82;
                }
                case 65: {
                    TypedValue type = a.peekValue(attr2);
                    if (type.type == 3) {
                        delta.add(65, a.getString(attr2));
                        continue block82;
                    }
                    delta.add(65, Easing.NAMED_EASING[a.getInteger(attr2, 0)]);
                    continue block82;
                }
                case 76: {
                    delta.add(76, a.getInt(attr2, c.motion.mPathMotionArc));
                    continue block82;
                }
                case 67: {
                    delta.add(67, a.getFloat(attr2, c.motion.mPathRotate));
                    continue block82;
                }
                case 79: {
                    delta.add(79, a.getFloat(attr2, c.motion.mMotionStagger));
                    continue block82;
                }
                case 84: {
                    delta.add(84, a.getInteger(attr2, c.motion.mQuantizeMotionSteps));
                    continue block82;
                }
                case 85: {
                    delta.add(85, a.getFloat(attr2, c.motion.mQuantizeMotionPhase));
                    continue block82;
                }
                case 86: {
                    TypedValue type = a.peekValue(attr2);
                    if (type.type == 1) {
                        c.motion.mQuantizeInterpolatorID = a.getResourceId(attr2, -1);
                        delta.add(89, c.motion.mQuantizeInterpolatorID);
                        if (c.motion.mQuantizeInterpolatorID == -1) continue block82;
                        c.motion.mQuantizeInterpolatorType = -2;
                        delta.add(88, c.motion.mQuantizeInterpolatorType);
                        continue block82;
                    }
                    if (type.type == 3) {
                        c.motion.mQuantizeInterpolatorString = a.getString(attr2);
                        delta.add(90, c.motion.mQuantizeInterpolatorString);
                        if (c.motion.mQuantizeInterpolatorString.indexOf("/") > 0) {
                            c.motion.mQuantizeInterpolatorID = a.getResourceId(attr2, -1);
                            delta.add(89, c.motion.mQuantizeInterpolatorID);
                            c.motion.mQuantizeInterpolatorType = -2;
                            delta.add(88, c.motion.mQuantizeInterpolatorType);
                            continue block82;
                        }
                        c.motion.mQuantizeInterpolatorType = -1;
                        delta.add(88, c.motion.mQuantizeInterpolatorType);
                        continue block82;
                    }
                    c.motion.mQuantizeInterpolatorType = a.getInteger(attr2, c.motion.mQuantizeInterpolatorID);
                    delta.add(88, c.motion.mQuantizeInterpolatorType);
                    continue block82;
                }
                case 66: {
                    delta.add(66, a.getInt(attr2, 0));
                    continue block82;
                }
                case 71: {
                    Log.e((String)TAG, (String)"CURRENTLY UNSUPPORTED");
                    continue block82;
                }
                case 72: {
                    delta.add(72, a.getInt(attr2, c.layout.mBarrierDirection));
                    continue block82;
                }
                case 73: {
                    delta.add(73, a.getDimensionPixelSize(attr2, c.layout.mBarrierMargin));
                    continue block82;
                }
                case 74: {
                    delta.add(74, a.getString(attr2));
                    continue block82;
                }
                case 77: {
                    delta.add(77, a.getString(attr2));
                    continue block82;
                }
                case 75: {
                    delta.add(75, a.getBoolean(attr2, c.layout.mBarrierAllowsGoneWidgets));
                    continue block82;
                }
                case 87: {
                    Log.w((String)TAG, (String)("unused attribute 0x" + Integer.toHexString(attr2) + "   " + mapToConstant.get(attr2)));
                    continue block82;
                }
                default: {
                    Log.w((String)TAG, (String)("Unknown attribute 0x" + Integer.toHexString(attr2) + "   " + mapToConstant.get(attr2)));
                }
            }
        }
    }

    private static void setDeltaValue(Constraint c, int type, float value) {
        switch (type) {
            case 19: {
                c.layout.guidePercent = value;
                break;
            }
            case 63: {
                c.layout.circleAngle = value;
                break;
            }
            case 20: {
                c.layout.horizontalBias = value;
                break;
            }
            case 37: {
                c.layout.verticalBias = value;
                break;
            }
            case 43: {
                c.propertySet.alpha = value;
                break;
            }
            case 44: {
                c.transform.elevation = value;
                c.transform.applyElevation = true;
                break;
            }
            case 60: {
                c.transform.rotation = value;
                break;
            }
            case 45: {
                c.transform.rotationX = value;
                break;
            }
            case 46: {
                c.transform.rotationY = value;
                break;
            }
            case 47: {
                c.transform.scaleX = value;
                break;
            }
            case 48: {
                c.transform.scaleY = value;
                break;
            }
            case 49: {
                c.transform.transformPivotX = value;
                break;
            }
            case 50: {
                c.transform.transformPivotY = value;
                break;
            }
            case 51: {
                c.transform.translationX = value;
                break;
            }
            case 52: {
                c.transform.translationY = value;
                break;
            }
            case 53: {
                c.transform.translationZ = value;
                break;
            }
            case 40: {
                c.layout.verticalWeight = value;
                break;
            }
            case 39: {
                c.layout.horizontalWeight = value;
                break;
            }
            case 69: {
                c.layout.widthPercent = value;
                break;
            }
            case 70: {
                c.layout.heightPercent = value;
                break;
            }
            case 68: {
                c.propertySet.mProgress = value;
                break;
            }
            case 67: {
                c.motion.mPathRotate = value;
                break;
            }
            case 79: {
                c.motion.mMotionStagger = value;
                break;
            }
            case 85: {
                c.motion.mQuantizeMotionPhase = value;
                break;
            }
            case 87: {
                break;
            }
            default: {
                Log.w((String)TAG, (String)"Unknown attribute 0x");
            }
        }
    }

    private static void setDeltaValue(Constraint c, int type, int value) {
        switch (type) {
            case 6: {
                c.layout.editorAbsoluteX = value;
                break;
            }
            case 7: {
                c.layout.editorAbsoluteY = value;
                break;
            }
            case 97: {
                c.layout.mWrapBehavior = value;
                break;
            }
            case 17: {
                c.layout.guideBegin = value;
                break;
            }
            case 18: {
                c.layout.guideEnd = value;
                break;
            }
            case 27: {
                c.layout.orientation = value;
                break;
            }
            case 61: {
                c.layout.circleConstraint = value;
                break;
            }
            case 62: {
                c.layout.circleRadius = value;
                break;
            }
            case 13: {
                c.layout.goneLeftMargin = value;
                break;
            }
            case 16: {
                c.layout.goneTopMargin = value;
                break;
            }
            case 14: {
                c.layout.goneRightMargin = value;
                break;
            }
            case 11: {
                c.layout.goneBottomMargin = value;
                break;
            }
            case 15: {
                c.layout.goneStartMargin = value;
                break;
            }
            case 12: {
                c.layout.goneEndMargin = value;
                break;
            }
            case 94: {
                c.layout.goneBaselineMargin = value;
                break;
            }
            case 24: {
                c.layout.leftMargin = value;
                break;
            }
            case 28: {
                c.layout.rightMargin = value;
                break;
            }
            case 31: {
                c.layout.startMargin = value;
                break;
            }
            case 8: {
                c.layout.endMargin = value;
                break;
            }
            case 34: {
                c.layout.topMargin = value;
                break;
            }
            case 2: {
                c.layout.bottomMargin = value;
                break;
            }
            case 93: {
                c.layout.baselineMargin = value;
                break;
            }
            case 23: {
                c.layout.mWidth = value;
                break;
            }
            case 21: {
                c.layout.mHeight = value;
                break;
            }
            case 54: {
                c.layout.widthDefault = value;
                break;
            }
            case 55: {
                c.layout.heightDefault = value;
                break;
            }
            case 57: {
                c.layout.heightMax = value;
                break;
            }
            case 56: {
                c.layout.widthMax = value;
                break;
            }
            case 59: {
                c.layout.heightMin = value;
                break;
            }
            case 58: {
                c.layout.widthMin = value;
                break;
            }
            case 22: {
                c.propertySet.visibility = value;
                break;
            }
            case 78: {
                c.propertySet.mVisibilityMode = value;
                break;
            }
            case 83: {
                c.transform.transformPivotTarget = value;
                break;
            }
            case 42: {
                c.layout.verticalChainStyle = value;
                break;
            }
            case 41: {
                c.layout.horizontalChainStyle = value;
                break;
            }
            case 38: {
                c.mViewId = value;
                break;
            }
            case 64: {
                c.motion.mAnimateRelativeTo = value;
                break;
            }
            case 82: {
                c.motion.mAnimateCircleAngleTo = value;
                break;
            }
            case 76: {
                c.motion.mPathMotionArc = value;
                break;
            }
            case 84: {
                c.motion.mQuantizeMotionSteps = value;
                break;
            }
            case 88: {
                c.motion.mQuantizeInterpolatorType = value;
                break;
            }
            case 89: {
                c.motion.mQuantizeInterpolatorID = value;
                break;
            }
            case 66: {
                c.motion.mDrawPath = value;
                break;
            }
            case 72: {
                c.layout.mBarrierDirection = value;
                break;
            }
            case 73: {
                c.layout.mBarrierMargin = value;
                break;
            }
            case 87: {
                break;
            }
            default: {
                Log.w((String)TAG, (String)"Unknown attribute 0x");
            }
        }
    }

    private static void setDeltaValue(Constraint c, int type, String value) {
        switch (type) {
            case 5: {
                c.layout.dimensionRatio = value;
                break;
            }
            case 65: {
                c.motion.mTransitionEasing = value;
                break;
            }
            case 90: {
                c.motion.mQuantizeInterpolatorString = value;
                break;
            }
            case 74: {
                c.layout.mReferenceIdString = value;
                c.layout.mReferenceIds = null;
                break;
            }
            case 77: {
                c.layout.mConstraintTag = value;
                break;
            }
            case 87: {
                break;
            }
            default: {
                Log.w((String)TAG, (String)"Unknown attribute 0x");
            }
        }
    }

    private static void setDeltaValue(Constraint c, int type, boolean value) {
        switch (type) {
            case 80: {
                c.layout.constrainedWidth = value;
                break;
            }
            case 81: {
                c.layout.constrainedHeight = value;
                break;
            }
            case 44: {
                c.transform.applyElevation = value;
                break;
            }
            case 75: {
                c.layout.mBarrierAllowsGoneWidgets = value;
                break;
            }
            case 87: {
                break;
            }
            default: {
                Log.w((String)TAG, (String)"Unknown attribute 0x");
            }
        }
    }

    private void populateConstraint(Context ctx, Constraint c, TypedArray a, boolean override) {
        if (override) {
            ConstraintSet.populateOverride(ctx, c, a);
            return;
        }
        int N = a.getIndexCount();
        block96: for (int i = 0; i < N; ++i) {
            int attr2 = a.getIndex(i);
            if (attr2 != R.styleable.Constraint_android_id && R.styleable.Constraint_android_layout_marginStart != attr2 && R.styleable.Constraint_android_layout_marginEnd != attr2) {
                c.motion.mApply = true;
                c.layout.mApply = true;
                c.propertySet.mApply = true;
                c.transform.mApply = true;
            }
            switch (mapToConstant.get(attr2)) {
                case 25: {
                    c.layout.leftToLeft = ConstraintSet.lookupID(a, attr2, c.layout.leftToLeft);
                    continue block96;
                }
                case 26: {
                    c.layout.leftToRight = ConstraintSet.lookupID(a, attr2, c.layout.leftToRight);
                    continue block96;
                }
                case 29: {
                    c.layout.rightToLeft = ConstraintSet.lookupID(a, attr2, c.layout.rightToLeft);
                    continue block96;
                }
                case 30: {
                    c.layout.rightToRight = ConstraintSet.lookupID(a, attr2, c.layout.rightToRight);
                    continue block96;
                }
                case 36: {
                    c.layout.topToTop = ConstraintSet.lookupID(a, attr2, c.layout.topToTop);
                    continue block96;
                }
                case 35: {
                    c.layout.topToBottom = ConstraintSet.lookupID(a, attr2, c.layout.topToBottom);
                    continue block96;
                }
                case 4: {
                    c.layout.bottomToTop = ConstraintSet.lookupID(a, attr2, c.layout.bottomToTop);
                    continue block96;
                }
                case 3: {
                    c.layout.bottomToBottom = ConstraintSet.lookupID(a, attr2, c.layout.bottomToBottom);
                    continue block96;
                }
                case 1: {
                    c.layout.baselineToBaseline = ConstraintSet.lookupID(a, attr2, c.layout.baselineToBaseline);
                    continue block96;
                }
                case 91: {
                    c.layout.baselineToTop = ConstraintSet.lookupID(a, attr2, c.layout.baselineToTop);
                    continue block96;
                }
                case 92: {
                    c.layout.baselineToBottom = ConstraintSet.lookupID(a, attr2, c.layout.baselineToBottom);
                    continue block96;
                }
                case 6: {
                    c.layout.editorAbsoluteX = a.getDimensionPixelOffset(attr2, c.layout.editorAbsoluteX);
                    continue block96;
                }
                case 7: {
                    c.layout.editorAbsoluteY = a.getDimensionPixelOffset(attr2, c.layout.editorAbsoluteY);
                    continue block96;
                }
                case 17: {
                    c.layout.guideBegin = a.getDimensionPixelOffset(attr2, c.layout.guideBegin);
                    continue block96;
                }
                case 18: {
                    c.layout.guideEnd = a.getDimensionPixelOffset(attr2, c.layout.guideEnd);
                    continue block96;
                }
                case 19: {
                    c.layout.guidePercent = a.getFloat(attr2, c.layout.guidePercent);
                    continue block96;
                }
                case 27: {
                    c.layout.orientation = a.getInt(attr2, c.layout.orientation);
                    continue block96;
                }
                case 32: {
                    c.layout.startToEnd = ConstraintSet.lookupID(a, attr2, c.layout.startToEnd);
                    continue block96;
                }
                case 33: {
                    c.layout.startToStart = ConstraintSet.lookupID(a, attr2, c.layout.startToStart);
                    continue block96;
                }
                case 10: {
                    c.layout.endToStart = ConstraintSet.lookupID(a, attr2, c.layout.endToStart);
                    continue block96;
                }
                case 9: {
                    c.layout.endToEnd = ConstraintSet.lookupID(a, attr2, c.layout.endToEnd);
                    continue block96;
                }
                case 61: {
                    c.layout.circleConstraint = ConstraintSet.lookupID(a, attr2, c.layout.circleConstraint);
                    continue block96;
                }
                case 62: {
                    c.layout.circleRadius = a.getDimensionPixelSize(attr2, c.layout.circleRadius);
                    continue block96;
                }
                case 63: {
                    c.layout.circleAngle = a.getFloat(attr2, c.layout.circleAngle);
                    continue block96;
                }
                case 13: {
                    c.layout.goneLeftMargin = a.getDimensionPixelSize(attr2, c.layout.goneLeftMargin);
                    continue block96;
                }
                case 16: {
                    c.layout.goneTopMargin = a.getDimensionPixelSize(attr2, c.layout.goneTopMargin);
                    continue block96;
                }
                case 14: {
                    c.layout.goneRightMargin = a.getDimensionPixelSize(attr2, c.layout.goneRightMargin);
                    continue block96;
                }
                case 11: {
                    c.layout.goneBottomMargin = a.getDimensionPixelSize(attr2, c.layout.goneBottomMargin);
                    continue block96;
                }
                case 15: {
                    c.layout.goneStartMargin = a.getDimensionPixelSize(attr2, c.layout.goneStartMargin);
                    continue block96;
                }
                case 12: {
                    c.layout.goneEndMargin = a.getDimensionPixelSize(attr2, c.layout.goneEndMargin);
                    continue block96;
                }
                case 94: {
                    c.layout.goneBaselineMargin = a.getDimensionPixelSize(attr2, c.layout.goneBaselineMargin);
                    continue block96;
                }
                case 20: {
                    c.layout.horizontalBias = a.getFloat(attr2, c.layout.horizontalBias);
                    continue block96;
                }
                case 37: {
                    c.layout.verticalBias = a.getFloat(attr2, c.layout.verticalBias);
                    continue block96;
                }
                case 24: {
                    c.layout.leftMargin = a.getDimensionPixelSize(attr2, c.layout.leftMargin);
                    continue block96;
                }
                case 28: {
                    c.layout.rightMargin = a.getDimensionPixelSize(attr2, c.layout.rightMargin);
                    continue block96;
                }
                case 31: {
                    if (Build.VERSION.SDK_INT < 17) continue block96;
                    c.layout.startMargin = a.getDimensionPixelSize(attr2, c.layout.startMargin);
                    continue block96;
                }
                case 8: {
                    if (Build.VERSION.SDK_INT < 17) continue block96;
                    c.layout.endMargin = a.getDimensionPixelSize(attr2, c.layout.endMargin);
                    continue block96;
                }
                case 34: {
                    c.layout.topMargin = a.getDimensionPixelSize(attr2, c.layout.topMargin);
                    continue block96;
                }
                case 2: {
                    c.layout.bottomMargin = a.getDimensionPixelSize(attr2, c.layout.bottomMargin);
                    continue block96;
                }
                case 93: {
                    c.layout.baselineMargin = a.getDimensionPixelSize(attr2, c.layout.baselineMargin);
                    continue block96;
                }
                case 23: {
                    c.layout.mWidth = a.getLayoutDimension(attr2, c.layout.mWidth);
                    continue block96;
                }
                case 21: {
                    c.layout.mHeight = a.getLayoutDimension(attr2, c.layout.mHeight);
                    continue block96;
                }
                case 95: {
                    ConstraintSet.parseDimensionConstraints(c.layout, a, attr2, 0);
                    continue block96;
                }
                case 96: {
                    ConstraintSet.parseDimensionConstraints(c.layout, a, attr2, 1);
                    continue block96;
                }
                case 97: {
                    c.layout.mWrapBehavior = a.getInt(attr2, c.layout.mWrapBehavior);
                    continue block96;
                }
                case 54: {
                    c.layout.widthDefault = a.getInt(attr2, c.layout.widthDefault);
                    continue block96;
                }
                case 55: {
                    c.layout.heightDefault = a.getInt(attr2, c.layout.heightDefault);
                    continue block96;
                }
                case 57: {
                    c.layout.heightMax = a.getDimensionPixelSize(attr2, c.layout.heightMax);
                    continue block96;
                }
                case 56: {
                    c.layout.widthMax = a.getDimensionPixelSize(attr2, c.layout.widthMax);
                    continue block96;
                }
                case 59: {
                    c.layout.heightMin = a.getDimensionPixelSize(attr2, c.layout.heightMin);
                    continue block96;
                }
                case 58: {
                    c.layout.widthMin = a.getDimensionPixelSize(attr2, c.layout.widthMin);
                    continue block96;
                }
                case 80: {
                    c.layout.constrainedWidth = a.getBoolean(attr2, c.layout.constrainedWidth);
                    continue block96;
                }
                case 81: {
                    c.layout.constrainedHeight = a.getBoolean(attr2, c.layout.constrainedHeight);
                    continue block96;
                }
                case 22: {
                    c.propertySet.visibility = a.getInt(attr2, c.propertySet.visibility);
                    c.propertySet.visibility = VISIBILITY_FLAGS[c.propertySet.visibility];
                    continue block96;
                }
                case 78: {
                    c.propertySet.mVisibilityMode = a.getInt(attr2, c.propertySet.mVisibilityMode);
                    continue block96;
                }
                case 43: {
                    c.propertySet.alpha = a.getFloat(attr2, c.propertySet.alpha);
                    continue block96;
                }
                case 44: {
                    if (Build.VERSION.SDK_INT < 21) continue block96;
                    c.transform.applyElevation = true;
                    c.transform.elevation = a.getDimension(attr2, c.transform.elevation);
                    continue block96;
                }
                case 60: {
                    c.transform.rotation = a.getFloat(attr2, c.transform.rotation);
                    continue block96;
                }
                case 45: {
                    c.transform.rotationX = a.getFloat(attr2, c.transform.rotationX);
                    continue block96;
                }
                case 46: {
                    c.transform.rotationY = a.getFloat(attr2, c.transform.rotationY);
                    continue block96;
                }
                case 47: {
                    c.transform.scaleX = a.getFloat(attr2, c.transform.scaleX);
                    continue block96;
                }
                case 48: {
                    c.transform.scaleY = a.getFloat(attr2, c.transform.scaleY);
                    continue block96;
                }
                case 49: {
                    c.transform.transformPivotX = a.getDimension(attr2, c.transform.transformPivotX);
                    continue block96;
                }
                case 50: {
                    c.transform.transformPivotY = a.getDimension(attr2, c.transform.transformPivotY);
                    continue block96;
                }
                case 51: {
                    c.transform.translationX = a.getDimension(attr2, c.transform.translationX);
                    continue block96;
                }
                case 52: {
                    c.transform.translationY = a.getDimension(attr2, c.transform.translationY);
                    continue block96;
                }
                case 53: {
                    if (Build.VERSION.SDK_INT < 21) continue block96;
                    c.transform.translationZ = a.getDimension(attr2, c.transform.translationZ);
                    continue block96;
                }
                case 83: {
                    c.transform.transformPivotTarget = ConstraintSet.lookupID(a, attr2, c.transform.transformPivotTarget);
                    continue block96;
                }
                case 40: {
                    c.layout.verticalWeight = a.getFloat(attr2, c.layout.verticalWeight);
                    continue block96;
                }
                case 39: {
                    c.layout.horizontalWeight = a.getFloat(attr2, c.layout.horizontalWeight);
                    continue block96;
                }
                case 42: {
                    c.layout.verticalChainStyle = a.getInt(attr2, c.layout.verticalChainStyle);
                    continue block96;
                }
                case 41: {
                    c.layout.horizontalChainStyle = a.getInt(attr2, c.layout.horizontalChainStyle);
                    continue block96;
                }
                case 38: {
                    c.mViewId = a.getResourceId(attr2, c.mViewId);
                    continue block96;
                }
                case 5: {
                    c.layout.dimensionRatio = a.getString(attr2);
                    continue block96;
                }
                case 69: {
                    c.layout.widthPercent = a.getFloat(attr2, 1.0f);
                    continue block96;
                }
                case 70: {
                    c.layout.heightPercent = a.getFloat(attr2, 1.0f);
                    continue block96;
                }
                case 68: {
                    c.propertySet.mProgress = a.getFloat(attr2, c.propertySet.mProgress);
                    continue block96;
                }
                case 64: {
                    c.motion.mAnimateRelativeTo = ConstraintSet.lookupID(a, attr2, c.motion.mAnimateRelativeTo);
                    continue block96;
                }
                case 82: {
                    c.motion.mAnimateCircleAngleTo = a.getInteger(attr2, c.motion.mAnimateCircleAngleTo);
                    continue block96;
                }
                case 65: {
                    TypedValue type = a.peekValue(attr2);
                    if (type.type == 3) {
                        c.motion.mTransitionEasing = a.getString(attr2);
                        continue block96;
                    }
                    c.motion.mTransitionEasing = Easing.NAMED_EASING[a.getInteger(attr2, 0)];
                    continue block96;
                }
                case 76: {
                    c.motion.mPathMotionArc = a.getInt(attr2, c.motion.mPathMotionArc);
                    continue block96;
                }
                case 67: {
                    c.motion.mPathRotate = a.getFloat(attr2, c.motion.mPathRotate);
                    continue block96;
                }
                case 79: {
                    c.motion.mMotionStagger = a.getFloat(attr2, c.motion.mMotionStagger);
                    continue block96;
                }
                case 84: {
                    c.motion.mQuantizeMotionSteps = a.getInteger(attr2, c.motion.mQuantizeMotionSteps);
                    continue block96;
                }
                case 85: {
                    c.motion.mQuantizeMotionPhase = a.getFloat(attr2, c.motion.mQuantizeMotionPhase);
                    continue block96;
                }
                case 86: {
                    TypedValue type = a.peekValue(attr2);
                    if (type.type == 1) {
                        c.motion.mQuantizeInterpolatorID = a.getResourceId(attr2, -1);
                        if (c.motion.mQuantizeInterpolatorID == -1) continue block96;
                        c.motion.mQuantizeInterpolatorType = -2;
                        continue block96;
                    }
                    if (type.type == 3) {
                        c.motion.mQuantizeInterpolatorString = a.getString(attr2);
                        if (c.motion.mQuantizeInterpolatorString.indexOf("/") > 0) {
                            c.motion.mQuantizeInterpolatorID = a.getResourceId(attr2, -1);
                            c.motion.mQuantizeInterpolatorType = -2;
                            continue block96;
                        }
                        c.motion.mQuantizeInterpolatorType = -1;
                        continue block96;
                    }
                    c.motion.mQuantizeInterpolatorType = a.getInteger(attr2, c.motion.mQuantizeInterpolatorID);
                    continue block96;
                }
                case 66: {
                    c.motion.mDrawPath = a.getInt(attr2, 0);
                    continue block96;
                }
                case 71: {
                    Log.e((String)TAG, (String)"CURRENTLY UNSUPPORTED");
                    continue block96;
                }
                case 72: {
                    c.layout.mBarrierDirection = a.getInt(attr2, c.layout.mBarrierDirection);
                    continue block96;
                }
                case 73: {
                    c.layout.mBarrierMargin = a.getDimensionPixelSize(attr2, c.layout.mBarrierMargin);
                    continue block96;
                }
                case 74: {
                    c.layout.mReferenceIdString = a.getString(attr2);
                    continue block96;
                }
                case 77: {
                    c.layout.mConstraintTag = a.getString(attr2);
                    continue block96;
                }
                case 75: {
                    c.layout.mBarrierAllowsGoneWidgets = a.getBoolean(attr2, c.layout.mBarrierAllowsGoneWidgets);
                    continue block96;
                }
                case 87: {
                    Log.w((String)TAG, (String)("unused attribute 0x" + Integer.toHexString(attr2) + "   " + mapToConstant.get(attr2)));
                    continue block96;
                }
                default: {
                    Log.w((String)TAG, (String)("Unknown attribute 0x" + Integer.toHexString(attr2) + "   " + mapToConstant.get(attr2)));
                }
            }
        }
        if (c.layout.mReferenceIdString != null) {
            c.layout.mReferenceIds = null;
        }
    }

    private int[] convertReferenceString(View view, String referenceIdString) {
        String[] split = referenceIdString.split(",");
        Context context = view.getContext();
        int[] tags = new int[split.length];
        int count = 0;
        for (int i = 0; i < split.length; ++i) {
            ConstraintLayout constraintLayout;
            Object value;
            String idString = split[i];
            idString = idString.trim();
            int tag = 0;
            try {
                Class<R.id> res = R.id.class;
                Field field = res.getField(idString);
                tag = field.getInt(null);
            }
            catch (Exception res) {
                // empty catch block
            }
            if (tag == 0) {
                tag = context.getResources().getIdentifier(idString, "id", context.getPackageName());
            }
            if (tag == 0 && view.isInEditMode() && view.getParent() instanceof ConstraintLayout && (value = (constraintLayout = (ConstraintLayout)view.getParent()).getDesignInformation(0, idString)) != null && value instanceof Integer) {
                tag = (Integer)value;
            }
            tags[count++] = tag;
        }
        if (count != split.length) {
            tags = Arrays.copyOf(tags, count);
        }
        return tags;
    }

    public Constraint getConstraint(int id2) {
        if (this.mConstraints.containsKey(id2)) {
            return this.mConstraints.get(id2);
        }
        return null;
    }

    public int[] getKnownIds() {
        Integer[] arr = this.mConstraints.keySet().toArray(new Integer[0]);
        int[] array = new int[arr.length];
        for (int i = 0; i < array.length; ++i) {
            array[i] = arr[i];
        }
        return array;
    }

    public boolean isForceId() {
        return this.mForceId;
    }

    public void setForceId(boolean forceId) {
        this.mForceId = forceId;
    }

    public void setValidateOnParse(boolean validate) {
        this.mValidate = validate;
    }

    public void dump(MotionScene scene, int ... ids) {
        HashSet<Object> set;
        Set<Integer> keys = this.mConstraints.keySet();
        if (ids.length != 0) {
            set = new HashSet();
            for (int id2 : ids) {
                set.add(id2);
            }
        } else {
            set = new HashSet<Integer>(keys);
        }
        System.out.println(set.size() + " constraints");
        StringBuilder stringBuilder = new StringBuilder();
        for (Integer id3 : set.toArray(new Integer[0])) {
            Constraint constraint = this.mConstraints.get(id3);
            if (constraint == null) continue;
            stringBuilder.append("<Constraint id=");
            stringBuilder.append(id3);
            stringBuilder.append(" \n");
            constraint.layout.dump(scene, stringBuilder);
            stringBuilder.append("/>\n");
        }
        System.out.println(stringBuilder.toString());
    }

    static String getLine(Context context, int resourceId, XmlPullParser pullParser) {
        return ".(" + Debug.getName(context, resourceId) + ".xml:" + pullParser.getLineNumber() + ") \"" + pullParser.getName() + "\"";
    }

    static String getDebugName(int v) {
        for (Field field : ConstraintSet.class.getDeclaredFields()) {
            if (!field.getName().contains("_") || field.getType() != Integer.TYPE || !Modifier.isStatic(field.getModifiers()) || !Modifier.isFinal(field.getModifiers())) continue;
            int val = 0;
            try {
                val = field.getInt(null);
                if (val != v) continue;
                return field.getName();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return "UNKNOWN";
    }

    public void writeState(Writer writer, ConstraintLayout layout, int flags) throws IOException {
        writer.write("\n---------------------------------------------\n");
        if ((flags & 1) == 1) {
            new WriteXmlEngine(writer, layout, flags).writeLayout();
        } else {
            new WriteJsonEngine(writer, layout, flags).writeLayout();
        }
        writer.write("\n---------------------------------------------\n");
    }

    static {
        mapToConstant.append(R.styleable.Constraint_layout_constraintLeft_toLeftOf, 25);
        mapToConstant.append(R.styleable.Constraint_layout_constraintLeft_toRightOf, 26);
        mapToConstant.append(R.styleable.Constraint_layout_constraintRight_toLeftOf, 29);
        mapToConstant.append(R.styleable.Constraint_layout_constraintRight_toRightOf, 30);
        mapToConstant.append(R.styleable.Constraint_layout_constraintTop_toTopOf, 36);
        mapToConstant.append(R.styleable.Constraint_layout_constraintTop_toBottomOf, 35);
        mapToConstant.append(R.styleable.Constraint_layout_constraintBottom_toTopOf, 4);
        mapToConstant.append(R.styleable.Constraint_layout_constraintBottom_toBottomOf, 3);
        mapToConstant.append(R.styleable.Constraint_layout_constraintBaseline_toBaselineOf, 1);
        mapToConstant.append(R.styleable.Constraint_layout_constraintBaseline_toTopOf, 91);
        mapToConstant.append(R.styleable.Constraint_layout_constraintBaseline_toBottomOf, 92);
        mapToConstant.append(R.styleable.Constraint_layout_editor_absoluteX, 6);
        mapToConstant.append(R.styleable.Constraint_layout_editor_absoluteY, 7);
        mapToConstant.append(R.styleable.Constraint_layout_constraintGuide_begin, 17);
        mapToConstant.append(R.styleable.Constraint_layout_constraintGuide_end, 18);
        mapToConstant.append(R.styleable.Constraint_layout_constraintGuide_percent, 19);
        mapToConstant.append(R.styleable.Constraint_guidelineUseRtl, 99);
        mapToConstant.append(R.styleable.Constraint_android_orientation, 27);
        mapToConstant.append(R.styleable.Constraint_layout_constraintStart_toEndOf, 32);
        mapToConstant.append(R.styleable.Constraint_layout_constraintStart_toStartOf, 33);
        mapToConstant.append(R.styleable.Constraint_layout_constraintEnd_toStartOf, 10);
        mapToConstant.append(R.styleable.Constraint_layout_constraintEnd_toEndOf, 9);
        mapToConstant.append(R.styleable.Constraint_layout_goneMarginLeft, 13);
        mapToConstant.append(R.styleable.Constraint_layout_goneMarginTop, 16);
        mapToConstant.append(R.styleable.Constraint_layout_goneMarginRight, 14);
        mapToConstant.append(R.styleable.Constraint_layout_goneMarginBottom, 11);
        mapToConstant.append(R.styleable.Constraint_layout_goneMarginStart, 15);
        mapToConstant.append(R.styleable.Constraint_layout_goneMarginEnd, 12);
        mapToConstant.append(R.styleable.Constraint_layout_constraintVertical_weight, 40);
        mapToConstant.append(R.styleable.Constraint_layout_constraintHorizontal_weight, 39);
        mapToConstant.append(R.styleable.Constraint_layout_constraintHorizontal_chainStyle, 41);
        mapToConstant.append(R.styleable.Constraint_layout_constraintVertical_chainStyle, 42);
        mapToConstant.append(R.styleable.Constraint_layout_constraintHorizontal_bias, 20);
        mapToConstant.append(R.styleable.Constraint_layout_constraintVertical_bias, 37);
        mapToConstant.append(R.styleable.Constraint_layout_constraintDimensionRatio, 5);
        mapToConstant.append(R.styleable.Constraint_layout_constraintLeft_creator, 87);
        mapToConstant.append(R.styleable.Constraint_layout_constraintTop_creator, 87);
        mapToConstant.append(R.styleable.Constraint_layout_constraintRight_creator, 87);
        mapToConstant.append(R.styleable.Constraint_layout_constraintBottom_creator, 87);
        mapToConstant.append(R.styleable.Constraint_layout_constraintBaseline_creator, 87);
        mapToConstant.append(R.styleable.Constraint_android_layout_marginLeft, 24);
        mapToConstant.append(R.styleable.Constraint_android_layout_marginRight, 28);
        mapToConstant.append(R.styleable.Constraint_android_layout_marginStart, 31);
        mapToConstant.append(R.styleable.Constraint_android_layout_marginEnd, 8);
        mapToConstant.append(R.styleable.Constraint_android_layout_marginTop, 34);
        mapToConstant.append(R.styleable.Constraint_android_layout_marginBottom, 2);
        mapToConstant.append(R.styleable.Constraint_android_layout_width, 23);
        mapToConstant.append(R.styleable.Constraint_android_layout_height, 21);
        mapToConstant.append(R.styleable.Constraint_layout_constraintWidth, 95);
        mapToConstant.append(R.styleable.Constraint_layout_constraintHeight, 96);
        mapToConstant.append(R.styleable.Constraint_android_visibility, 22);
        mapToConstant.append(R.styleable.Constraint_android_alpha, 43);
        mapToConstant.append(R.styleable.Constraint_android_elevation, 44);
        mapToConstant.append(R.styleable.Constraint_android_rotationX, 45);
        mapToConstant.append(R.styleable.Constraint_android_rotationY, 46);
        mapToConstant.append(R.styleable.Constraint_android_rotation, 60);
        mapToConstant.append(R.styleable.Constraint_android_scaleX, 47);
        mapToConstant.append(R.styleable.Constraint_android_scaleY, 48);
        mapToConstant.append(R.styleable.Constraint_android_transformPivotX, 49);
        mapToConstant.append(R.styleable.Constraint_android_transformPivotY, 50);
        mapToConstant.append(R.styleable.Constraint_android_translationX, 51);
        mapToConstant.append(R.styleable.Constraint_android_translationY, 52);
        mapToConstant.append(R.styleable.Constraint_android_translationZ, 53);
        mapToConstant.append(R.styleable.Constraint_layout_constraintWidth_default, 54);
        mapToConstant.append(R.styleable.Constraint_layout_constraintHeight_default, 55);
        mapToConstant.append(R.styleable.Constraint_layout_constraintWidth_max, 56);
        mapToConstant.append(R.styleable.Constraint_layout_constraintHeight_max, 57);
        mapToConstant.append(R.styleable.Constraint_layout_constraintWidth_min, 58);
        mapToConstant.append(R.styleable.Constraint_layout_constraintHeight_min, 59);
        mapToConstant.append(R.styleable.Constraint_layout_constraintCircle, 61);
        mapToConstant.append(R.styleable.Constraint_layout_constraintCircleRadius, 62);
        mapToConstant.append(R.styleable.Constraint_layout_constraintCircleAngle, 63);
        mapToConstant.append(R.styleable.Constraint_animateRelativeTo, 64);
        mapToConstant.append(R.styleable.Constraint_transitionEasing, 65);
        mapToConstant.append(R.styleable.Constraint_drawPath, 66);
        mapToConstant.append(R.styleable.Constraint_transitionPathRotate, 67);
        mapToConstant.append(R.styleable.Constraint_motionStagger, 79);
        mapToConstant.append(R.styleable.Constraint_android_id, 38);
        mapToConstant.append(R.styleable.Constraint_motionProgress, 68);
        mapToConstant.append(R.styleable.Constraint_layout_constraintWidth_percent, 69);
        mapToConstant.append(R.styleable.Constraint_layout_constraintHeight_percent, 70);
        mapToConstant.append(R.styleable.Constraint_layout_wrapBehaviorInParent, 97);
        mapToConstant.append(R.styleable.Constraint_chainUseRtl, 71);
        mapToConstant.append(R.styleable.Constraint_barrierDirection, 72);
        mapToConstant.append(R.styleable.Constraint_barrierMargin, 73);
        mapToConstant.append(R.styleable.Constraint_constraint_referenced_ids, 74);
        mapToConstant.append(R.styleable.Constraint_barrierAllowsGoneWidgets, 75);
        mapToConstant.append(R.styleable.Constraint_pathMotionArc, 76);
        mapToConstant.append(R.styleable.Constraint_layout_constraintTag, 77);
        mapToConstant.append(R.styleable.Constraint_visibilityMode, 78);
        mapToConstant.append(R.styleable.Constraint_layout_constrainedWidth, 80);
        mapToConstant.append(R.styleable.Constraint_layout_constrainedHeight, 81);
        mapToConstant.append(R.styleable.Constraint_polarRelativeTo, 82);
        mapToConstant.append(R.styleable.Constraint_transformPivotTarget, 83);
        mapToConstant.append(R.styleable.Constraint_quantizeMotionSteps, 84);
        mapToConstant.append(R.styleable.Constraint_quantizeMotionPhase, 85);
        mapToConstant.append(R.styleable.Constraint_quantizeMotionInterpolator, 86);
        overrideMapToConstant.append(R.styleable.ConstraintOverride_layout_editor_absoluteY, 6);
        overrideMapToConstant.append(R.styleable.ConstraintOverride_layout_editor_absoluteY, 7);
        overrideMapToConstant.append(R.styleable.ConstraintOverride_android_orientation, 27);
        overrideMapToConstant.append(R.styleable.ConstraintOverride_layout_goneMarginLeft, 13);
        overrideMapToConstant.append(R.styleable.ConstraintOverride_layout_goneMarginTop, 16);
        overrideMapToConstant.append(R.styleable.ConstraintOverride_layout_goneMarginRight, 14);
        overrideMapToConstant.append(R.styleable.ConstraintOverride_layout_goneMarginBottom, 11);
        overrideMapToConstant.append(R.styleable.ConstraintOverride_layout_goneMarginStart, 15);
        overrideMapToConstant.append(R.styleable.ConstraintOverride_layout_goneMarginEnd, 12);
        overrideMapToConstant.append(R.styleable.ConstraintOverride_layout_constraintVertical_weight, 40);
        overrideMapToConstant.append(R.styleable.ConstraintOverride_layout_constraintHorizontal_weight, 39);
        overrideMapToConstant.append(R.styleable.ConstraintOverride_layout_constraintHorizontal_chainStyle, 41);
        overrideMapToConstant.append(R.styleable.ConstraintOverride_layout_constraintVertical_chainStyle, 42);
        overrideMapToConstant.append(R.styleable.ConstraintOverride_layout_constraintHorizontal_bias, 20);
        overrideMapToConstant.append(R.styleable.ConstraintOverride_layout_constraintVertical_bias, 37);
        overrideMapToConstant.append(R.styleable.ConstraintOverride_layout_constraintDimensionRatio, 5);
        overrideMapToConstant.append(R.styleable.ConstraintOverride_layout_constraintLeft_creator, 87);
        overrideMapToConstant.append(R.styleable.ConstraintOverride_layout_constraintTop_creator, 87);
        overrideMapToConstant.append(R.styleable.ConstraintOverride_layout_constraintRight_creator, 87);
        overrideMapToConstant.append(R.styleable.ConstraintOverride_layout_constraintBottom_creator, 87);
        overrideMapToConstant.append(R.styleable.ConstraintOverride_layout_constraintBaseline_creator, 87);
        overrideMapToConstant.append(R.styleable.ConstraintOverride_android_layout_marginLeft, 24);
        overrideMapToConstant.append(R.styleable.ConstraintOverride_android_layout_marginRight, 28);
        overrideMapToConstant.append(R.styleable.ConstraintOverride_android_layout_marginStart, 31);
        overrideMapToConstant.append(R.styleable.ConstraintOverride_android_layout_marginEnd, 8);
        overrideMapToConstant.append(R.styleable.ConstraintOverride_android_layout_marginTop, 34);
        overrideMapToConstant.append(R.styleable.ConstraintOverride_android_layout_marginBottom, 2);
        overrideMapToConstant.append(R.styleable.ConstraintOverride_android_layout_width, 23);
        overrideMapToConstant.append(R.styleable.ConstraintOverride_android_layout_height, 21);
        overrideMapToConstant.append(R.styleable.ConstraintOverride_layout_constraintWidth, 95);
        overrideMapToConstant.append(R.styleable.ConstraintOverride_layout_constraintHeight, 96);
        overrideMapToConstant.append(R.styleable.ConstraintOverride_android_visibility, 22);
        overrideMapToConstant.append(R.styleable.ConstraintOverride_android_alpha, 43);
        overrideMapToConstant.append(R.styleable.ConstraintOverride_android_elevation, 44);
        overrideMapToConstant.append(R.styleable.ConstraintOverride_android_rotationX, 45);
        overrideMapToConstant.append(R.styleable.ConstraintOverride_android_rotationY, 46);
        overrideMapToConstant.append(R.styleable.ConstraintOverride_android_rotation, 60);
        overrideMapToConstant.append(R.styleable.ConstraintOverride_android_scaleX, 47);
        overrideMapToConstant.append(R.styleable.ConstraintOverride_android_scaleY, 48);
        overrideMapToConstant.append(R.styleable.ConstraintOverride_android_transformPivotX, 49);
        overrideMapToConstant.append(R.styleable.ConstraintOverride_android_transformPivotY, 50);
        overrideMapToConstant.append(R.styleable.ConstraintOverride_android_translationX, 51);
        overrideMapToConstant.append(R.styleable.ConstraintOverride_android_translationY, 52);
        overrideMapToConstant.append(R.styleable.ConstraintOverride_android_translationZ, 53);
        overrideMapToConstant.append(R.styleable.ConstraintOverride_layout_constraintWidth_default, 54);
        overrideMapToConstant.append(R.styleable.ConstraintOverride_layout_constraintHeight_default, 55);
        overrideMapToConstant.append(R.styleable.ConstraintOverride_layout_constraintWidth_max, 56);
        overrideMapToConstant.append(R.styleable.ConstraintOverride_layout_constraintHeight_max, 57);
        overrideMapToConstant.append(R.styleable.ConstraintOverride_layout_constraintWidth_min, 58);
        overrideMapToConstant.append(R.styleable.ConstraintOverride_layout_constraintHeight_min, 59);
        overrideMapToConstant.append(R.styleable.ConstraintOverride_layout_constraintCircleRadius, 62);
        overrideMapToConstant.append(R.styleable.ConstraintOverride_layout_constraintCircleAngle, 63);
        overrideMapToConstant.append(R.styleable.ConstraintOverride_animateRelativeTo, 64);
        overrideMapToConstant.append(R.styleable.ConstraintOverride_transitionEasing, 65);
        overrideMapToConstant.append(R.styleable.ConstraintOverride_drawPath, 66);
        overrideMapToConstant.append(R.styleable.ConstraintOverride_transitionPathRotate, 67);
        overrideMapToConstant.append(R.styleable.ConstraintOverride_motionStagger, 79);
        overrideMapToConstant.append(R.styleable.ConstraintOverride_android_id, 38);
        overrideMapToConstant.append(R.styleable.ConstraintOverride_motionTarget, 98);
        overrideMapToConstant.append(R.styleable.ConstraintOverride_motionProgress, 68);
        overrideMapToConstant.append(R.styleable.ConstraintOverride_layout_constraintWidth_percent, 69);
        overrideMapToConstant.append(R.styleable.ConstraintOverride_layout_constraintHeight_percent, 70);
        overrideMapToConstant.append(R.styleable.ConstraintOverride_chainUseRtl, 71);
        overrideMapToConstant.append(R.styleable.ConstraintOverride_barrierDirection, 72);
        overrideMapToConstant.append(R.styleable.ConstraintOverride_barrierMargin, 73);
        overrideMapToConstant.append(R.styleable.ConstraintOverride_constraint_referenced_ids, 74);
        overrideMapToConstant.append(R.styleable.ConstraintOverride_barrierAllowsGoneWidgets, 75);
        overrideMapToConstant.append(R.styleable.ConstraintOverride_pathMotionArc, 76);
        overrideMapToConstant.append(R.styleable.ConstraintOverride_layout_constraintTag, 77);
        overrideMapToConstant.append(R.styleable.ConstraintOverride_visibilityMode, 78);
        overrideMapToConstant.append(R.styleable.ConstraintOverride_layout_constrainedWidth, 80);
        overrideMapToConstant.append(R.styleable.ConstraintOverride_layout_constrainedHeight, 81);
        overrideMapToConstant.append(R.styleable.ConstraintOverride_polarRelativeTo, 82);
        overrideMapToConstant.append(R.styleable.ConstraintOverride_transformPivotTarget, 83);
        overrideMapToConstant.append(R.styleable.ConstraintOverride_quantizeMotionSteps, 84);
        overrideMapToConstant.append(R.styleable.ConstraintOverride_quantizeMotionPhase, 85);
        overrideMapToConstant.append(R.styleable.ConstraintOverride_quantizeMotionInterpolator, 86);
        overrideMapToConstant.append(R.styleable.ConstraintOverride_layout_wrapBehaviorInParent, 97);
    }

    class WriteJsonEngine {
        Writer writer;
        ConstraintLayout layout;
        Context context;
        int flags;
        int unknownCount = 0;
        final String LEFT = "'left'";
        final String RIGHT = "'right'";
        final String BASELINE = "'baseline'";
        final String BOTTOM = "'bottom'";
        final String TOP = "'top'";
        final String START = "'start'";
        final String END = "'end'";
        private static final String SPACE = "       ";
        HashMap<Integer, String> idMap = new HashMap();

        WriteJsonEngine(Writer writer, ConstraintLayout layout, int flags) throws IOException {
            this.writer = writer;
            this.layout = layout;
            this.context = layout.getContext();
            this.flags = flags;
        }

        void writeLayout() throws IOException {
            this.writer.write("\n'ConstraintSet':{\n");
            for (Integer id2 : ConstraintSet.this.mConstraints.keySet()) {
                Constraint c = (Constraint)ConstraintSet.this.mConstraints.get(id2);
                String idName = this.getName(id2);
                this.writer.write(idName + ":{\n");
                Layout l = c.layout;
                this.writeDimension("height", l.mHeight, l.heightDefault, l.heightPercent, l.heightMin, l.heightMax, l.constrainedHeight);
                this.writeDimension("width", l.mWidth, l.widthDefault, l.widthPercent, l.widthMin, l.widthMax, l.constrainedWidth);
                this.writeConstraint("'left'", l.leftToLeft, "'left'", l.leftMargin, l.goneLeftMargin);
                this.writeConstraint("'left'", l.leftToRight, "'right'", l.leftMargin, l.goneLeftMargin);
                this.writeConstraint("'right'", l.rightToLeft, "'left'", l.rightMargin, l.goneRightMargin);
                this.writeConstraint("'right'", l.rightToRight, "'right'", l.rightMargin, l.goneRightMargin);
                this.writeConstraint("'baseline'", l.baselineToBaseline, "'baseline'", -1, l.goneBaselineMargin);
                this.writeConstraint("'baseline'", l.baselineToTop, "'top'", -1, l.goneBaselineMargin);
                this.writeConstraint("'baseline'", l.baselineToBottom, "'bottom'", -1, l.goneBaselineMargin);
                this.writeConstraint("'top'", l.topToBottom, "'bottom'", l.topMargin, l.goneTopMargin);
                this.writeConstraint("'top'", l.topToTop, "'top'", l.topMargin, l.goneTopMargin);
                this.writeConstraint("'bottom'", l.bottomToBottom, "'bottom'", l.bottomMargin, l.goneBottomMargin);
                this.writeConstraint("'bottom'", l.bottomToTop, "'top'", l.bottomMargin, l.goneBottomMargin);
                this.writeConstraint("'start'", l.startToStart, "'start'", l.startMargin, l.goneStartMargin);
                this.writeConstraint("'start'", l.startToEnd, "'end'", l.startMargin, l.goneStartMargin);
                this.writeConstraint("'end'", l.endToStart, "'start'", l.endMargin, l.goneEndMargin);
                this.writeConstraint("'end'", l.endToEnd, "'end'", l.endMargin, l.goneEndMargin);
                this.writeVariable("'horizontalBias'", l.horizontalBias, 0.5f);
                this.writeVariable("'verticalBias'", l.verticalBias, 0.5f);
                this.writeCircle(l.circleConstraint, l.circleAngle, l.circleRadius);
                this.writeGuideline(l.orientation, l.guideBegin, l.guideEnd, l.guidePercent);
                this.writeVariable("'dimensionRatio'", l.dimensionRatio);
                this.writeVariable("'barrierMargin'", l.mBarrierMargin);
                this.writeVariable("'type'", l.mHelperType);
                this.writeVariable("'ReferenceId'", l.mReferenceIdString);
                this.writeVariable("'mBarrierAllowsGoneWidgets'", l.mBarrierAllowsGoneWidgets, true);
                this.writeVariable("'WrapBehavior'", l.mWrapBehavior);
                this.writeVariable("'verticalWeight'", l.verticalWeight);
                this.writeVariable("'horizontalWeight'", l.horizontalWeight);
                this.writeVariable("'horizontalChainStyle'", l.horizontalChainStyle);
                this.writeVariable("'verticalChainStyle'", l.verticalChainStyle);
                this.writeVariable("'barrierDirection'", l.mBarrierDirection);
                if (l.mReferenceIds != null) {
                    this.writeVariable("'ReferenceIds'", l.mReferenceIds);
                }
                this.writer.write("}\n");
            }
            this.writer.write("}\n");
        }

        private void writeGuideline(int orientation, int guideBegin, int guideEnd, float guidePercent) {
        }

        private void writeDimension(String dimString, int dim, int dimDefault, float dimPercent, int dimMin, int dimMax, boolean constrainedDim) throws IOException {
            if (dim == 0) {
                if (dimMax != -1 || dimMin != -1) {
                    switch (dimDefault) {
                        case 0: {
                            this.writer.write(SPACE + dimString + ": {'spread' ," + dimMin + ", " + dimMax + "}\n");
                            break;
                        }
                        case 1: {
                            this.writer.write(SPACE + dimString + ": {'wrap' ," + dimMin + ", " + dimMax + "}\n");
                            return;
                        }
                        case 2: {
                            this.writer.write(SPACE + dimString + ": {'" + dimPercent + "'% ," + dimMin + ", " + dimMax + "}\n");
                            return;
                        }
                    }
                    return;
                }
                switch (dimDefault) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        this.writer.write(SPACE + dimString + ": '???????????',\n");
                        return;
                    }
                    case 2: {
                        this.writer.write(SPACE + dimString + ": '" + dimPercent + "%',\n");
                        return;
                    }
                }
            } else if (dim == -2) {
                this.writer.write(SPACE + dimString + ": 'wrap'\n");
            } else if (dim == -1) {
                this.writer.write(SPACE + dimString + ": 'parent'\n");
            } else {
                this.writer.write(SPACE + dimString + ": " + dim + ",\n");
            }
        }

        String getName(int id2) {
            if (this.idMap.containsKey(id2)) {
                return "'" + this.idMap.get(id2) + "'";
            }
            if (id2 == 0) {
                return "'parent'";
            }
            String name = this.lookup(id2);
            this.idMap.put(id2, name);
            return "'" + name + "'";
        }

        String lookup(int id2) {
            try {
                if (id2 != -1) {
                    return this.context.getResources().getResourceEntryName(id2);
                }
                return "unknown" + ++this.unknownCount;
            }
            catch (Exception ex) {
                return "unknown" + ++this.unknownCount;
            }
        }

        void writeConstraint(String my, int leftToLeft, String other, int margin, int goneMargin) throws IOException {
            if (leftToLeft == -1) {
                return;
            }
            this.writer.write(SPACE + my);
            this.writer.write(":[");
            this.writer.write(this.getName(leftToLeft));
            this.writer.write(" , ");
            this.writer.write(other);
            if (margin != 0) {
                this.writer.write(" , " + margin);
            }
            this.writer.write("],\n");
        }

        void writeCircle(int circleConstraint, float circleAngle, int circleRadius) throws IOException {
            if (circleConstraint == -1) {
                return;
            }
            this.writer.write("       circle");
            this.writer.write(":[");
            this.writer.write(this.getName(circleConstraint));
            this.writer.write(", " + circleAngle);
            this.writer.write(circleRadius + "]");
        }

        void writeVariable(String name, int value) throws IOException {
            if (value == 0 || value == -1) {
                return;
            }
            this.writer.write(SPACE + name);
            this.writer.write(":");
            this.writer.write(", " + value);
            this.writer.write("\n");
        }

        void writeVariable(String name, float value) throws IOException {
            if (value == -1.0f) {
                return;
            }
            this.writer.write(SPACE + name);
            this.writer.write(": " + value);
            this.writer.write(",\n");
        }

        void writeVariable(String name, float value, float def) throws IOException {
            if (value == def) {
                return;
            }
            this.writer.write(SPACE + name);
            this.writer.write(": " + value);
            this.writer.write(",\n");
        }

        void writeVariable(String name, boolean value) throws IOException {
            if (!value) {
                return;
            }
            this.writer.write(SPACE + name);
            this.writer.write(": " + value);
            this.writer.write(",\n");
        }

        void writeVariable(String name, boolean value, boolean def) throws IOException {
            if (value == def) {
                return;
            }
            this.writer.write(SPACE + name);
            this.writer.write(": " + value);
            this.writer.write(",\n");
        }

        void writeVariable(String name, int[] value) throws IOException {
            if (value == null) {
                return;
            }
            this.writer.write(SPACE + name);
            this.writer.write(": ");
            for (int i = 0; i < value.length; ++i) {
                this.writer.write((i == 0 ? "[" : ", ") + this.getName(value[i]));
            }
            this.writer.write("],\n");
        }

        void writeVariable(String name, String value) throws IOException {
            if (value == null) {
                return;
            }
            this.writer.write(SPACE + name);
            this.writer.write(":");
            this.writer.write(", " + value);
            this.writer.write("\n");
        }
    }

    class WriteXmlEngine {
        Writer writer;
        ConstraintLayout layout;
        Context context;
        int flags;
        int unknownCount = 0;
        final String LEFT = "'left'";
        final String RIGHT = "'right'";
        final String BASELINE = "'baseline'";
        final String BOTTOM = "'bottom'";
        final String TOP = "'top'";
        final String START = "'start'";
        final String END = "'end'";
        private static final String SPACE = "\n       ";
        HashMap<Integer, String> idMap = new HashMap();

        WriteXmlEngine(Writer writer, ConstraintLayout layout, int flags) throws IOException {
            this.writer = writer;
            this.layout = layout;
            this.context = layout.getContext();
            this.flags = flags;
        }

        void writeLayout() throws IOException {
            this.writer.write("\n<ConstraintSet>\n");
            for (Integer id2 : ConstraintSet.this.mConstraints.keySet()) {
                Constraint c = (Constraint)ConstraintSet.this.mConstraints.get(id2);
                String idName = this.getName(id2);
                this.writer.write("  <Constraint");
                this.writer.write("\n       android:id=\"" + idName + "\"");
                Layout l = c.layout;
                this.writeBaseDimension("android:layout_width", l.mWidth, -5);
                this.writeBaseDimension("android:layout_height", l.mHeight, -5);
                this.writeVariable("app:layout_constraintGuide_begin", l.guideBegin, -1.0f);
                this.writeVariable("app:layout_constraintGuide_end", l.guideEnd, -1.0f);
                this.writeVariable("app:layout_constraintGuide_percent", l.guidePercent, -1.0f);
                this.writeVariable("app:layout_constraintHorizontal_bias", l.horizontalBias, 0.5f);
                this.writeVariable("app:layout_constraintVertical_bias", l.verticalBias, 0.5f);
                this.writeVariable("app:layout_constraintDimensionRatio", l.dimensionRatio, null);
                this.writeXmlConstraint("app:layout_constraintCircle", l.circleConstraint);
                this.writeVariable("app:layout_constraintCircleRadius", l.circleRadius, 0.0f);
                this.writeVariable("app:layout_constraintCircleAngle", l.circleAngle, 0.0f);
                this.writeVariable("android:orientation", l.orientation, -1.0f);
                this.writeVariable("app:layout_constraintVertical_weight", l.verticalWeight, -1.0f);
                this.writeVariable("app:layout_constraintHorizontal_weight", l.horizontalWeight, -1.0f);
                this.writeVariable("app:layout_constraintHorizontal_chainStyle", l.horizontalChainStyle, 0.0f);
                this.writeVariable("app:layout_constraintVertical_chainStyle", l.verticalChainStyle, 0.0f);
                this.writeVariable("app:barrierDirection", l.mBarrierDirection, -1.0f);
                this.writeVariable("app:barrierMargin", l.mBarrierMargin, 0.0f);
                this.writeDimension("app:layout_marginLeft", l.leftMargin, 0);
                this.writeDimension("app:layout_goneMarginLeft", l.goneLeftMargin, Integer.MIN_VALUE);
                this.writeDimension("app:layout_marginRight", l.rightMargin, 0);
                this.writeDimension("app:layout_goneMarginRight", l.goneRightMargin, Integer.MIN_VALUE);
                this.writeDimension("app:layout_marginStart", l.startMargin, 0);
                this.writeDimension("app:layout_goneMarginStart", l.goneStartMargin, Integer.MIN_VALUE);
                this.writeDimension("app:layout_marginEnd", l.endMargin, 0);
                this.writeDimension("app:layout_goneMarginEnd", l.goneEndMargin, Integer.MIN_VALUE);
                this.writeDimension("app:layout_marginTop", l.topMargin, 0);
                this.writeDimension("app:layout_goneMarginTop", l.goneTopMargin, Integer.MIN_VALUE);
                this.writeDimension("app:layout_marginBottom", l.bottomMargin, 0);
                this.writeDimension("app:layout_goneMarginBottom", l.goneBottomMargin, Integer.MIN_VALUE);
                this.writeDimension("app:goneBaselineMargin", l.goneBaselineMargin, Integer.MIN_VALUE);
                this.writeDimension("app:baselineMargin", l.baselineMargin, 0);
                this.writeBoolen("app:layout_constrainedWidth", l.constrainedWidth, false);
                this.writeBoolen("app:layout_constrainedHeight", l.constrainedHeight, false);
                this.writeBoolen("app:barrierAllowsGoneWidgets", l.mBarrierAllowsGoneWidgets, true);
                this.writeVariable("app:layout_wrapBehaviorInParent", l.mWrapBehavior, 0.0f);
                this.writeXmlConstraint("app:baselineToBaseline", l.baselineToBaseline);
                this.writeXmlConstraint("app:baselineToBottom", l.baselineToBottom);
                this.writeXmlConstraint("app:baselineToTop", l.baselineToTop);
                this.writeXmlConstraint("app:layout_constraintBottom_toBottomOf", l.bottomToBottom);
                this.writeXmlConstraint("app:layout_constraintBottom_toTopOf", l.bottomToTop);
                this.writeXmlConstraint("app:layout_constraintEnd_toEndOf", l.endToEnd);
                this.writeXmlConstraint("app:layout_constraintEnd_toStartOf", l.endToStart);
                this.writeXmlConstraint("app:layout_constraintLeft_toLeftOf", l.leftToLeft);
                this.writeXmlConstraint("app:layout_constraintLeft_toRightOf", l.leftToRight);
                this.writeXmlConstraint("app:layout_constraintRight_toLeftOf", l.rightToLeft);
                this.writeXmlConstraint("app:layout_constraintRight_toRightOf", l.rightToRight);
                this.writeXmlConstraint("app:layout_constraintStart_toEndOf", l.startToEnd);
                this.writeXmlConstraint("app:layout_constraintStart_toStartOf", l.startToStart);
                this.writeXmlConstraint("app:layout_constraintTop_toBottomOf", l.topToBottom);
                this.writeXmlConstraint("app:layout_constraintTop_toTopOf", l.topToTop);
                String[] typesConstraintDefault = new String[]{"spread", "wrap", "percent"};
                this.writeEnum("app:layout_constraintHeight_default", l.heightDefault, typesConstraintDefault, 0);
                this.writeVariable("app:layout_constraintHeight_percent", l.heightPercent, 1.0f);
                this.writeDimension("app:layout_constraintHeight_min", l.heightMin, 0);
                this.writeDimension("app:layout_constraintHeight_max", l.heightMax, 0);
                this.writeBoolen("android:layout_constrainedHeight", l.constrainedHeight, false);
                this.writeEnum("app:layout_constraintWidth_default", l.widthDefault, typesConstraintDefault, 0);
                this.writeVariable("app:layout_constraintWidth_percent", l.widthPercent, 1.0f);
                this.writeDimension("app:layout_constraintWidth_min", l.widthMin, 0);
                this.writeDimension("app:layout_constraintWidth_max", l.widthMax, 0);
                this.writeBoolen("android:layout_constrainedWidth", l.constrainedWidth, false);
                this.writeVariable("app:layout_constraintVertical_weight", l.verticalWeight, -1.0f);
                this.writeVariable("app:layout_constraintHorizontal_weight", l.horizontalWeight, -1.0f);
                this.writeVariable("app:layout_constraintHorizontal_chainStyle", l.horizontalChainStyle);
                this.writeVariable("app:layout_constraintVertical_chainStyle", l.verticalChainStyle);
                String[] barrierDir = new String[]{"left", "right", "top", "bottom", "start", "end"};
                this.writeEnum("app:barrierDirection", l.mBarrierDirection, barrierDir, -1);
                this.writeVariable("app:layout_constraintTag", l.mConstraintTag, null);
                if (l.mReferenceIds != null) {
                    this.writeVariable("'ReferenceIds'", l.mReferenceIds);
                }
                this.writer.write(" />\n");
            }
            this.writer.write("</ConstraintSet>\n");
        }

        private void writeBoolen(String dimString, boolean val, boolean def) throws IOException {
            if (val != def) {
                this.writer.write(SPACE + dimString + "=\"" + val + "dp\"");
            }
        }

        private void writeEnum(String dimString, int val, String[] types, int def) throws IOException {
            if (val != def) {
                this.writer.write(SPACE + dimString + "=\"" + types[val] + "\"");
            }
        }

        private void writeDimension(String dimString, int dim, int def) throws IOException {
            if (dim != def) {
                this.writer.write(SPACE + dimString + "=\"" + dim + "dp\"");
            }
        }

        private void writeBaseDimension(String dimString, int dim, int def) throws IOException {
            if (dim != def) {
                if (dim == -2) {
                    this.writer.write(SPACE + dimString + "=\"wrap_content\"");
                } else if (dim == -1) {
                    this.writer.write(SPACE + dimString + "=\"match_parent\"");
                } else {
                    this.writer.write(SPACE + dimString + "=\"" + dim + "dp\"");
                }
            }
        }

        String getName(int id2) {
            if (this.idMap.containsKey(id2)) {
                return "@+id/" + this.idMap.get(id2) + "";
            }
            if (id2 == 0) {
                return ConstraintSet.KEY_PERCENT_PARENT;
            }
            String name = this.lookup(id2);
            this.idMap.put(id2, name);
            return "@+id/" + name + "";
        }

        String lookup(int id2) {
            try {
                if (id2 != -1) {
                    return this.context.getResources().getResourceEntryName(id2);
                }
                return "unknown" + ++this.unknownCount;
            }
            catch (Exception ex) {
                return "unknown" + ++this.unknownCount;
            }
        }

        void writeXmlConstraint(String str, int leftToLeft) throws IOException {
            if (leftToLeft == -1) {
                return;
            }
            this.writer.write(SPACE + str);
            this.writer.write("=\"" + this.getName(leftToLeft) + "\"");
        }

        void writeConstraint(String my, int leftToLeft, String other, int margin, int goneMargin) throws IOException {
            if (leftToLeft == -1) {
                return;
            }
            this.writer.write(SPACE + my);
            this.writer.write(":[");
            this.writer.write(this.getName(leftToLeft));
            this.writer.write(" , ");
            this.writer.write(other);
            if (margin != 0) {
                this.writer.write(" , " + margin);
            }
            this.writer.write("],\n");
        }

        void writeCircle(int circleConstraint, float circleAngle, int circleRadius) throws IOException {
            if (circleConstraint == -1) {
                return;
            }
            this.writer.write("circle");
            this.writer.write(":[");
            this.writer.write(this.getName(circleConstraint));
            this.writer.write(", " + circleAngle);
            this.writer.write(circleRadius + "]");
        }

        void writeVariable(String name, int value) throws IOException {
            if (value == 0 || value == -1) {
                return;
            }
            this.writer.write(SPACE + name + "=\"" + value + "\"\n");
        }

        void writeVariable(String name, float value, float def) throws IOException {
            if (value == def) {
                return;
            }
            this.writer.write(SPACE + name);
            this.writer.write("=\"" + value + "\"");
        }

        void writeVariable(String name, String value, String def) throws IOException {
            if (value == null || value.equals(def)) {
                return;
            }
            this.writer.write(SPACE + name);
            this.writer.write("=\"" + value + "\"");
        }

        void writeVariable(String name, int[] value) throws IOException {
            if (value == null) {
                return;
            }
            this.writer.write(SPACE + name);
            this.writer.write(":");
            for (int i = 0; i < value.length; ++i) {
                this.writer.write((i == 0 ? "[" : ", ") + this.getName(value[i]));
            }
            this.writer.write("],\n");
        }

        void writeVariable(String name, String value) throws IOException {
            if (value == null) {
                return;
            }
            this.writer.write(name);
            this.writer.write(":");
            this.writer.write(", " + value);
            this.writer.write("\n");
        }
    }

    public static class Constraint {
        int mViewId;
        String mTargetString;
        public final PropertySet propertySet = new PropertySet();
        public final Motion motion = new Motion();
        public final Layout layout = new Layout();
        public final Transform transform = new Transform();
        public HashMap<String, ConstraintAttribute> mCustomConstraints = new HashMap();
        Delta mDelta;

        public void applyDelta(Constraint c) {
            if (this.mDelta != null) {
                this.mDelta.applyDelta(c);
            }
        }

        public void printDelta(String tag) {
            if (this.mDelta != null) {
                this.mDelta.printDelta(tag);
            } else {
                Log.v((String)tag, (String)"DELTA IS NULL");
            }
        }

        private ConstraintAttribute get(String attributeName, ConstraintAttribute.AttributeType attributeType) {
            ConstraintAttribute ret;
            if (this.mCustomConstraints.containsKey(attributeName)) {
                ret = this.mCustomConstraints.get(attributeName);
                if (ret.getType() != attributeType) {
                    throw new IllegalArgumentException("ConstraintAttribute is already a " + ret.getType().name());
                }
            } else {
                ret = new ConstraintAttribute(attributeName, attributeType);
                this.mCustomConstraints.put(attributeName, ret);
            }
            return ret;
        }

        private void setStringValue(String attributeName, String value) {
            this.get(attributeName, ConstraintAttribute.AttributeType.STRING_TYPE).setStringValue(value);
        }

        private void setFloatValue(String attributeName, float value) {
            this.get(attributeName, ConstraintAttribute.AttributeType.FLOAT_TYPE).setFloatValue(value);
        }

        private void setIntValue(String attributeName, int value) {
            this.get(attributeName, ConstraintAttribute.AttributeType.INT_TYPE).setIntValue(value);
        }

        private void setColorValue(String attributeName, int value) {
            this.get(attributeName, ConstraintAttribute.AttributeType.COLOR_TYPE).setColorValue(value);
        }

        public Constraint clone() {
            Constraint clone = new Constraint();
            clone.layout.copyFrom(this.layout);
            clone.motion.copyFrom(this.motion);
            clone.propertySet.copyFrom(this.propertySet);
            clone.transform.copyFrom(this.transform);
            clone.mViewId = this.mViewId;
            clone.mDelta = this.mDelta;
            return clone;
        }

        private void fillFromConstraints(ConstraintHelper helper, int viewId, Constraints.LayoutParams param) {
            this.fillFromConstraints(viewId, param);
            if (helper instanceof Barrier) {
                this.layout.mHelperType = 1;
                Barrier barrier = (Barrier)helper;
                this.layout.mBarrierDirection = barrier.getType();
                this.layout.mReferenceIds = barrier.getReferencedIds();
                this.layout.mBarrierMargin = barrier.getMargin();
            }
        }

        private void fillFromConstraints(int viewId, Constraints.LayoutParams param) {
            this.fillFrom(viewId, param);
            this.propertySet.alpha = param.alpha;
            this.transform.rotation = param.rotation;
            this.transform.rotationX = param.rotationX;
            this.transform.rotationY = param.rotationY;
            this.transform.scaleX = param.scaleX;
            this.transform.scaleY = param.scaleY;
            this.transform.transformPivotX = param.transformPivotX;
            this.transform.transformPivotY = param.transformPivotY;
            this.transform.translationX = param.translationX;
            this.transform.translationY = param.translationY;
            this.transform.translationZ = param.translationZ;
            this.transform.elevation = param.elevation;
            this.transform.applyElevation = param.applyElevation;
        }

        private void fillFrom(int viewId, ConstraintLayout.LayoutParams param) {
            this.mViewId = viewId;
            this.layout.leftToLeft = param.leftToLeft;
            this.layout.leftToRight = param.leftToRight;
            this.layout.rightToLeft = param.rightToLeft;
            this.layout.rightToRight = param.rightToRight;
            this.layout.topToTop = param.topToTop;
            this.layout.topToBottom = param.topToBottom;
            this.layout.bottomToTop = param.bottomToTop;
            this.layout.bottomToBottom = param.bottomToBottom;
            this.layout.baselineToBaseline = param.baselineToBaseline;
            this.layout.baselineToTop = param.baselineToTop;
            this.layout.baselineToBottom = param.baselineToBottom;
            this.layout.startToEnd = param.startToEnd;
            this.layout.startToStart = param.startToStart;
            this.layout.endToStart = param.endToStart;
            this.layout.endToEnd = param.endToEnd;
            this.layout.horizontalBias = param.horizontalBias;
            this.layout.verticalBias = param.verticalBias;
            this.layout.dimensionRatio = param.dimensionRatio;
            this.layout.circleConstraint = param.circleConstraint;
            this.layout.circleRadius = param.circleRadius;
            this.layout.circleAngle = param.circleAngle;
            this.layout.editorAbsoluteX = param.editorAbsoluteX;
            this.layout.editorAbsoluteY = param.editorAbsoluteY;
            this.layout.orientation = param.orientation;
            this.layout.guidePercent = param.guidePercent;
            this.layout.guideBegin = param.guideBegin;
            this.layout.guideEnd = param.guideEnd;
            this.layout.mWidth = param.width;
            this.layout.mHeight = param.height;
            this.layout.leftMargin = param.leftMargin;
            this.layout.rightMargin = param.rightMargin;
            this.layout.topMargin = param.topMargin;
            this.layout.bottomMargin = param.bottomMargin;
            this.layout.baselineMargin = param.baselineMargin;
            this.layout.verticalWeight = param.verticalWeight;
            this.layout.horizontalWeight = param.horizontalWeight;
            this.layout.verticalChainStyle = param.verticalChainStyle;
            this.layout.horizontalChainStyle = param.horizontalChainStyle;
            this.layout.constrainedWidth = param.constrainedWidth;
            this.layout.constrainedHeight = param.constrainedHeight;
            this.layout.widthDefault = param.matchConstraintDefaultWidth;
            this.layout.heightDefault = param.matchConstraintDefaultHeight;
            this.layout.widthMax = param.matchConstraintMaxWidth;
            this.layout.heightMax = param.matchConstraintMaxHeight;
            this.layout.widthMin = param.matchConstraintMinWidth;
            this.layout.heightMin = param.matchConstraintMinHeight;
            this.layout.widthPercent = param.matchConstraintPercentWidth;
            this.layout.heightPercent = param.matchConstraintPercentHeight;
            this.layout.mConstraintTag = param.constraintTag;
            this.layout.goneTopMargin = param.goneTopMargin;
            this.layout.goneBottomMargin = param.goneBottomMargin;
            this.layout.goneLeftMargin = param.goneLeftMargin;
            this.layout.goneRightMargin = param.goneRightMargin;
            this.layout.goneStartMargin = param.goneStartMargin;
            this.layout.goneEndMargin = param.goneEndMargin;
            this.layout.goneBaselineMargin = param.goneBaselineMargin;
            this.layout.mWrapBehavior = param.wrapBehaviorInParent;
            int currentApiVersion = Build.VERSION.SDK_INT;
            if (currentApiVersion >= 17) {
                this.layout.endMargin = param.getMarginEnd();
                this.layout.startMargin = param.getMarginStart();
            }
        }

        public void applyTo(ConstraintLayout.LayoutParams param) {
            param.leftToLeft = this.layout.leftToLeft;
            param.leftToRight = this.layout.leftToRight;
            param.rightToLeft = this.layout.rightToLeft;
            param.rightToRight = this.layout.rightToRight;
            param.topToTop = this.layout.topToTop;
            param.topToBottom = this.layout.topToBottom;
            param.bottomToTop = this.layout.bottomToTop;
            param.bottomToBottom = this.layout.bottomToBottom;
            param.baselineToBaseline = this.layout.baselineToBaseline;
            param.baselineToTop = this.layout.baselineToTop;
            param.baselineToBottom = this.layout.baselineToBottom;
            param.startToEnd = this.layout.startToEnd;
            param.startToStart = this.layout.startToStart;
            param.endToStart = this.layout.endToStart;
            param.endToEnd = this.layout.endToEnd;
            param.leftMargin = this.layout.leftMargin;
            param.rightMargin = this.layout.rightMargin;
            param.topMargin = this.layout.topMargin;
            param.bottomMargin = this.layout.bottomMargin;
            param.goneStartMargin = this.layout.goneStartMargin;
            param.goneEndMargin = this.layout.goneEndMargin;
            param.goneTopMargin = this.layout.goneTopMargin;
            param.goneBottomMargin = this.layout.goneBottomMargin;
            param.horizontalBias = this.layout.horizontalBias;
            param.verticalBias = this.layout.verticalBias;
            param.circleConstraint = this.layout.circleConstraint;
            param.circleRadius = this.layout.circleRadius;
            param.circleAngle = this.layout.circleAngle;
            param.dimensionRatio = this.layout.dimensionRatio;
            param.editorAbsoluteX = this.layout.editorAbsoluteX;
            param.editorAbsoluteY = this.layout.editorAbsoluteY;
            param.verticalWeight = this.layout.verticalWeight;
            param.horizontalWeight = this.layout.horizontalWeight;
            param.verticalChainStyle = this.layout.verticalChainStyle;
            param.horizontalChainStyle = this.layout.horizontalChainStyle;
            param.constrainedWidth = this.layout.constrainedWidth;
            param.constrainedHeight = this.layout.constrainedHeight;
            param.matchConstraintDefaultWidth = this.layout.widthDefault;
            param.matchConstraintDefaultHeight = this.layout.heightDefault;
            param.matchConstraintMaxWidth = this.layout.widthMax;
            param.matchConstraintMaxHeight = this.layout.heightMax;
            param.matchConstraintMinWidth = this.layout.widthMin;
            param.matchConstraintMinHeight = this.layout.heightMin;
            param.matchConstraintPercentWidth = this.layout.widthPercent;
            param.matchConstraintPercentHeight = this.layout.heightPercent;
            param.orientation = this.layout.orientation;
            param.guidePercent = this.layout.guidePercent;
            param.guideBegin = this.layout.guideBegin;
            param.guideEnd = this.layout.guideEnd;
            param.width = this.layout.mWidth;
            param.height = this.layout.mHeight;
            if (this.layout.mConstraintTag != null) {
                param.constraintTag = this.layout.mConstraintTag;
            }
            param.wrapBehaviorInParent = this.layout.mWrapBehavior;
            if (Build.VERSION.SDK_INT >= 17) {
                param.setMarginStart(this.layout.startMargin);
                param.setMarginEnd(this.layout.endMargin);
            }
            param.validate();
        }

        static class Delta {
            private static final int INITIAL_BOOLEAN = 4;
            private static final int INITIAL_INT = 10;
            private static final int INITIAL_FLOAT = 10;
            private static final int INITIAL_STRING = 5;
            int[] mTypeInt = new int[10];
            int[] mValueInt = new int[10];
            int mCountInt = 0;
            int[] mTypeFloat = new int[10];
            float[] mValueFloat = new float[10];
            int mCountFloat = 0;
            int[] mTypeString = new int[5];
            String[] mValueString = new String[5];
            int mCountString = 0;
            int[] mTypeBoolean = new int[4];
            boolean[] mValueBoolean = new boolean[4];
            int mCountBoolean = 0;

            Delta() {
            }

            void add(int type, int value) {
                if (this.mCountInt >= this.mTypeInt.length) {
                    this.mTypeInt = Arrays.copyOf(this.mTypeInt, this.mTypeInt.length * 2);
                    this.mValueInt = Arrays.copyOf(this.mValueInt, this.mValueInt.length * 2);
                }
                this.mTypeInt[this.mCountInt] = type;
                this.mValueInt[this.mCountInt++] = value;
            }

            void add(int type, float value) {
                if (this.mCountFloat >= this.mTypeFloat.length) {
                    this.mTypeFloat = Arrays.copyOf(this.mTypeFloat, this.mTypeFloat.length * 2);
                    this.mValueFloat = Arrays.copyOf(this.mValueFloat, this.mValueFloat.length * 2);
                }
                this.mTypeFloat[this.mCountFloat] = type;
                this.mValueFloat[this.mCountFloat++] = value;
            }

            void add(int type, String value) {
                if (this.mCountString >= this.mTypeString.length) {
                    this.mTypeString = Arrays.copyOf(this.mTypeString, this.mTypeString.length * 2);
                    this.mValueString = Arrays.copyOf(this.mValueString, this.mValueString.length * 2);
                }
                this.mTypeString[this.mCountString] = type;
                this.mValueString[this.mCountString++] = value;
            }

            void add(int type, boolean value) {
                if (this.mCountBoolean >= this.mTypeBoolean.length) {
                    this.mTypeBoolean = Arrays.copyOf(this.mTypeBoolean, this.mTypeBoolean.length * 2);
                    this.mValueBoolean = Arrays.copyOf(this.mValueBoolean, this.mValueBoolean.length * 2);
                }
                this.mTypeBoolean[this.mCountBoolean] = type;
                this.mValueBoolean[this.mCountBoolean++] = value;
            }

            void applyDelta(Constraint c) {
                int i;
                for (i = 0; i < this.mCountInt; ++i) {
                    ConstraintSet.setDeltaValue(c, this.mTypeInt[i], this.mValueInt[i]);
                }
                for (i = 0; i < this.mCountFloat; ++i) {
                    ConstraintSet.setDeltaValue(c, this.mTypeFloat[i], this.mValueFloat[i]);
                }
                for (i = 0; i < this.mCountString; ++i) {
                    ConstraintSet.setDeltaValue(c, this.mTypeString[i], this.mValueString[i]);
                }
                for (i = 0; i < this.mCountBoolean; ++i) {
                    ConstraintSet.setDeltaValue(c, this.mTypeBoolean[i], this.mValueBoolean[i]);
                }
            }

            @SuppressLint(value={"LogConditional"})
            void printDelta(String tag) {
                int i;
                Log.v((String)tag, (String)"int");
                for (i = 0; i < this.mCountInt; ++i) {
                    Log.v((String)tag, (String)(this.mTypeInt[i] + " = " + this.mValueInt[i]));
                }
                Log.v((String)tag, (String)"float");
                for (i = 0; i < this.mCountFloat; ++i) {
                    Log.v((String)tag, (String)(this.mTypeFloat[i] + " = " + this.mValueFloat[i]));
                }
                Log.v((String)tag, (String)"strings");
                for (i = 0; i < this.mCountString; ++i) {
                    Log.v((String)tag, (String)(this.mTypeString[i] + " = " + this.mValueString[i]));
                }
                Log.v((String)tag, (String)"boolean");
                for (i = 0; i < this.mCountBoolean; ++i) {
                    Log.v((String)tag, (String)(this.mTypeBoolean[i] + " = " + this.mValueBoolean[i]));
                }
            }
        }
    }

    public static class Motion {
        public boolean mApply = false;
        public int mAnimateRelativeTo = -1;
        public int mAnimateCircleAngleTo = 0;
        public String mTransitionEasing = null;
        public int mPathMotionArc = -1;
        public int mDrawPath = 0;
        public float mMotionStagger = Float.NaN;
        public int mPolarRelativeTo = -1;
        public float mPathRotate = Float.NaN;
        public float mQuantizeMotionPhase = Float.NaN;
        public int mQuantizeMotionSteps = -1;
        public String mQuantizeInterpolatorString = null;
        public int mQuantizeInterpolatorType = -3;
        public int mQuantizeInterpolatorID = -1;
        private static final int INTERPOLATOR_REFERENCE_ID = -2;
        private static final int SPLINE_STRING = -1;
        private static final int INTERPOLATOR_UNDEFINED = -3;
        private static SparseIntArray mapToConstant = new SparseIntArray();
        private static final int TRANSITION_PATH_ROTATE = 1;
        private static final int PATH_MOTION_ARC = 2;
        private static final int TRANSITION_EASING = 3;
        private static final int MOTION_DRAW_PATH = 4;
        private static final int ANIMATE_RELATIVE_TO = 5;
        private static final int ANIMATE_CIRCLE_ANGLE_TO = 6;
        private static final int MOTION_STAGGER = 7;
        private static final int QUANTIZE_MOTION_STEPS = 8;
        private static final int QUANTIZE_MOTION_PHASE = 9;
        private static final int QUANTIZE_MOTION_INTERPOLATOR = 10;

        public void copyFrom(Motion src) {
            this.mApply = src.mApply;
            this.mAnimateRelativeTo = src.mAnimateRelativeTo;
            this.mTransitionEasing = src.mTransitionEasing;
            this.mPathMotionArc = src.mPathMotionArc;
            this.mDrawPath = src.mDrawPath;
            this.mPathRotate = src.mPathRotate;
            this.mMotionStagger = src.mMotionStagger;
            this.mPolarRelativeTo = src.mPolarRelativeTo;
        }

        void fillFromAttributeList(Context context, AttributeSet attrs) {
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.Motion);
            this.mApply = true;
            int N = a.getIndexCount();
            block12: for (int i = 0; i < N; ++i) {
                int attr2 = a.getIndex(i);
                switch (mapToConstant.get(attr2)) {
                    case 1: {
                        this.mPathRotate = a.getFloat(attr2, this.mPathRotate);
                        continue block12;
                    }
                    case 2: {
                        this.mPathMotionArc = a.getInt(attr2, this.mPathMotionArc);
                        continue block12;
                    }
                    case 3: {
                        TypedValue type = a.peekValue(attr2);
                        if (type.type == 3) {
                            this.mTransitionEasing = a.getString(attr2);
                            continue block12;
                        }
                        this.mTransitionEasing = Easing.NAMED_EASING[a.getInteger(attr2, 0)];
                        continue block12;
                    }
                    case 4: {
                        this.mDrawPath = a.getInt(attr2, 0);
                        continue block12;
                    }
                    case 5: {
                        this.mAnimateRelativeTo = ConstraintSet.lookupID(a, attr2, this.mAnimateRelativeTo);
                        continue block12;
                    }
                    case 6: {
                        this.mAnimateCircleAngleTo = a.getInteger(attr2, this.mAnimateCircleAngleTo);
                        continue block12;
                    }
                    case 7: {
                        this.mMotionStagger = a.getFloat(attr2, this.mMotionStagger);
                        continue block12;
                    }
                    case 8: {
                        this.mQuantizeMotionSteps = a.getInteger(attr2, this.mQuantizeMotionSteps);
                        continue block12;
                    }
                    case 9: {
                        this.mQuantizeMotionPhase = a.getFloat(attr2, this.mQuantizeMotionPhase);
                        continue block12;
                    }
                    case 10: {
                        TypedValue type = a.peekValue(attr2);
                        if (type.type == 1) {
                            this.mQuantizeInterpolatorID = a.getResourceId(attr2, -1);
                            if (this.mQuantizeInterpolatorID == -1) continue block12;
                            this.mQuantizeInterpolatorType = -2;
                            continue block12;
                        }
                        if (type.type == 3) {
                            this.mQuantizeInterpolatorString = a.getString(attr2);
                            if (this.mQuantizeInterpolatorString.indexOf("/") > 0) {
                                this.mQuantizeInterpolatorID = a.getResourceId(attr2, -1);
                                this.mQuantizeInterpolatorType = -2;
                                continue block12;
                            }
                            this.mQuantizeInterpolatorType = -1;
                            continue block12;
                        }
                        this.mQuantizeInterpolatorType = a.getInteger(attr2, this.mQuantizeInterpolatorID);
                    }
                }
            }
            a.recycle();
        }

        static {
            mapToConstant.append(R.styleable.Motion_motionPathRotate, 1);
            mapToConstant.append(R.styleable.Motion_pathMotionArc, 2);
            mapToConstant.append(R.styleable.Motion_transitionEasing, 3);
            mapToConstant.append(R.styleable.Motion_drawPath, 4);
            mapToConstant.append(R.styleable.Motion_animateRelativeTo, 5);
            mapToConstant.append(R.styleable.Motion_animateCircleAngleTo, 6);
            mapToConstant.append(R.styleable.Motion_motionStagger, 7);
            mapToConstant.append(R.styleable.Motion_quantizeMotionSteps, 8);
            mapToConstant.append(R.styleable.Motion_quantizeMotionPhase, 9);
            mapToConstant.append(R.styleable.Motion_quantizeMotionInterpolator, 10);
        }
    }

    public static class PropertySet {
        public boolean mApply = false;
        public int visibility = 0;
        public int mVisibilityMode = 0;
        public float alpha = 1.0f;
        public float mProgress = Float.NaN;

        public void copyFrom(PropertySet src) {
            this.mApply = src.mApply;
            this.visibility = src.visibility;
            this.alpha = src.alpha;
            this.mProgress = src.mProgress;
            this.mVisibilityMode = src.mVisibilityMode;
        }

        void fillFromAttributeList(Context context, AttributeSet attrs) {
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.PropertySet);
            this.mApply = true;
            int N = a.getIndexCount();
            for (int i = 0; i < N; ++i) {
                int attr2 = a.getIndex(i);
                if (attr2 == R.styleable.PropertySet_android_alpha) {
                    this.alpha = a.getFloat(attr2, this.alpha);
                    continue;
                }
                if (attr2 == R.styleable.PropertySet_android_visibility) {
                    this.visibility = a.getInt(attr2, this.visibility);
                    this.visibility = VISIBILITY_FLAGS[this.visibility];
                    continue;
                }
                if (attr2 == R.styleable.PropertySet_visibilityMode) {
                    this.mVisibilityMode = a.getInt(attr2, this.mVisibilityMode);
                    continue;
                }
                if (attr2 != R.styleable.PropertySet_motionProgress) continue;
                this.mProgress = a.getFloat(attr2, this.mProgress);
            }
            a.recycle();
        }
    }

    public static class Transform {
        public boolean mApply = false;
        public float rotation = 0.0f;
        public float rotationX = 0.0f;
        public float rotationY = 0.0f;
        public float scaleX = 1.0f;
        public float scaleY = 1.0f;
        public float transformPivotX = Float.NaN;
        public float transformPivotY = Float.NaN;
        public int transformPivotTarget = -1;
        public float translationX = 0.0f;
        public float translationY = 0.0f;
        public float translationZ = 0.0f;
        public boolean applyElevation = false;
        public float elevation = 0.0f;
        private static SparseIntArray mapToConstant = new SparseIntArray();
        private static final int ROTATION = 1;
        private static final int ROTATION_X = 2;
        private static final int ROTATION_Y = 3;
        private static final int SCALE_X = 4;
        private static final int SCALE_Y = 5;
        private static final int TRANSFORM_PIVOT_X = 6;
        private static final int TRANSFORM_PIVOT_Y = 7;
        private static final int TRANSLATION_X = 8;
        private static final int TRANSLATION_Y = 9;
        private static final int TRANSLATION_Z = 10;
        private static final int ELEVATION = 11;
        private static final int TRANSFORM_PIVOT_TARGET = 12;

        public void copyFrom(Transform src) {
            this.mApply = src.mApply;
            this.rotation = src.rotation;
            this.rotationX = src.rotationX;
            this.rotationY = src.rotationY;
            this.scaleX = src.scaleX;
            this.scaleY = src.scaleY;
            this.transformPivotX = src.transformPivotX;
            this.transformPivotY = src.transformPivotY;
            this.transformPivotTarget = src.transformPivotTarget;
            this.translationX = src.translationX;
            this.translationY = src.translationY;
            this.translationZ = src.translationZ;
            this.applyElevation = src.applyElevation;
            this.elevation = src.elevation;
        }

        void fillFromAttributeList(Context context, AttributeSet attrs) {
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.Transform);
            this.mApply = true;
            int N = a.getIndexCount();
            block14: for (int i = 0; i < N; ++i) {
                int attr2 = a.getIndex(i);
                switch (mapToConstant.get(attr2)) {
                    case 1: {
                        this.rotation = a.getFloat(attr2, this.rotation);
                        continue block14;
                    }
                    case 2: {
                        this.rotationX = a.getFloat(attr2, this.rotationX);
                        continue block14;
                    }
                    case 3: {
                        this.rotationY = a.getFloat(attr2, this.rotationY);
                        continue block14;
                    }
                    case 4: {
                        this.scaleX = a.getFloat(attr2, this.scaleX);
                        continue block14;
                    }
                    case 5: {
                        this.scaleY = a.getFloat(attr2, this.scaleY);
                        continue block14;
                    }
                    case 6: {
                        this.transformPivotX = a.getDimension(attr2, this.transformPivotX);
                        continue block14;
                    }
                    case 7: {
                        this.transformPivotY = a.getDimension(attr2, this.transformPivotY);
                        continue block14;
                    }
                    case 12: {
                        this.transformPivotTarget = ConstraintSet.lookupID(a, attr2, this.transformPivotTarget);
                        continue block14;
                    }
                    case 8: {
                        this.translationX = a.getDimension(attr2, this.translationX);
                        continue block14;
                    }
                    case 9: {
                        this.translationY = a.getDimension(attr2, this.translationY);
                        continue block14;
                    }
                    case 10: {
                        if (Build.VERSION.SDK_INT < 21) continue block14;
                        this.translationZ = a.getDimension(attr2, this.translationZ);
                        continue block14;
                    }
                    case 11: {
                        if (Build.VERSION.SDK_INT < 21) continue block14;
                        this.applyElevation = true;
                        this.elevation = a.getDimension(attr2, this.elevation);
                    }
                }
            }
            a.recycle();
        }

        static {
            mapToConstant.append(R.styleable.Transform_android_rotation, 1);
            mapToConstant.append(R.styleable.Transform_android_rotationX, 2);
            mapToConstant.append(R.styleable.Transform_android_rotationY, 3);
            mapToConstant.append(R.styleable.Transform_android_scaleX, 4);
            mapToConstant.append(R.styleable.Transform_android_scaleY, 5);
            mapToConstant.append(R.styleable.Transform_android_transformPivotX, 6);
            mapToConstant.append(R.styleable.Transform_android_transformPivotY, 7);
            mapToConstant.append(R.styleable.Transform_android_translationX, 8);
            mapToConstant.append(R.styleable.Transform_android_translationY, 9);
            mapToConstant.append(R.styleable.Transform_android_translationZ, 10);
            mapToConstant.append(R.styleable.Transform_android_elevation, 11);
            mapToConstant.append(R.styleable.Transform_transformPivotTarget, 12);
        }
    }

    public static class Layout {
        public boolean mIsGuideline = false;
        public boolean mApply = false;
        public boolean mOverride = false;
        public int mWidth;
        public int mHeight;
        public static final int UNSET = -1;
        public static final int UNSET_GONE_MARGIN = Integer.MIN_VALUE;
        public int guideBegin = -1;
        public int guideEnd = -1;
        public float guidePercent = -1.0f;
        public boolean guidelineUseRtl = true;
        public int leftToLeft = -1;
        public int leftToRight = -1;
        public int rightToLeft = -1;
        public int rightToRight = -1;
        public int topToTop = -1;
        public int topToBottom = -1;
        public int bottomToTop = -1;
        public int bottomToBottom = -1;
        public int baselineToBaseline = -1;
        public int baselineToTop = -1;
        public int baselineToBottom = -1;
        public int startToEnd = -1;
        public int startToStart = -1;
        public int endToStart = -1;
        public int endToEnd = -1;
        public float horizontalBias = 0.5f;
        public float verticalBias = 0.5f;
        public String dimensionRatio = null;
        public int circleConstraint = -1;
        public int circleRadius = 0;
        public float circleAngle = 0.0f;
        public int editorAbsoluteX = -1;
        public int editorAbsoluteY = -1;
        public int orientation = -1;
        public int leftMargin = 0;
        public int rightMargin = 0;
        public int topMargin = 0;
        public int bottomMargin = 0;
        public int endMargin = 0;
        public int startMargin = 0;
        public int baselineMargin = 0;
        public int goneLeftMargin = Integer.MIN_VALUE;
        public int goneTopMargin = Integer.MIN_VALUE;
        public int goneRightMargin = Integer.MIN_VALUE;
        public int goneBottomMargin = Integer.MIN_VALUE;
        public int goneEndMargin = Integer.MIN_VALUE;
        public int goneStartMargin = Integer.MIN_VALUE;
        public int goneBaselineMargin = Integer.MIN_VALUE;
        public float verticalWeight = -1.0f;
        public float horizontalWeight = -1.0f;
        public int horizontalChainStyle = 0;
        public int verticalChainStyle = 0;
        public int widthDefault = 0;
        public int heightDefault = 0;
        public int widthMax = 0;
        public int heightMax = 0;
        public int widthMin = 0;
        public int heightMin = 0;
        public float widthPercent = 1.0f;
        public float heightPercent = 1.0f;
        public int mBarrierDirection = -1;
        public int mBarrierMargin = 0;
        public int mHelperType = -1;
        public int[] mReferenceIds;
        public String mReferenceIdString;
        public String mConstraintTag;
        public boolean constrainedWidth = false;
        public boolean constrainedHeight = false;
        public boolean mBarrierAllowsGoneWidgets = true;
        public int mWrapBehavior = 0;
        private static SparseIntArray mapToConstant = new SparseIntArray();
        private static final int BASELINE_TO_BASELINE = 1;
        private static final int BOTTOM_MARGIN = 2;
        private static final int BOTTOM_TO_BOTTOM = 3;
        private static final int BOTTOM_TO_TOP = 4;
        private static final int DIMENSION_RATIO = 5;
        private static final int EDITOR_ABSOLUTE_X = 6;
        private static final int EDITOR_ABSOLUTE_Y = 7;
        private static final int END_MARGIN = 8;
        private static final int END_TO_END = 9;
        private static final int END_TO_START = 10;
        private static final int GONE_BOTTOM_MARGIN = 11;
        private static final int GONE_END_MARGIN = 12;
        private static final int GONE_LEFT_MARGIN = 13;
        private static final int GONE_RIGHT_MARGIN = 14;
        private static final int GONE_START_MARGIN = 15;
        private static final int GONE_TOP_MARGIN = 16;
        private static final int GUIDE_BEGIN = 17;
        private static final int GUIDE_END = 18;
        private static final int GUIDE_PERCENT = 19;
        private static final int HORIZONTAL_BIAS = 20;
        private static final int LAYOUT_HEIGHT = 21;
        private static final int LAYOUT_WIDTH = 22;
        private static final int LEFT_MARGIN = 23;
        private static final int LEFT_TO_LEFT = 24;
        private static final int LEFT_TO_RIGHT = 25;
        private static final int ORIENTATION = 26;
        private static final int RIGHT_MARGIN = 27;
        private static final int RIGHT_TO_LEFT = 28;
        private static final int RIGHT_TO_RIGHT = 29;
        private static final int START_MARGIN = 30;
        private static final int START_TO_END = 31;
        private static final int START_TO_START = 32;
        private static final int TOP_MARGIN = 33;
        private static final int TOP_TO_BOTTOM = 34;
        private static final int TOP_TO_TOP = 35;
        private static final int VERTICAL_BIAS = 36;
        private static final int HORIZONTAL_WEIGHT = 37;
        private static final int VERTICAL_WEIGHT = 38;
        private static final int HORIZONTAL_STYLE = 39;
        private static final int VERTICAL_STYLE = 40;
        private static final int LAYOUT_CONSTRAINT_WIDTH = 41;
        private static final int LAYOUT_CONSTRAINT_HEIGHT = 42;
        private static final int CIRCLE = 61;
        private static final int CIRCLE_RADIUS = 62;
        private static final int CIRCLE_ANGLE = 63;
        private static final int WIDTH_PERCENT = 69;
        private static final int HEIGHT_PERCENT = 70;
        private static final int CHAIN_USE_RTL = 71;
        private static final int BARRIER_DIRECTION = 72;
        private static final int BARRIER_MARGIN = 73;
        private static final int CONSTRAINT_REFERENCED_IDS = 74;
        private static final int BARRIER_ALLOWS_GONE_WIDGETS = 75;
        private static final int LAYOUT_WRAP_BEHAVIOR = 76;
        private static final int BASELINE_TO_TOP = 77;
        private static final int BASELINE_TO_BOTTOM = 78;
        private static final int GONE_BASELINE_MARGIN = 79;
        private static final int BASELINE_MARGIN = 80;
        private static final int WIDTH_DEFAULT = 81;
        private static final int HEIGHT_DEFAULT = 82;
        private static final int HEIGHT_MAX = 83;
        private static final int WIDTH_MAX = 84;
        private static final int HEIGHT_MIN = 85;
        private static final int WIDTH_MIN = 86;
        private static final int CONSTRAINED_WIDTH = 87;
        private static final int CONSTRAINED_HEIGHT = 88;
        private static final int CONSTRAINT_TAG = 89;
        private static final int GUIDE_USE_RTL = 90;
        private static final int UNUSED = 91;

        public void copyFrom(Layout src) {
            this.mIsGuideline = src.mIsGuideline;
            this.mWidth = src.mWidth;
            this.mApply = src.mApply;
            this.mHeight = src.mHeight;
            this.guideBegin = src.guideBegin;
            this.guideEnd = src.guideEnd;
            this.guidePercent = src.guidePercent;
            this.guidelineUseRtl = src.guidelineUseRtl;
            this.leftToLeft = src.leftToLeft;
            this.leftToRight = src.leftToRight;
            this.rightToLeft = src.rightToLeft;
            this.rightToRight = src.rightToRight;
            this.topToTop = src.topToTop;
            this.topToBottom = src.topToBottom;
            this.bottomToTop = src.bottomToTop;
            this.bottomToBottom = src.bottomToBottom;
            this.baselineToBaseline = src.baselineToBaseline;
            this.baselineToTop = src.baselineToTop;
            this.baselineToBottom = src.baselineToBottom;
            this.startToEnd = src.startToEnd;
            this.startToStart = src.startToStart;
            this.endToStart = src.endToStart;
            this.endToEnd = src.endToEnd;
            this.horizontalBias = src.horizontalBias;
            this.verticalBias = src.verticalBias;
            this.dimensionRatio = src.dimensionRatio;
            this.circleConstraint = src.circleConstraint;
            this.circleRadius = src.circleRadius;
            this.circleAngle = src.circleAngle;
            this.editorAbsoluteX = src.editorAbsoluteX;
            this.editorAbsoluteY = src.editorAbsoluteY;
            this.orientation = src.orientation;
            this.leftMargin = src.leftMargin;
            this.rightMargin = src.rightMargin;
            this.topMargin = src.topMargin;
            this.bottomMargin = src.bottomMargin;
            this.endMargin = src.endMargin;
            this.startMargin = src.startMargin;
            this.baselineMargin = src.baselineMargin;
            this.goneLeftMargin = src.goneLeftMargin;
            this.goneTopMargin = src.goneTopMargin;
            this.goneRightMargin = src.goneRightMargin;
            this.goneBottomMargin = src.goneBottomMargin;
            this.goneEndMargin = src.goneEndMargin;
            this.goneStartMargin = src.goneStartMargin;
            this.goneBaselineMargin = src.goneBaselineMargin;
            this.verticalWeight = src.verticalWeight;
            this.horizontalWeight = src.horizontalWeight;
            this.horizontalChainStyle = src.horizontalChainStyle;
            this.verticalChainStyle = src.verticalChainStyle;
            this.widthDefault = src.widthDefault;
            this.heightDefault = src.heightDefault;
            this.widthMax = src.widthMax;
            this.heightMax = src.heightMax;
            this.widthMin = src.widthMin;
            this.heightMin = src.heightMin;
            this.widthPercent = src.widthPercent;
            this.heightPercent = src.heightPercent;
            this.mBarrierDirection = src.mBarrierDirection;
            this.mBarrierMargin = src.mBarrierMargin;
            this.mHelperType = src.mHelperType;
            this.mConstraintTag = src.mConstraintTag;
            this.mReferenceIds = (int[])(src.mReferenceIds != null && src.mReferenceIdString == null ? Arrays.copyOf(src.mReferenceIds, src.mReferenceIds.length) : null);
            this.mReferenceIdString = src.mReferenceIdString;
            this.constrainedWidth = src.constrainedWidth;
            this.constrainedHeight = src.constrainedHeight;
            this.mBarrierAllowsGoneWidgets = src.mBarrierAllowsGoneWidgets;
            this.mWrapBehavior = src.mWrapBehavior;
        }

        void fillFromAttributeList(Context context, AttributeSet attrs) {
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.Layout);
            this.mApply = true;
            int N = a.getIndexCount();
            block70: for (int i = 0; i < N; ++i) {
                int attr2 = a.getIndex(i);
                switch (mapToConstant.get(attr2)) {
                    case 24: {
                        this.leftToLeft = ConstraintSet.lookupID(a, attr2, this.leftToLeft);
                        continue block70;
                    }
                    case 25: {
                        this.leftToRight = ConstraintSet.lookupID(a, attr2, this.leftToRight);
                        continue block70;
                    }
                    case 28: {
                        this.rightToLeft = ConstraintSet.lookupID(a, attr2, this.rightToLeft);
                        continue block70;
                    }
                    case 29: {
                        this.rightToRight = ConstraintSet.lookupID(a, attr2, this.rightToRight);
                        continue block70;
                    }
                    case 35: {
                        this.topToTop = ConstraintSet.lookupID(a, attr2, this.topToTop);
                        continue block70;
                    }
                    case 34: {
                        this.topToBottom = ConstraintSet.lookupID(a, attr2, this.topToBottom);
                        continue block70;
                    }
                    case 4: {
                        this.bottomToTop = ConstraintSet.lookupID(a, attr2, this.bottomToTop);
                        continue block70;
                    }
                    case 3: {
                        this.bottomToBottom = ConstraintSet.lookupID(a, attr2, this.bottomToBottom);
                        continue block70;
                    }
                    case 1: {
                        this.baselineToBaseline = ConstraintSet.lookupID(a, attr2, this.baselineToBaseline);
                        continue block70;
                    }
                    case 77: {
                        this.baselineToTop = ConstraintSet.lookupID(a, attr2, this.baselineToTop);
                        continue block70;
                    }
                    case 78: {
                        this.baselineToBottom = ConstraintSet.lookupID(a, attr2, this.baselineToBottom);
                        continue block70;
                    }
                    case 6: {
                        this.editorAbsoluteX = a.getDimensionPixelOffset(attr2, this.editorAbsoluteX);
                        continue block70;
                    }
                    case 7: {
                        this.editorAbsoluteY = a.getDimensionPixelOffset(attr2, this.editorAbsoluteY);
                        continue block70;
                    }
                    case 17: {
                        this.guideBegin = a.getDimensionPixelOffset(attr2, this.guideBegin);
                        continue block70;
                    }
                    case 18: {
                        this.guideEnd = a.getDimensionPixelOffset(attr2, this.guideEnd);
                        continue block70;
                    }
                    case 19: {
                        this.guidePercent = a.getFloat(attr2, this.guidePercent);
                        continue block70;
                    }
                    case 90: {
                        this.guidelineUseRtl = a.getBoolean(attr2, this.guidelineUseRtl);
                        continue block70;
                    }
                    case 26: {
                        this.orientation = a.getInt(attr2, this.orientation);
                        continue block70;
                    }
                    case 31: {
                        this.startToEnd = ConstraintSet.lookupID(a, attr2, this.startToEnd);
                        continue block70;
                    }
                    case 32: {
                        this.startToStart = ConstraintSet.lookupID(a, attr2, this.startToStart);
                        continue block70;
                    }
                    case 10: {
                        this.endToStart = ConstraintSet.lookupID(a, attr2, this.endToStart);
                        continue block70;
                    }
                    case 9: {
                        this.endToEnd = ConstraintSet.lookupID(a, attr2, this.endToEnd);
                        continue block70;
                    }
                    case 61: {
                        this.circleConstraint = ConstraintSet.lookupID(a, attr2, this.circleConstraint);
                        continue block70;
                    }
                    case 62: {
                        this.circleRadius = a.getDimensionPixelSize(attr2, this.circleRadius);
                        continue block70;
                    }
                    case 63: {
                        this.circleAngle = a.getFloat(attr2, this.circleAngle);
                        continue block70;
                    }
                    case 13: {
                        this.goneLeftMargin = a.getDimensionPixelSize(attr2, this.goneLeftMargin);
                        continue block70;
                    }
                    case 16: {
                        this.goneTopMargin = a.getDimensionPixelSize(attr2, this.goneTopMargin);
                        continue block70;
                    }
                    case 14: {
                        this.goneRightMargin = a.getDimensionPixelSize(attr2, this.goneRightMargin);
                        continue block70;
                    }
                    case 11: {
                        this.goneBottomMargin = a.getDimensionPixelSize(attr2, this.goneBottomMargin);
                        continue block70;
                    }
                    case 15: {
                        this.goneStartMargin = a.getDimensionPixelSize(attr2, this.goneStartMargin);
                        continue block70;
                    }
                    case 12: {
                        this.goneEndMargin = a.getDimensionPixelSize(attr2, this.goneEndMargin);
                        continue block70;
                    }
                    case 79: {
                        this.goneBaselineMargin = a.getDimensionPixelSize(attr2, this.goneBaselineMargin);
                        continue block70;
                    }
                    case 20: {
                        this.horizontalBias = a.getFloat(attr2, this.horizontalBias);
                        continue block70;
                    }
                    case 36: {
                        this.verticalBias = a.getFloat(attr2, this.verticalBias);
                        continue block70;
                    }
                    case 23: {
                        this.leftMargin = a.getDimensionPixelSize(attr2, this.leftMargin);
                        continue block70;
                    }
                    case 27: {
                        this.rightMargin = a.getDimensionPixelSize(attr2, this.rightMargin);
                        continue block70;
                    }
                    case 30: {
                        if (Build.VERSION.SDK_INT < 17) continue block70;
                        this.startMargin = a.getDimensionPixelSize(attr2, this.startMargin);
                        continue block70;
                    }
                    case 8: {
                        if (Build.VERSION.SDK_INT < 17) continue block70;
                        this.endMargin = a.getDimensionPixelSize(attr2, this.endMargin);
                        continue block70;
                    }
                    case 33: {
                        this.topMargin = a.getDimensionPixelSize(attr2, this.topMargin);
                        continue block70;
                    }
                    case 2: {
                        this.bottomMargin = a.getDimensionPixelSize(attr2, this.bottomMargin);
                        continue block70;
                    }
                    case 80: {
                        this.baselineMargin = a.getDimensionPixelSize(attr2, this.baselineMargin);
                        continue block70;
                    }
                    case 22: {
                        this.mWidth = a.getLayoutDimension(attr2, this.mWidth);
                        continue block70;
                    }
                    case 21: {
                        this.mHeight = a.getLayoutDimension(attr2, this.mHeight);
                        continue block70;
                    }
                    case 41: {
                        ConstraintSet.parseDimensionConstraints(this, a, attr2, 0);
                        continue block70;
                    }
                    case 42: {
                        ConstraintSet.parseDimensionConstraints(this, a, attr2, 1);
                        continue block70;
                    }
                    case 81: {
                        this.widthDefault = a.getInt(attr2, this.widthDefault);
                        continue block70;
                    }
                    case 82: {
                        this.heightDefault = a.getInt(attr2, this.heightDefault);
                        continue block70;
                    }
                    case 38: {
                        this.verticalWeight = a.getFloat(attr2, this.verticalWeight);
                        continue block70;
                    }
                    case 37: {
                        this.horizontalWeight = a.getFloat(attr2, this.horizontalWeight);
                        continue block70;
                    }
                    case 40: {
                        this.verticalChainStyle = a.getInt(attr2, this.verticalChainStyle);
                        continue block70;
                    }
                    case 39: {
                        this.horizontalChainStyle = a.getInt(attr2, this.horizontalChainStyle);
                        continue block70;
                    }
                    case 5: {
                        this.dimensionRatio = a.getString(attr2);
                        continue block70;
                    }
                    case 83: {
                        this.heightMax = a.getDimensionPixelSize(attr2, this.heightMax);
                        continue block70;
                    }
                    case 84: {
                        this.widthMax = a.getDimensionPixelSize(attr2, this.widthMax);
                        continue block70;
                    }
                    case 85: {
                        this.heightMin = a.getDimensionPixelSize(attr2, this.heightMin);
                        continue block70;
                    }
                    case 86: {
                        this.widthMin = a.getDimensionPixelSize(attr2, this.widthMin);
                        continue block70;
                    }
                    case 69: {
                        this.widthPercent = a.getFloat(attr2, 1.0f);
                        continue block70;
                    }
                    case 70: {
                        this.heightPercent = a.getFloat(attr2, 1.0f);
                        continue block70;
                    }
                    case 87: {
                        this.constrainedWidth = a.getBoolean(attr2, this.constrainedWidth);
                        continue block70;
                    }
                    case 88: {
                        this.constrainedHeight = a.getBoolean(attr2, this.constrainedHeight);
                        continue block70;
                    }
                    case 71: {
                        Log.e((String)ConstraintSet.TAG, (String)"CURRENTLY UNSUPPORTED");
                        continue block70;
                    }
                    case 72: {
                        this.mBarrierDirection = a.getInt(attr2, this.mBarrierDirection);
                        continue block70;
                    }
                    case 76: {
                        this.mWrapBehavior = a.getInt(attr2, this.mWrapBehavior);
                        continue block70;
                    }
                    case 73: {
                        this.mBarrierMargin = a.getDimensionPixelSize(attr2, this.mBarrierMargin);
                        continue block70;
                    }
                    case 74: {
                        this.mReferenceIdString = a.getString(attr2);
                        continue block70;
                    }
                    case 75: {
                        this.mBarrierAllowsGoneWidgets = a.getBoolean(attr2, this.mBarrierAllowsGoneWidgets);
                        continue block70;
                    }
                    case 89: {
                        this.mConstraintTag = a.getString(attr2);
                        continue block70;
                    }
                    case 91: {
                        Log.w((String)ConstraintSet.TAG, (String)("unused attribute 0x" + Integer.toHexString(attr2) + "   " + mapToConstant.get(attr2)));
                        continue block70;
                    }
                    default: {
                        Log.w((String)ConstraintSet.TAG, (String)("Unknown attribute 0x" + Integer.toHexString(attr2) + "   " + mapToConstant.get(attr2)));
                    }
                }
            }
            a.recycle();
        }

        public void dump(MotionScene scene, StringBuilder stringBuilder) {
            Field[] fields = this.getClass().getDeclaredFields();
            stringBuilder.append("\n");
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                String name = field.getName();
                if (Modifier.isStatic(field.getModifiers())) continue;
                try {
                    Float fValue;
                    Object value = field.get(this);
                    Class<?> type = field.getType();
                    if (type == Integer.TYPE) {
                        Integer iValue = (Integer)value;
                        if (iValue == -1) continue;
                        String stringId = scene.lookUpConstraintName(iValue);
                        stringBuilder.append("    ");
                        stringBuilder.append(name);
                        stringBuilder.append(" = \"");
                        stringBuilder.append(stringId == null ? iValue : stringId);
                        stringBuilder.append("\"\n");
                        continue;
                    }
                    if (type != Float.TYPE || (fValue = (Float)value).floatValue() == -1.0f) continue;
                    stringBuilder.append("    ");
                    stringBuilder.append(name);
                    stringBuilder.append(" = \"");
                    stringBuilder.append(fValue);
                    stringBuilder.append("\"\n");
                    continue;
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }

        static {
            mapToConstant.append(R.styleable.Layout_layout_constraintLeft_toLeftOf, 24);
            mapToConstant.append(R.styleable.Layout_layout_constraintLeft_toRightOf, 25);
            mapToConstant.append(R.styleable.Layout_layout_constraintRight_toLeftOf, 28);
            mapToConstant.append(R.styleable.Layout_layout_constraintRight_toRightOf, 29);
            mapToConstant.append(R.styleable.Layout_layout_constraintTop_toTopOf, 35);
            mapToConstant.append(R.styleable.Layout_layout_constraintTop_toBottomOf, 34);
            mapToConstant.append(R.styleable.Layout_layout_constraintBottom_toTopOf, 4);
            mapToConstant.append(R.styleable.Layout_layout_constraintBottom_toBottomOf, 3);
            mapToConstant.append(R.styleable.Layout_layout_constraintBaseline_toBaselineOf, 1);
            mapToConstant.append(R.styleable.Layout_layout_editor_absoluteX, 6);
            mapToConstant.append(R.styleable.Layout_layout_editor_absoluteY, 7);
            mapToConstant.append(R.styleable.Layout_layout_constraintGuide_begin, 17);
            mapToConstant.append(R.styleable.Layout_layout_constraintGuide_end, 18);
            mapToConstant.append(R.styleable.Layout_layout_constraintGuide_percent, 19);
            mapToConstant.append(R.styleable.Layout_guidelineUseRtl, 90);
            mapToConstant.append(R.styleable.Layout_android_orientation, 26);
            mapToConstant.append(R.styleable.Layout_layout_constraintStart_toEndOf, 31);
            mapToConstant.append(R.styleable.Layout_layout_constraintStart_toStartOf, 32);
            mapToConstant.append(R.styleable.Layout_layout_constraintEnd_toStartOf, 10);
            mapToConstant.append(R.styleable.Layout_layout_constraintEnd_toEndOf, 9);
            mapToConstant.append(R.styleable.Layout_layout_goneMarginLeft, 13);
            mapToConstant.append(R.styleable.Layout_layout_goneMarginTop, 16);
            mapToConstant.append(R.styleable.Layout_layout_goneMarginRight, 14);
            mapToConstant.append(R.styleable.Layout_layout_goneMarginBottom, 11);
            mapToConstant.append(R.styleable.Layout_layout_goneMarginStart, 15);
            mapToConstant.append(R.styleable.Layout_layout_goneMarginEnd, 12);
            mapToConstant.append(R.styleable.Layout_layout_constraintVertical_weight, 38);
            mapToConstant.append(R.styleable.Layout_layout_constraintHorizontal_weight, 37);
            mapToConstant.append(R.styleable.Layout_layout_constraintHorizontal_chainStyle, 39);
            mapToConstant.append(R.styleable.Layout_layout_constraintVertical_chainStyle, 40);
            mapToConstant.append(R.styleable.Layout_layout_constraintHorizontal_bias, 20);
            mapToConstant.append(R.styleable.Layout_layout_constraintVertical_bias, 36);
            mapToConstant.append(R.styleable.Layout_layout_constraintDimensionRatio, 5);
            mapToConstant.append(R.styleable.Layout_layout_constraintLeft_creator, 91);
            mapToConstant.append(R.styleable.Layout_layout_constraintTop_creator, 91);
            mapToConstant.append(R.styleable.Layout_layout_constraintRight_creator, 91);
            mapToConstant.append(R.styleable.Layout_layout_constraintBottom_creator, 91);
            mapToConstant.append(R.styleable.Layout_layout_constraintBaseline_creator, 91);
            mapToConstant.append(R.styleable.Layout_android_layout_marginLeft, 23);
            mapToConstant.append(R.styleable.Layout_android_layout_marginRight, 27);
            mapToConstant.append(R.styleable.Layout_android_layout_marginStart, 30);
            mapToConstant.append(R.styleable.Layout_android_layout_marginEnd, 8);
            mapToConstant.append(R.styleable.Layout_android_layout_marginTop, 33);
            mapToConstant.append(R.styleable.Layout_android_layout_marginBottom, 2);
            mapToConstant.append(R.styleable.Layout_android_layout_width, 22);
            mapToConstant.append(R.styleable.Layout_android_layout_height, 21);
            mapToConstant.append(R.styleable.Layout_layout_constraintWidth, 41);
            mapToConstant.append(R.styleable.Layout_layout_constraintHeight, 42);
            mapToConstant.append(R.styleable.Layout_layout_constrainedWidth, 41);
            mapToConstant.append(R.styleable.Layout_layout_constrainedHeight, 42);
            mapToConstant.append(R.styleable.Layout_layout_wrapBehaviorInParent, 76);
            mapToConstant.append(R.styleable.Layout_layout_constraintCircle, 61);
            mapToConstant.append(R.styleable.Layout_layout_constraintCircleRadius, 62);
            mapToConstant.append(R.styleable.Layout_layout_constraintCircleAngle, 63);
            mapToConstant.append(R.styleable.Layout_layout_constraintWidth_percent, 69);
            mapToConstant.append(R.styleable.Layout_layout_constraintHeight_percent, 70);
            mapToConstant.append(R.styleable.Layout_chainUseRtl, 71);
            mapToConstant.append(R.styleable.Layout_barrierDirection, 72);
            mapToConstant.append(R.styleable.Layout_barrierMargin, 73);
            mapToConstant.append(R.styleable.Layout_constraint_referenced_ids, 74);
            mapToConstant.append(R.styleable.Layout_barrierAllowsGoneWidgets, 75);
        }
    }
}

