/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.maui.glide;

import android.graphics.drawable.Drawable;
import android.view.View;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.bumptech.glide.request.target.CustomViewTarget;
import com.bumptech.glide.request.transition.Transition;
import com.microsoft.maui.ImageLoaderCallback;

public class MauiCustomViewTarget
extends CustomViewTarget<ImageView, Drawable> {
    private final ImageLoaderCallback callback;
    private boolean completed = false;

    public MauiCustomViewTarget(@NonNull ImageView view, ImageLoaderCallback callback) {
        super((View)view);
        this.callback = callback;
    }

    protected void onResourceCleared(@Nullable Drawable placeholder) {
    }

    public void onLoadFailed(@Nullable Drawable errorDrawable) {
        if (this.completed) {
            return;
        }
        this.completed = true;
        this.post(() -> this.callback.onComplete(false, errorDrawable, this::clear));
    }

    public void onResourceReady(@NonNull Drawable resource, @Nullable Transition<? super Drawable> transition) {
        if (this.completed) {
            return;
        }
        this.completed = true;
        ((ImageView)this.view).setImageDrawable(resource);
        this.post(() -> this.callback.onComplete(true, resource, this::clear));
    }

    private void post(Runnable runnable) {
        ((ImageView)this.view).post(runnable);
    }

    private void clear() {
        this.post(() -> {});
    }
}

