/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.request.target;

import android.appwidget.AppWidgetManager;
import android.content.ComponentName;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.widget.RemoteViews;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.bumptech.glide.request.target.CustomTarget;
import com.bumptech.glide.request.transition.Transition;
import com.bumptech.glide.util.Preconditions;

public class AppWidgetTarget
extends CustomTarget<Bitmap> {
    private final int[] widgetIds;
    private final ComponentName componentName;
    private final RemoteViews remoteViews;
    private final Context context;
    private final int viewId;

    public AppWidgetTarget(Context context, int width, int height, int viewId, RemoteViews remoteViews, int ... widgetIds) {
        super(width, height);
        if (widgetIds.length == 0) {
            throw new IllegalArgumentException("WidgetIds must have length > 0");
        }
        this.context = Preconditions.checkNotNull(context, "Context can not be null!");
        this.remoteViews = Preconditions.checkNotNull(remoteViews, "RemoteViews object can not be null!");
        this.widgetIds = Preconditions.checkNotNull(widgetIds, "WidgetIds can not be null!");
        this.viewId = viewId;
        this.componentName = null;
    }

    public AppWidgetTarget(Context context, int viewId, RemoteViews remoteViews, int ... widgetIds) {
        this(context, Integer.MIN_VALUE, Integer.MIN_VALUE, viewId, remoteViews, widgetIds);
    }

    public AppWidgetTarget(Context context, int width, int height, int viewId, RemoteViews remoteViews, ComponentName componentName) {
        super(width, height);
        this.context = Preconditions.checkNotNull(context, "Context can not be null!");
        this.remoteViews = Preconditions.checkNotNull(remoteViews, "RemoteViews object can not be null!");
        this.componentName = Preconditions.checkNotNull(componentName, "ComponentName can not be null!");
        this.viewId = viewId;
        this.widgetIds = null;
    }

    public AppWidgetTarget(Context context, int viewId, RemoteViews remoteViews, ComponentName componentName) {
        this(context, Integer.MIN_VALUE, Integer.MIN_VALUE, viewId, remoteViews, componentName);
    }

    private void update() {
        AppWidgetManager appWidgetManager = AppWidgetManager.getInstance((Context)this.context);
        if (this.componentName != null) {
            appWidgetManager.updateAppWidget(this.componentName, this.remoteViews);
        } else {
            appWidgetManager.updateAppWidget(this.widgetIds, this.remoteViews);
        }
    }

    @Override
    public void onResourceReady(@NonNull Bitmap resource, @Nullable Transition<? super Bitmap> transition) {
        this.setBitmap(resource);
    }

    @Override
    public void onLoadCleared(@Nullable Drawable placeholder) {
        this.setBitmap(null);
    }

    private void setBitmap(@Nullable Bitmap bitmap) {
        this.remoteViews.setImageViewBitmap(this.viewId, bitmap);
        this.update();
    }
}

