/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.resource;

import android.annotation.SuppressLint;
import android.graphics.ColorSpace;
import android.graphics.ImageDecoder;
import android.os.Build;
import android.util.Log;
import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.bumptech.glide.load.DecodeFormat;
import com.bumptech.glide.load.Options;
import com.bumptech.glide.load.PreferredColorSpace;
import com.bumptech.glide.load.ResourceDecoder;
import com.bumptech.glide.load.engine.Resource;
import com.bumptech.glide.load.resource.bitmap.DownsampleStrategy;
import com.bumptech.glide.load.resource.bitmap.Downsampler;
import com.bumptech.glide.load.resource.bitmap.HardwareConfigState;
import java.io.IOException;

@RequiresApi(api=28)
public abstract class ImageDecoderResourceDecoder<T>
implements ResourceDecoder<ImageDecoder.Source, T> {
    private static final String TAG = "ImageDecoder";
    final HardwareConfigState hardwareConfigState = HardwareConfigState.getInstance();

    @Override
    public final boolean handles(@NonNull ImageDecoder.Source source, @NonNull Options options) {
        return true;
    }

    @Override
    @Nullable
    public final Resource<T> decode(@NonNull ImageDecoder.Source source, final int requestedWidth, final int requestedHeight, @NonNull Options options) throws IOException {
        final DecodeFormat decodeFormat = options.get(Downsampler.DECODE_FORMAT);
        final DownsampleStrategy strategy = options.get(DownsampleStrategy.OPTION);
        final boolean isHardwareConfigAllowed = options.get(Downsampler.ALLOW_HARDWARE_CONFIG) != null && options.get(Downsampler.ALLOW_HARDWARE_CONFIG) != false;
        final PreferredColorSpace preferredColorSpace = options.get(Downsampler.PREFERRED_COLOR_SPACE);
        return this.decode(source, requestedWidth, requestedHeight, new ImageDecoder.OnHeaderDecodedListener(){

            @SuppressLint(value={"Override"})
            public void onHeaderDecoded(ImageDecoder decoder, ImageDecoder.ImageInfo info, ImageDecoder.Source source) {
                if (ImageDecoderResourceDecoder.this.hardwareConfigState.isHardwareConfigAllowed(requestedWidth, requestedHeight, isHardwareConfigAllowed, false)) {
                    decoder.setAllocator(3);
                } else {
                    decoder.setAllocator(1);
                }
                if (decodeFormat == DecodeFormat.PREFER_RGB_565) {
                    decoder.setMemorySizePolicy(0);
                }
                decoder.setOnPartialImageListener(new ImageDecoder.OnPartialImageListener(){

                    public boolean onPartialImage(@NonNull ImageDecoder.DecodeException e) {
                        return false;
                    }
                });
                Size size = info.getSize();
                int targetWidth = requestedWidth;
                if (requestedWidth == Integer.MIN_VALUE) {
                    targetWidth = size.getWidth();
                }
                int targetHeight = requestedHeight;
                if (requestedHeight == Integer.MIN_VALUE) {
                    targetHeight = size.getHeight();
                }
                float scaleFactor = strategy.getScaleFactor(size.getWidth(), size.getHeight(), targetWidth, targetHeight);
                int resizeWidth = Math.round(scaleFactor * (float)size.getWidth());
                int resizeHeight = Math.round(scaleFactor * (float)size.getHeight());
                if (Log.isLoggable((String)ImageDecoderResourceDecoder.TAG, (int)2)) {
                    Log.v((String)ImageDecoderResourceDecoder.TAG, (String)("Resizing from [" + size.getWidth() + "x" + size.getHeight() + "] to [" + resizeWidth + "x" + resizeHeight + "] scaleFactor: " + scaleFactor));
                }
                decoder.setTargetSize(resizeWidth, resizeHeight);
                if (Build.VERSION.SDK_INT >= 28) {
                    boolean isP3Eligible = preferredColorSpace == PreferredColorSpace.DISPLAY_P3 && info.getColorSpace() != null && info.getColorSpace().isWideGamut();
                    decoder.setTargetColorSpace(ColorSpace.get((ColorSpace.Named)(isP3Eligible ? ColorSpace.Named.DISPLAY_P3 : ColorSpace.Named.SRGB)));
                } else if (Build.VERSION.SDK_INT >= 26) {
                    decoder.setTargetColorSpace(ColorSpace.get((ColorSpace.Named)ColorSpace.Named.SRGB));
                }
            }
        });
    }

    protected abstract Resource<T> decode(ImageDecoder.Source var1, int var2, int var3, ImageDecoder.OnHeaderDecodedListener var4) throws IOException;
}

