/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.data;

import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.bumptech.glide.load.engine.bitmap_recycle.ArrayPool;
import java.io.IOException;
import java.io.OutputStream;

public final class BufferedOutputStream
extends OutputStream {
    @NonNull
    private final OutputStream out;
    private byte[] buffer;
    private ArrayPool arrayPool;
    private int index;

    public BufferedOutputStream(@NonNull OutputStream out, @NonNull ArrayPool arrayPool) {
        this(out, arrayPool, 65536);
    }

    @VisibleForTesting
    BufferedOutputStream(@NonNull OutputStream out, ArrayPool arrayPool, int bufferSize) {
        this.out = out;
        this.arrayPool = arrayPool;
        this.buffer = arrayPool.get(bufferSize, byte[].class);
    }

    @Override
    public void write(int b) throws IOException {
        this.buffer[this.index++] = (byte)b;
        this.maybeFlushBuffer();
    }

    @Override
    public void write(@NonNull byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(@NonNull byte[] b, int initialOffset, int length) throws IOException {
        int totalBytesToWriteToBuffer;
        int writtenSoFar = 0;
        do {
            int remainingToWrite = length - writtenSoFar;
            int currentOffset = initialOffset + writtenSoFar;
            if (this.index == 0 && remainingToWrite >= this.buffer.length) {
                this.out.write(b, currentOffset, remainingToWrite);
                return;
            }
            int remainingSpaceInBuffer = this.buffer.length - this.index;
            totalBytesToWriteToBuffer = Math.min(remainingToWrite, remainingSpaceInBuffer);
            System.arraycopy(b, currentOffset, this.buffer, this.index, totalBytesToWriteToBuffer);
            this.index += totalBytesToWriteToBuffer;
            this.maybeFlushBuffer();
        } while ((writtenSoFar += totalBytesToWriteToBuffer) < length);
    }

    @Override
    public void flush() throws IOException {
        this.flushBuffer();
        this.out.flush();
    }

    private void flushBuffer() throws IOException {
        if (this.index > 0) {
            this.out.write(this.buffer, 0, this.index);
            this.index = 0;
        }
    }

    private void maybeFlushBuffer() throws IOException {
        if (this.index == this.buffer.length) {
            this.flushBuffer();
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.flush();
        }
        finally {
            this.out.close();
        }
        this.release();
    }

    private void release() {
        if (this.buffer != null) {
            this.arrayPool.put(this.buffer);
            this.buffer = null;
        }
    }
}

