/*
 * Decompiled with CFR 0.152.
 */
package androidx.media;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.media.AudioAttributesCompat;
import androidx.media.AudioAttributesImpl;
import java.util.Arrays;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class AudioAttributesImplBase
implements AudioAttributesImpl {
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public int mUsage = 0;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public int mContentType = 0;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public int mFlags = 0;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public int mLegacyStream = -1;

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public AudioAttributesImplBase() {
    }

    AudioAttributesImplBase(int contentType, int flags, int usage, int legacyStream) {
        this.mContentType = contentType;
        this.mFlags = flags;
        this.mUsage = usage;
        this.mLegacyStream = legacyStream;
    }

    @Override
    @Nullable
    public Object getAudioAttributes() {
        return null;
    }

    @Override
    public int getVolumeControlStream() {
        return AudioAttributesCompat.toVolumeStreamType(true, this.mFlags, this.mUsage);
    }

    @Override
    public int getLegacyStreamType() {
        if (this.mLegacyStream != -1) {
            return this.mLegacyStream;
        }
        return AudioAttributesCompat.toVolumeStreamType(false, this.mFlags, this.mUsage);
    }

    @Override
    public int getRawLegacyStreamType() {
        return this.mLegacyStream;
    }

    @Override
    public int getContentType() {
        return this.mContentType;
    }

    @Override
    public int getUsage() {
        return this.mUsage;
    }

    @Override
    public int getFlags() {
        int flags = this.mFlags;
        int legacyStream = this.getLegacyStreamType();
        if (legacyStream == 6) {
            flags |= 4;
        } else if (legacyStream == 7) {
            flags |= 1;
        }
        return flags & 0x111;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.mContentType, this.mFlags, this.mUsage, this.mLegacyStream});
    }

    public boolean equals(Object o) {
        if (!(o instanceof AudioAttributesImplBase)) {
            return false;
        }
        AudioAttributesImplBase that = (AudioAttributesImplBase)o;
        return this.mContentType == that.getContentType() && this.mFlags == that.getFlags() && this.mUsage == that.getUsage() && this.mLegacyStream == that.mLegacyStream;
    }

    @NonNull
    public String toString() {
        StringBuilder sb = new StringBuilder("AudioAttributesCompat:");
        if (this.mLegacyStream != -1) {
            sb.append(" stream=").append(this.mLegacyStream);
            sb.append(" derived");
        }
        sb.append(" usage=").append(AudioAttributesCompat.usageToString(this.mUsage)).append(" content=").append(this.mContentType).append(" flags=0x").append(Integer.toHexString(this.mFlags).toUpperCase());
        return sb.toString();
    }

    static int usageForStreamType(int streamType) {
        switch (streamType) {
            case 0: {
                return 2;
            }
            case 1: 
            case 7: {
                return 13;
            }
            case 2: {
                return 6;
            }
            case 3: {
                return 1;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
            case 6: {
                return 2;
            }
            case 8: {
                return 3;
            }
            case 10: {
                return 11;
            }
        }
        return 0;
    }

    static class Builder
    implements AudioAttributesImpl.Builder {
        private int mUsage = 0;
        private int mContentType = 0;
        private int mFlags = 0;
        private int mLegacyStream = -1;

        Builder() {
        }

        Builder(AudioAttributesCompat aa) {
            this.mUsage = aa.getUsage();
            this.mContentType = aa.getContentType();
            this.mFlags = aa.getFlags();
            this.mLegacyStream = aa.getRawLegacyStreamType();
        }

        @Override
        @NonNull
        public AudioAttributesImpl build() {
            return new AudioAttributesImplBase(this.mContentType, this.mFlags, this.mUsage, this.mLegacyStream);
        }

        @Override
        @NonNull
        public Builder setUsage(int usage) {
            switch (usage) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    this.mUsage = usage;
                    break;
                }
                case 16: {
                    this.mUsage = 12;
                    break;
                }
                default: {
                    this.mUsage = 0;
                }
            }
            return this;
        }

        @Override
        @NonNull
        public Builder setContentType(int contentType) {
            switch (contentType) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    this.mContentType = contentType;
                    break;
                }
                default: {
                    this.mContentType = 0;
                }
            }
            return this;
        }

        @Override
        @NonNull
        public Builder setFlags(int flags) {
            this.mFlags |= (flags &= 0x3FF);
            return this;
        }

        @Override
        @NonNull
        public Builder setLegacyStreamType(int streamType) {
            if (streamType == 10) {
                throw new IllegalArgumentException("STREAM_ACCESSIBILITY is not a legacy stream type that was used for audio playback");
            }
            this.mLegacyStream = streamType;
            return this.setInternalLegacyStreamType(streamType);
        }

        private Builder setInternalLegacyStreamType(int streamType) {
            switch (streamType) {
                case 0: {
                    this.mContentType = 1;
                    break;
                }
                case 7: {
                    this.mFlags |= 1;
                }
                case 1: {
                    this.mContentType = 4;
                    break;
                }
                case 2: {
                    this.mContentType = 4;
                    break;
                }
                case 3: {
                    this.mContentType = 2;
                    break;
                }
                case 4: {
                    this.mContentType = 4;
                    break;
                }
                case 5: {
                    this.mContentType = 4;
                    break;
                }
                case 6: {
                    this.mContentType = 1;
                    this.mFlags |= 4;
                    break;
                }
                case 8: {
                    this.mContentType = 4;
                    break;
                }
                case 9: {
                    this.mContentType = 4;
                    break;
                }
                case 10: {
                    this.mContentType = 1;
                    break;
                }
                default: {
                    Log.e((String)"AudioAttributesCompat", (String)("Invalid stream type " + streamType + " for AudioAttributesCompat"));
                }
            }
            this.mUsage = AudioAttributesImplBase.usageForStreamType(streamType);
            return this;
        }
    }
}

