/*
 * Decompiled with CFR 0.152.
 */
package androidx.loader.content;

import android.os.Binder;
import android.os.Handler;
import android.os.Looper;
import android.os.Process;
import android.util.Log;
import androidx.annotation.NonNull;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicBoolean;

abstract class ModernAsyncTask<Result> {
    private static final String LOG_TAG = "AsyncTask";
    private static Handler sHandler;
    private final FutureTask<Result> mFuture;
    private volatile Status mStatus = Status.PENDING;
    final AtomicBoolean mCancelled = new AtomicBoolean();
    final AtomicBoolean mTaskInvoked = new AtomicBoolean();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Handler getHandler() {
        Class<ModernAsyncTask> clazz = ModernAsyncTask.class;
        synchronized (ModernAsyncTask.class) {
            if (sHandler == null) {
                sHandler = new Handler(Looper.getMainLooper());
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sHandler;
        }
    }

    ModernAsyncTask() {
        Callable worker = new Callable<Result>(){

            @Override
            public Result call() {
                ModernAsyncTask.this.mTaskInvoked.set(true);
                Object result = null;
                try {
                    Process.setThreadPriority((int)10);
                    result = ModernAsyncTask.this.doInBackground();
                    Binder.flushPendingCommands();
                }
                catch (Throwable tr) {
                    ModernAsyncTask.this.mCancelled.set(true);
                    throw tr;
                }
                finally {
                    ModernAsyncTask.this.postResult(result);
                }
                return result;
            }
        };
        this.mFuture = new FutureTask<Result>(worker){

            @Override
            protected void done() {
                try {
                    Object result = this.get();
                    ModernAsyncTask.this.postResultIfNotInvoked(result);
                }
                catch (InterruptedException e) {
                    Log.w((String)ModernAsyncTask.LOG_TAG, (Throwable)e);
                }
                catch (ExecutionException e) {
                    throw new RuntimeException("An error occurred while executing doInBackground()", e.getCause());
                }
                catch (CancellationException e) {
                    ModernAsyncTask.this.postResultIfNotInvoked(null);
                }
                catch (Throwable t) {
                    throw new RuntimeException("An error occurred while executing doInBackground()", t);
                }
            }
        };
    }

    void postResultIfNotInvoked(Result result) {
        boolean wasTaskInvoked = this.mTaskInvoked.get();
        if (!wasTaskInvoked) {
            this.postResult(result);
        }
    }

    void postResult(final Result result) {
        ModernAsyncTask.getHandler().post(new Runnable(){

            @Override
            public void run() {
                ModernAsyncTask.this.finish(result);
            }
        });
    }

    protected abstract Result doInBackground();

    protected void onPostExecute(Result result) {
    }

    protected void onCancelled(Result result) {
    }

    public final boolean isCancelled() {
        return this.mCancelled.get();
    }

    public final boolean cancel(boolean mayInterruptIfRunning) {
        this.mCancelled.set(true);
        return this.mFuture.cancel(mayInterruptIfRunning);
    }

    public final void executeOnExecutor(@NonNull Executor exec) {
        if (this.mStatus != Status.PENDING) {
            switch (this.mStatus) {
                case RUNNING: {
                    throw new IllegalStateException("Cannot execute task: the task is already running.");
                }
                case FINISHED: {
                    throw new IllegalStateException("Cannot execute task: the task has already been executed (a task can be executed only once)");
                }
            }
            throw new IllegalStateException("We should never reach this state");
        }
        this.mStatus = Status.RUNNING;
        exec.execute(this.mFuture);
    }

    void finish(Result result) {
        if (this.isCancelled()) {
            this.onCancelled(result);
        } else {
            this.onPostExecute(result);
        }
        this.mStatus = Status.FINISHED;
    }

    public static enum Status {
        PENDING,
        RUNNING,
        FINISHED;

    }
}

