/*
 * Decompiled with CFR 0.152.
 */
package androidx.browser.trusted;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import java.util.List;

public final class TrustedWebActivityIntent {
    @NonNull
    private final Intent mIntent;
    @NonNull
    private final List<Uri> mSharedFileUris;

    TrustedWebActivityIntent(@NonNull Intent intent, @NonNull List<Uri> sharedFileUris) {
        this.mIntent = intent;
        this.mSharedFileUris = sharedFileUris;
    }

    public void launchTrustedWebActivity(@NonNull Context context) {
        this.grantUriPermissionToProvider(context);
        ContextCompat.startActivity((Context)context, (Intent)this.mIntent, null);
    }

    private void grantUriPermissionToProvider(Context context) {
        for (Uri uri : this.mSharedFileUris) {
            context.grantUriPermission(this.mIntent.getPackage(), uri, 1);
        }
    }

    @NonNull
    public Intent getIntent() {
        return this.mIntent;
    }
}

