/*
 * Decompiled with CFR 0.152.
 */
package androidx.browser.browseractions;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.browser.R;
import androidx.browser.browseractions.BrowserActionItem;
import androidx.browser.browseractions.BrowserServiceFileProvider;
import androidx.core.content.res.ResourcesCompat;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;

@Deprecated
class BrowserActionsFallbackMenuAdapter
extends BaseAdapter {
    private final List<BrowserActionItem> mMenuItems;
    private final Context mContext;

    BrowserActionsFallbackMenuAdapter(List<BrowserActionItem> menuItems, Context context) {
        this.mMenuItems = menuItems;
        this.mContext = context;
    }

    public int getCount() {
        return this.mMenuItems.size();
    }

    public Object getItem(int position) {
        return this.mMenuItems.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        ViewHolderItem viewHolder;
        BrowserActionItem menuItem = this.mMenuItems.get(position);
        if (convertView == null) {
            convertView = LayoutInflater.from((Context)this.mContext).inflate(R.layout.browser_actions_context_menu_row, null);
            ImageView icon = (ImageView)convertView.findViewById(R.id.browser_actions_menu_item_icon);
            TextView text = (TextView)convertView.findViewById(R.id.browser_actions_menu_item_text);
            if (icon == null || text == null) {
                throw new IllegalStateException("Browser Actions fallback UI does not contain necessary Views.");
            }
            viewHolder = new ViewHolderItem(icon, text);
            convertView.setTag((Object)viewHolder);
        } else {
            viewHolder = (ViewHolderItem)convertView.getTag();
        }
        final String titleText = menuItem.getTitle();
        viewHolder.mText.setText((CharSequence)titleText);
        if (menuItem.getIconId() != 0) {
            Drawable drawable = ResourcesCompat.getDrawable((Resources)this.mContext.getResources(), (int)menuItem.getIconId(), null);
            viewHolder.mIcon.setImageDrawable(drawable);
        } else if (menuItem.getIconUri() != null) {
            final ListenableFuture<Bitmap> bitmapFuture = BrowserServiceFileProvider.loadBitmap(this.mContext.getContentResolver(), menuItem.getIconUri());
            bitmapFuture.addListener(new Runnable(){

                @Override
                public void run() {
                    if (!TextUtils.equals((CharSequence)titleText, (CharSequence)viewHolder.mText.getText())) {
                        return;
                    }
                    Bitmap bitmap = null;
                    try {
                        bitmap = (Bitmap)bitmapFuture.get();
                    }
                    catch (InterruptedException | ExecutionException exception) {
                        // empty catch block
                    }
                    if (bitmap != null) {
                        viewHolder.mIcon.setVisibility(0);
                        viewHolder.mIcon.setImageBitmap(bitmap);
                    } else {
                        viewHolder.mIcon.setVisibility(4);
                        viewHolder.mIcon.setImageBitmap(null);
                    }
                }
            }, new Executor(){

                @Override
                public void execute(@NonNull Runnable runnable) {
                    runnable.run();
                }
            });
        } else {
            viewHolder.mIcon.setImageBitmap(null);
            viewHolder.mIcon.setVisibility(4);
        }
        return convertView;
    }

    static class ViewHolderItem {
        final ImageView mIcon;
        final TextView mText;

        ViewHolderItem(ImageView icon, TextView text) {
            this.mIcon = icon;
            this.mText = text;
        }
    }
}

