/*
 * Decompiled with CFR 0.152.
 */
package androidx.emoji2.viewsintegration;

import android.annotation.SuppressLint;
import android.text.Editable;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.emoji2.text.SpannableBuilder;

final class EmojiEditableFactory
extends Editable.Factory {
    private static final Object INSTANCE_LOCK = new Object();
    @GuardedBy(value="INSTANCE_LOCK")
    private static volatile Editable.Factory sInstance;
    @Nullable
    private static Class<?> sWatcherClass;

    @SuppressLint(value={"PrivateApi"})
    private EmojiEditableFactory() {
        try {
            String className = "android.text.DynamicLayout$ChangeWatcher";
            sWatcherClass = Class.forName(className, false, ((Object)((Object)this)).getClass().getClassLoader());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Editable.Factory getInstance() {
        if (sInstance == null) {
            Object object = INSTANCE_LOCK;
            synchronized (object) {
                if (sInstance == null) {
                    sInstance = new EmojiEditableFactory();
                }
            }
        }
        return sInstance;
    }

    public Editable newEditable(@NonNull CharSequence source) {
        if (sWatcherClass != null) {
            return SpannableBuilder.create(sWatcherClass, (CharSequence)source);
        }
        return super.newEditable(source);
    }
}

