/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.color;

import com.google.android.material.color.Cam16;
import com.google.android.material.color.ColorUtils;
import com.google.android.material.color.MathUtils;
import com.google.android.material.color.ViewingConditions;

final class Hct {
    private float hue;
    private float chroma;
    private float tone;
    private static final float CHROMA_SEARCH_ENDPOINT = 0.4f;
    private static final float DE_MAX = 1.0f;
    private static final float DL_MAX = 0.2f;
    private static final float DE_MAX_ERROR = 1.0E-9f;
    private static final float LIGHTNESS_SEARCH_ENDPOINT = 0.01f;

    public static Hct from(float hue, float chroma, float tone) {
        return new Hct(hue, chroma, tone);
    }

    public static Hct fromInt(int argb) {
        Cam16 cam = Cam16.fromInt(argb);
        return new Hct(cam.getHue(), cam.getChroma(), ColorUtils.lstarFromInt(argb));
    }

    private Hct(float hue, float chroma, float tone) {
        this.setInternalState(Hct.gamutMap(hue, chroma, tone));
    }

    public float getHue() {
        return this.hue;
    }

    public float getChroma() {
        return this.chroma;
    }

    public float getTone() {
        return this.tone;
    }

    public int toInt() {
        return Hct.gamutMap(this.hue, this.chroma, this.tone);
    }

    public void setHue(float newHue) {
        this.setInternalState(Hct.gamutMap(MathUtils.sanitizeDegrees(newHue), this.chroma, this.tone));
    }

    public void setChroma(float newChroma) {
        this.setInternalState(Hct.gamutMap(this.hue, newChroma, this.tone));
    }

    public void setTone(float newTone) {
        this.setInternalState(Hct.gamutMap(this.hue, this.chroma, newTone));
    }

    private void setInternalState(int argb) {
        Cam16 cam = Cam16.fromInt(argb);
        float tone = ColorUtils.lstarFromInt(argb);
        this.hue = cam.getHue();
        this.chroma = cam.getChroma();
        this.tone = tone;
    }

    private static int gamutMap(float hue, float chroma, float tone) {
        return Hct.gamutMapInViewingConditions(hue, chroma, tone, ViewingConditions.DEFAULT);
    }

    static int gamutMapInViewingConditions(float hue, float chroma, float tone, ViewingConditions viewingConditions) {
        if ((double)chroma < 1.0 || (double)Math.round(tone) <= 0.0 || (double)Math.round(tone) >= 100.0) {
            return ColorUtils.intFromLstar(tone);
        }
        hue = MathUtils.sanitizeDegrees(hue);
        float high = chroma;
        float mid = chroma;
        float low = 0.0f;
        boolean isFirstLoop = true;
        Cam16 answer = null;
        while (Math.abs(low - high) >= 0.4f) {
            Cam16 possibleAnswer = Hct.findCamByJ(hue, mid, tone);
            if (isFirstLoop) {
                if (possibleAnswer != null) {
                    return possibleAnswer.viewed(viewingConditions);
                }
                isFirstLoop = false;
                mid = low + (high - low) / 2.0f;
                continue;
            }
            if (possibleAnswer == null) {
                high = mid;
            } else {
                answer = possibleAnswer;
                low = mid;
            }
            mid = low + (high - low) / 2.0f;
        }
        if (answer == null) {
            return ColorUtils.intFromLstar(tone);
        }
        return answer.viewed(viewingConditions);
    }

    private static Cam16 findCamByJ(float hue, float chroma, float tone) {
        float low = 0.0f;
        float high = 100.0f;
        float mid = 0.0f;
        float bestdL = 1000.0f;
        float bestdE = 1000.0f;
        Cam16 bestCam = null;
        while (Math.abs(low - high) > 0.01f) {
            Cam16 camClipped;
            float dE;
            mid = low + (high - low) / 2.0f;
            Cam16 camBeforeClip = Cam16.fromJch(mid, chroma, hue);
            int clipped = camBeforeClip.getInt();
            float clippedLstar = ColorUtils.lstarFromInt(clipped);
            float dL = Math.abs(tone - clippedLstar);
            if (dL < 0.2f && (dE = (camClipped = Cam16.fromInt(clipped)).distance(Cam16.fromJch(camClipped.getJ(), camClipped.getChroma(), hue))) <= 1.0f && dE <= bestdE) {
                bestdL = dL;
                bestdE = dE;
                bestCam = camClipped;
            }
            if (bestdL == 0.0f && bestdE < 1.0E-9f) break;
            if (clippedLstar < tone) {
                low = mid;
                continue;
            }
            high = mid;
        }
        return bestCam;
    }
}

