/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.util;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public class AtomicFile {
    private static final String LOG_TAG = "AtomicFile";
    private final File mBaseName;
    private final File mNewName;
    private final File mLegacyBackupName;

    public AtomicFile(@NonNull File baseName) {
        this.mBaseName = baseName;
        this.mNewName = new File(baseName.getPath() + ".new");
        this.mLegacyBackupName = new File(baseName.getPath() + ".bak");
    }

    @NonNull
    public File getBaseFile() {
        return this.mBaseName;
    }

    public void delete() {
        this.mBaseName.delete();
        this.mNewName.delete();
        this.mLegacyBackupName.delete();
    }

    @NonNull
    public FileOutputStream startWrite() throws IOException {
        if (this.mLegacyBackupName.exists()) {
            AtomicFile.rename(this.mLegacyBackupName, this.mBaseName);
        }
        try {
            return new FileOutputStream(this.mNewName);
        }
        catch (FileNotFoundException e) {
            File parent = this.mNewName.getParentFile();
            if (!parent.mkdirs()) {
                throw new IOException("Failed to create directory for " + this.mNewName);
            }
            try {
                return new FileOutputStream(this.mNewName);
            }
            catch (FileNotFoundException e2) {
                throw new IOException("Failed to create new file " + this.mNewName, e2);
            }
        }
    }

    public void finishWrite(@Nullable FileOutputStream str) {
        if (str == null) {
            return;
        }
        if (!AtomicFile.sync(str)) {
            Log.e((String)LOG_TAG, (String)"Failed to sync file output stream");
        }
        try {
            str.close();
        }
        catch (IOException e) {
            Log.e((String)LOG_TAG, (String)"Failed to close file output stream", (Throwable)e);
        }
        AtomicFile.rename(this.mNewName, this.mBaseName);
    }

    public void failWrite(@Nullable FileOutputStream str) {
        if (str == null) {
            return;
        }
        if (!AtomicFile.sync(str)) {
            Log.e((String)LOG_TAG, (String)"Failed to sync file output stream");
        }
        try {
            str.close();
        }
        catch (IOException e) {
            Log.e((String)LOG_TAG, (String)"Failed to close file output stream", (Throwable)e);
        }
        if (!this.mNewName.delete()) {
            Log.e((String)LOG_TAG, (String)("Failed to delete new file " + this.mNewName));
        }
    }

    @NonNull
    public FileInputStream openRead() throws FileNotFoundException {
        if (this.mLegacyBackupName.exists()) {
            AtomicFile.rename(this.mLegacyBackupName, this.mBaseName);
        }
        if (this.mNewName.exists() && this.mBaseName.exists() && !this.mNewName.delete()) {
            Log.e((String)LOG_TAG, (String)("Failed to delete outdated new file " + this.mNewName));
        }
        return new FileInputStream(this.mBaseName);
    }

    @NonNull
    public byte[] readFully() throws IOException {
        try (FileInputStream stream = this.openRead();){
            int pos = 0;
            int avail = stream.available();
            byte[] data = new byte[avail];
            while (true) {
                int amt;
                if ((amt = stream.read(data, pos, data.length - pos)) <= 0) {
                    byte[] byArray = data;
                    return byArray;
                }
                avail = stream.available();
                if (avail <= data.length - (pos += amt)) continue;
                byte[] newData = new byte[pos + avail];
                System.arraycopy(data, 0, newData, 0, pos);
                data = newData;
            }
        }
    }

    private static boolean sync(@NonNull FileOutputStream stream) {
        try {
            stream.getFD().sync();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private static void rename(@NonNull File source, @NonNull File target) {
        if (target.isDirectory() && !target.delete()) {
            Log.e((String)LOG_TAG, (String)("Failed to delete file which is a directory " + target));
        }
        if (!source.renameTo(target)) {
            Log.e((String)LOG_TAG, (String)("Failed to rename " + source + " to " + target));
        }
    }
}

