/*
 * Decompiled with CFR 0.152.
 */
package androidx.transition;

import android.graphics.Path;
import android.graphics.PathMeasure;
import android.graphics.PointF;
import android.util.Property;

class PathProperty<T>
extends Property<T, Float> {
    private final Property<T, PointF> mProperty;
    private final PathMeasure mPathMeasure;
    private final float mPathLength;
    private final float[] mPosition = new float[2];
    private final PointF mPointF = new PointF();
    private float mCurrentFraction;

    PathProperty(Property<T, PointF> property, Path path) {
        super(Float.class, property.getName());
        this.mProperty = property;
        this.mPathMeasure = new PathMeasure(path, false);
        this.mPathLength = this.mPathMeasure.getLength();
    }

    public Float get(T object) {
        return Float.valueOf(this.mCurrentFraction);
    }

    public void set(T target, Float fraction) {
        this.mCurrentFraction = fraction.floatValue();
        this.mPathMeasure.getPosTan(this.mPathLength * fraction.floatValue(), this.mPosition, null);
        this.mPointF.x = this.mPosition[0];
        this.mPointF.y = this.mPosition[1];
        this.mProperty.set(target, (Object)this.mPointF);
    }
}

