/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.content;

import android.content.LocusId;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.core.util.Preconditions;

public final class LocusIdCompat {
    private final String mId;
    private final LocusId mWrapped;

    public LocusIdCompat(@NonNull String id2) {
        this.mId = Preconditions.checkStringNotEmpty(id2, "id cannot be empty");
        this.mWrapped = Build.VERSION.SDK_INT >= 29 ? Api29Impl.create(id2) : null;
    }

    @NonNull
    public String getId() {
        return this.mId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.mId == null ? 0 : this.mId.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LocusIdCompat other = (LocusIdCompat)obj;
        if (this.mId == null) {
            return other.mId == null;
        }
        return this.mId.equals(other.mId);
    }

    @NonNull
    public String toString() {
        return "LocusIdCompat[" + this.getSanitizedId() + "]";
    }

    @NonNull
    @RequiresApi(value=29)
    public LocusId toLocusId() {
        return this.mWrapped;
    }

    @NonNull
    @RequiresApi(value=29)
    public static LocusIdCompat toLocusIdCompat(@NonNull LocusId locusId) {
        Preconditions.checkNotNull(locusId, "locusId cannot be null");
        return new LocusIdCompat(Preconditions.checkStringNotEmpty(Api29Impl.getId(locusId), "id cannot be empty"));
    }

    @NonNull
    private String getSanitizedId() {
        int size = this.mId.length();
        return size + "_chars";
    }

    @RequiresApi(value=29)
    private static class Api29Impl {
        private Api29Impl() {
        }

        @NonNull
        static LocusId create(@NonNull String id2) {
            return new LocusId(id2);
        }

        @NonNull
        static String getId(@NonNull LocusId obj) {
            return obj.getId();
        }
    }
}

