/*
 * Decompiled with CFR 0.152.
 */
package androidx.browser.customtabs;

import android.content.ComponentName;
import android.content.Context;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.support.customtabs.ICustomTabsService;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.browser.customtabs.CustomTabsClient;

public abstract class CustomTabsServiceConnection
implements ServiceConnection {
    @Nullable
    private Context mApplicationContext;

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    void setApplicationContext(@NonNull Context context) {
        this.mApplicationContext = context;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @Nullable
    Context getApplicationContext() {
        return this.mApplicationContext;
    }

    public final void onServiceConnected(@NonNull ComponentName name, @NonNull IBinder service) {
        if (this.mApplicationContext == null) {
            throw new IllegalStateException("Custom Tabs Service connected before an applicationcontext has been provided.");
        }
        this.onCustomTabsServiceConnected(name, new CustomTabsClient(ICustomTabsService.Stub.asInterface(service), name, this.mApplicationContext){});
    }

    public abstract void onCustomTabsServiceConnected(@NonNull ComponentName var1, @NonNull CustomTabsClient var2);
}

