/*
 * Decompiled with CFR 0.152.
 */
package androidx.browser.customtabs;

import android.app.PendingIntent;
import android.app.Service;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.support.customtabs.ICustomTabsCallback;
import android.support.customtabs.ICustomTabsService;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.browser.customtabs.CustomTabsSessionToken;
import androidx.collection.SimpleArrayMap;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;
import java.util.NoSuchElementException;

public abstract class CustomTabsService
extends Service {
    public static final String ACTION_CUSTOM_TABS_CONNECTION = "android.support.customtabs.action.CustomTabsService";
    public static final String CATEGORY_NAVBAR_COLOR_CUSTOMIZATION = "androidx.browser.customtabs.category.NavBarColorCustomization";
    public static final String CATEGORY_COLOR_SCHEME_CUSTOMIZATION = "androidx.browser.customtabs.category.ColorSchemeCustomization";
    public static final String TRUSTED_WEB_ACTIVITY_CATEGORY = "androidx.browser.trusted.category.TrustedWebActivities";
    public static final String CATEGORY_WEB_SHARE_TARGET_V2 = "androidx.browser.trusted.category.WebShareTargetV2";
    public static final String CATEGORY_TRUSTED_WEB_ACTIVITY_IMMERSIVE_MODE = "androidx.browser.trusted.category.ImmersiveMode";
    public static final String KEY_URL = "android.support.customtabs.otherurls.URL";
    public static final String KEY_SUCCESS = "androidx.browser.customtabs.SUCCESS";
    public static final int RESULT_SUCCESS = 0;
    public static final int RESULT_FAILURE_DISALLOWED = -1;
    public static final int RESULT_FAILURE_REMOTE_ERROR = -2;
    public static final int RESULT_FAILURE_MESSAGING_ERROR = -3;
    public static final int RELATION_USE_AS_ORIGIN = 1;
    public static final int RELATION_HANDLE_ALL_URLS = 2;
    public static final int FILE_PURPOSE_TRUSTED_WEB_ACTIVITY_SPLASH_IMAGE = 1;
    final SimpleArrayMap<IBinder, IBinder.DeathRecipient> mDeathRecipientMap = new SimpleArrayMap();
    private ICustomTabsService.Stub mBinder = new ICustomTabsService.Stub(){

        @Override
        public boolean warmup(long flags) {
            return CustomTabsService.this.warmup(flags);
        }

        @Override
        public boolean newSession(@NonNull ICustomTabsCallback callback) {
            return this.newSessionInternal(callback, null);
        }

        @Override
        public boolean newSessionWithExtras(@NonNull ICustomTabsCallback callback, @Nullable Bundle extras) {
            return this.newSessionInternal(callback, this.getSessionIdFromBundle(extras));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean newSessionInternal(@NonNull ICustomTabsCallback callback, @Nullable PendingIntent sessionId) {
            CustomTabsSessionToken sessionToken = new CustomTabsSessionToken(callback, sessionId);
            try {
                IBinder.DeathRecipient deathRecipient = () -> CustomTabsService.this.cleanUpSession(sessionToken);
                SimpleArrayMap<IBinder, IBinder.DeathRecipient> simpleArrayMap = CustomTabsService.this.mDeathRecipientMap;
                synchronized (simpleArrayMap) {
                    callback.asBinder().linkToDeath(deathRecipient, 0);
                    CustomTabsService.this.mDeathRecipientMap.put((Object)callback.asBinder(), (Object)deathRecipient);
                }
                return CustomTabsService.this.newSession(sessionToken);
            }
            catch (RemoteException e) {
                return false;
            }
        }

        @Override
        public boolean mayLaunchUrl(@Nullable ICustomTabsCallback callback, @Nullable Uri url, @Nullable Bundle extras, @Nullable List<Bundle> otherLikelyBundles) {
            return CustomTabsService.this.mayLaunchUrl(new CustomTabsSessionToken(callback, this.getSessionIdFromBundle(extras)), url, extras, otherLikelyBundles);
        }

        @Override
        public Bundle extraCommand(@NonNull String commandName, @Nullable Bundle args) {
            return CustomTabsService.this.extraCommand(commandName, args);
        }

        @Override
        public boolean updateVisuals(@NonNull ICustomTabsCallback callback, @Nullable Bundle bundle) {
            return CustomTabsService.this.updateVisuals(new CustomTabsSessionToken(callback, this.getSessionIdFromBundle(bundle)), bundle);
        }

        @Override
        public boolean requestPostMessageChannel(@NonNull ICustomTabsCallback callback, @NonNull Uri postMessageOrigin) {
            return CustomTabsService.this.requestPostMessageChannel(new CustomTabsSessionToken(callback, null), postMessageOrigin);
        }

        @Override
        public boolean requestPostMessageChannelWithExtras(@NonNull ICustomTabsCallback callback, @NonNull Uri postMessageOrigin, @NonNull Bundle extras) {
            return CustomTabsService.this.requestPostMessageChannel(new CustomTabsSessionToken(callback, this.getSessionIdFromBundle(extras)), postMessageOrigin);
        }

        @Override
        public int postMessage(@NonNull ICustomTabsCallback callback, @NonNull String message, @Nullable Bundle extras) {
            return CustomTabsService.this.postMessage(new CustomTabsSessionToken(callback, this.getSessionIdFromBundle(extras)), message, extras);
        }

        @Override
        public boolean validateRelationship(@NonNull ICustomTabsCallback callback, int relation, @NonNull Uri origin, @Nullable Bundle extras) {
            return CustomTabsService.this.validateRelationship(new CustomTabsSessionToken(callback, this.getSessionIdFromBundle(extras)), relation, origin, extras);
        }

        @Override
        public boolean receiveFile(@NonNull ICustomTabsCallback callback, @NonNull Uri uri, int purpose, @Nullable Bundle extras) {
            return CustomTabsService.this.receiveFile(new CustomTabsSessionToken(callback, this.getSessionIdFromBundle(extras)), uri, purpose, extras);
        }

        @Nullable
        private PendingIntent getSessionIdFromBundle(@Nullable Bundle bundle) {
            if (bundle == null) {
                return null;
            }
            PendingIntent sessionId = (PendingIntent)bundle.getParcelable("android.support.customtabs.extra.SESSION_ID");
            bundle.remove("android.support.customtabs.extra.SESSION_ID");
            return sessionId;
        }
    };

    @NonNull
    public IBinder onBind(@Nullable Intent intent) {
        return this.mBinder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean cleanUpSession(@NonNull CustomTabsSessionToken sessionToken) {
        try {
            SimpleArrayMap<IBinder, IBinder.DeathRecipient> simpleArrayMap = this.mDeathRecipientMap;
            synchronized (simpleArrayMap) {
                IBinder binder = sessionToken.getCallbackBinder();
                if (binder == null) {
                    return false;
                }
                IBinder.DeathRecipient deathRecipient = (IBinder.DeathRecipient)this.mDeathRecipientMap.get((Object)binder);
                binder.unlinkToDeath(deathRecipient, 0);
                this.mDeathRecipientMap.remove((Object)binder);
            }
        }
        catch (NoSuchElementException e) {
            return false;
        }
        return true;
    }

    protected abstract boolean warmup(long var1);

    protected abstract boolean newSession(@NonNull CustomTabsSessionToken var1);

    protected abstract boolean mayLaunchUrl(@NonNull CustomTabsSessionToken var1, @Nullable Uri var2, @Nullable Bundle var3, @Nullable List<Bundle> var4);

    @Nullable
    protected abstract Bundle extraCommand(@NonNull String var1, @Nullable Bundle var2);

    protected abstract boolean updateVisuals(@NonNull CustomTabsSessionToken var1, @Nullable Bundle var2);

    protected abstract boolean requestPostMessageChannel(@NonNull CustomTabsSessionToken var1, @NonNull Uri var2);

    protected abstract int postMessage(@NonNull CustomTabsSessionToken var1, @NonNull String var2, @Nullable Bundle var3);

    protected abstract boolean validateRelationship(@NonNull CustomTabsSessionToken var1, int var2, @NonNull Uri var3, @Nullable Bundle var4);

    protected abstract boolean receiveFile(@NonNull CustomTabsSessionToken var1, @NonNull Uri var2, int var3, @Nullable Bundle var4);

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static @interface FilePurpose {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Relation {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Result {
    }
}

